/*
 * Decompiled with CFR 0.152.
 */
package io.github.muntashirakon.adb;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.github.muntashirakon.adb.AdbProtocol;
import io.github.muntashirakon.adb.StringCompat;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

final class AdbProtocol {
    public static final int ADB_HEADER_LENGTH = 24;
    public static final int A_SYNC = 1129208147;
    public static final int A_CNXN = 1314410051;
    public static final byte[] SYSTEM_IDENTITY_STRING_HOST = StringCompat.getBytes("host::\u0000", "UTF-8");
    public static final int A_AUTH = 1213486401;
    public static final int A_OPEN = 1313165391;
    public static final int A_OKAY = 1497451343;
    public static final int A_CLSE = 1163086915;
    public static final int A_WRTE = 1163154007;
    public static final int A_STLS = 1397511251;
    public static final int MAX_PAYLOAD_V1 = 4096;
    public static final int MAX_PAYLOAD_V2 = 262144;
    public static final int MAX_PAYLOAD_V3 = 0x100000;
    public static final int MAX_PAYLOAD = 4096;
    public static final int A_VERSION_MIN = 0x1000000;
    public static final int A_VERSION_SKIP_CHECKSUM = 0x1000001;
    public static final int A_VERSION = 0x1000000;
    public static final int A_STLS_VERSION_MIN = 0x1000000;
    public static final int A_STLS_VERSION = 0x1000000;
    public static final int ADB_AUTH_TOKEN = 1;
    public static final int ADB_AUTH_SIGNATURE = 2;
    public static final int ADB_AUTH_RSAPUBLICKEY = 3;

    AdbProtocol() {
    }

    public static int getMaxData(int api) {
        if (api >= 28) {
            return 0x100000;
        }
        if (api >= 24) {
            return 262144;
        }
        return 4096;
    }

    public static int getProtocolVersion(int api) {
        if (api >= 28) {
            return 0x1000001;
        }
        return 0x1000000;
    }

    private static int getPayloadChecksum(@NonNull byte[] data) {
        return AdbProtocol.getPayloadChecksum(data, 0, data.length);
    }

    private static int getPayloadChecksum(@NonNull byte[] data, int offset, int length) {
        int checksum = 0;
        for (int i = offset; i < offset + length; ++i) {
            checksum += data[i] & 0xFF;
        }
        return checksum;
    }

    @NonNull
    public static byte[] generateMessage(int command, int arg0, int arg1, @Nullable byte[] data) {
        return AdbProtocol.generateMessage(command, arg0, arg1, data, 0, data == null ? 0 : data.length);
    }

    @NonNull
    public static byte[] generateMessage(int command, int arg0, int arg1, @Nullable byte[] data, int offset, int length) {
        ByteBuffer message = data != null ? ByteBuffer.allocate(24 + length).order(ByteOrder.LITTLE_ENDIAN) : ByteBuffer.allocate(24).order(ByteOrder.LITTLE_ENDIAN);
        message.putInt(command);
        message.putInt(arg0);
        message.putInt(arg1);
        if (data != null) {
            message.putInt(length);
            message.putInt(AdbProtocol.getPayloadChecksum(data, offset, length));
        } else {
            message.putInt(0);
            message.putInt(0);
        }
        message.putInt(~command);
        if (data != null) {
            message.put(data, offset, length);
        }
        return message.array();
    }

    @NonNull
    public static byte[] generateConnect(int api) {
        return AdbProtocol.generateMessage(1314410051, AdbProtocol.getProtocolVersion(api), AdbProtocol.getMaxData(api), SYSTEM_IDENTITY_STRING_HOST);
    }

    @NonNull
    public static byte[] generateAuth(@AuthType int type, byte[] data) {
        return AdbProtocol.generateMessage(1213486401, type, 0, data);
    }

    @NonNull
    public static byte[] generateStls() {
        return AdbProtocol.generateMessage(1397511251, 0x1000000, 0, null);
    }

    @NonNull
    public static byte[] generateOpen(int localId, @NonNull String destination) {
        ByteBuffer bbuf = ByteBuffer.allocate(destination.length() + 1);
        bbuf.put(StringCompat.getBytes(destination, "UTF-8"));
        bbuf.put((byte)0);
        return AdbProtocol.generateMessage(1313165391, localId, 0, bbuf.array());
    }

    @NonNull
    public static byte[] generateWrite(int localId, int remoteId, byte[] data, int offset, int length) {
        return AdbProtocol.generateMessage(1163154007, localId, remoteId, data, offset, length);
    }

    @NonNull
    public static byte[] generateClose(int localId, int remoteId) {
        return AdbProtocol.generateMessage(1163086915, localId, remoteId, null);
    }

    @NonNull
    public static byte[] generateReady(int localId, int remoteId) {
        return AdbProtocol.generateMessage(1497451343, localId, remoteId, null);
    }

    static final class Message {
        public final int command;
        public final int arg0;
        public final int arg1;
        public final int dataLength;
        public final int dataCheck;
        public final int magic;
        public byte[] payload;

        @NonNull
        public static Message parse(@NonNull InputStream in, int protocolVersion, int maxData) throws IOException {
            int bytesRead;
            int bytesRead2;
            ByteBuffer header = ByteBuffer.allocate(24).order(ByteOrder.LITTLE_ENDIAN);
            int dataRead = 0;
            do {
                if ((bytesRead2 = in.read(header.array(), dataRead, 24 - dataRead)) >= 0) continue;
                throw new IOException("Stream closed");
            } while ((dataRead += bytesRead2) < 24);
            Message msg = new Message(header);
            if (msg.command != ~msg.magic) {
                throw new StreamCorruptedException(String.format("Invalid header: Invalid magic 0x%x.", msg.magic));
            }
            if (msg.command != 1129208147 && msg.command != 1314410051 && msg.command != 1313165391 && msg.command != 1497451343 && msg.command != 1163086915 && msg.command != 1163154007 && msg.command != 1213486401 && msg.command != 1397511251) {
                throw new StreamCorruptedException(String.format("Invalid header: Invalid command 0x%x.", msg.command));
            }
            if (msg.dataLength < 0 || msg.dataLength > maxData) {
                throw new StreamCorruptedException(String.format("Invalid header: Invalid data length %d", msg.dataLength));
            }
            if (msg.dataLength == 0) {
                return msg;
            }
            msg.payload = new byte[msg.dataLength];
            dataRead = 0;
            do {
                if ((bytesRead = in.read(msg.payload, dataRead, msg.dataLength - dataRead)) >= 0) continue;
                throw new IOException("Stream closed");
            } while ((dataRead += bytesRead) < msg.dataLength);
            if ((protocolVersion <= 0x1000000 || msg.command == 1314410051 && msg.arg0 <= 0x1000000) && AdbProtocol.getPayloadChecksum(msg.payload) != msg.dataCheck) {
                throw new StreamCorruptedException("Invalid header: Checksum mismatched.");
            }
            return msg;
        }

        private Message(@NonNull ByteBuffer header) {
            this.command = header.getInt();
            this.arg0 = header.getInt();
            this.arg1 = header.getInt();
            this.dataLength = header.getInt();
            this.dataCheck = header.getInt();
            this.magic = header.getInt();
        }

        @NonNull
        public String toString() {
            String tag;
            switch (this.command) {
                case 1129208147: {
                    tag = "SYNC";
                    break;
                }
                case 1314410051: {
                    tag = "CNXN";
                    break;
                }
                case 1313165391: {
                    tag = "OPEN";
                    break;
                }
                case 1497451343: {
                    tag = "OKAY";
                    break;
                }
                case 1163086915: {
                    tag = "CLSE";
                    break;
                }
                case 1163154007: {
                    tag = "WRTE";
                    break;
                }
                case 1213486401: {
                    tag = "AUTH";
                    break;
                }
                case 1397511251: {
                    tag = "STLS";
                    break;
                }
                default: {
                    tag = "????";
                }
            }
            return "Message{command=" + tag + ", arg0=0x" + Integer.toHexString(this.arg0) + ", arg1=0x" + Integer.toHexString(this.arg1) + ", payloadLength=" + this.dataLength + ", checksum=" + this.dataCheck + ", magic=0x" + Integer.toHexString(this.magic) + ", payload=" + Arrays.toString(this.payload) + '}';
        }
    }
}

