/*
 * Decompiled with CFR 0.152.
 */
package com.monstertechno.adblocker.util;

import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.WebResourceResponse;
import androidx.annotation.WorkerThread;
import com.monstertechno.adblocker.util.UrlUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Set;

public class AdBlocker {
    private static final String AD_HOSTS_FILE = "hosts";
    private static final Set<String> AD_HOSTS = new HashSet<String>();

    public static void init(final Context context) {
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                try {
                    AdBlocker.loadFromAssets(context);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        }.execute((Object[])new Void[0]);
    }

    @WorkerThread
    private static void loadFromAssets(Context context) throws IOException {
        String line;
        InputStream stream = context.getAssets().open(AD_HOSTS_FILE);
        InputStreamReader inputStreamReader = new InputStreamReader(stream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        while ((line = bufferedReader.readLine()) != null) {
            AD_HOSTS.add(line);
        }
        bufferedReader.close();
        inputStreamReader.close();
        stream.close();
    }

    public static boolean isAd(String url) {
        try {
            return AdBlocker.isAdHost(UrlUtils.getHost(url));
        }
        catch (MalformedURLException e) {
            Log.d((String)"AmniX", (String)e.toString());
            return false;
        }
    }

    private static boolean isAdHost(String host) {
        if (TextUtils.isEmpty((CharSequence)host)) {
            return false;
        }
        int index = host.indexOf(".");
        return index >= 0 && (AD_HOSTS.contains(host) || index + 1 < host.length() && AdBlocker.isAdHost(host.substring(index + 1)));
    }

    public static WebResourceResponse createEmptyResource() {
        return new WebResourceResponse("text/plain", "utf-8", (InputStream)new ByteArrayInputStream("".getBytes()));
    }
}

