/*
 * Decompiled with CFR 0.152.
 */
package com.mohammedalaa.seekbar;

import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.ColorInt;
import com.mohammedalaa.seekbar.Direction;
import com.mohammedalaa.seekbar.OnRangeSeekBarChangeListener;
import com.mohammedalaa.seekbar.R;
import com.mohammedalaa.seekbar.RangeSeekBarView$WhenMappings;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0007\u0018\u0000 Z2\u00020\u0001:\u0002Z[B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010;\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u00122\u0006\u0010<\u001a\u00020\u00122\u0006\u0010=\u001a\u00020\u0012H\u0002J\u0018\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020A2\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010B\u001a\u00020?2\u0006\u0010@\u001a\u00020A2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010C\u001a\u00020?2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010D\u001a\u00020\u00122\u0006\u0010E\u001a\u00020\u0012H\u0002J\u0010\u0010F\u001a\u00020\u00122\u0006\u0010E\u001a\u00020\u0012H\u0002J\u0010\u0010G\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0014J\u0018\u0010H\u001a\u00020?2\u0006\u0010I\u001a\u00020\u00122\u0006\u0010J\u001a\u00020\u0012H\u0014J\u0010\u0010K\u001a\u00020?2\u0006\u0010L\u001a\u00020MH\u0014J\b\u0010N\u001a\u00020MH\u0014J\u0010\u0010O\u001a\u00020\t2\u0006\u0010P\u001a\u00020QH\u0017J\u0012\u0010R\u001a\u00020?2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010S\u001a\u00020\tH\u0016J\u0016\u0010T\u001a\u00020?2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010U\u001a\u00020?2\u0006\u0010V\u001a\u00020.J\b\u0010W\u001a\u00020?H\u0002J\b\u0010X\u001a\u00020?H\u0002J\u0010\u0010Y\u001a\u00020?2\u0006\u0010\"\u001a\u00020\u0012H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0014\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R&\u0010\u0019\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018R\u000e\u0010\u001c\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u001e\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0016\"\u0004\b \u0010\u0018R\u000e\u0010!\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010#\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0016\"\u0004\b%\u0010\u0018R\u000e\u0010&\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010)\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0016\"\u0004\b+\u0010\u0018R\u000e\u0010,\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010/\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0016\"\u0004\b1\u0010\u0018R$\u00102\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u0016\"\u0004\b4\u0010\u0018R$\u00105\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u0016\"\u0004\b7\u0010\u0018R\u000e\u00108\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020:X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\\"}, d2={"Lcom/mohammedalaa/seekbar/RangeSeekBarView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "animated", "", "animation", "Landroid/animation/ValueAnimator;", "animationDuration", "", "barBasePaint", "Landroid/graphics/Paint;", "barFillPaint", "barHeight", "", "color", "baseColor", "getBaseColor", "()I", "setBaseColor", "(I)V", "circleFillColor", "getCircleFillColor", "setCircleFillColor", "circlePaint", "circleRadius", "circleTextColor", "getCircleTextColor", "setCircleTextColor", "circleTextSize", "value", "currentValue", "getCurrentValue", "setCurrentValue", "defaultPadding", "direction", "Lcom/mohammedalaa/seekbar/Direction;", "fillColor", "getFillColor", "setFillColor", "isTouchListenerEnabled", "mOnRangeSeekBarViewChangeListener", "Lcom/mohammedalaa/seekbar/OnRangeSeekBarChangeListener;", "maxValue", "getMaxValue", "setMaxValue", "minValue", "getMinValue", "setMinValue", "step", "getStep", "setStep", "valuePaint", "valueToDraw", "", "calculateProgress", "MIN", "MAX", "drawBarHorizontal", "", "canvas", "Landroid/graphics/Canvas;", "drawBarVertical", "init", "measureHeight", "measureSpec", "measureWidth", "onDraw", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "onSaveInstanceState", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "parseAttr", "performClick", "setAnimated", "setOnRangeSeekBarViewChangeListener", "l", "setValues", "swap", "upDatePosition", "Companion", "SavedState", "seekbar_release"})
@SuppressLint(value={"AppCompatCustomView"})
public final class RangeSeekBarView
extends View {
    private float valueToDraw;
    private int barHeight;
    private int circleRadius;
    private int circleTextSize;
    private int defaultPadding;
    private Paint barBasePaint;
    private Paint barFillPaint;
    private Paint circlePaint;
    private Paint valuePaint;
    private Direction direction;
    private boolean animated;
    private long animationDuration;
    private ValueAnimator animation;
    private OnRangeSeekBarChangeListener mOnRangeSeekBarViewChangeListener;
    private int step;
    private int maxValue;
    private int minValue;
    private int baseColor;
    private int fillColor;
    private int circleTextColor;
    private int circleFillColor;
    private boolean isTouchListenerEnabled;
    private int currentValue;
    private static final int DEFAULT_BASE_COLOR = -7829368;
    private static final int DEFAULT_FILL_COLOR = -65536;
    private static final int DEFAULT_TEXT_COLOR = -12303292;
    private static final int DEFAULT_CIRCLE_COLOR = -16711936;
    private static final int DEFAULT_VALUE = 0;
    private static final int DEFAULT_STEP_VALUE = 0;
    private static final int DEFAULT_MAX_VALUE = 100;
    private static final int DEFAULT_MIN_VALUE = 0;
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    public final int getStep() {
        return this.step;
    }

    public final void setStep(int value) {
        this.step = value;
        this.invalidate();
        this.requestLayout();
    }

    public final int getMaxValue() {
        return this.maxValue;
    }

    public final void setMaxValue(int value) {
        this.maxValue = value;
        this.invalidate();
        this.requestLayout();
    }

    public final int getMinValue() {
        return this.minValue;
    }

    public final void setMinValue(int value) {
        this.minValue = value;
        this.invalidate();
        this.requestLayout();
    }

    public final int getBaseColor() {
        return this.baseColor;
    }

    public final void setBaseColor(@ColorInt int color) {
        this.baseColor = color;
        this.barBasePaint.setColor(color);
        this.invalidate();
    }

    public final int getFillColor() {
        return this.fillColor;
    }

    public final void setFillColor(@ColorInt int color) {
        this.fillColor = color;
        this.barFillPaint.setColor(color);
        this.invalidate();
    }

    public final int getCircleTextColor() {
        return this.circleTextColor;
    }

    public final void setCircleTextColor(@ColorInt int color) {
        this.circleTextColor = color;
        this.valuePaint.setColor(color);
        this.invalidate();
    }

    public final int getCircleFillColor() {
        return this.circleFillColor;
    }

    public final void setCircleFillColor(@ColorInt int color) {
        this.circleFillColor = color;
        this.circlePaint.setColor(color);
        this.invalidate();
    }

    public final int getCurrentValue() {
        return this.currentValue;
    }

    public final void setCurrentValue(int value) {
        int previousValue = this.currentValue;
        this.currentValue = value;
        int newValue = value;
        if (newValue < this.minValue || newValue > this.maxValue) {
            this.currentValue = newValue = this.currentValue;
        }
        if (newValue % this.step == 0) {
            this.currentValue = newValue;
        }
        ValueAnimator valueAnimator = this.animation;
        if (valueAnimator != null) {
            valueAnimator.cancel();
        }
        if (this.animated) {
            this.animation = ValueAnimator.ofFloat((float[])new float[]{previousValue, this.currentValue});
            int changeInValue = Math.abs(this.currentValue - previousValue);
            long durationToUse = 0L;
            durationToUse = this.direction == Direction.BOTTOM_TO_TOP || this.direction == Direction.RIGHT_TO_LEFT ? (long)((float)this.animationDuration * ((float)changeInValue / (float)this.minValue)) : (long)((float)this.animationDuration * ((float)changeInValue / (float)this.maxValue));
            ValueAnimator valueAnimator2 = this.animation;
            if (valueAnimator2 != null) {
                valueAnimator2.setDuration(durationToUse);
            }
            ValueAnimator valueAnimator3 = this.animation;
            if (valueAnimator3 != null) {
                valueAnimator3.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
                    final /* synthetic */ RangeSeekBarView this$0;

                    public final void onAnimationUpdate(ValueAnimator valueAnimator) {
                        ValueAnimator valueAnimator2 = valueAnimator;
                        Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator2, (String)"valueAnimator");
                        Object object = valueAnimator2.getAnimatedValue();
                        if (object == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Float");
                        }
                        RangeSeekBarView.access$setValueToDraw$p(this.this$0, ((Float)object).floatValue());
                        OnRangeSeekBarChangeListener onRangeSeekBarChangeListener = RangeSeekBarView.access$getMOnRangeSeekBarViewChangeListener$p(this.this$0);
                        if (onRangeSeekBarChangeListener != null) {
                            onRangeSeekBarChangeListener.onProgressChanged(this.this$0, (int)RangeSeekBarView.access$getValueToDraw$p(this.this$0), true);
                        }
                        this.this$0.invalidate();
                    }
                    {
                        this.this$0 = rangeSeekBarView;
                    }
                });
            }
            ValueAnimator valueAnimator4 = this.animation;
            if (valueAnimator4 == null) {
                Intrinsics.throwNpe();
            }
            valueAnimator4.start();
        } else {
            this.valueToDraw = this.currentValue;
            OnRangeSeekBarChangeListener onRangeSeekBarChangeListener = this.mOnRangeSeekBarViewChangeListener;
            if (onRangeSeekBarChangeListener != null) {
                onRangeSeekBarChangeListener.onProgressChanged(this, (int)this.valueToDraw, true);
            }
        }
        this.invalidate();
    }

    private final void init(AttributeSet attrs) {
        this.parseAttr(attrs);
        Paint paint = this.barBasePaint;
        boolean bl = false;
        boolean bl2 = false;
        Paint $this$apply = paint;
        boolean bl3 = false;
        $this$apply.setColor(this.baseColor);
        paint = this.barFillPaint;
        bl = false;
        bl2 = false;
        $this$apply = paint;
        boolean bl4 = false;
        $this$apply.setColor(this.fillColor);
        paint = this.valuePaint;
        bl = false;
        bl2 = false;
        $this$apply = paint;
        boolean bl5 = false;
        $this$apply.setTextSize((float)this.circleTextSize);
        $this$apply.setColor(this.circleTextColor);
        $this$apply.setTextAlign(Paint.Align.CENTER);
        paint = this.circlePaint;
        bl = false;
        bl2 = false;
        $this$apply = paint;
        boolean bl6 = false;
        $this$apply.setColor(this.circleFillColor);
        this.setValues();
    }

    private final void setValues() {
        this.setSaveEnabled(true);
        this.setBackgroundColor(0);
        if (this.currentValue < this.minValue || this.currentValue > this.maxValue) {
            throw (Throwable)new RuntimeException("Value must be in range   (min <= value <= max) ");
        }
        if (this.direction == Direction.BOTTOM_TO_TOP || this.direction == Direction.RIGHT_TO_LEFT) {
            this.swap();
        }
    }

    private final void parseAttr(AttributeSet attrs) {
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.RangeSeekBarView, 0, 0);
        if (typedArray.hasValue(R.styleable.RangeSeekBarView_stepValue)) {
            this.setStep(typedArray.getInt(R.styleable.RangeSeekBarView_stepValue, 0));
        }
        if (typedArray.hasValue(R.styleable.RangeSeekBarView_minValue)) {
            this.setMinValue(typedArray.getInt(R.styleable.RangeSeekBarView_minValue, 0));
        }
        if (typedArray.hasValue(R.styleable.RangeSeekBarView_maxValue)) {
            this.setMaxValue(typedArray.getInt(R.styleable.RangeSeekBarView_maxValue, 0));
        }
        if (typedArray.hasValue(R.styleable.RangeSeekBarView_currentValue)) {
            this.setCurrentValue(typedArray.getInt(R.styleable.RangeSeekBarView_currentValue, 0));
        }
        if (typedArray.hasValue(R.styleable.RangeSeekBarView_barHeight)) {
            this.barHeight = typedArray.getDimensionPixelSize(R.styleable.RangeSeekBarView_barHeight, 0);
        }
        if (typedArray.hasValue(R.styleable.RangeSeekBarView_circleRadius)) {
            this.defaultPadding = this.circleRadius = typedArray.getDimensionPixelSize(R.styleable.RangeSeekBarView_circleRadius, 0);
        }
        if (typedArray.hasValue(R.styleable.RangeSeekBarView_circleTextSize)) {
            this.circleTextSize = typedArray.getDimensionPixelSize(R.styleable.RangeSeekBarView_circleTextSize, 0);
        }
        if (typedArray.hasValue(R.styleable.RangeSeekBarView_circleTextColor)) {
            this.setCircleTextColor(typedArray.getColor(R.styleable.RangeSeekBarView_circleTextColor, -12303292));
        }
        if (typedArray.hasValue(R.styleable.RangeSeekBarView_circleFillColor)) {
            this.setCircleFillColor(typedArray.getColor(R.styleable.RangeSeekBarView_circleFillColor, -16711936));
        }
        if (typedArray.hasValue(R.styleable.RangeSeekBarView_baseColor)) {
            this.setBaseColor(typedArray.getColor(R.styleable.RangeSeekBarView_baseColor, -7829368));
        }
        if (typedArray.hasValue(R.styleable.RangeSeekBarView_fillColor)) {
            this.setFillColor(typedArray.getColor(R.styleable.RangeSeekBarView_fillColor, -65536));
        }
        if (typedArray.hasValue(R.styleable.RangeSeekBarView_orientation)) {
            this.direction = Direction.values()[typedArray.getInt(R.styleable.RangeSeekBarView_orientation, 1)];
        }
        this.setPadding(this.defaultPadding, this.defaultPadding, this.defaultPadding, this.defaultPadding);
        typedArray.recycle();
    }

    private final void swap() {
        int temp = this.maxValue;
        this.setMaxValue(this.minValue);
        this.setMinValue(temp);
    }

    public final void setOnRangeSeekBarViewChangeListener(@NotNull OnRangeSeekBarChangeListener l) {
        Intrinsics.checkParameterIsNotNull((Object)l, (String)"l");
        this.mOnRangeSeekBarViewChangeListener = l;
    }

    private final int calculateProgress(int value, int MIN, int MAX) {
        return 100 * (value - MIN) / (MAX - MIN);
    }

    public final void setAnimated(boolean animated, long animationDuration) {
        this.animated = animated;
        this.animationDuration = animationDuration;
    }

    private final int measureHeight(int measureSpec) {
        int size = this.getPaddingTop() + this.getPaddingBottom();
        return View.resolveSizeAndState((int)(size += Math.max(this.barHeight, this.circleRadius)), (int)measureSpec, (int)0);
    }

    private final int measureWidth(int measureSpec) {
        int size = this.getPaddingLeft() + this.getPaddingRight();
        return View.resolveSizeAndState((int)size, (int)measureSpec, (int)0);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.measureWidth(widthMeasureSpec), this.measureHeight(heightMeasureSpec));
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        switch (RangeSeekBarView$WhenMappings.$EnumSwitchMapping$0[this.direction.ordinal()]) {
            case 1: {
                super.onDraw(canvas);
                this.drawBarVertical(canvas, Direction.TOP_TO_BOTTOM);
                break;
            }
            case 2: {
                super.onDraw(canvas);
                this.drawBarVertical(canvas, Direction.BOTTOM_TO_TOP);
                break;
            }
            case 3: {
                super.onDraw(canvas);
                this.drawBarHorizontal(canvas, Direction.LEFT_TO_RIGHT);
                break;
            }
            case 4: {
                super.onDraw(canvas);
                this.drawBarHorizontal(canvas, Direction.RIGHT_TO_LEFT);
            }
        }
    }

    private final void drawBarVertical(Canvas canvas, Direction direction) {
        float barLength = (float)(this.getHeight() - this.getPaddingTop()) - (float)this.getPaddingBottom();
        float barCenter = this.getWidth() / 2;
        float halfBarHeight = this.barHeight / 2;
        float top = this.getPaddingTop();
        float bottom = barLength + (float)this.getPaddingTop();
        float left = barCenter - halfBarHeight;
        float right = barCenter + halfBarHeight;
        RectF rect = new RectF(left, top, right, bottom);
        canvas.drawRoundRect(rect, barCenter, barCenter, this.barBasePaint);
        float percentFilled = (float)this.calculateProgress((int)this.valueToDraw, this.minValue, this.maxValue) / (float)100;
        float fillLength = barLength * percentFilled;
        float fillPosition = 0.0f;
        RectF fillRect = null;
        switch (RangeSeekBarView$WhenMappings.$EnumSwitchMapping$1[direction.ordinal()]) {
            case 1: {
                fillPosition = fillLength + (float)this.getPaddingTop();
                fillRect = new RectF(left, top, right, fillPosition);
                break;
            }
            default: {
                fillPosition = fillLength + (float)this.getPaddingBottom();
                fillRect = new RectF(left, fillPosition, right, bottom);
            }
        }
        canvas.drawRoundRect(fillRect, barCenter, barCenter, this.barFillPaint);
        canvas.drawCircle(barCenter, fillPosition, (float)this.circleRadius, this.circlePaint);
        Rect bounds = new Rect();
        String valueString = String.valueOf(Math.round(this.valueToDraw));
        this.valuePaint.getTextBounds(valueString, 0, valueString.length(), bounds);
        float y = fillPosition + (float)(bounds.height() / 2);
        canvas.drawText(valueString, barCenter, y, this.valuePaint);
    }

    private final void drawBarHorizontal(Canvas canvas, Direction direction) {
        RectF rectF;
        float barLength = this.getWidth() - this.getPaddingRight() - this.getPaddingLeft();
        float barCenter = this.getHeight() / 2;
        float halfBarHeight = this.barHeight / 2;
        float top = barCenter - halfBarHeight;
        float bottom = barCenter + halfBarHeight;
        float left = this.getPaddingLeft();
        float right = (float)this.getPaddingLeft() + barLength;
        RectF rect = new RectF(left, top, right, bottom);
        canvas.drawRoundRect(rect, halfBarHeight, halfBarHeight, this.barBasePaint);
        float percentFilled = (float)this.calculateProgress((int)this.valueToDraw, this.minValue, this.maxValue) / (float)100;
        float fillLength = barLength * percentFilled;
        float fillPosition = left + fillLength;
        RectF fillRect = null;
        switch (RangeSeekBarView$WhenMappings.$EnumSwitchMapping$2[direction.ordinal()]) {
            case 1: {
                rectF = new RectF(left, top, fillPosition, bottom);
                break;
            }
            default: {
                rectF = new RectF(fillPosition, top, right, bottom);
            }
        }
        fillRect = rectF;
        canvas.drawRoundRect(fillRect, halfBarHeight, halfBarHeight, this.barFillPaint);
        canvas.drawCircle(fillPosition, barCenter, (float)this.circleRadius, this.circlePaint);
        Rect bounds = new Rect();
        String valueString = String.valueOf(Math.round(this.valueToDraw));
        this.valuePaint.getTextBounds(valueString, 0, valueString.length(), bounds);
        float y = barCenter + (float)(bounds.height() / 2);
        canvas.drawText(valueString, fillPosition, y, this.valuePaint);
    }

    private final void upDatePosition(int value) {
        double calcValue = MathKt.roundToInt((float)(value * (this.maxValue - this.minValue) / 100));
        int displayValue = ((int)calcValue + this.minValue) / this.step * this.step;
        this.setCurrentValue(displayValue);
    }

    @NotNull
    protected Parcelable onSaveInstanceState() {
        Parcelable superState;
        Parcelable parcelable = superState = super.onSaveInstanceState();
        if (parcelable == null) {
            Intrinsics.throwNpe();
        }
        SavedState ss = new SavedState(parcelable);
        ss.setValue$seekbar_release(this.currentValue);
        return (Parcelable)ss;
    }

    protected void onRestoreInstanceState(@NotNull Parcelable state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        SavedState ss = (SavedState)state;
        this.setCurrentValue(ss.getValue$seekbar_release());
        this.valueToDraw = this.currentValue;
        super.onRestoreInstanceState(ss.getSuperState());
    }

    public boolean performClick() {
        super.performClick();
        return true;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (!this.isTouchListenerEnabled) {
            return false;
        }
        double coordinate = 0.0;
        double canvasSize = 0.0;
        int eventAction = event.getAction();
        switch (RangeSeekBarView$WhenMappings.$EnumSwitchMapping$3[this.direction.ordinal()]) {
            case 1: 
            case 2: {
                coordinate = event.getY();
                canvasSize = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
                break;
            }
            case 3: 
            case 4: {
                coordinate = event.getX();
                canvasSize = this.getWidth() - this.getPaddingStart() - this.getPaddingEnd();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (coordinate < 0.0) {
            coordinate = 0.0;
        } else if (coordinate > canvasSize) {
            coordinate = canvasSize;
        }
        switch (eventAction) {
            case 0: {
                OnRangeSeekBarChangeListener onRangeSeekBarChangeListener = this.mOnRangeSeekBarViewChangeListener;
                if (onRangeSeekBarChangeListener != null) {
                    onRangeSeekBarChangeListener.onStartTrackingTouch(this, this.currentValue);
                }
                break;
            }
            case 1: {
                int value = (int)(coordinate / canvasSize * (double)100);
                this.upDatePosition(value);
                OnRangeSeekBarChangeListener onRangeSeekBarChangeListener = this.mOnRangeSeekBarViewChangeListener;
                if (onRangeSeekBarChangeListener != null) {
                    onRangeSeekBarChangeListener.onStopTrackingTouch(this, this.currentValue);
                }
                break;
            }
            case 2: {
                int value = (int)(coordinate / canvasSize * (double)100);
                this.upDatePosition(value);
                OnRangeSeekBarChangeListener onRangeSeekBarChangeListener = this.mOnRangeSeekBarViewChangeListener;
                if (onRangeSeekBarChangeListener == null) break;
                onRangeSeekBarChangeListener.onProgressChanged(this, this.currentValue, true);
                break;
            }
        }
        return true;
    }

    public RangeSeekBarView(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.defaultPadding = 15;
        this.barBasePaint = new Paint(1);
        this.barFillPaint = new Paint(1);
        this.circlePaint = new Paint(1);
        this.valuePaint = new Paint(1);
        this.direction = Direction.LEFT_TO_RIGHT;
        this.animationDuration = 3000L;
        this.maxValue = 100;
        this.baseColor = -7829368;
        this.fillColor = -65536;
        this.circleTextColor = -12303292;
        this.circleFillColor = -16711936;
        this.isTouchListenerEnabled = true;
    }

    public RangeSeekBarView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.defaultPadding = 15;
        this.barBasePaint = new Paint(1);
        this.barFillPaint = new Paint(1);
        this.circlePaint = new Paint(1);
        this.valuePaint = new Paint(1);
        this.direction = Direction.LEFT_TO_RIGHT;
        this.animationDuration = 3000L;
        this.maxValue = 100;
        this.baseColor = -7829368;
        this.fillColor = -65536;
        this.circleTextColor = -12303292;
        this.circleFillColor = -16711936;
        this.isTouchListenerEnabled = true;
        this.init(attrs);
    }

    public static final /* synthetic */ float access$getValueToDraw$p(RangeSeekBarView $this) {
        return $this.valueToDraw;
    }

    public static final /* synthetic */ void access$setValueToDraw$p(RangeSeekBarView $this, float f) {
        $this.valueToDraw = f;
    }

    public static final /* synthetic */ OnRangeSeekBarChangeListener access$getMOnRangeSeekBarViewChangeListener$p(RangeSeekBarView $this) {
        return $this.mOnRangeSeekBarViewChangeListener;
    }

    public static final /* synthetic */ void access$setMOnRangeSeekBarViewChangeListener$p(RangeSeekBarView $this, OnRangeSeekBarChangeListener onRangeSeekBarChangeListener) {
        $this.mOnRangeSeekBarViewChangeListener = onRangeSeekBarChangeListener;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0012\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\tH\u0016R\u001a\u0010\b\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lcom/mohammedalaa/seekbar/RangeSeekBarView$SavedState;", "Landroid/view/View$BaseSavedState;", "superState", "Landroid/os/Parcelable;", "(Landroid/os/Parcelable;)V", "in", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "value", "", "getValue$seekbar_release", "()I", "setValue$seekbar_release", "(I)V", "writeToParcel", "", "out", "flags", "Companion", "seekbar_release"})
    private static final class SavedState
    extends View.BaseSavedState {
        private int value;
        @JvmField
        @NotNull
        public static final Parcelable.Creator<SavedState> CREATOR;
        public static final Companion Companion;

        public final int getValue$seekbar_release() {
            return this.value;
        }

        public final void setValue$seekbar_release(int n) {
            this.value = n;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
            super.writeToParcel(out, flags);
            out.writeInt(this.value);
        }

        public SavedState(@NotNull Parcelable superState) {
            Intrinsics.checkParameterIsNotNull((Object)superState, (String)"superState");
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.value = in.readInt();
        }

        static {
            Companion = new Companion(null);
            CREATOR = (Parcelable.Creator)new Parcelable.Creator<SavedState>(){

                @NotNull
                public SavedState createFromParcel(@NotNull Parcel in) {
                    Intrinsics.checkParameterIsNotNull((Object)in, (String)"in");
                    return new SavedState(in, null);
                }

                @NotNull
                public SavedState[] newArray(int size) {
                    return new SavedState[size];
                }
            };
        }

        public /* synthetic */ SavedState(Parcel in, DefaultConstructorMarker $constructor_marker) {
            this(in);
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/mohammedalaa/seekbar/RangeSeekBarView$SavedState$Companion;", "", "()V", "CREATOR", "Landroid/os/Parcelable$Creator;", "Lcom/mohammedalaa/seekbar/RangeSeekBarView$SavedState;", "seekbar_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/mohammedalaa/seekbar/RangeSeekBarView$Companion;", "", "()V", "DEFAULT_BASE_COLOR", "", "DEFAULT_CIRCLE_COLOR", "DEFAULT_FILL_COLOR", "DEFAULT_MAX_VALUE", "DEFAULT_MIN_VALUE", "DEFAULT_STEP_VALUE", "DEFAULT_TEXT_COLOR", "DEFAULT_VALUE", "seekbar_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

