/*
 * Decompiled with CFR 0.152.
 */
package com.mohammedalaa.seekbar;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.ColorInt;
import com.mohammedalaa.seekbar.OnDoubleValueSeekBarChangeListener;
import com.mohammedalaa.seekbar.R;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u001a\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0017\u0018\u0000 s2\u00020\u0001:\u0003stuB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010A\u001a\u00020BH\u0002J \u0010C\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010D\u001a\u00020\f2\u0006\u0010E\u001a\u00020\fH\u0002J\u0010\u0010F\u001a\u00020B2\u0006\u0010G\u001a\u00020HH\u0002J\u0010\u0010I\u001a\u00020?2\u0006\u0010J\u001a\u00020KH\u0002J\u0012\u0010L\u001a\u0004\u0018\u00010?2\u0006\u0010J\u001a\u00020KH\u0002J\b\u0010M\u001a\u00020KH\u0002J\u0010\u0010N\u001a\u00020B2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010O\u001a\u00020'2\u0006\u0010J\u001a\u00020K2\u0006\u0010P\u001a\u00020\fH\u0002J\u0010\u0010Q\u001a\u00020\f2\u0006\u0010R\u001a\u00020\fH\u0002J\u0010\u0010S\u001a\u00020\f2\u0006\u0010R\u001a\u00020\fH\u0002J\u0010\u0010T\u001a\u00020\f2\u0006\u0010U\u001a\u00020KH\u0002J\u0010\u0010V\u001a\u00020\f2\u0006\u0010W\u001a\u00020\fH\u0002J\u0010\u0010X\u001a\u00020B2\u0006\u0010G\u001a\u00020HH\u0014J\u0018\u0010Y\u001a\u00020B2\u0006\u0010Z\u001a\u00020\f2\u0006\u0010[\u001a\u00020\fH\u0014J\u0010\u0010\\\u001a\u00020B2\u0006\u0010]\u001a\u00020^H\u0014J\b\u0010_\u001a\u00020^H\u0014J\b\u0010`\u001a\u00020BH\u0002J\b\u0010a\u001a\u00020BH\u0002J\u0010\u0010b\u001a\u00020'2\u0006\u0010c\u001a\u00020dH\u0017J\u0012\u0010e\u001a\u00020B2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010f\u001a\u00020'H\u0016J\u0018\u0010g\u001a\u00020B2\u0006\u0010U\u001a\u00020K2\u0006\u0010h\u001a\u00020?H\u0002J\u000e\u0010i\u001a\u00020B2\u0006\u0010j\u001a\u00020*J\u0018\u0010k\u001a\u00020B2\u0006\u0010l\u001a\u00020K2\u0006\u0010m\u001a\u00020KH\u0004J\u0018\u0010n\u001a\u00020B2\u0006\u0010l\u001a\u00020K2\u0006\u0010m\u001a\u00020KH\u0004J\u0018\u0010o\u001a\u00020B2\u0006\u0010l\u001a\u00020K2\u0006\u0010m\u001a\u00020KH\u0004J\u0010\u0010p\u001a\u00020B2\u0006\u0010c\u001a\u00020dH\u0002J\u0010\u0010q\u001a\u00020B2\u0006\u0010\u001b\u001a\u00020\fH\u0002J\u0010\u0010r\u001a\u00020B2\u0006\u0010\u001b\u001a\u00020\fH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u000e\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R&\u0010\u0013\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u000e\u0010\u0016\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0017\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0010\"\u0004\b\u0019\u0010\u0012R\u000e\u0010\u001a\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0010\"\u0004\b\u001e\u0010\u0012R$\u0010\u001f\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0010\"\u0004\b!\u0010\u0012R\u000e\u0010\"\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010#\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0010\"\u0004\b%\u0010\u0012R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010,\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u0010\"\u0004\b.\u0010\u0012R$\u0010/\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0010\"\u0004\b1\u0010\u0012R\u000e\u00102\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00105\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u0010\"\u0004\b7\u0010\u0012R$\u00108\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010\u0010\"\u0004\b:\u0010\u0012R\u000e\u0010;\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010>\u001a\u0004\u0018\u00010?X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006v"}, d2={"Lcom/mohammedalaa/seekbar/DoubleValueSeekBarView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "barBasePaint", "Landroid/graphics/Paint;", "barFillPaint", "barHeight", "", "color", "baseColor", "getBaseColor", "()I", "setBaseColor", "(I)V", "circleFillColor", "getCircleFillColor", "setCircleFillColor", "circleRadius", "circleTextColor", "getCircleTextColor", "setCircleTextColor", "circleTextSize", "value", "currentMaxValue", "getCurrentMaxValue", "setCurrentMaxValue", "currentMinValue", "getCurrentMinValue", "setCurrentMinValue", "defaultPadding", "fillColor", "getFillColor", "setFillColor", "isDragging", "", "mActivePointerId", "mOnDoubleValueSeekBarViewChangeListener", "Lcom/mohammedalaa/seekbar/OnDoubleValueSeekBarChangeListener;", "maxCirclePaint", "maxStep", "getMaxStep", "setMaxStep", "maxValue", "getMaxValue", "setMaxValue", "maxValuePaint", "maxValueToDraw", "minCirclePaint", "minStep", "getMinStep", "setMinStep", "minValue", "getMinValue", "setMinValue", "minValuePaint", "minValueToDraw", "pointerIndex", "pressedThumb", "Lcom/mohammedalaa/seekbar/DoubleValueSeekBarView$Thumb;", "seekBarTouchEnabled", "attemptClaimDrag", "", "calculateProgress", "MIN", "MAX", "drawDoubleValueBarHorizontal", "canvas", "Landroid/graphics/Canvas;", "evalPressedThumb", "touchX", "", "findClosestThumb", "getThumbWidth", "init", "isInThumbRange", "normalizedThumbValue", "measureHeight", "measureSpec", "measureWidth", "normalize", "screenCoord", "normalizedToScreen", "normalizedCoord", "onDraw", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "onSaveInstanceState", "onStartTrackingTouch", "onStopTrackingTouch", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "parseAttr", "performClick", "screenToNormalized", "thumb", "setOnRangeSeekBarViewChangeListener", "l", "touchDown", "x", "y", "touchMove", "touchUp", "trackTouchEvent", "upDatePositionMax", "upDatePositionMin", "Companion", "SavedState", "Thumb", "seekbar_release"})
@SuppressLint(value={"AppCompatCustomView"})
public class DoubleValueSeekBarView
extends View {
    private boolean seekBarTouchEnabled;
    private Thumb pressedThumb;
    private int mActivePointerId;
    private int pointerIndex;
    private boolean isDragging;
    private int minValueToDraw;
    private int maxValueToDraw;
    private int barHeight;
    private int circleRadius;
    private int circleTextSize;
    private int defaultPadding;
    private Paint barBasePaint;
    private Paint barFillPaint;
    private Paint minCirclePaint;
    private Paint maxCirclePaint;
    private Paint minValuePaint;
    private Paint maxValuePaint;
    private OnDoubleValueSeekBarChangeListener mOnDoubleValueSeekBarViewChangeListener;
    private int minStep;
    private int maxStep;
    private int maxValue;
    private int minValue;
    private int baseColor;
    private int fillColor;
    private int circleTextColor;
    private int circleFillColor;
    private int currentMinValue;
    private int currentMaxValue;
    private static final int DEFAULT_BASE_COLOR = -7829368;
    private static final int DEFAULT_FILL_COLOR = -65536;
    private static final int DEFAULT_TEXT_COLOR = -12303292;
    private static final int DEFAULT_CIRCLE_COLOR = -16711936;
    private static final int DEFAULT_MIN_VALUE = 0;
    private static final int DEFAULT_MAX_VALUE = 100;
    private static final int DEFAULT_MAX_STEP_VALUE = 1;
    private static final int DEFAULT_MIN_STEP_VALUE = 1;
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    public final int getMinStep() {
        return this.minStep;
    }

    public final void setMinStep(int value) {
        this.minStep = value;
        this.invalidate();
        this.requestLayout();
    }

    public final int getMaxStep() {
        return this.maxStep;
    }

    public final void setMaxStep(int value) {
        this.maxStep = value;
        this.invalidate();
        this.requestLayout();
    }

    public final int getMaxValue() {
        return this.maxValue;
    }

    public final void setMaxValue(int value) {
        this.maxValue = value;
        this.invalidate();
        this.requestLayout();
    }

    public final int getMinValue() {
        return this.minValue;
    }

    public final void setMinValue(int value) {
        this.minValue = value;
        this.invalidate();
        this.requestLayout();
    }

    public final int getBaseColor() {
        return this.baseColor;
    }

    public final void setBaseColor(@ColorInt int color) {
        this.baseColor = color;
        this.barBasePaint.setColor(color);
        this.invalidate();
    }

    public final int getFillColor() {
        return this.fillColor;
    }

    public final void setFillColor(@ColorInt int color) {
        this.fillColor = color;
        this.barFillPaint.setColor(color);
        this.invalidate();
    }

    public final int getCircleTextColor() {
        return this.circleTextColor;
    }

    public final void setCircleTextColor(@ColorInt int color) {
        this.circleTextColor = color;
        this.minValuePaint.setColor(color);
        this.maxValuePaint.setColor(color);
        this.invalidate();
    }

    public final int getCircleFillColor() {
        return this.circleFillColor;
    }

    public final void setCircleFillColor(@ColorInt int color) {
        this.circleFillColor = color;
        this.minCirclePaint.setColor(color);
        this.maxCirclePaint.setColor(color);
        this.invalidate();
    }

    public final int getCurrentMinValue() {
        return this.currentMinValue;
    }

    public final void setCurrentMinValue(int value) {
        if (value > this.currentMaxValue) {
            return;
        }
        this.currentMinValue = value;
        int newValue = value;
        if (newValue < this.minValue || newValue > this.maxValue) {
            newValue = this.currentMinValue;
        }
        if (newValue % this.maxStep == 0) {
            this.currentMinValue = newValue;
        }
        this.minValueToDraw = this.currentMinValue;
        this.invalidate();
    }

    public final int getCurrentMaxValue() {
        return this.currentMaxValue;
    }

    public final void setCurrentMaxValue(int value) {
        if (value < this.currentMinValue) {
            return;
        }
        this.currentMaxValue = value;
        int newValue = value;
        if (newValue < this.minValue || newValue > this.maxValue) {
            newValue = this.currentMaxValue;
        }
        if (newValue % this.maxStep == 0) {
            this.currentMaxValue = newValue;
        }
        this.maxValueToDraw = this.currentMaxValue;
        this.invalidate();
    }

    private final void init(AttributeSet attrs) {
        this.parseAttr(attrs);
        Paint paint = this.barBasePaint;
        boolean bl = false;
        boolean bl2 = false;
        Paint $this$apply = paint;
        boolean bl3 = false;
        $this$apply.setColor(this.baseColor);
        paint = this.barFillPaint;
        bl = false;
        bl2 = false;
        $this$apply = paint;
        boolean bl4 = false;
        $this$apply.setColor(this.fillColor);
        paint = this.minValuePaint;
        bl = false;
        bl2 = false;
        $this$apply = paint;
        boolean bl5 = false;
        $this$apply.setTextSize((float)this.circleTextSize);
        $this$apply.setColor(this.circleTextColor);
        $this$apply.setTextAlign(Paint.Align.CENTER);
        paint = this.maxValuePaint;
        bl = false;
        bl2 = false;
        $this$apply = paint;
        boolean bl6 = false;
        $this$apply.setTextSize((float)this.circleTextSize);
        $this$apply.setColor(this.circleTextColor);
        $this$apply.setTextAlign(Paint.Align.CENTER);
        paint = this.minCirclePaint;
        bl = false;
        bl2 = false;
        $this$apply = paint;
        boolean bl7 = false;
        $this$apply.setColor(this.circleFillColor);
        paint = this.maxCirclePaint;
        bl = false;
        bl2 = false;
        $this$apply = paint;
        boolean bl8 = false;
        $this$apply.setColor(this.circleFillColor);
    }

    private final void parseAttr(AttributeSet attrs) {
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.DoubleValueSeekBarView, 0, 0);
        if (typedArray.hasValue(R.styleable.DoubleValueSeekBarView_r2minValueStep)) {
            this.setMinStep(typedArray.getInt(R.styleable.DoubleValueSeekBarView_r2minValueStep, 0));
        }
        if (typedArray.hasValue(R.styleable.DoubleValueSeekBarView_r2maxValueStep)) {
            this.setMaxStep(typedArray.getInt(R.styleable.DoubleValueSeekBarView_r2maxValueStep, 0));
        }
        if (typedArray.hasValue(R.styleable.DoubleValueSeekBarView_r2minValue)) {
            this.setMinValue(typedArray.getInt(R.styleable.DoubleValueSeekBarView_r2minValue, 0));
        }
        if (typedArray.hasValue(R.styleable.DoubleValueSeekBarView_r2maxValue)) {
            this.setMaxValue(typedArray.getInt(R.styleable.DoubleValueSeekBarView_r2maxValue, 0));
        }
        if (typedArray.hasValue(R.styleable.DoubleValueSeekBarView_r2barHeight)) {
            this.barHeight = typedArray.getDimensionPixelSize(R.styleable.DoubleValueSeekBarView_r2barHeight, 0);
        }
        if (typedArray.hasValue(R.styleable.DoubleValueSeekBarView_r2circleRadius)) {
            this.defaultPadding = this.circleRadius = typedArray.getDimensionPixelSize(R.styleable.DoubleValueSeekBarView_r2circleRadius, 0);
        }
        if (typedArray.hasValue(R.styleable.DoubleValueSeekBarView_r2circleTextSize)) {
            this.circleTextSize = typedArray.getDimensionPixelSize(R.styleable.DoubleValueSeekBarView_r2circleTextSize, 0);
        }
        if (typedArray.hasValue(R.styleable.DoubleValueSeekBarView_r2circleTextColor)) {
            this.setCircleTextColor(typedArray.getColor(R.styleable.DoubleValueSeekBarView_r2circleTextColor, -12303292));
        }
        if (typedArray.hasValue(R.styleable.DoubleValueSeekBarView_r2circleFillColor)) {
            this.setCircleFillColor(typedArray.getColor(R.styleable.DoubleValueSeekBarView_r2circleFillColor, -16711936));
        }
        if (typedArray.hasValue(R.styleable.DoubleValueSeekBarView_r2baseColor)) {
            this.setBaseColor(typedArray.getColor(R.styleable.DoubleValueSeekBarView_r2baseColor, -7829368));
        }
        if (typedArray.hasValue(R.styleable.DoubleValueSeekBarView_r2fillColor)) {
            this.setFillColor(typedArray.getColor(R.styleable.DoubleValueSeekBarView_r2fillColor, -65536));
        }
        if (typedArray.hasValue(R.styleable.DoubleValueSeekBarView_r2CurrentMaxValue)) {
            this.setCurrentMaxValue(typedArray.getInt(R.styleable.DoubleValueSeekBarView_r2CurrentMaxValue, 100));
        }
        if (typedArray.hasValue(R.styleable.DoubleValueSeekBarView_r2CurrentMinValue)) {
            this.setCurrentMinValue(typedArray.getInt(R.styleable.DoubleValueSeekBarView_r2CurrentMinValue, 0));
        }
        this.setPadding(this.defaultPadding, this.defaultPadding, this.defaultPadding, this.defaultPadding);
        typedArray.recycle();
    }

    public final void setOnRangeSeekBarViewChangeListener(@NotNull OnDoubleValueSeekBarChangeListener l) {
        Intrinsics.checkParameterIsNotNull((Object)l, (String)"l");
        this.mOnDoubleValueSeekBarViewChangeListener = l;
    }

    private final int calculateProgress(int value, int MIN, int MAX) {
        return 100 * (value - MIN) / (MAX - MIN);
    }

    private final int measureHeight(int measureSpec) {
        int size = this.getPaddingTop() + this.getPaddingBottom();
        return View.resolveSizeAndState((int)(size += Math.max(this.barHeight, this.circleRadius)), (int)measureSpec, (int)0);
    }

    private final int measureWidth(int measureSpec) {
        int size = this.getPaddingLeft() + this.getPaddingRight();
        return View.resolveSizeAndState((int)size, (int)measureSpec, (int)0);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.measureWidth(widthMeasureSpec), this.measureHeight(heightMeasureSpec));
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        this.drawDoubleValueBarHorizontal(canvas);
    }

    private final void drawDoubleValueBarHorizontal(Canvas canvas) {
        float barLength = this.getWidth() - this.getPaddingRight() - this.getPaddingLeft();
        float barCenter = this.getHeight() / 2;
        float halfBarHeight = this.barHeight / 2;
        float top = barCenter - halfBarHeight;
        float bottom = barCenter + halfBarHeight;
        float left = this.getPaddingLeft();
        float right = (float)this.getPaddingLeft() + barLength;
        RectF rect = new RectF(left, top, right, bottom);
        canvas.drawRoundRect(rect, halfBarHeight, halfBarHeight, this.barBasePaint);
        float percentFilledMin = (float)this.calculateProgress(this.minValueToDraw, this.minValue, this.maxValue) / (float)100;
        float fillLengthMin = barLength * percentFilledMin;
        float fillPositionMin = left + fillLengthMin;
        float percentFilledMax = (float)this.calculateProgress(this.maxValueToDraw, this.minValue, this.maxValue) / (float)100;
        float fillLengthMax = barLength * percentFilledMax;
        float fillPositionMax = left + fillLengthMax;
        RectF fillRect = new RectF(fillPositionMin, top, fillPositionMax, bottom);
        canvas.drawRoundRect(fillRect, barCenter, barCenter, this.barFillPaint);
        canvas.drawCircle(fillPositionMin, barCenter, (float)this.circleRadius, this.minCirclePaint);
        canvas.drawCircle(fillPositionMax, barCenter, (float)this.circleRadius, this.maxCirclePaint);
        Rect boundsMin = new Rect();
        String minValueString = String.valueOf(Math.round((double)this.minValueToDraw));
        this.minValuePaint.getTextBounds(minValueString, 0, minValueString.length(), boundsMin);
        Rect boundsMax = new Rect();
        String maxValueString = String.valueOf(Math.round((double)this.maxValueToDraw));
        this.maxValuePaint.getTextBounds(maxValueString, 0, maxValueString.length(), boundsMax);
        float y = barCenter + (float)(boundsMin.height() / 2);
        canvas.drawText(minValueString, fillPositionMin, y, this.minValuePaint);
        canvas.drawText(maxValueString, fillPositionMax, y, this.maxValuePaint);
    }

    private final void upDatePositionMax(int value) {
        double calcValue = MathKt.roundToInt((float)(value * (this.maxValue - this.minValue) / 100));
        int displayValue = ((int)calcValue + this.minValue) / this.maxStep * this.maxStep;
        this.setCurrentMaxValue(displayValue);
    }

    private final void upDatePositionMin(int value) {
        double calcValue = MathKt.roundToInt((float)(value * (this.maxValue - this.minValue) / 100));
        int displayValue = ((int)calcValue + this.minValue) / this.minStep * this.minStep;
        this.setCurrentMinValue(displayValue);
    }

    public boolean performClick() {
        super.performClick();
        return true;
    }

    private final int normalizedToScreen(int normalizedCoord) {
        float widthSize = this.getWidth() - this.getPaddingStart() - this.getPaddingEnd();
        return MathKt.roundToInt((float)((float)normalizedCoord / (float)this.maxValue * widthSize));
    }

    private final boolean isInThumbRange(float touchX, int normalizedThumbValue) {
        return Math.abs(touchX - (float)this.normalizedToScreen(normalizedThumbValue)) <= this.getThumbWidth();
    }

    private final float getThumbWidth() {
        return (float)this.circleRadius * 2.0f;
    }

    private final Thumb evalPressedThumb(float touchX) {
        Thumb result = null;
        boolean minThumbPressed = this.isInThumbRange(touchX, this.normalizedToScreen(this.currentMinValue));
        boolean maxThumbPressed = this.isInThumbRange(touchX, this.normalizedToScreen(this.currentMaxValue));
        if (minThumbPressed && maxThumbPressed) {
            result = touchX / (float)this.getWidth() > 0.5f ? Thumb.MIN : Thumb.MAX;
        } else if (minThumbPressed) {
            result = Thumb.MIN;
        } else if (maxThumbPressed) {
            result = Thumb.MAX;
        }
        if (this.seekBarTouchEnabled && result == null) {
            result = this.findClosestThumb(touchX);
        }
        Thumb thumb = result;
        if (thumb == null) {
            Intrinsics.throwNpe();
        }
        return thumb;
    }

    private final Thumb findClosestThumb(float touchX) {
        double maxDiff;
        int screenMinX = this.normalizedToScreen(this.currentMinValue);
        int screenMaxX = this.normalizedToScreen(this.currentMaxValue);
        if (touchX >= (float)screenMaxX) {
            return Thumb.MAX;
        }
        if (touchX <= (float)screenMinX) {
            return Thumb.MIN;
        }
        double minDiff = Math.abs((double)screenMinX - (double)touchX);
        return minDiff < (maxDiff = Math.abs((double)screenMaxX - (double)touchX)) ? Thumb.MIN : Thumb.MAX;
    }

    private final void attemptClaimDrag() {
        if (this.getParent() != null) {
            this.getParent().requestDisallowInterceptTouchEvent(true);
        }
    }

    private final void onStartTrackingTouch() {
        this.isDragging = true;
    }

    private final void onStopTrackingTouch() {
        this.isDragging = false;
    }

    private final void trackTouchEvent(MotionEvent event) {
        int pointerIndex = event.findPointerIndex(this.mActivePointerId);
        try {
            float x = event.getX(pointerIndex);
            if (Thumb.MIN == this.pressedThumb) {
                this.screenToNormalized(x, Thumb.MIN);
            } else if (Thumb.MAX == this.pressedThumb) {
                this.screenToNormalized(x, Thumb.MAX);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final int normalize(float screenCoord) {
        double width = this.getWidth();
        float coordinate = screenCoord;
        double canvasSize = width - (double)this.getPaddingStart() - (double)this.getPaddingEnd();
        if (coordinate < 0.0f) {
            coordinate = 0.0f;
        } else if ((double)screenCoord > canvasSize) {
            coordinate = (float)canvasSize;
        }
        int value = (int)((double)coordinate / canvasSize * (double)100);
        return value;
    }

    private final void screenToNormalized(float screenCoord, Thumb thumb) {
        double width = this.getWidth();
        float coordinate = screenCoord;
        double canvasSize = width - (double)this.getPaddingStart() - (double)this.getPaddingEnd();
        if (coordinate < 0.0f) {
            coordinate = 0.0f;
        } else if ((double)screenCoord > canvasSize) {
            coordinate = (float)canvasSize;
        }
        int value = (int)((double)coordinate / canvasSize * (double)100);
        if (thumb == Thumb.MIN) {
            this.upDatePositionMin(value);
        } else {
            this.upDatePositionMax(value);
        }
    }

    protected final void touchDown(float x, float y) {
    }

    protected final void touchMove(float x, float y) {
    }

    protected final void touchUp(float x, float y) {
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return false;
        }
        int action = event.getAction();
        switch (action & 0xFF) {
            case 0: {
                this.mActivePointerId = event.getPointerId(event.getPointerCount() - 1);
                this.pointerIndex = event.findPointerIndex(this.mActivePointerId);
                float mDownMotionX = event.getX(this.pointerIndex);
                this.pressedThumb = this.evalPressedThumb(mDownMotionX);
                if (this.pressedThumb == null) {
                    return super.onTouchEvent(event);
                }
                this.touchDown(event.getX(this.pointerIndex), event.getY(this.pointerIndex));
                this.setPressed(true);
                this.invalidate();
                this.onStartTrackingTouch();
                this.trackTouchEvent(event);
                this.attemptClaimDrag();
                break;
            }
            case 2: {
                if (this.pressedThumb == null) break;
                if (this.isDragging) {
                    this.touchMove(event.getX(this.pointerIndex), event.getY(this.pointerIndex));
                    this.trackTouchEvent(event);
                }
                OnDoubleValueSeekBarChangeListener onDoubleValueSeekBarChangeListener = this.mOnDoubleValueSeekBarViewChangeListener;
                if (onDoubleValueSeekBarChangeListener != null) {
                    onDoubleValueSeekBarChangeListener.onValueChanged(this, this.currentMinValue, this.currentMaxValue, true);
                }
                break;
            }
            case 1: {
                if (this.isDragging) {
                    this.trackTouchEvent(event);
                    this.onStopTrackingTouch();
                    this.setPressed(false);
                    this.touchUp(event.getX(this.pointerIndex), event.getY(this.pointerIndex));
                    OnDoubleValueSeekBarChangeListener onDoubleValueSeekBarChangeListener = this.mOnDoubleValueSeekBarViewChangeListener;
                    if (onDoubleValueSeekBarChangeListener != null) {
                        onDoubleValueSeekBarChangeListener.onStopTrackingTouch(this, this.currentMinValue, this.currentMaxValue);
                    }
                } else {
                    this.onStartTrackingTouch();
                    this.trackTouchEvent(event);
                    this.onStopTrackingTouch();
                }
                this.pressedThumb = null;
                this.invalidate();
                OnDoubleValueSeekBarChangeListener onDoubleValueSeekBarChangeListener = this.mOnDoubleValueSeekBarViewChangeListener;
                if (onDoubleValueSeekBarChangeListener != null) {
                    onDoubleValueSeekBarChangeListener.onValueChanged(this, this.currentMinValue, this.currentMaxValue, true);
                }
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.invalidate();
                break;
            }
            case 3: {
                if (this.isDragging) {
                    this.onStopTrackingTouch();
                    this.setPressed(false);
                    this.touchUp(event.getX(this.pointerIndex), event.getY(this.pointerIndex));
                }
                this.invalidate();
            }
        }
        return true;
    }

    @NotNull
    protected Parcelable onSaveInstanceState() {
        Parcelable superState;
        Parcelable parcelable = superState = super.onSaveInstanceState();
        if (parcelable == null) {
            Intrinsics.throwNpe();
        }
        SavedState ss = new SavedState(parcelable);
        ss.setMinValue$seekbar_release(this.currentMinValue);
        ss.setMaxValue$seekbar_release(this.currentMaxValue);
        return (Parcelable)ss;
    }

    protected void onRestoreInstanceState(@NotNull Parcelable state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        SavedState ss = (SavedState)state;
        this.setCurrentMinValue(ss.getMinValue$seekbar_release());
        this.setCurrentMaxValue(ss.getMaxValue$seekbar_release());
        this.minValueToDraw = this.currentMinValue;
        this.maxValueToDraw = this.currentMaxValue;
        super.onRestoreInstanceState(ss.getSuperState());
    }

    public DoubleValueSeekBarView(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.seekBarTouchEnabled = true;
        this.mActivePointerId = -1;
        this.isDragging = true;
        this.maxValueToDraw = 100;
        this.defaultPadding = 15;
        this.barBasePaint = new Paint(1);
        this.barFillPaint = new Paint(1);
        this.minCirclePaint = new Paint(1);
        this.maxCirclePaint = new Paint(1);
        this.minValuePaint = new Paint(1);
        this.maxValuePaint = new Paint(1);
        this.minStep = 1;
        this.maxStep = 1;
        this.maxValue = 100;
        this.baseColor = -7829368;
        this.fillColor = -65536;
        this.circleTextColor = -12303292;
        this.circleFillColor = -16711936;
        this.currentMaxValue = 100;
    }

    public DoubleValueSeekBarView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.seekBarTouchEnabled = true;
        this.mActivePointerId = -1;
        this.isDragging = true;
        this.maxValueToDraw = 100;
        this.defaultPadding = 15;
        this.barBasePaint = new Paint(1);
        this.barFillPaint = new Paint(1);
        this.minCirclePaint = new Paint(1);
        this.maxCirclePaint = new Paint(1);
        this.minValuePaint = new Paint(1);
        this.maxValuePaint = new Paint(1);
        this.minStep = 1;
        this.maxStep = 1;
        this.maxValue = 100;
        this.baseColor = -7829368;
        this.fillColor = -65536;
        this.circleTextColor = -12303292;
        this.circleFillColor = -16711936;
        this.currentMaxValue = 100;
        this.init(attrs);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0084\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/mohammedalaa/seekbar/DoubleValueSeekBarView$Thumb;", "", "(Ljava/lang/String;I)V", "MIN", "MAX", "seekbar_release"})
    protected static final class Thumb
    extends Enum<Thumb> {
        public static final /* enum */ Thumb MIN;
        public static final /* enum */ Thumb MAX;
        private static final /* synthetic */ Thumb[] $VALUES;

        static {
            Thumb[] thumbArray = new Thumb[2];
            Thumb[] thumbArray2 = thumbArray;
            thumbArray[0] = MIN = new Thumb();
            thumbArray[1] = MAX = new Thumb();
            $VALUES = thumbArray;
        }

        public static Thumb[] values() {
            return (Thumb[])$VALUES.clone();
        }

        public static Thumb valueOf(String string) {
            return Enum.valueOf(Thumb.class, string);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0012\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\tH\u0016R\u001a\u0010\b\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\r\u00a8\u0006\u0016"}, d2={"Lcom/mohammedalaa/seekbar/DoubleValueSeekBarView$SavedState;", "Landroid/view/View$BaseSavedState;", "superState", "Landroid/os/Parcelable;", "(Landroid/os/Parcelable;)V", "in", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "maxValue", "", "getMaxValue$seekbar_release", "()I", "setMaxValue$seekbar_release", "(I)V", "minValue", "getMinValue$seekbar_release", "setMinValue$seekbar_release", "writeToParcel", "", "out", "flags", "Companion", "seekbar_release"})
    private static final class SavedState
    extends View.BaseSavedState {
        private int minValue;
        private int maxValue;
        @JvmField
        @NotNull
        public static final Parcelable.Creator<SavedState> CREATOR;
        public static final Companion Companion;

        public final int getMinValue$seekbar_release() {
            return this.minValue;
        }

        public final void setMinValue$seekbar_release(int n) {
            this.minValue = n;
        }

        public final int getMaxValue$seekbar_release() {
            return this.maxValue;
        }

        public final void setMaxValue$seekbar_release(int n) {
            this.maxValue = n;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
            super.writeToParcel(out, flags);
            out.writeInt(this.minValue);
            out.writeInt(this.maxValue);
        }

        public SavedState(@NotNull Parcelable superState) {
            Intrinsics.checkParameterIsNotNull((Object)superState, (String)"superState");
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.minValue = in.readInt();
            this.maxValue = in.readInt();
        }

        static {
            Companion = new Companion(null);
            CREATOR = (Parcelable.Creator)new Parcelable.Creator<SavedState>(){

                @NotNull
                public SavedState createFromParcel(@NotNull Parcel in) {
                    Intrinsics.checkParameterIsNotNull((Object)in, (String)"in");
                    return new SavedState(in, null);
                }

                @NotNull
                public SavedState[] newArray(int size) {
                    return new SavedState[size];
                }
            };
        }

        public /* synthetic */ SavedState(Parcel in, DefaultConstructorMarker $constructor_marker) {
            this(in);
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/mohammedalaa/seekbar/DoubleValueSeekBarView$SavedState$Companion;", "", "()V", "CREATOR", "Landroid/os/Parcelable$Creator;", "Lcom/mohammedalaa/seekbar/DoubleValueSeekBarView$SavedState;", "seekbar_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/mohammedalaa/seekbar/DoubleValueSeekBarView$Companion;", "", "()V", "DEFAULT_BASE_COLOR", "", "DEFAULT_CIRCLE_COLOR", "DEFAULT_FILL_COLOR", "DEFAULT_MAX_STEP_VALUE", "DEFAULT_MAX_VALUE", "DEFAULT_MIN_STEP_VALUE", "DEFAULT_MIN_VALUE", "DEFAULT_TEXT_COLOR", "seekbar_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

