/*
 * Decompiled with CFR 0.152.
 */
package com.mohammedalaa.seekbar;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.SeekBar;
import androidx.appcompat.widget.AppCompatSeekBar;
import com.mohammedalaa.seekbar.OnRangeSeekBarChangeListener;
import com.mohammedalaa.seekbar.R;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u00012\u00020\u0002:\u0001IB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020\u0017H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\u0006\u0010.\u001a\u00020\u0017J\u0018\u0010/\u001a\u00020+2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u00100\u001a\u00020\u00172\u0006\u00101\u001a\u00020\u0017H\u0002J\u0010\u00102\u001a\u00020\u00172\u0006\u00101\u001a\u00020\u0017H\u0002J\u0010\u00103\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0014J\u0018\u00104\u001a\u00020+2\u0006\u00105\u001a\u00020\u00172\u0006\u00106\u001a\u00020\u0017H\u0014J \u00107\u001a\u00020+2\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u00172\u0006\u0010;\u001a\u00020\nH\u0016J\u0010\u0010<\u001a\u00020+2\u0006\u0010=\u001a\u00020>H\u0016J\b\u0010?\u001a\u00020>H\u0016J\u0010\u0010@\u001a\u00020+2\u0006\u00108\u001a\u000209H\u0016J\u0010\u0010A\u001a\u00020+2\u0006\u00108\u001a\u000209H\u0016J\u0016\u0010B\u001a\u00020+2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010C\u001a\u00020+2\u0006\u0010D\u001a\u00020\u0017J\u000e\u0010E\u001a\u00020+2\u0006\u0010\"\u001a\u00020\u0017J\u000e\u0010F\u001a\u00020+2\u0006\u0010'\u001a\u00020\u0017J\u000e\u0010G\u001a\u00020+2\u0006\u0010H\u001a\u00020!R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lcom/mohammedalaa/seekbar/RangeSeekBarView;", "Landroidx/appcompat/widget/AppCompatSeekBar;", "Landroid/widget/SeekBar$OnSeekBarChangeListener;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "animated", "", "animation", "Landroid/animation/ValueAnimator;", "animationDuration", "", "barBasePaint", "Landroid/graphics/Paint;", "barCenter", "", "getBarCenter", "()F", "barFillPaint", "barHeight", "", "baseColor", "circlePaint", "circleRadius", "circleTextColor", "circleTextSize", "currentValue", "currentValuePaint", "fillColor", "mOnRangeSeekBarViewChangeListener", "Lcom/mohammedalaa/seekbar/OnRangeSeekBarChangeListener;", "maxValue", "minValue", "step", "valueToDraw", "calculateProgress", "value", "MIN", "MAX", "drawBar", "", "canvas", "Landroid/graphics/Canvas;", "getCurrentValue", "init", "measureHeight", "measureSpec", "measureWidth", "onDraw", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onProgressChanged", "seekBar", "Landroid/widget/SeekBar;", "progress", "fromUser", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "onSaveInstanceState", "onStartTrackingTouch", "onStopTrackingTouch", "setAnimated", "setCurrentValue", "newVal", "setMaxValue", "setMinValue", "setOnRangeSeekBarViewChangeListener", "l", "SavedState", "seekbar_release"})
public final class RangeSeekBarView
extends AppCompatSeekBar
implements SeekBar.OnSeekBarChangeListener {
    private int maxValue;
    private int currentValue;
    private int minValue;
    private float valueToDraw;
    private int step;
    private int barHeight;
    private int circleRadius;
    private int circleTextSize;
    private int circleTextColor;
    private int baseColor;
    private int fillColor;
    private Paint barBasePaint;
    private Paint barFillPaint;
    private Paint circlePaint;
    private Paint currentValuePaint;
    private boolean animated;
    private long animationDuration;
    private ValueAnimator animation;
    private OnRangeSeekBarChangeListener mOnRangeSeekBarViewChangeListener;
    private HashMap _$_findViewCache;

    private final float getBarCenter() {
        return (this.getHeight() - this.getPaddingTop() - this.getPaddingBottom()) / 2;
    }

    private final void init(Context context, AttributeSet attrs) {
        this.setSaveEnabled(true);
        Drawable drawable = this.getThumb().mutate();
        Intrinsics.checkExpressionValueIsNotNull((Object)drawable, (String)"this.thumb.mutate()");
        drawable.setAlpha(0);
        this.setBackgroundColor(0);
        this.setBackgroundColor(0);
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.RangeSeekBarView, 0, 0);
        if (typedArray.hasValue(R.styleable.RangeSeekBarView_stepValue)) {
            this.step = typedArray.getInt(R.styleable.RangeSeekBarView_stepValue, 0);
        }
        if (typedArray.hasValue(R.styleable.RangeSeekBarView_minValue)) {
            this.minValue = typedArray.getInt(R.styleable.RangeSeekBarView_minValue, 0);
        }
        if (typedArray.hasValue(R.styleable.RangeSeekBarView_maxValue)) {
            this.maxValue = typedArray.getInt(R.styleable.RangeSeekBarView_maxValue, 0);
        }
        if (typedArray.hasValue(R.styleable.RangeSeekBarView_currentValue)) {
            this.currentValue = typedArray.getInt(R.styleable.RangeSeekBarView_currentValue, 0);
        }
        if (typedArray.hasValue(R.styleable.RangeSeekBarView_barHeight)) {
            this.barHeight = typedArray.getDimensionPixelSize(R.styleable.RangeSeekBarView_barHeight, 0);
        }
        if (typedArray.hasValue(R.styleable.RangeSeekBarView_circleRadius)) {
            this.circleRadius = typedArray.getDimensionPixelSize(R.styleable.RangeSeekBarView_circleRadius, 0);
        }
        if (typedArray.hasValue(R.styleable.RangeSeekBarView_circleTextSize)) {
            this.circleTextSize = typedArray.getDimensionPixelSize(R.styleable.RangeSeekBarView_circleTextSize, 0);
        }
        if (typedArray.hasValue(R.styleable.RangeSeekBarView_circleTextColor)) {
            this.circleTextColor = typedArray.getColor(R.styleable.RangeSeekBarView_circleTextColor, -65536);
        }
        if (typedArray.hasValue(R.styleable.RangeSeekBarView_baseColor)) {
            this.baseColor = typedArray.getColor(R.styleable.RangeSeekBarView_baseColor, -7829368);
        }
        if (typedArray.hasValue(R.styleable.RangeSeekBarView_fillColor)) {
            this.fillColor = typedArray.getColor(R.styleable.RangeSeekBarView_fillColor, -16777216);
        }
        this.setMax(100);
        if (this.currentValue < this.minValue || this.currentValue > this.maxValue) {
            throw (Throwable)new RuntimeException("Value must be in range   (min <= value <= max) ");
        }
        this.setProgress(this.calculateProgress(this.currentValue, this.minValue, this.maxValue));
        this.setCurrentValue(this.currentValue);
        typedArray.recycle();
        Paint paint = this.barBasePaint = new Paint(1);
        if (paint == null) {
            Intrinsics.throwNpe();
        }
        paint.setColor(this.baseColor);
        Paint paint2 = this.barFillPaint = new Paint(1);
        if (paint2 == null) {
            Intrinsics.throwNpe();
        }
        paint2.setColor(this.fillColor);
        Paint paint3 = this.circlePaint = new Paint(1);
        if (paint3 == null) {
            Intrinsics.throwNpe();
        }
        paint3.setColor(this.fillColor);
        Paint paint4 = this.currentValuePaint = new Paint(1);
        if (paint4 == null) {
            Intrinsics.throwNpe();
        }
        paint4.setTextSize((float)this.circleTextSize);
        Paint paint5 = this.currentValuePaint;
        if (paint5 == null) {
            Intrinsics.throwNpe();
        }
        paint5.setColor(this.circleTextColor);
        Paint paint6 = this.currentValuePaint;
        if (paint6 == null) {
            Intrinsics.throwNpe();
        }
        paint6.setTextAlign(Paint.Align.CENTER);
        this.setOnSeekBarChangeListener(this);
    }

    public final void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
        this.invalidate();
        this.requestLayout();
    }

    public final int getCurrentValue() {
        return this.currentValue;
    }

    public final void setCurrentValue(int newVal) {
        int newValue = newVal;
        int previousValue = this.currentValue;
        if (newValue < this.minValue || newValue > this.maxValue) {
            newValue = this.currentValue;
        }
        if (newValue % this.step == 0) {
            this.currentValue = newValue;
        }
        ValueAnimator valueAnimator = this.animation;
        if (valueAnimator != null) {
            valueAnimator.cancel();
        }
        if (this.animated) {
            this.animation = ValueAnimator.ofFloat((float[])new float[]{previousValue, this.currentValue});
            int changeInValue = Math.abs(this.currentValue - previousValue);
            long durationToUse = (long)((float)this.animationDuration * ((float)changeInValue / (float)this.maxValue));
            ValueAnimator valueAnimator2 = this.animation;
            if (valueAnimator2 == null) {
                Intrinsics.throwNpe();
            }
            valueAnimator2.setDuration(durationToUse);
            ValueAnimator valueAnimator3 = this.animation;
            if (valueAnimator3 == null) {
                Intrinsics.throwNpe();
            }
            valueAnimator3.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
                final /* synthetic */ RangeSeekBarView this$0;

                public final void onAnimationUpdate(ValueAnimator valueAnimator) {
                    ValueAnimator valueAnimator2 = valueAnimator;
                    Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator2, (String)"valueAnimator");
                    Object object = valueAnimator2.getAnimatedValue();
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Float");
                    }
                    RangeSeekBarView.access$setValueToDraw$p(this.this$0, ((Float)object).floatValue());
                    this.this$0.invalidate();
                }
                {
                    this.this$0 = rangeSeekBarView;
                }
            });
            ValueAnimator valueAnimator4 = this.animation;
            if (valueAnimator4 == null) {
                Intrinsics.throwNpe();
            }
            valueAnimator4.start();
        } else {
            this.valueToDraw = this.currentValue;
        }
        this.invalidate();
    }

    private final int calculateProgress(int value, int MIN, int MAX) {
        return 100 * (value - MIN) / (MAX - MIN);
    }

    public final void setMinValue(int value) {
        this.minValue = value;
        this.invalidate();
        this.requestLayout();
    }

    public final void setAnimated(boolean animated, long animationDuration) {
        this.animated = animated;
        this.animationDuration = animationDuration;
    }

    private final int measureHeight(int measureSpec) {
        int size = this.getPaddingTop() + this.getPaddingBottom();
        return View.resolveSizeAndState((int)(size += Math.max(this.barHeight, this.circleRadius * 2)), (int)measureSpec, (int)0);
    }

    private final int measureWidth(int measureSpec) {
        int size = this.getPaddingLeft() + this.getPaddingRight();
        return View.resolveSizeAndState((int)size, (int)measureSpec, (int)0);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.measureWidth(widthMeasureSpec), this.measureHeight(heightMeasureSpec));
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        this.drawBar(canvas);
    }

    private final void drawBar(Canvas canvas) {
        float barLength = this.getWidth() - this.getPaddingRight() - this.getPaddingLeft();
        float barCenter = this.getBarCenter();
        float halfBarHeight = this.barHeight / 2;
        float top = barCenter - halfBarHeight;
        float bottom = barCenter + halfBarHeight;
        float left = this.getPaddingLeft();
        float right = (float)this.getPaddingLeft() + barLength;
        RectF rect = new RectF(left, top, right, bottom);
        Paint paint = this.barBasePaint;
        if (paint == null) {
            Intrinsics.throwNpe();
        }
        canvas.drawRoundRect(rect, halfBarHeight, halfBarHeight, paint);
        float percentFilled = (float)this.calculateProgress((int)this.valueToDraw, this.minValue, this.maxValue) / (float)this.getMax();
        float fillLength = barLength * percentFilled;
        float fillPosition = left + fillLength;
        RectF fillRect = new RectF(left, top, fillPosition, bottom);
        Paint paint2 = this.barFillPaint;
        if (paint2 == null) {
            Intrinsics.throwNpe();
        }
        canvas.drawRoundRect(fillRect, halfBarHeight, halfBarHeight, paint2);
        float f = this.circleRadius;
        Paint paint3 = this.circlePaint;
        if (paint3 == null) {
            Intrinsics.throwNpe();
        }
        canvas.drawCircle(fillPosition, barCenter, f, paint3);
        Rect bounds = new Rect();
        String valueString = String.valueOf(Math.round(this.valueToDraw));
        Paint paint4 = this.currentValuePaint;
        if (paint4 == null) {
            Intrinsics.throwNpe();
        }
        paint4.getTextBounds(valueString, 0, valueString.length(), bounds);
        float y = barCenter + (float)(bounds.height() / 2);
        Paint paint5 = this.currentValuePaint;
        if (paint5 == null) {
            Intrinsics.throwNpe();
        }
        canvas.drawText(valueString, fillPosition, y, paint5);
    }

    public void onProgressChanged(@NotNull SeekBar seekBar, int progress, boolean fromUser) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)seekBar, (String)"seekBar");
            double calcValue = MathKt.roundToInt((float)(progress * (this.maxValue - this.minValue) / 100));
            int displayValue = ((int)calcValue + this.minValue) / this.step * this.step;
            this.setCurrentValue(displayValue);
            OnRangeSeekBarChangeListener onRangeSeekBarChangeListener = this.mOnRangeSeekBarViewChangeListener;
            if (onRangeSeekBarChangeListener == null) break block0;
            onRangeSeekBarChangeListener.onProgressChanged(this, displayValue, fromUser);
        }
    }

    public void onStopTrackingTouch(@NotNull SeekBar seekBar) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)seekBar, (String)"seekBar");
            OnRangeSeekBarChangeListener onRangeSeekBarChangeListener = this.mOnRangeSeekBarViewChangeListener;
            if (onRangeSeekBarChangeListener == null) break block0;
            onRangeSeekBarChangeListener.onStopTrackingTouch(this);
        }
    }

    public void onStartTrackingTouch(@NotNull SeekBar seekBar) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)seekBar, (String)"seekBar");
            OnRangeSeekBarChangeListener onRangeSeekBarChangeListener = this.mOnRangeSeekBarViewChangeListener;
            if (onRangeSeekBarChangeListener == null) break block0;
            onRangeSeekBarChangeListener.onStartTrackingTouch(this);
        }
    }

    public final void setOnRangeSeekBarViewChangeListener(@NotNull OnRangeSeekBarChangeListener l) {
        Intrinsics.checkParameterIsNotNull((Object)l, (String)"l");
        this.mOnRangeSeekBarViewChangeListener = l;
    }

    @NotNull
    public Parcelable onSaveInstanceState() {
        Parcelable superState;
        Parcelable parcelable = superState = super.onSaveInstanceState();
        if (parcelable == null) {
            Intrinsics.throwNpe();
        }
        SavedState ss = new SavedState(parcelable);
        ss.setValue$seekbar_release(this.currentValue);
        return (Parcelable)ss;
    }

    public void onRestoreInstanceState(@NotNull Parcelable state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        SavedState ss = (SavedState)state;
        this.currentValue = ss.getValue$seekbar_release();
        this.valueToDraw = this.currentValue;
        super.onRestoreInstanceState(ss.getSuperState());
    }

    public RangeSeekBarView(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.animationDuration = 3000L;
    }

    public RangeSeekBarView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.animationDuration = 3000L;
        this.init(context, attrs);
    }

    public static final /* synthetic */ float access$getValueToDraw$p(RangeSeekBarView $this) {
        return $this.valueToDraw;
    }

    public static final /* synthetic */ void access$setValueToDraw$p(RangeSeekBarView $this, float f) {
        $this.valueToDraw = f;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0012\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\tH\u0016R\u001a\u0010\b\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lcom/mohammedalaa/seekbar/RangeSeekBarView$SavedState;", "Landroid/view/View$BaseSavedState;", "superState", "Landroid/os/Parcelable;", "(Landroid/os/Parcelable;)V", "in", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "value", "", "getValue$seekbar_release", "()I", "setValue$seekbar_release", "(I)V", "writeToParcel", "", "out", "flags", "Companion", "seekbar_release"})
    private static final class SavedState
    extends View.BaseSavedState {
        private int value;
        @JvmField
        @NotNull
        public static final Parcelable.Creator<SavedState> CREATOR;
        public static final Companion Companion;

        public final int getValue$seekbar_release() {
            return this.value;
        }

        public final void setValue$seekbar_release(int n) {
            this.value = n;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
            super.writeToParcel(out, flags);
            out.writeInt(this.value);
        }

        public SavedState(@NotNull Parcelable superState) {
            Intrinsics.checkParameterIsNotNull((Object)superState, (String)"superState");
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.value = in.readInt();
        }

        static {
            Companion = new Companion(null);
            CREATOR = (Parcelable.Creator)new Parcelable.Creator<SavedState>(){

                @NotNull
                public SavedState createFromParcel(@NotNull Parcel in) {
                    Intrinsics.checkParameterIsNotNull((Object)in, (String)"in");
                    return new SavedState(in, null);
                }

                @NotNull
                public SavedState[] newArray(int size) {
                    return new SavedState[size];
                }
            };
        }

        public /* synthetic */ SavedState(Parcel in, DefaultConstructorMarker $constructor_marker) {
            this(in);
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/mohammedalaa/seekbar/RangeSeekBarView$SavedState$Companion;", "", "()V", "CREATOR", "Landroid/os/Parcelable$Creator;", "Lcom/mohammedalaa/seekbar/RangeSeekBarView$SavedState;", "seekbar_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

