/*
 * Decompiled with CFR 0.152.
 */
package net.aquadc.collections;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.AbstractList;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import net.aquadc.collections.ArrayIterator;
import net.aquadc.collections.Arrayz;
import net.aquadc.collections.ListArrayIterator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010*\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B+\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0012\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0016J+\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0004\"\u0004\b\u0001\u0010\u00012\u0010\u0010\u0016\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00170\u0004H\u0002\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00020\u0006H\u0096\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001fH\u0096\u0002J\u0015\u0010 \u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\"H\u0016J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\"2\u0006\u0010\u001a\u001a\u00020\u0006H\u0016J\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0015\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0004H\u0014\u00a2\u0006\u0002\u0010&J'\u0010%\u001a\b\u0012\u0004\u0012\u0002H'0\u0004\"\u0004\b\u0001\u0010'2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H'0\u0004H\u0014\u00a2\u0006\u0002\u0010\u0018R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lnet/aquadc/collections/SubArray;", "E", "Lkotlin/collections/AbstractList;", "array", "", "fromIndex", "", "toIndex", "step", "([Ljava/lang/Object;III)V", "[Ljava/lang/Object;", "size", "getSize", "()I", "contains", "", "element", "(Ljava/lang/Object;)Z", "containsAll", "elements", "", "copyInto", "dst", "", "([Ljava/lang/Object;)[Ljava/lang/Object;", "get", "index", "(I)Ljava/lang/Object;", "indexOf", "(Ljava/lang/Object;)I", "iterator", "", "lastIndexOf", "listIterator", "", "subList", "", "toArray", "()[Ljava/lang/Object;", "T", "Collection-utils"})
final class SubArray<E>
extends AbstractList<E> {
    @NotNull
    private final E[] array;
    private final int fromIndex;
    private final int toIndex;
    private final int step;

    public SubArray(@NotNull E[] array, int fromIndex, int toIndex, int step) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        this.array = array;
        this.fromIndex = fromIndex;
        this.toIndex = toIndex;
        this.step = step;
    }

    public int getSize() {
        return (this.toIndex - this.fromIndex) / this.step;
    }

    public E get(int index) {
        Arrayz.rangeCheck(index, this.size());
        return this.array[this.fromIndex + index * this.step];
    }

    public boolean contains(Object element) {
        return this.indexOf(element) >= 0;
    }

    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Iterable $this$all$iv = elements;
            boolean $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator = $this$all$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = iterator.next();
                    boolean bl2 = false;
                    if (this.indexOf(it) >= 0) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public Iterator<E> iterator() {
        return new ArrayIterator<E>(this.array, this.fromIndex, this.toIndex, this.step);
    }

    @NotNull
    public ListIterator<E> listIterator() {
        return new ListArrayIterator<E>(this.array, this.fromIndex, this.fromIndex, this.toIndex, this.step);
    }

    @NotNull
    public ListIterator<E> listIterator(int index) {
        Arrayz.listIteratorBoundsCheck(index, this.size());
        return new ListArrayIterator<E>(this.array, this.fromIndex, this.fromIndex + index * this.step, this.toIndex, this.step);
    }

    public int indexOf(Object element) {
        for (int index = this.fromIndex; index < this.toIndex; index += this.step) {
            if (!Intrinsics.areEqual(this.array[index], (Object)element)) continue;
            return (index - this.fromIndex) / this.step;
        }
        return -1;
    }

    public int lastIndexOf(Object element) {
        for (int index = this.toIndex - this.step; index >= this.fromIndex; index -= this.step) {
            if (!Intrinsics.areEqual(this.array[index], (Object)element)) continue;
            return (index - this.fromIndex) / this.step;
        }
        return -1;
    }

    @NotNull
    public List<E> subList(int fromIndex, int toIndex) {
        Arrayz.subArrayRangeCheck(fromIndex, toIndex, this.size());
        int from = this.fromIndex;
        return Arrayz.newSubList(this.array, from + fromIndex * this.step, from + toIndex * this.step, this.step);
    }

    @NotNull
    public Object[] toArray() {
        return this.copyInto(new Object[this.size()]);
    }

    @NotNull
    public <T> T[] toArray(@NotNull T[] array) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter(array, (String)"array");
        if (array.length < this.size()) {
            T[] TArray = array;
            int n = this.size();
            boolean bl = false;
            T[] TArray2 = Arrays.copyOf(TArray, n);
            objectArray = TArray2;
            Intrinsics.checkNotNullExpressionValue(TArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
        } else {
            objectArray = array;
        }
        return this.copyInto(objectArray);
    }

    private final <E> E[] copyInto(Object[] dst) {
        if (this.step == 1) {
            ArraysKt.copyInto((Object[])this.array, (Object[])dst, (int)0, (int)this.fromIndex, (int)this.toIndex);
        } else {
            int dstIdx = 0;
            for (int srcIdx = this.fromIndex; srcIdx < this.toIndex; srcIdx += this.step) {
                int n = dstIdx;
                dstIdx = n + 1;
                dst[n] = this.array[srcIdx];
            }
        }
        if (dst.length > this.size()) {
            dst[this.size()] = null;
        }
        return dst;
    }
}

