/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.utils.view.globalPositioning;

import android.graphics.Point;
import android.graphics.Rect;
import android.view.View;
import com.merseyside.utils.view.ext.PointExtKt;
import com.merseyside.utils.view.ext.RectExtKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001\u001a\u0016\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006\u001a(\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u001a4\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0001\u001a%\u0010\u0013\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0015\u001a%\u0010\u0016\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0015\u001a\u0016\u0010\u0017\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0018"}, d2={"getGlobalScreenRect", "Landroid/graphics/Rect;", "screenWidth", "", "screenHeight", "scrollPosition", "Landroid/graphics/Point;", "getRelativeToParentGlobalRect", "", "view", "Landroid/view/View;", "rect", "getScreenCoordByScrollPosition", "screenCoord", "globalPointToScreenPoint", "point", "globalRectToVisibleRect", "globalRect", "screenVisibleRect", "globalXToScreenCoords", "coord", "(IILandroid/graphics/Point;)Ljava/lang/Integer;", "globalYToScreenCoords", "screenCoordToGlobalCoord", "utils_release"})
public final class GlobalPositioningKt {
    @Nullable
    public static final Integer globalXToScreenCoords(int coord, int screenWidth, @NotNull Point scrollPosition) {
        Intrinsics.checkNotNullParameter((Object)scrollPosition, (String)"scrollPosition");
        int n = scrollPosition.x;
        return (coord <= scrollPosition.x + screenWidth ? n <= coord : false) ? Integer.valueOf(coord - scrollPosition.x) : null;
    }

    @Nullable
    public static final Integer globalYToScreenCoords(int coord, int screenHeight, @NotNull Point scrollPosition) {
        Intrinsics.checkNotNullParameter((Object)scrollPosition, (String)"scrollPosition");
        int n = scrollPosition.y;
        return (coord <= scrollPosition.y + screenHeight ? n <= coord : false) ? Integer.valueOf(coord - scrollPosition.y) : null;
    }

    @Nullable
    public static final Point globalPointToScreenPoint(@NotNull Point point, int screenWidth, int screenHeight, @NotNull Point scrollPosition) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)scrollPosition, (String)"scrollPosition");
        Integer n = GlobalPositioningKt.globalXToScreenCoords(point.x, screenWidth, scrollPosition);
        if (n == null) {
            return null;
        }
        Integer n2 = GlobalPositioningKt.globalYToScreenCoords(point.y, screenHeight, scrollPosition);
        if (n2 == null) {
            return null;
        }
        return new Point(n.intValue(), n2.intValue());
    }

    @NotNull
    public static final Point screenCoordToGlobalCoord(@NotNull Point screenCoord, @NotNull Point scrollPosition) {
        Intrinsics.checkNotNullParameter((Object)screenCoord, (String)"screenCoord");
        Intrinsics.checkNotNullParameter((Object)scrollPosition, (String)"scrollPosition");
        return PointExtKt.plus(scrollPosition, screenCoord);
    }

    @NotNull
    public static final Point getScreenCoordByScrollPosition(@NotNull Point screenCoord, @NotNull Point scrollPosition) {
        Intrinsics.checkNotNullParameter((Object)screenCoord, (String)"screenCoord");
        Intrinsics.checkNotNullParameter((Object)scrollPosition, (String)"scrollPosition");
        return PointExtKt.minus(screenCoord, scrollPosition);
    }

    @NotNull
    public static final Rect getGlobalScreenRect(int screenWidth, int screenHeight, @NotNull Point scrollPosition) {
        Intrinsics.checkNotNullParameter((Object)scrollPosition, (String)"scrollPosition");
        return new Rect(scrollPosition.x, scrollPosition.y, scrollPosition.x + screenWidth, scrollPosition.y + screenHeight);
    }

    @Nullable
    public static final Rect globalRectToVisibleRect(@NotNull Rect globalRect, int screenWidth, int screenHeight, @NotNull Point scrollPosition, @Nullable Rect screenVisibleRect) {
        Rect rect;
        Rect intersectedRect;
        Intrinsics.checkNotNullParameter((Object)globalRect, (String)"globalRect");
        Intrinsics.checkNotNullParameter((Object)scrollPosition, (String)"scrollPosition");
        Rect $this$globalRectToVisibleRect_u24lambda_u2d2 = globalRect;
        boolean bl = false;
        Rect globalScreenRect = GlobalPositioningKt.getGlobalScreenRect(screenWidth, screenHeight, scrollPosition);
        Rect $this$globalRectToVisibleRect_u24lambda_u2d2_u24lambda_u2d0 = RectExtKt.Rect(new Point($this$globalRectToVisibleRect_u24lambda_u2d2.left, $this$globalRectToVisibleRect_u24lambda_u2d2.top), new Point($this$globalRectToVisibleRect_u24lambda_u2d2.right, $this$globalRectToVisibleRect_u24lambda_u2d2.bottom));
        boolean bl2 = false;
        Rect rect2 = intersectedRect = RectExtKt.getIntersectedRect($this$globalRectToVisibleRect_u24lambda_u2d2_u24lambda_u2d0, globalScreenRect);
        if (rect2 == null) {
            rect = null;
        } else {
            Rect intersected = rect2;
            boolean bl3 = false;
            Point leftTop = GlobalPositioningKt.globalPointToScreenPoint(new Point(intersected.left, intersected.top), screenWidth, screenHeight, scrollPosition);
            Point rightBottom = GlobalPositioningKt.globalPointToScreenPoint(new Point(intersected.right, intersected.bottom), screenWidth, screenHeight, scrollPosition);
            if (leftTop == null || rightBottom == null) {
                rect = null;
            } else {
                Rect rect3 = RectExtKt.Rect(leftTop, rightBottom);
                rect = screenVisibleRect != null ? RectExtKt.getIntersectedRect(screenVisibleRect, rect3) : rect3;
            }
        }
        return rect;
    }

    public static /* synthetic */ Rect globalRectToVisibleRect$default(Rect rect, int n, int n2, Point point, Rect rect2, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            rect2 = null;
        }
        return GlobalPositioningKt.globalRectToVisibleRect(rect, n, n2, point, rect2);
    }

    public static final void getRelativeToParentGlobalRect(@NotNull View view, @NotNull Rect rect) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        int x = (int)view.getX();
        int y = (int)view.getY();
        rect.left = x;
        rect.right = x + view.getWidth();
        rect.top = y;
        rect.bottom = y + view.getHeight();
    }
}

