/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.utils.view;

import android.graphics.Point;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.merseyside.utils.buffer.BufferQueue;
import com.merseyside.utils.gestures.ClickGestureListener;
import com.merseyside.utils.gestures.SwipeGestureListener;
import com.merseyside.utils.view.ScrollInterpolator;
import com.merseyside.utils.view.ext.PointExtKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0002PQB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u000105J\u000e\u00106\u001a\u0002032\u0006\u00104\u001a\u00020\rJ\u000e\u00107\u001a\u0002032\u0006\u00104\u001a\u00020*J\u0006\u00108\u001a\u000203J\u0010\u00109\u001a\u00020\u001f2\u0006\u0010:\u001a\u00020\u001fH\u0002J\u0010\u0010;\u001a\u00020\u001f2\u0006\u0010<\u001a\u00020\u001fH\u0002J\u000e\u0010=\u001a\u0002032\u0006\u0010>\u001a\u00020\u001fJ\u000e\u0010?\u001a\u0002032\u0006\u0010@\u001a\u00020\u001fJ\u0010\u0010A\u001a\u0002032\u0006\u0010:\u001a\u00020\u001fH\u0002J\u0010\u0010B\u001a\u0002032\u0006\u0010>\u001a\u00020\u001fH\u0002J\u0010\u0010C\u001a\u0002032\u0006\u0010:\u001a\u00020\u001fH\u0002J\u0010\u0010D\u001a\u0002032\u0006\u0010:\u001a\u00020\u001fH\u0002J\u0010\u0010E\u001a\u0002032\u0006\u0010:\u001a\u00020\u001fH\u0002J\u0018\u0010F\u001a\u00020\u00032\u0006\u0010G\u001a\u0002012\u0006\u0010H\u001a\u00020IH\u0016J\u000e\u0010J\u001a\u0002032\u0006\u00104\u001a\u00020\rJ\u0006\u0010K\u001a\u000203J\u000e\u0010L\u001a\u0002032\u0006\u00104\u001a\u00020*J\u0016\u0010M\u001a\u0002032\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014J\u0016\u0010N\u001a\u0002032\u0006\u0010#\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u0014J\u000e\u0010O\u001a\u0002032\u0006\u00100\u001a\u000201R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000f\"\u0004\b\u0012\u0010\u0004R\u001e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u001a\u0010\u001a\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u000f\"\u0004\b\u001b\u0010\u0004R\u000e\u0010\u001c\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010$\u001a\u00020%8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010\n\u001a\u0004\b&\u0010'R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010,\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020\u001f@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b-\u0010.R\u0010\u0010/\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lcom/merseyside/utils/view/TouchManager;", "Landroid/view/View$OnTouchListener;", "enableLongPress", "", "(Z)V", "clickGestureDetector", "Landroid/view/GestureDetector;", "getClickGestureDetector", "()Landroid/view/GestureDetector;", "clickGestureDetector$delegate", "Lkotlin/Lazy;", "clickListeners", "", "Lcom/merseyside/utils/view/TouchManager$OnClickListener;", "getEnableLongPress", "()Z", "enabled", "getEnabled", "setEnabled", "<set-?>", "", "globalHeight", "getGlobalHeight", "()I", "globalWidth", "getGlobalWidth", "isDragAndDrop", "setDragAndDrop", "isLongPressing", "isUserScrolling", "lastPosition", "Landroid/graphics/Point;", "pointQueue", "Lcom/merseyside/utils/buffer/BufferQueue;", "screenHeight", "screenWidth", "scrollInterpolator", "Lcom/merseyside/utils/view/ScrollInterpolator;", "getScrollInterpolator", "()Lcom/merseyside/utils/view/ScrollInterpolator;", "scrollInterpolator$delegate", "scrollListeners", "Lcom/merseyside/utils/view/TouchManager$OnScrollListener;", "value", "scrollPosition", "setScrollPosition", "(Landroid/graphics/Point;)V", "swipeDetector", "view", "Landroid/view/View;", "addGestureListener", "", "listener", "Lcom/merseyside/utils/gestures/SwipeGestureListener;", "addOnClickListener", "addScrollListener", "clear", "getGlobalPosition", "point", "getValidPosition", "tmpPosition", "moveOnDelta", "delta", "moveToPosition", "position", "onClick", "onDeltaChanged", "onLongPress", "onLongPressMove", "onLongPressReleased", "onTouch", "v", "event", "Landroid/view/MotionEvent;", "removeClickListener", "removeGestureListener", "removeScrollListener", "setGlobalSizes", "setScreenSizes", "setView", "OnClickListener", "OnScrollListener", "utils_release"})
public final class TouchManager
implements View.OnTouchListener {
    private final boolean enableLongPress;
    private boolean enabled;
    private boolean isDragAndDrop;
    private int globalWidth;
    private int globalHeight;
    private int screenWidth;
    private int screenHeight;
    private boolean isUserScrolling;
    @NotNull
    private Point lastPosition;
    @NotNull
    private Point scrollPosition;
    @NotNull
    private final BufferQueue<Point> pointQueue;
    private View view;
    @Nullable
    private GestureDetector swipeDetector;
    @NotNull
    private final Lazy clickGestureDetector$delegate;
    @NotNull
    private final Lazy scrollInterpolator$delegate;
    @NotNull
    private List<OnScrollListener> scrollListeners;
    @NotNull
    private List<OnClickListener> clickListeners;
    private boolean isLongPressing;

    public TouchManager(boolean enableLongPress) {
        this.enableLongPress = enableLongPress;
        this.enabled = true;
        this.lastPosition = new Point(0, 0);
        this.scrollPosition = new Point(0, 0);
        this.pointQueue = new BufferQueue(2);
        this.clickGestureDetector$delegate = LazyKt.lazy((Function0)((Function0)new Function0<GestureDetector>(this){
            final /* synthetic */ TouchManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final GestureDetector invoke() {
                View view = TouchManager.access$getView$p(this.this$0);
                if (view == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"view");
                    view = null;
                }
                return new GestureDetector(view.getContext(), (GestureDetector.OnGestureListener)new ClickGestureListener(this.this$0){
                    final /* synthetic */ TouchManager this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public boolean onLongPress(@NotNull Point point) {
                        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
                        TouchManager.access$setLongPressing$p(this.this$0, true);
                        TouchManager.access$onLongPress(this.this$0, point);
                        return true;
                    }

                    public void onClick(@NotNull Point point) {
                        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
                    }
                });
            }
        }));
        this.scrollInterpolator$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ScrollInterpolator>(this){
            final /* synthetic */ TouchManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ScrollInterpolator invoke() {
                ScrollInterpolator scrollInterpolator2 = new ScrollInterpolator(this.this$0.getGlobalWidth() - TouchManager.access$getScreenWidth$p(this.this$0), this.this$0.getGlobalHeight() - TouchManager.access$getScreenHeight$p(this.this$0));
                TouchManager touchManager = this.this$0;
                ScrollInterpolator $this$invoke_u24lambda_u2d0 = scrollInterpolator2;
                boolean bl = false;
                $this$invoke_u24lambda_u2d0.setTimeCoef(0.8f);
                $this$invoke_u24lambda_u2d0.setOnNewValueCallback((Function1<? super Point, Unit>)((Function1)new Function1<Point, Unit>(touchManager){
                    final /* synthetic */ TouchManager this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Point it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        TouchManager.access$setScrollPosition(this.this$0, it);
                    }
                }));
                return scrollInterpolator2;
            }
        }));
        this.scrollListeners = new ArrayList();
        this.clickListeners = new ArrayList();
    }

    public /* synthetic */ TouchManager(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    public final boolean getEnableLongPress() {
        return this.enableLongPress;
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public final boolean isDragAndDrop() {
        return this.isDragAndDrop;
    }

    public final void setDragAndDrop(boolean bl) {
        this.isDragAndDrop = bl;
    }

    public final int getGlobalWidth() {
        return this.globalWidth;
    }

    public final int getGlobalHeight() {
        return this.globalHeight;
    }

    private final void setScrollPosition(Point value) {
        Iterable $this$forEach$iv = this.scrollListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OnScrollListener it = (OnScrollListener)element$iv;
            boolean bl = false;
            it.onPositionChanged(value);
        }
        this.onDeltaChanged(PointExtKt.minus(value, this.scrollPosition));
        this.scrollPosition = value;
        if (this.isUserScrolling) {
            this.pointQueue.add(value);
        }
    }

    private final GestureDetector getClickGestureDetector() {
        Lazy lazy = this.clickGestureDetector$delegate;
        return (GestureDetector)lazy.getValue();
    }

    private final ScrollInterpolator getScrollInterpolator() {
        Lazy lazy = this.scrollInterpolator$delegate;
        return (ScrollInterpolator)lazy.getValue();
    }

    public final void setView(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.view = view;
    }

    public final void addGestureListener(@Nullable SwipeGestureListener listener) {
        View view = this.view;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"view");
            view = null;
        }
        this.swipeDetector = new GestureDetector(view.getContext(), (GestureDetector.OnGestureListener)listener);
    }

    public final void removeGestureListener() {
        this.swipeDetector = null;
    }

    public final void setGlobalSizes(int globalWidth, int globalHeight) {
        this.globalWidth = globalWidth;
        this.globalHeight = globalHeight;
        this.getScrollInterpolator().setMaxWidth(globalWidth - this.screenWidth);
        this.getScrollInterpolator().setMaxHeight(globalHeight - this.screenHeight);
    }

    public final void setScreenSizes(int screenWidth, int screenHeight) {
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        if (this.globalWidth == 0 || this.globalHeight == 0) {
            return;
        }
        if (this.scrollPosition.x + screenWidth > this.globalWidth) {
            int newX = this.globalWidth - screenWidth;
            if (newX < 0) {
                newX = 0;
            }
            this.setScrollPosition(new Point(newX, this.scrollPosition.y));
        }
        if (this.scrollPosition.y + screenHeight > this.globalHeight) {
            int newY = this.globalHeight - screenHeight;
            if (newY < 0) {
                newY = 0;
            }
            this.setScrollPosition(new Point(this.scrollPosition.x, newY));
        }
    }

    private final void onClick(Point point) {
        Iterable $this$forEach$iv = this.clickListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OnClickListener it = (OnClickListener)element$iv;
            boolean bl = false;
            it.onClick(PointExtKt.plus(this.scrollPosition, point), point);
        }
    }

    private final void onLongPress(Point point) {
        Iterable $this$forEach$iv = this.clickListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OnClickListener it = (OnClickListener)element$iv;
            boolean bl = false;
            it.onLongPressed(PointExtKt.plus(this.scrollPosition, point), point);
        }
    }

    private final void onLongPressMove(Point point) {
        Iterable $this$forEach$iv = this.clickListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OnClickListener it = (OnClickListener)element$iv;
            boolean bl = false;
            it.onLongPressMove(PointExtKt.plus(this.scrollPosition, point), point);
        }
    }

    private final void onLongPressReleased(Point point) {
        Iterable $this$forEach$iv = this.clickListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OnClickListener it = (OnClickListener)element$iv;
            boolean bl = false;
            it.onLongPressReleased(PointExtKt.plus(this.scrollPosition, point), point);
        }
    }

    private final void onDeltaChanged(Point delta) {
        Iterable $this$forEach$iv = this.scrollListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OnScrollListener it = (OnScrollListener)element$iv;
            boolean bl = false;
            it.onDeltaChanged(delta);
        }
    }

    public boolean onTouch(@NotNull View v, @NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.enabled) {
            GestureDetector gestureDetector = this.swipeDetector;
            if (gestureDetector != null) {
                GestureDetector detector = gestureDetector;
                boolean bl = false;
                if (detector.onTouchEvent(event)) {
                    return true;
                }
            }
            if (this.enableLongPress && this.getClickGestureDetector().onTouchEvent(event)) {
                return true;
            }
            if (this.globalWidth == 0 || this.globalHeight == 0) {
                return false;
            }
            Point currentPoint = new Point((int)event.getX(), (int)event.getY());
            switch (event.getAction() & 0xFF) {
                case 0: {
                    this.lastPosition = currentPoint;
                    this.getScrollInterpolator().stopScrolling();
                    break;
                }
                case 2: {
                    if (this.isLongPressing) {
                        this.onLongPressMove(currentPoint);
                        break;
                    }
                    if (Intrinsics.areEqual((Object)this.lastPosition, (Object)currentPoint)) break;
                    this.isUserScrolling = !this.isLongPressing;
                    this.setScrollPosition(this.getGlobalPosition(currentPoint));
                    break;
                }
                case 1: {
                    if (this.isLongPressing) {
                        this.isLongPressing = false;
                        this.onLongPressReleased(currentPoint);
                    } else if (Intrinsics.areEqual((Object)this.lastPosition, (Object)currentPoint) && !this.isUserScrolling) {
                        this.onClick(this.lastPosition);
                        View view = this.view;
                        if (view == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"view");
                            view = null;
                        }
                        view.performClick();
                    } else if (this.pointQueue.isNotEmpty() && this.pointQueue.getSize() != 1) {
                        ScrollInterpolator scrollInterpolator2 = this.getScrollInterpolator();
                        Point point = this.pointQueue.getFirst();
                        Intrinsics.checkNotNull((Object)point);
                        Point point2 = this.pointQueue.getLast();
                        Intrinsics.checkNotNull((Object)point2);
                        scrollInterpolator2.startScrolling(point, point2);
                    }
                    this.isUserScrolling = false;
                    this.pointQueue.clear();
                }
            }
            return true;
        }
        return false;
    }

    private final Point getGlobalPosition(Point point) {
        Point delta = new Point(this.lastPosition.x - point.x, this.lastPosition.y - point.y);
        this.lastPosition = point;
        if (this.isDragAndDrop) {
            delta = PointExtKt.inverse(delta);
        }
        Point tmpPosition = PointExtKt.plus(this.scrollPosition, delta);
        return this.getValidPosition(tmpPosition);
    }

    public final void moveToPosition(@NotNull Point position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.setScrollPosition(this.getValidPosition(position));
    }

    public final void moveOnDelta(@NotNull Point delta) {
        Intrinsics.checkNotNullParameter((Object)delta, (String)"delta");
        this.setScrollPosition(this.getValidPosition(PointExtKt.plus(this.scrollPosition, delta)));
    }

    public final void addScrollListener(@NotNull OnScrollListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.scrollListeners.add(listener);
    }

    public final void removeScrollListener(@NotNull OnScrollListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.scrollListeners.remove(listener);
    }

    public final void addOnClickListener(@NotNull OnClickListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.clickListeners.add(listener);
    }

    public final void removeClickListener(@NotNull OnClickListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.clickListeners.remove(listener);
    }

    public final void clear() {
        this.lastPosition = new Point();
        this.setScrollPosition(new Point());
    }

    private final Point getValidPosition(Point tmpPosition) {
        if (tmpPosition.x < 0) {
            tmpPosition.x = 0;
        }
        if (tmpPosition.x + this.screenWidth > this.globalWidth) {
            tmpPosition.x = this.globalWidth - this.screenWidth;
        }
        if (tmpPosition.y < 0) {
            tmpPosition.y = 0;
        }
        if (tmpPosition.y + this.screenHeight > this.globalHeight) {
            tmpPosition.y = this.globalHeight - this.screenHeight;
        }
        Point globalPosition = new Point();
        if (tmpPosition.x >= 0 && tmpPosition.x + this.screenWidth <= this.globalWidth) {
            globalPosition = new Point(tmpPosition.x, this.scrollPosition.y);
        }
        if (tmpPosition.y >= 0 && tmpPosition.y + this.screenHeight <= this.globalHeight) {
            globalPosition = new Point(globalPosition.x, tmpPosition.y);
        }
        return globalPosition;
    }

    public TouchManager() {
        this(false, 1, null);
    }

    public static final /* synthetic */ View access$getView$p(TouchManager $this) {
        return $this.view;
    }

    public static final /* synthetic */ void access$setLongPressing$p(TouchManager $this, boolean bl) {
        $this.isLongPressing = bl;
    }

    public static final /* synthetic */ void access$onLongPress(TouchManager $this, Point point) {
        $this.onLongPress(point);
    }

    public static final /* synthetic */ int access$getScreenWidth$p(TouchManager $this) {
        return $this.screenWidth;
    }

    public static final /* synthetic */ int access$getScreenHeight$p(TouchManager $this) {
        return $this.screenHeight;
    }

    public static final /* synthetic */ void access$setScrollPosition(TouchManager $this, Point value) {
        $this.setScrollPosition(value);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0005H&\u00a8\u0006\b"}, d2={"Lcom/merseyside/utils/view/TouchManager$OnScrollListener;", "", "onDeltaChanged", "", "delta", "Landroid/graphics/Point;", "onPositionChanged", "position", "utils_release"})
    public static interface OnScrollListener {
        public void onPositionChanged(@NotNull Point var1);

        public void onDeltaChanged(@NotNull Point var1);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&J\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&J\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&J\u0018\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&\u00a8\u0006\n"}, d2={"Lcom/merseyside/utils/view/TouchManager$OnClickListener;", "", "onClick", "", "globalCoord", "Landroid/graphics/Point;", "screenCoord", "onLongPressMove", "onLongPressReleased", "onLongPressed", "utils_release"})
    public static interface OnClickListener {
        public void onClick(@NotNull Point var1, @NotNull Point var2);

        public void onLongPressed(@NotNull Point var1, @NotNull Point var2);

        public void onLongPressMove(@NotNull Point var1, @NotNull Point var2);

        public void onLongPressReleased(@NotNull Point var1, @NotNull Point var2);
    }
}

