/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.utils.layout;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B3\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\u001a\u0010\u000f\u001a\u00020\u00052\b\b\u0001\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J \u0010\u0010\u001a\u00020\u00112\f\b\u0001\u0010\u0012\u001a\u00060\u0013R\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/merseyside/utils/layout/GridAutofitLayoutManager;", "Landroidx/recyclerview/widget/GridLayoutManager;", "context", "Landroid/content/Context;", "columnWidth", "", "(Landroid/content/Context;I)V", "orientation", "reverseLayout", "", "maxColumnRowCount", "(Landroid/content/Context;IIZI)V", "isColumnWidthChanged", "lastHeight", "lastWidth", "checkedColumnWidth", "onLayoutChildren", "", "recycler", "Landroidx/recyclerview/widget/RecyclerView$Recycler;", "Landroidx/recyclerview/widget/RecyclerView;", "state", "Landroidx/recyclerview/widget/RecyclerView$State;", "setColumnWidth", "newColumnWidth", "utils_release"})
public final class GridAutofitLayoutManager
extends GridLayoutManager {
    private int columnWidth;
    private boolean isColumnWidthChanged;
    private int lastWidth;
    private int lastHeight;
    private int maxColumnRowCount;

    public GridAutofitLayoutManager(@NonNull @NotNull Context context, int columnWidth) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, 1);
        this.isColumnWidthChanged = true;
        this.setColumnWidth(this.checkedColumnWidth(context, columnWidth));
    }

    public GridAutofitLayoutManager(@NonNull @NotNull Context context, int columnWidth, int orientation, boolean reverseLayout, int maxColumnRowCount) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, 1, orientation, reverseLayout);
        this.isColumnWidthChanged = true;
        this.maxColumnRowCount = maxColumnRowCount;
        this.setColumnWidth(this.checkedColumnWidth(context, columnWidth));
    }

    public /* synthetic */ GridAutofitLayoutManager(Context context, int n, int n2, boolean bl, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 0x10) != 0) {
            n3 = 0;
        }
        this(context, n, n2, bl, n3);
    }

    private final int checkedColumnWidth(@NonNull Context context, int columnWidth) {
        int mutColumnWidth = columnWidth;
        if (mutColumnWidth <= 0) {
            mutColumnWidth = (int)TypedValue.applyDimension((int)1, (float)48.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
        }
        return mutColumnWidth;
    }

    public final void setColumnWidth(int newColumnWidth) {
        if (newColumnWidth > 0 && newColumnWidth != this.columnWidth) {
            this.columnWidth = newColumnWidth;
            this.isColumnWidthChanged = true;
        }
    }

    public void onLayoutChildren(@NonNull @NotNull RecyclerView.Recycler recycler, @NonNull @NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)recycler, (String)"recycler");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.columnWidth > 0 && width > 0 && height > 0 && (this.isColumnWidthChanged || this.lastWidth != width || this.lastHeight != height)) {
            int totalSpace = this.getOrientation() == 1 ? width - this.getPaddingRight() - this.getPaddingLeft() : height - this.getPaddingTop() - this.getPaddingBottom();
            int spanCount = this.maxColumnRowCount == 0 ? Math.max(1, totalSpace / this.columnWidth) : Math.min(this.maxColumnRowCount, totalSpace / this.columnWidth);
            this.setSpanCount(spanCount);
            this.isColumnWidthChanged = false;
        }
        this.lastWidth = width;
        this.lastHeight = height;
        super.onLayoutChildren(recycler, state);
    }
}

