/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.utils;

import android.content.res.Configuration;
import androidx.appcompat.app.AppCompatDelegate;
import com.merseyside.utils.Logger;
import com.merseyside.utils.preferences.PreferenceManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\bJ\u0006\u0010\f\u001a\u00020\bJ\u0006\u0010\r\u001a\u00020\nJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0014\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/merseyside/utils/ThemeManager;", "", "()V", "THEME_KEY", "", "preferenceManager", "Lcom/merseyside/utils/preferences/PreferenceManager;", "savedTheme", "Lcom/merseyside/utils/ThemeManager$Theme;", "apply", "", "theme", "getSavedTheme", "initTheme", "isDarkTheme", "", "configuration", "Landroid/content/res/Configuration;", "isLightTheme", "setPrefsManager", "setTheme", "Theme", "utils_release"})
public final class ThemeManager {
    private static Theme savedTheme;
    private static PreferenceManager preferenceManager;
    private static final String THEME_KEY = "theme";
    @NotNull
    public static final ThemeManager INSTANCE;

    public final void setPrefsManager(@NotNull PreferenceManager preferenceManager) {
        Intrinsics.checkNotNullParameter((Object)preferenceManager, (String)"preferenceManager");
        ThemeManager.preferenceManager = preferenceManager;
    }

    public final void setTheme(@Nullable Theme theme) {
        savedTheme = theme;
    }

    public final boolean isDarkTheme(@NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        int currentNightMode = configuration.uiMode & 0x30;
        return currentNightMode == 32;
    }

    public final boolean isLightTheme(@NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return !this.isDarkTheme(configuration);
    }

    public final void apply(@Nullable Theme theme) {
        if (theme != null) {
            AppCompatDelegate.setDefaultNightMode((int)theme.getThemeId$utils_release());
            PreferenceManager preferenceManager = ThemeManager.preferenceManager;
            if (preferenceManager != null) {
                preferenceManager.put(THEME_KEY, theme.getThemeId$utils_release());
            }
        } else {
            Logger.INSTANCE.log(this, "Theme hasn't been set");
        }
    }

    public static /* synthetic */ void apply$default(ThemeManager themeManager, Theme theme, int n, Object object) {
        if ((n & 1) != 0) {
            theme = savedTheme;
        }
        themeManager.apply(theme);
    }

    public final void initTheme() {
        block3: {
            block2: {
                PreferenceManager preferenceManager = ThemeManager.preferenceManager;
                if (preferenceManager == null) break block2;
                PreferenceManager preferenceManager2 = preferenceManager;
                boolean bl = false;
                boolean bl2 = false;
                PreferenceManager it = preferenceManager2;
                boolean bl3 = false;
                INSTANCE.apply(INSTANCE.getSavedTheme());
                preferenceManager = preferenceManager2;
                if (preferenceManager != null) break block3;
            }
            throw (Throwable)new IllegalStateException("Preference manager hasn't been set");
        }
    }

    @NotNull
    public final Theme getSavedTheme() {
        Object object;
        block3: {
            block2: {
                object = preferenceManager;
                if (object == null) break block2;
                PreferenceManager preferenceManager = object;
                boolean bl = false;
                boolean bl2 = false;
                PreferenceManager it = preferenceManager;
                boolean bl3 = false;
                PreferenceManager preferenceManager2 = ThemeManager.preferenceManager;
                Intrinsics.checkNotNull((Object)preferenceManager2);
                object = Theme.Companion.getThemeById(preferenceManager2.getInt(THEME_KEY, Theme.DEFAULT.getThemeId$utils_release()));
                if (object != null) break block3;
            }
            throw (Throwable)new IllegalStateException("Preference manager hasn't been set");
        }
        return object;
    }

    private ThemeManager() {
    }

    static {
        ThemeManager themeManager;
        INSTANCE = themeManager = new ThemeManager();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0001\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\nB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\u000b"}, d2={"Lcom/merseyside/utils/ThemeManager$Theme;", "", "themeId", "", "(Ljava/lang/String;II)V", "getThemeId$utils_release", "()I", "LIGHT", "DARK", "DEFAULT", "Companion", "utils_release"})
    public static final class Theme
    extends Enum<Theme> {
        public static final /* enum */ Theme LIGHT;
        public static final /* enum */ Theme DARK;
        public static final /* enum */ Theme DEFAULT;
        private static final /* synthetic */ Theme[] $VALUES;
        private final int themeId;
        @NotNull
        public static final Companion Companion;

        static {
            Theme[] themeArray = new Theme[3];
            Theme[] themeArray2 = themeArray;
            themeArray[0] = LIGHT = new Theme(1);
            themeArray[1] = DARK = new Theme(2);
            themeArray[2] = DEFAULT = new Theme(-1);
            $VALUES = themeArray;
            Companion = new Companion(null);
        }

        public final int getThemeId$utils_release() {
            return this.themeId;
        }

        private Theme(int themeId) {
            this.themeId = themeId;
        }

        public static Theme[] values() {
            return (Theme[])$VALUES.clone();
        }

        public static Theme valueOf(String string2) {
            return Enum.valueOf(Theme.class, string2);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/merseyside/utils/ThemeManager$Theme$Companion;", "", "()V", "getThemeById", "Lcom/merseyside/utils/ThemeManager$Theme;", "themeId", "", "utils_release"})
        public static final class Companion {
            @Nullable
            public final Theme getThemeById(int themeId) {
                Theme theme;
                block1: {
                    Theme[] themeArray = Theme.values();
                    boolean bl = false;
                    Theme[] themeArray2 = themeArray;
                    boolean bl2 = false;
                    Theme[] themeArray3 = themeArray2;
                    int n = themeArray3.length;
                    for (int i = 0; i < n; ++i) {
                        Theme theme2;
                        Theme it = theme2 = themeArray3[i];
                        boolean bl3 = false;
                        if (!(it.getThemeId$utils_release() == themeId)) continue;
                        theme = theme2;
                        break block1;
                    }
                    theme = null;
                }
                return theme;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

