/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.utils.binding;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import androidx.annotation.DrawableRes;
import androidx.core.content.ContextCompat;
import androidx.databinding.BindingAdapter;
import coil.Coil;
import coil.ImageLoader;
import coil.request.ImageRequest;
import coil.transform.CircleCropTransformation;
import coil.transform.Transformation;
import com.merseyside.utils.LibUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a'\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\n\b\u0001\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007\u00a2\u0006\u0002\u0010\u0007\u001a4\u0010\b\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fH\u0007\u001a\u0016\u0010\u000e\u001a\u00020\u0001*\u00020\u00022\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0007\u001a\u0016\u0010\u0010\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0007\u001a\u001d\u0010\u0013\u001a\u00020\u0001*\u00020\u00022\n\b\u0001\u0010\u0014\u001a\u0004\u0018\u00010\u0006H\u0007\u00a2\u0006\u0002\u0010\u0015\u001a\u001d\u0010\u0016\u001a\u00020\u0001*\u00020\u00022\n\b\u0001\u0010\u0017\u001a\u0004\u0018\u00010\u0006H\u0007\u00a2\u0006\u0002\u0010\u0015\u001a\u0016\u0010\u0018\u001a\u00020\u0001*\u00020\u00022\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0007\u00a8\u0006\u0019"}, d2={"imageUrl", "", "Landroid/widget/ImageView;", "url", "", "placeholderId", "", "(Landroid/widget/ImageView;Ljava/lang/String;Ljava/lang/Integer;)V", "imageUrlDrawablePlaceholder", "placeholder", "Landroid/graphics/drawable/Drawable;", "isCropCircle", "", "isCrossfade", "loadDrawableByName", "name", "loadImageBitmap", "bitmap", "Landroid/graphics/Bitmap;", "loadImageDrawable", "drawableRes", "(Landroid/widget/ImageView;Ljava/lang/Integer;)V", "loadVectorDrawable", "resId", "loadVectorDrawableByName", "utils_release"})
public final class ImageBindingKt {
    @BindingAdapter(value={"app:drawableName"})
    public static final void loadDrawableByName(@NotNull ImageView $this$loadDrawableByName, @Nullable String name) {
        Intrinsics.checkNotNullParameter((Object)$this$loadDrawableByName, (String)"$this$loadDrawableByName");
        if (name != null) {
            Context context = $this$loadDrawableByName.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            int drawableRes = LibUtils.getDrawableResourceIdByName(context, name);
            ImageBindingKt.loadImageDrawable($this$loadDrawableByName, drawableRes);
        }
    }

    @BindingAdapter(value={"app:vectorDrawableName"})
    public static final void loadVectorDrawableByName(@NotNull ImageView $this$loadVectorDrawableByName, @Nullable String name) {
        Intrinsics.checkNotNullParameter((Object)$this$loadVectorDrawableByName, (String)"$this$loadVectorDrawableByName");
        if (name != null) {
            Context context = $this$loadVectorDrawableByName.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            int drawableRes = LibUtils.getDrawableResourceIdByName(context, name);
            ImageBindingKt.loadImageDrawable($this$loadVectorDrawableByName, drawableRes);
        }
    }

    @BindingAdapter(value={"app:bitmap"})
    public static final void loadImageBitmap(@NotNull ImageView $this$loadImageBitmap, @Nullable Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)$this$loadImageBitmap, (String)"$this$loadImageBitmap");
        if (bitmap != null) {
            $this$loadImageBitmap.setImageBitmap(bitmap);
        }
    }

    @BindingAdapter(value={"app:drawableRes"})
    public static final void loadImageDrawable(@NotNull ImageView $this$loadImageDrawable, @DrawableRes @Nullable Integer drawableRes) {
        Intrinsics.checkNotNullParameter((Object)$this$loadImageDrawable, (String)"$this$loadImageDrawable");
        if (drawableRes != null) {
            $this$loadImageDrawable.setImageDrawable(ContextCompat.getDrawable((Context)$this$loadImageDrawable.getContext(), (int)drawableRes));
        }
    }

    @BindingAdapter(value={"app:vectorDrawable"})
    public static final void loadVectorDrawable(@NotNull ImageView $this$loadVectorDrawable, @DrawableRes @Nullable Integer resId) {
        Intrinsics.checkNotNullParameter((Object)$this$loadVectorDrawable, (String)"$this$loadVectorDrawable");
        if (resId != null) {
            $this$loadVectorDrawable.setImageResource(resId.intValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    @BindingAdapter(value={"imageUrl", "imagePlaceholder"}, requireAll=false)
    public static final void imageUrl(@NotNull ImageView $this$imageUrl, @Nullable String url, @DrawableRes @Nullable Integer placeholderId) {
        Drawable drawable;
        Intrinsics.checkNotNullParameter((Object)$this$imageUrl, (String)"$this$imageUrl");
        ImageView $this$load$iv = $this$imageUrl;
        Context context = $this$load$iv.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        Context $this$imageLoader$iv$iv = context;
        boolean $i$f$imageLoader = false;
        ImageLoader imageLoader$iv = Coil.imageLoader((Context)$this$imageLoader$iv$iv);
        boolean $i$f$load = false;
        ImageView $this$loadAny$iv$iv = $this$load$iv;
        boolean $i$f$loadAny = false;
        Context context2 = $this$loadAny$iv$iv.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        ImageRequest.Builder builder = new ImageRequest.Builder(context2).data((Object)url).target($this$loadAny$iv$iv);
        boolean bl = false;
        boolean bl2 = false;
        ImageRequest.Builder $this$load = builder;
        boolean bl3 = false;
        ImageRequest.Builder builder2 = $this$load;
        Integer n = placeholderId;
        if (n != null) {
            void it;
            Integer n2 = n;
            boolean bl4 = false;
            boolean bl5 = false;
            int n3 = ((Number)n2).intValue();
            ImageRequest.Builder builder3 = builder2;
            boolean bl6 = false;
            Drawable drawable2 = ContextCompat.getDrawable((Context)$this$imageUrl.getContext(), (int)it);
            builder2 = builder3;
            drawable = drawable2;
        } else {
            drawable = null;
        }
        builder2.placeholder(drawable);
        ImageRequest request$iv$iv = builder.build();
        imageLoader$iv.enqueue(request$iv$iv);
    }

    @BindingAdapter(value={"imageUrl", "imagePlaceholder", "cropCircle", "crossfade"}, requireAll=false)
    public static final void imageUrlDrawablePlaceholder(@NotNull ImageView $this$imageUrlDrawablePlaceholder, @Nullable String url, @Nullable Drawable placeholder, boolean isCropCircle, boolean isCrossfade) {
        ImageView $this$load$iv;
        Intrinsics.checkNotNullParameter((Object)$this$imageUrlDrawablePlaceholder, (String)"$this$imageUrlDrawablePlaceholder");
        CharSequence charSequence = url;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            $this$load$iv = $this$imageUrlDrawablePlaceholder;
            Context context = $this$load$iv.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            Context $this$imageLoader$iv$iv = context;
            boolean $i$f$imageLoader = false;
            ImageLoader imageLoader$iv = Coil.imageLoader((Context)$this$imageLoader$iv$iv);
            boolean $i$f$load = false;
            ImageView $this$loadAny$iv$iv = $this$load$iv;
            boolean $i$f$loadAny = false;
            Context context2 = $this$loadAny$iv$iv.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
            ImageRequest.Builder builder = new ImageRequest.Builder(context2).data((Object)placeholder).target($this$loadAny$iv$iv);
            boolean bl3 = false;
            boolean bl4 = false;
            ImageRequest.Builder $receiver = builder;
            ImageRequest request$iv$iv = builder.build();
            imageLoader$iv.enqueue(request$iv$iv);
        } else {
            $this$load$iv = $this$imageUrlDrawablePlaceholder;
            Context context = $this$load$iv.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            Context $this$imageLoader$iv$iv = context;
            boolean $i$f$imageLoader = false;
            ImageLoader imageLoader$iv = Coil.imageLoader((Context)$this$imageLoader$iv$iv);
            boolean $i$f$load = false;
            ImageView $this$loadAny$iv$iv = $this$load$iv;
            boolean $i$f$loadAny = false;
            Context context3 = $this$loadAny$iv$iv.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"context");
            ImageRequest.Builder builder = new ImageRequest.Builder(context3).data((Object)url).target($this$loadAny$iv$iv);
            boolean bl5 = false;
            boolean bl6 = false;
            ImageRequest.Builder $this$load = builder;
            boolean bl7 = false;
            if (isCrossfade) {
                $this$load.crossfade(true);
            }
            $this$load.placeholder(placeholder);
            if (isCropCircle) {
                $this$load.transformations(new Transformation[]{(Transformation)new CircleCropTransformation()});
            }
            ImageRequest request$iv$iv = builder.build();
            imageLoader$iv.enqueue(request$iv$iv);
        }
    }

    public static /* synthetic */ void imageUrlDrawablePlaceholder$default(ImageView imageView, String string2, Drawable drawable, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        ImageBindingKt.imageUrlDrawablePlaceholder(imageView, string2, drawable, bl, bl2);
    }
}

