/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.utils.time;

import android.annotation.SuppressLint;
import android.content.Context;
import com.merseyside.utils.LocaleManager;
import com.merseyside.utils.time.Millis;
import com.merseyside.utils.time.TimeKt;
import com.merseyside.utils.time.TimeUnit;
import com.merseyside.utils.time.TimeUnitKt;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u001a\u0010\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u0001\u001a\u0010\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\t\u001a\u00020\u0001\u001a\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u001a\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u001a\u001a\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u001a\u001a\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u001a\"\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\r2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u001a$\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\r2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007\u001a\u001a\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u001a\u001a\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u001a/\u0010\u0015\u001a\u00020\u000b2\u001c\u0010\u0016\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0017H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001b\"\u0019\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0019\u0010\u0005\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0004\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001c"}, d2={"GMT", "Ljava/util/TimeZone;", "kotlin.jvm.PlatformType", "getGMT", "()Ljava/util/TimeZone;", "SYSTEM", "getSYSTEM", "getCurrentTimeMillis", "", "timeZone", "getCurrentTimeUnit", "Lcom/merseyside/utils/time/TimeUnit;", "getDate", "", "timestamp", "context", "Landroid/content/Context;", "getDateWithTime", "getFormattedDate", "pattern", "getHoursMinutes", "measureTime", "block", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "", "", "(Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "utils_release"})
public final class TimeKt {
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final TimeZone SYSTEM = TimeZone.getTimeZone("GMT0");

    public static final TimeZone getGMT() {
        return GMT;
    }

    public static final TimeZone getSYSTEM() {
        return SYSTEM;
    }

    public static final long getCurrentTimeMillis(@NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        TimeZone timeZone2 = timeZone;
        if (Intrinsics.areEqual((Object)timeZone2, (Object)SYSTEM)) {
            TimeZone timeZone3 = TimeZone.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)timeZone3, (String)"TimeZone.getDefault()");
            int n = timeZone3.getRawOffset();
            TimeZone timeZone4 = TimeZone.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)timeZone4, (String)"TimeZone.getDefault()");
            int offset = n + timeZone4.getDSTSavings();
            return System.currentTimeMillis() + (long)offset;
        }
        Calendar calendar = Calendar.getInstance(timeZone);
        Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"Calendar.getInstance(timeZone)");
        return calendar.getTimeInMillis();
    }

    public static /* synthetic */ long getCurrentTimeMillis$default(TimeZone timeZone, int n, Object object) {
        if ((n & 1) != 0) {
            TimeZone timeZone2 = GMT;
            Intrinsics.checkNotNullExpressionValue((Object)timeZone2, (String)"GMT");
            timeZone = timeZone2;
        }
        return TimeKt.getCurrentTimeMillis(timeZone);
    }

    @NotNull
    public static final TimeUnit getCurrentTimeUnit(@NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        return Millis.box-impl(Millis.constructor-impl(TimeKt.getCurrentTimeMillis(timeZone)));
    }

    public static /* synthetic */ TimeUnit getCurrentTimeUnit$default(TimeZone timeZone, int n, Object object) {
        if ((n & 1) != 0) {
            TimeZone timeZone2 = GMT;
            Intrinsics.checkNotNullExpressionValue((Object)timeZone2, (String)"GMT");
            timeZone = timeZone2;
        }
        return TimeKt.getCurrentTimeUnit(timeZone);
    }

    @NotNull
    public static final String getHoursMinutes(long timestamp, @Nullable Context context) {
        return TimeKt.getFormattedDate(timestamp, "HH:mm", context);
    }

    public static /* synthetic */ String getHoursMinutes$default(long l, Context context, int n, Object object) {
        if ((n & 2) != 0) {
            context = null;
        }
        return TimeKt.getHoursMinutes(l, context);
    }

    @NotNull
    public static final String getHoursMinutes(@NotNull TimeUnit timestamp, @Nullable Context context) {
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        return TimeKt.getHoursMinutes(timestamp.toMillisLong(), context);
    }

    public static /* synthetic */ String getHoursMinutes$default(TimeUnit timeUnit2, Context context, int n, Object object) {
        if ((n & 2) != 0) {
            context = null;
        }
        return TimeKt.getHoursMinutes(timeUnit2, context);
    }

    @NotNull
    public static final String getDate(long timestamp, @Nullable Context context) {
        return TimeKt.getFormattedDate(timestamp, "dd.MM.YYYY", context);
    }

    @NotNull
    public static final String getDate(@NotNull TimeUnit timestamp, @Nullable Context context) {
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        return TimeKt.getDate(timestamp.toMillisLong(), context);
    }

    @NotNull
    public static final String getDateWithTime(long timestamp, @Nullable Context context) {
        return TimeKt.getFormattedDate(timestamp, "dd-MM-YYYY HH:mm", context);
    }

    public static /* synthetic */ String getDateWithTime$default(long l, Context context, int n, Object object) {
        if ((n & 2) != 0) {
            context = null;
        }
        return TimeKt.getDateWithTime(l, context);
    }

    @NotNull
    public static final String getDateWithTime(@NotNull TimeUnit timestamp, @Nullable Context context) {
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        return TimeKt.getDateWithTime(timestamp.toMillisLong(), context);
    }

    public static /* synthetic */ String getDateWithTime$default(TimeUnit timeUnit2, Context context, int n, Object object) {
        if ((n & 2) != 0) {
            context = null;
        }
        return TimeKt.getDateWithTime(timeUnit2, context);
    }

    @NotNull
    public static final String getFormattedDate(@NotNull TimeUnit timestamp, @NotNull String pattern, @Nullable Context context) {
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        return TimeKt.getFormattedDate(timestamp.toMillisLong(), pattern, context);
    }

    public static /* synthetic */ String getFormattedDate$default(TimeUnit timeUnit2, String string2, Context context, int n, Object object) {
        if ((n & 4) != 0) {
            context = null;
        }
        return TimeKt.getFormattedDate(timeUnit2, string2, context);
    }

    @SuppressLint(value={"SimpleDateFormat"})
    @NotNull
    public static final String getFormattedDate(long timestamp, @NotNull String pattern, @Nullable Context context) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Locale locale = context != null ? new LocaleManager(context).getCurrentLocale() : Locale.getDefault();
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(pattern, locale);
            sdf.setTimeZone(GMT);
            Date netDate = new Date(timestamp);
            String string3 = sdf.format(netDate);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"sdf.format(netDate)");
            string2 = string3;
        }
        catch (Exception e) {
            string2 = e.toString();
        }
        return string2;
    }

    public static /* synthetic */ String getFormattedDate$default(long l, String string2, Context context, int n, Object object) {
        if ((n & 4) != 0) {
            context = null;
        }
        return TimeKt.getFormattedDate(l, string2, context);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object measureTime(@NotNull Function1<? super Continuation<? super Unit>, ? extends Object> var0, @NotNull Continuation<? super TimeUnit> var1_1) {
        if (!(var1_1 instanceof measureTime.1)) ** GOTO lbl-1000
        var4_2 = var1_1;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var1_1){
                /* synthetic */ Object result;
                int label;
                Object L$0;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TimeKt.measureTime(null, (Continuation<? super TimeUnit>)this);
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                startTime = TimeKt.getCurrentTimeUnit$default(null, 1, null);
                $continuation.L$0 = startTime;
                $continuation.label = 1;
                v0 = block.invoke((Object)$continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl23
            }
            case 1: {
                startTime = (TimeUnit)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                return TimeUnitKt.minus(TimeKt.getCurrentTimeUnit$default(null, 1, null), startTime);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }
}

