/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tH\u0003J\u0006\u0010\u0014\u001a\u00020\u0003J\u000e\u0010\u0015\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/merseyside/utils/LocaleManager;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "setContext", "language", "", "getLanguage", "()Ljava/lang/String;", "setLanguage", "(Ljava/lang/String;)V", "prefs", "Landroid/content/SharedPreferences;", "getCurrentLocale", "Ljava/util/Locale;", "persistLanguage", "", "setLocale", "setNewLocale", "updateResources", "Companion", "utils_release"})
public final class LocaleManager {
    private final SharedPreferences prefs;
    @NotNull
    private String language;
    @NotNull
    private Context context;
    private static final String LANGUAGE_KEY = "language_key";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getLanguage() {
        return this.language;
    }

    public final void setLanguage(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.language = string2;
    }

    @NotNull
    public final Context setLocale() {
        return this.updateResources(this.language);
    }

    @NotNull
    public final Context setNewLocale(@NotNull String language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        this.persistLanguage(language);
        return this.updateResources(language);
    }

    @SuppressLint(value={"ApplySharedPref"})
    private final void persistLanguage(String language) {
        this.language = language;
        this.prefs.edit().putString(LANGUAGE_KEY, language).commit();
    }

    private final Context updateResources(String language) {
        Context context;
        Resources res;
        Locale locale = new Locale(language);
        Locale.setDefault(locale);
        Resources resources = res = this.context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"res");
        Configuration config = new Configuration(resources.getConfiguration());
        if (Build.VERSION.SDK_INT >= 17) {
            config.setLocale(locale);
            Context context2 = this.context.createConfigurationContext(config);
            context = context2;
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.createConfigurationContext(config)");
        } else {
            config.locale = locale;
            res.updateConfiguration(config, res.getDisplayMetrics());
            context = this.context;
        }
        this.context = context;
        return this.context;
    }

    @NotNull
    public final Locale getCurrentLocale() {
        return Companion.getCurrentLocale(this.context);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public final void setContext(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"<set-?>");
        this.context = context;
    }

    public LocaleManager(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        SharedPreferences sharedPreferences = this.context.getSharedPreferences("locale_pref", 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026ontext.MODE_PRIVATE\n    )");
        this.prefs = sharedPreferences;
        String string2 = this.prefs.getString(LANGUAGE_KEY, this.getCurrentLocale().getLanguage());
        Intrinsics.checkNotNull((Object)string2);
        this.language = string2;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/merseyside/utils/LocaleManager$Companion;", "", "()V", "LANGUAGE_KEY", "", "getCurrentLocale", "Ljava/util/Locale;", "context", "Landroid/content/Context;", "utils_release"})
    public static final class Companion {
        @NotNull
        public final Locale getCurrentLocale(@NotNull Context context) {
            Locale locale;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (Build.VERSION.SDK_INT >= 24) {
                Resources resources = context.getResources();
                Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
                Configuration configuration = resources.getConfiguration();
                Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"context.resources.configuration");
                Locale locale2 = configuration.getLocales().get(0);
                locale = locale2;
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"context.resources.configuration.locales[0]");
            } else {
                Resources resources = context.getResources();
                Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
                Locale locale3 = resources.getConfiguration().locale;
                locale = locale3;
                Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"context.resources.configuration.locale");
            }
            return locale;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

