/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.cardview.widget.CardView;
import androidx.core.content.ContextCompat;
import androidx.databinding.BindingAdapter;
import androidx.databinding.InverseBindingAdapter;
import androidx.databinding.InverseBindingListener;
import coil.Coil;
import coil.ImageLoader;
import coil.request.ImageRequest;
import com.google.android.material.textfield.TextInputLayout;
import com.merseyside.utils.LibUtils;
import com.merseyside.utils.ext.CollectionExtKt;
import com.merseyside.utils.ext.DrawableExtKt;
import com.merseyside.utils.ext.NumberExtKt;
import com.merseyside.utils.ext.StringExtKt;
import com.merseyside.utils.ext.ViewExtKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000l\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\nH\u0007\u001a\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\fH\u0007\u001a\u001a\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007\u001a\u001f\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0004\u001a\u0004\u0018\u00010\nH\u0007\u00a2\u0006\u0002\u0010\u000e\u001a\u001a\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0001H\u0007\u001a\u001e\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\fH\u0007\u001a\u001a\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0007\u001a\u001a\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0007\u001a!\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0001\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0007\u00a2\u0006\u0002\u0010\u0019\u001a!\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0001\u0010\u001b\u001a\u0004\u0018\u00010\u0018H\u0007\u00a2\u0006\u0002\u0010\u0019\u001a\u001a\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0007\u001a!\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0001\u0010\u001e\u001a\u0004\u0018\u00010\u0018H\u0007\u00a2\u0006\u0002\u0010\u001f\u001a!\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"2\n\b\u0001\u0010\u001e\u001a\u0004\u0018\u00010\u0018H\u0007\u00a2\u0006\u0002\u0010#\u001a\u001e\u0010$\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\f\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\fH\u0007\u001a!\u0010%\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\n\b\u0001\u0010\u001e\u001a\u0004\u0018\u00010\u0018H\u0007\u00a2\u0006\u0002\u0010&\u001a!\u0010'\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0001\u0010(\u001a\u0004\u0018\u00010\u0018H\u0007\u00a2\u0006\u0002\u0010\u001f\u001a\u001a\u0010)\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010\u0001H\u0007\u001a\u001a\u0010,\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\b\u0010-\u001a\u0004\u0018\u00010.H\u0007\u001a\u001a\u0010/\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\b\u00100\u001a\u0004\u0018\u00010\u0001H\u0007\u001a!\u00101\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\n\b\u0001\u00102\u001a\u0004\u0018\u00010\u0018H\u0007\u00a2\u0006\u0002\u0010&\u001a\u001a\u00103\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\b\u00104\u001a\u0004\u0018\u000105H\u0007\u001a!\u00106\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0001\u00102\u001a\u0004\u0018\u00010\u0018H\u0007\u00a2\u0006\u0002\u0010\u001f\u001a!\u00107\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0001\u0010\u001e\u001a\u0004\u0018\u00010\u0018H\u0007\u00a2\u0006\u0002\u0010\u001f\u001a!\u00108\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0001\u00109\u001a\u0004\u0018\u00010\u0018H\u0007\u00a2\u0006\u0002\u0010\u001f\u001a!\u0010:\u001a\u00020\u00052\u0006\u0010;\u001a\u00020<2\n\b\u0001\u0010\u001e\u001a\u0004\u0018\u00010\u0018H\u0007\u00a2\u0006\u0002\u0010=\u001a'\u0010>\u001a\u00020\u0005*\u00020\u00112\b\u0010?\u001a\u0004\u0018\u00010\u00012\n\b\u0001\u0010@\u001a\u0004\u0018\u00010\u0018H\u0007\u00a2\u0006\u0002\u0010A\u00a8\u0006B"}, d2={"getText", "", "textView", "Landroid/widget/TextView;", "isVisible", "", "view", "Landroid/view/View;", "obj", "", "", "collection", "", "isVisibleOrGone", "(Landroid/view/View;Ljava/lang/Boolean;)V", "loadDrawableByName", "iv", "Landroid/widget/ImageView;", "name", "loadImageBitmap", "bitmap", "Landroid/graphics/Bitmap;", "loadImageDrawable", "drawableRes", "", "(Landroid/widget/ImageView;Ljava/lang/Integer;)V", "loadVectorDrawable", "resId", "loadVectorDrawableByName", "setAttrTint", "attrId", "(Landroid/view/View;Ljava/lang/Integer;)V", "setCardViewBackgroundColor", "cardView", "Landroidx/cardview/widget/CardView;", "(Landroidx/cardview/widget/CardView;Ljava/lang/Integer;)V", "setCount", "setCustomTextColor", "(Landroid/widget/TextView;Ljava/lang/Integer;)V", "setDrawableBackground", "res", "setErrorMessage", "Lcom/google/android/material/textfield/TextInputLayout;", "errorMessage", "setSpannedText", "charSequence", "", "setText", "text", "setTextColor", "colorRes", "setTextListener", "listener", "Landroidx/databinding/InverseBindingListener;", "setTint", "setViewAttrBackgroundColor", "setViewBackgroundColor", "colorId", "setViewGroupBackgroundColor", "viewGroup", "Landroid/view/ViewGroup;", "(Landroid/view/ViewGroup;Ljava/lang/Integer;)V", "imageUrl", "url", "placeholderId", "(Landroid/widget/ImageView;Ljava/lang/String;Ljava/lang/Integer;)V", "utils_release"})
public final class BindingKt {
    @BindingAdapter(value={"app:isVisibleOrGone"})
    public static final void isVisibleOrGone(@NotNull View view, @Nullable Boolean isVisible) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Boolean bl = isVisible;
        if (Intrinsics.areEqual((Object)bl, (Object)true)) {
            view.setVisibility(0);
        } else {
            view.setVisibility(8);
        }
    }

    @BindingAdapter(value={"app:isVisibleOrGone"})
    public static final void isVisibleOrGone(@NotNull View view, @Nullable Object obj) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setVisibility(obj != null ? 0 : 8);
    }

    @BindingAdapter(value={"app:isVisibleOrGone"})
    public static final void isVisibleOrGone(@NotNull View view, @Nullable String obj) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setVisibility(StringExtKt.isNotNullAndEmpty(obj) ? 0 : 8);
    }

    @BindingAdapter(value={"app:isVisibleOrGone"})
    public static final void isVisibleOrGone(@NotNull View view, @Nullable Collection<?> collection) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setVisibility(CollectionExtKt.isNotNullAndEmpty(collection) ? 0 : 8);
    }

    @BindingAdapter(value={"app:isVisible"})
    public static final void isVisible(@NotNull View view, boolean isVisible) {
        block1: {
            boolean bl;
            block0: {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                bl = isVisible;
                if (!bl) break block0;
                view.setVisibility(0);
                break block1;
            }
            if (bl) break block1;
            view.setVisibility(4);
        }
    }

    @BindingAdapter(value={"app:isVisible"})
    public static final void isVisible(@NotNull View view, @Nullable Object obj) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setVisibility(obj != null ? 0 : 4);
    }

    @BindingAdapter(value={"app:isVisible"})
    public static final void isVisible(@NotNull View view, @Nullable Collection<?> collection) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setVisibility(CollectionExtKt.isNotNullAndEmpty(collection) ? 0 : 4);
    }

    @BindingAdapter(value={"app:backgroundDrawable"})
    public static final void setDrawableBackground(@NotNull View view, @DrawableRes @Nullable Integer res) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (res != null) {
            view.setBackground(ContextCompat.getDrawable((Context)view.getContext(), (int)res));
        }
    }

    @BindingAdapter(value={"app:text"})
    public static final void setText(@NotNull TextView textView, @Nullable String text) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
        if (textView instanceof EditText) {
            ViewExtKt.setTextWithCursor((EditText)textView, text);
        } else {
            textView.setText((CharSequence)text);
        }
    }

    @BindingAdapter(value={"app:textAttrChanged"})
    public static final void setTextListener(@NotNull TextView textView, @Nullable InverseBindingListener listener2) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
        ViewExtKt.addTextChangeListener(textView, (Function5<? super String, ? super Integer, ? super Integer, ? super Integer, ? super Integer, Unit>)((Function5)new Function5<String, Integer, Integer, Integer, Integer, Unit>(listener2){
            final /* synthetic */ InverseBindingListener $listener;

            public final void invoke(@Nullable String $noName_0, int $noName_1, int $noName_2, int $noName_3, int $noName_4) {
                block0: {
                    InverseBindingListener inverseBindingListener = this.$listener;
                    if (inverseBindingListener == null) break block0;
                    inverseBindingListener.onChange();
                }
            }
            {
                this.$listener = inverseBindingListener;
                super(5);
            }
        }));
    }

    @InverseBindingAdapter(attribute="app:text")
    @Nullable
    public static final String getText(@NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
        return ((Object)textView.getText()).toString();
    }

    @BindingAdapter(value={"app:drawableName"})
    public static final void loadDrawableByName(@NotNull ImageView iv, @Nullable String name) {
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        if (name != null) {
            Context context = iv.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"iv.context");
            int drawableRes = LibUtils.getDrawableResourceIdByName(context, name);
            BindingKt.loadImageDrawable(iv, drawableRes);
        }
    }

    @BindingAdapter(value={"app:vectorDrawableName"})
    public static final void loadVectorDrawableByName(@NotNull ImageView iv, @Nullable String name) {
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        if (name != null) {
            Context context = iv.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"iv.context");
            int drawableRes = LibUtils.getDrawableResourceIdByName(context, name);
            BindingKt.loadImageDrawable(iv, drawableRes);
        }
    }

    @BindingAdapter(value={"app:bitmap"})
    public static final void loadImageBitmap(@NotNull ImageView iv, @Nullable Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        if (bitmap != null) {
            iv.setImageBitmap(bitmap);
        }
    }

    @BindingAdapter(value={"app:drawableRes"})
    public static final void loadImageDrawable(@NotNull ImageView iv, @DrawableRes @Nullable Integer drawableRes) {
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        if (drawableRes != null) {
            iv.setImageDrawable(ContextCompat.getDrawable((Context)iv.getContext(), (int)drawableRes));
        }
    }

    @BindingAdapter(value={"app:vectorDrawable"})
    public static final void loadVectorDrawable(@NotNull ImageView iv, @DrawableRes @Nullable Integer resId) {
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        if (resId != null) {
            iv.setImageResource(resId.intValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    @BindingAdapter(value={"imageUrl", "imagePlaceholder"}, requireAll=false)
    public static final void imageUrl(@NotNull ImageView $this$imageUrl, @Nullable String url, @DrawableRes @Nullable Integer placeholderId) {
        Drawable drawable;
        Intrinsics.checkNotNullParameter((Object)$this$imageUrl, (String)"$this$imageUrl");
        ImageView $this$load$iv = $this$imageUrl;
        Context context = $this$load$iv.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        Context $this$imageLoader$iv$iv = context;
        boolean $i$f$imageLoader = false;
        ImageLoader imageLoader$iv = Coil.imageLoader((Context)$this$imageLoader$iv$iv);
        boolean $i$f$load = false;
        ImageView $this$loadAny$iv$iv = $this$load$iv;
        boolean $i$f$loadAny = false;
        Context context2 = $this$loadAny$iv$iv.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        ImageRequest.Builder builder = new ImageRequest.Builder(context2).data((Object)url).target($this$loadAny$iv$iv);
        boolean bl = false;
        boolean bl2 = false;
        ImageRequest.Builder $this$load = builder;
        boolean bl3 = false;
        $this$load.crossfade(true);
        ImageRequest.Builder builder2 = $this$load;
        Integer n = placeholderId;
        if (n != null) {
            void it;
            Integer n2 = n;
            boolean bl4 = false;
            boolean bl5 = false;
            int n3 = ((Number)n2).intValue();
            ImageRequest.Builder builder3 = builder2;
            boolean bl6 = false;
            Drawable drawable2 = ContextCompat.getDrawable((Context)$this$imageUrl.getContext(), (int)it);
            builder2 = builder3;
            drawable = drawable2;
        } else {
            drawable = null;
        }
        builder2.placeholder(drawable);
        ImageRequest request$iv$iv = builder.build();
        imageLoader$iv.enqueue(request$iv$iv);
    }

    @BindingAdapter(value={"app:attrCardBackgroundColor"})
    public static final void setCardViewBackgroundColor(@NotNull CardView cardView, @AttrRes @Nullable Integer attrId) {
        Intrinsics.checkNotNullParameter((Object)cardView, (String)"cardView");
        if (attrId != null) {
            cardView.setCardBackgroundColor(ViewExtKt.getColorFromAttr$default((View)cardView, attrId, null, false, 6, null));
        }
    }

    @BindingAdapter(value={"app:attrBackgroundColor"})
    public static final void setViewGroupBackgroundColor(@NotNull ViewGroup viewGroup, @AttrRes @Nullable Integer attrId) {
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"viewGroup");
        if (attrId != null) {
            viewGroup.setBackgroundColor(ViewExtKt.getColorFromAttr$default((View)viewGroup, attrId, null, false, 6, null));
        }
    }

    @BindingAdapter(value={"app:attrBackgroundColor"})
    public static final void setViewAttrBackgroundColor(@NotNull View view, @AttrRes @Nullable Integer attrId) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (attrId != null) {
            view.setBackgroundColor(ViewExtKt.getColorFromAttr$default(view, attrId, null, false, 6, null));
        }
    }

    @BindingAdapter(value={"app:backgroundColorRes"})
    public static final void setViewBackgroundColor(@NotNull View view, @ColorRes @Nullable Integer colorId) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (NumberExtKt.isNotNullAndZero(colorId)) {
            Context context = view.getContext();
            Integer n = colorId;
            Intrinsics.checkNotNull((Object)n);
            view.setBackgroundColor(ContextCompat.getColor((Context)context, (int)n));
        }
    }

    @BindingAdapter(value={"app:resTextColor"})
    public static final void setTextColor(@NotNull TextView view, @ColorRes @Nullable Integer colorRes) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (colorRes != null) {
            view.setTextColor(ContextCompat.getColor((Context)view.getContext(), (int)colorRes));
        }
    }

    @BindingAdapter(value={"app:attrTextColor"})
    public static final void setCustomTextColor(@NotNull TextView view, @AttrRes @Nullable Integer attrId) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (attrId != null) {
            view.setTextColor(ViewExtKt.getColorFromAttr$default((View)view, attrId, null, false, 6, null));
        }
    }

    @BindingAdapter(value={"app:attrTint"})
    public static final void setAttrTint(@NotNull View view, @AttrRes @Nullable Integer attrId) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (attrId != null) {
            Drawable drawable;
            Drawable drawable2 = drawable = view.getBackground();
            Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"drawable");
            DrawableExtKt.setColor(drawable2, ViewExtKt.getColorFromAttr$default(view, attrId, null, false, 6, null));
        }
    }

    @BindingAdapter(value={"app:colorTint"})
    public static final void setTint(@NotNull View view, @ColorRes @Nullable Integer colorRes) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (colorRes != null) {
            Drawable drawable;
            Drawable drawable2 = drawable = view.getBackground();
            Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"drawable");
            DrawableExtKt.setColor(drawable2, ContextCompat.getColor((Context)view.getContext(), (int)colorRes));
        }
    }

    @BindingAdapter(value={"app:spanned"})
    public static final void setSpannedText(@NotNull TextView view, @Nullable CharSequence charSequence) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (charSequence != null) {
            view.setText(charSequence);
        }
    }

    @BindingAdapter(value={"app:count"})
    public static final void setCount(@NotNull TextView view, @Nullable Collection<?> collection) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (collection != null) {
            view.setText((CharSequence)String.valueOf(collection.size()));
        } else {
            view.setText((CharSequence)"0");
        }
    }

    @BindingAdapter(value={"app:errorText"})
    public static final void setErrorMessage(@NotNull TextInputLayout view, @Nullable String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setErrorEnabled(StringExtKt.isNotNullAndEmpty(errorMessage));
        view.setError((CharSequence)errorMessage);
    }
}

