/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.archy.data.cache;

import android.content.Context;
import com.merseyside.archy.data.cache.BaseCache;
import com.merseyside.archy.data.cache.CacheFileManager;
import com.merseyside.archy.data.cache.serializer.Serializer;
import com.merseyside.archy.domain.executor.ThreadExecutor;
import com.merseyside.utils.preferences.PreferenceManager;

public abstract class BaseCachePreference<T>
extends BaseCache<T> {
    private final PreferenceManager preferenceManager;

    BaseCachePreference(Context context, Serializer serializer2, CacheFileManager fileManager, ThreadExecutor executor, PreferenceManager preferenceManager) {
        super(context, serializer2, fileManager, executor);
        this.preferenceManager = preferenceManager;
    }

    protected abstract String getPreferenceLastCacheUpdateKey();

    protected abstract long getExpirationTimeMillis();

    private void setLastCacheUpdateTimeMillis() {
        long currentMillis = System.currentTimeMillis();
        this.preferenceManager.put(this.getPreferenceLastCacheUpdateKey(), currentMillis);
    }

    private long getLastCacheUpdateTimeMillis() {
        return this.preferenceManager.getLong(this.getPreferenceLastCacheUpdateKey(), 0L);
    }

    @Override
    public boolean put(T entity) {
        if (super.put(entity)) {
            this.setLastCacheUpdateTimeMillis();
            return true;
        }
        return false;
    }

    public boolean isExpired() {
        long lastUpdateTime;
        boolean expired;
        long currentTime = System.currentTimeMillis();
        boolean bl = expired = currentTime - (lastUpdateTime = this.getLastCacheUpdateTimeMillis()) > this.getExpirationTimeMillis();
        if (expired) {
            this.evict();
        }
        return expired;
    }
}

