/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.archy.presentation.view.progressBar;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.core.content.ContextCompat;
import com.merseyside.archy.R;
import com.merseyside.archy.databinding.ViewProgressBarBinding;
import com.merseyside.utils.delegate.Binding;
import com.merseyside.utils.delegate.BindingDelegateKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0017\u001a\u00020\u00152\b\u0010\u0018\u001a\u0004\u0018\u00010\u0013J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\bH\u0016R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0016\u0010\u0011\u001a\u0004\u0018\u00010\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/merseyside/archy/presentation/view/progressBar/TextProgressBar;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "attributeSet", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "bgColor", "", "Ljava/lang/Integer;", "binding", "Lcom/merseyside/archy/databinding/ViewProgressBarBinding;", "getBinding", "()Lcom/merseyside/archy/databinding/ViewProgressBarBinding;", "binding$delegate", "Lcom/merseyside/utils/delegate/Binding;", "progressColor", "textColor", "textValue", "", "doLayout", "", "loadAttrs", "setText", "value", "setVisibility", "visibility", "archy_release"})
public final class TextProgressBar
extends LinearLayout {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Binding binding$delegate;
    @Nullable
    private String textValue;
    @ColorInt
    @Nullable
    private Integer bgColor;
    @ColorInt
    @Nullable
    private Integer textColor;
    @ColorInt
    @Nullable
    private Integer progressColor;

    public TextProgressBar(@NotNull Context context, @NotNull AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attributeSet, (String)"attributeSet");
        super(context, attributeSet);
        this.binding$delegate = BindingDelegateKt.viewBinding$default((ViewGroup)((ViewGroup)this), (int)R.layout.view_progress_bar, (boolean)false, (int)2, null);
        this.loadAttrs(attributeSet);
        this.doLayout();
    }

    private final ViewProgressBarBinding getBinding() {
        return (ViewProgressBarBinding)BindingDelegateKt.getValue((Binding)this.binding$delegate, (ViewGroup)((ViewGroup)this), $$delegatedProperties[0]);
    }

    private final void loadAttrs(AttributeSet attributeSet) {
        Object object = this.getContext().getTheme().obtainStyledAttributes(attributeSet, R.styleable.ProgressBarAttr, 0, 0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.theme.obtainStyledAttributes(attributeSet, R.styleable.ProgressBarAttr, 0, 0)");
        TypedArray array = object;
        object = array.getString(R.styleable.ProgressBarAttr_text);
        this.textValue = object == null ? "" : object;
        this.bgColor = array.getColor(R.styleable.ProgressBarAttr_backgroundColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.default_progress_bg_color));
        this.textColor = array.getColor(R.styleable.ProgressBarAttr_android_textColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.default_progress_text_color));
        this.progressColor = array.getColor(R.styleable.ProgressBarAttr_progressColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.default_progress_color));
        array.recycle();
    }

    private final void doLayout() {
        ProgressBar progressBar = this.getBinding().textProgress;
        Integer n = this.progressColor;
        Intrinsics.checkNotNull((Object)n);
        progressBar.setIndeterminateTintList(ColorStateList.valueOf((int)n));
        n = this.bgColor;
        Intrinsics.checkNotNull((Object)n);
        this.setBackgroundColor(n);
        TextView textView = this.getBinding().text;
        n = this.textColor;
        Intrinsics.checkNotNull((Object)n);
        textView.setTextColor(n.intValue());
        this.setText(this.textValue);
    }

    public final void setText(@Nullable String value) {
        this.textValue = value;
        this.getBinding().text.setText((CharSequence)value);
        CharSequence charSequence = value;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            this.getBinding().text.setVisibility(8);
        } else {
            this.getBinding().text.setVisibility(0);
        }
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        this.getBinding().text.setVisibility(visibility);
        this.getBinding().textProgress.setVisibility(visibility);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(TextProgressBar.class), "binding", "getBinding()Lcom/merseyside/archy/databinding/ViewProgressBarBinding;")))};
        $$delegatedProperties = kPropertyArray;
    }
}

