/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.archy.presentation.view.merseyRecyclerView;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.merseyside.archy.R;
import com.merseyside.utils.ext.LoggerExtKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0015B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u0002J\u0018\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\nH\u0014J\u0012\u0010\u0011\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/merseyside/archy/presentation/view/merseyRecyclerView/MerseyRecyclerView;", "Landroidx/recyclerview/widget/RecyclerView;", "context", "Landroid/content/Context;", "attrSet", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "isSaveScrollPosition", "", "mMaxHeight", "", "loadAttributes", "", "attrs", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "onSaveInstanceState", "SavedState", "archy_release"})
public class MerseyRecyclerView
extends RecyclerView {
    private int mMaxHeight;
    private boolean isSaveScrollPosition;

    public MerseyRecyclerView(@NotNull Context context, @Nullable AttributeSet attrSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrSet);
        this.isSaveScrollPosition = true;
        this.loadAttributes(attrSet);
    }

    public /* synthetic */ MerseyRecyclerView(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    private final void loadAttributes(AttributeSet attrs) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.MerseyRecyclerView);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttributes(attrs, R.styleable.MerseyRecyclerView)");
        TypedArray arr = typedArray;
        this.mMaxHeight = arr.getLayoutDimension(R.styleable.MerseyRecyclerView_maxHeight, this.mMaxHeight);
        arr.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int heightMeasureSpecMut = heightMeasureSpec;
        if (this.mMaxHeight > 0) {
            heightMeasureSpecMut = View.MeasureSpec.makeMeasureSpec((int)this.mMaxHeight, (int)Integer.MIN_VALUE);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpecMut);
    }

    @Nullable
    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState newState = new SavedState(superState);
        if (this.isSaveScrollPosition && this.getLayoutManager() != null) {
            RecyclerView.LayoutManager lm = this.getLayoutManager();
            int scrollPosition = lm instanceof LinearLayoutManager ? ((LinearLayoutManager)lm).findFirstVisibleItemPosition() : (lm instanceof GridLayoutManager ? ((GridLayoutManager)lm).findFirstVisibleItemPosition() : 0);
            newState.setMScrollPosition(((Number)LoggerExtKt.log$default((Object)scrollPosition, (Object)"position = ", null, null, (int)6, null)).intValue());
        }
        return (Parcelable)newState;
    }

    protected void onRestoreInstanceState(@Nullable Parcelable state) {
        if (state != null) {
            if (state instanceof SavedState) {
                super.onRestoreInstanceState(((SavedState)state).getSuperState());
                int mScrollPosition = ((SavedState)state).getMScrollPosition();
                RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
                if (layoutManager != null) {
                    int count = layoutManager.getItemCount();
                    if (mScrollPosition != -1 && mScrollPosition < count) {
                        layoutManager.scrollToPosition(mScrollPosition);
                    }
                }
            } else {
                super.onRestoreInstanceState(state);
            }
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0011\b\u0016\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\tH\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lcom/merseyside/archy/presentation/view/merseyRecyclerView/MerseyRecyclerView$SavedState;", "Landroid/view/View$BaseSavedState;", "in", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "superState", "Landroid/os/Parcelable;", "(Landroid/os/Parcelable;)V", "mScrollPosition", "", "getMScrollPosition", "()I", "setMScrollPosition", "(I)V", "writeToParcel", "", "dest", "flags", "archy_release"})
    public static final class SavedState
    extends View.BaseSavedState {
        private int mScrollPosition;

        public final int getMScrollPosition() {
            return this.mScrollPosition;
        }

        public final void setMScrollPosition(int n) {
            this.mScrollPosition = n;
        }

        public SavedState(@NotNull Parcel in) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            super(in);
            this.mScrollPosition = in.readInt();
        }

        public SavedState(@Nullable Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(@NotNull Parcel dest, int flags) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mScrollPosition);
        }
    }
}

