/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.archy.presentation.model;

import android.content.Context;
import androidx.annotation.StringRes;
import androidx.databinding.ObservableBoolean;
import androidx.databinding.ObservableField;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.ViewModel;
import com.merseyside.archy.presentation.interfaces.IStringHelper;
import com.merseyside.archy.presentation.model.BaseViewModel;
import com.merseyside.utils.Logger;
import com.merseyside.utils.PermissionManager;
import com.merseyside.utils.ext.ObservableExtKt;
import com.merseyside.utils.mvvm.SingleLiveEvent;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0018\b&\u0018\u00002\u00020\u00012\u00020\u0002:\u0002HIB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u001e\u001a\u00020\u001fH\u0014J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\nH\u0016J\u0006\u0010\"\u001a\u00020\u001fJ'\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020%2\u0012\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000f\u00a2\u0006\u0002\u0010'J\b\u0010(\u001a\u00020\u0016H\u0016J\b\u0010)\u001a\u00020\u001fH\u0014J\u0010\u0010*\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\nH\u0016J \u0010+\u001a\u00020\u001f2\u0018\u0010&\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0004\u0012\u00020\u00100\rJs\u0010,\u001a\u00020\u001f2\n\b\u0003\u0010-\u001a\u0004\u0018\u00010\u00102\n\b\u0003\u0010.\u001a\u0004\u0018\u00010\u00102\n\b\u0003\u0010/\u001a\u0004\u0018\u00010\u00102\n\b\u0003\u00100\u001a\u0004\u0018\u00010\u00102\u000e\b\u0002\u00101\u001a\b\u0012\u0004\u0012\u00020\u001f022\u000e\b\u0002\u00103\u001a\b\u0012\u0004\u0012\u00020\u001f022\n\b\u0002\u00104\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u00105\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\u0002\u00106Js\u0010,\u001a\u00020\u001f2\n\b\u0002\u00107\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u00108\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u00109\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010:\u001a\u0004\u0018\u00010\u000f2\u000e\b\u0002\u00101\u001a\b\u0012\u0004\u0012\u00020\u001f022\u000e\b\u0002\u00103\u001a\b\u0012\u0004\u0012\u00020\u001f022\n\b\u0002\u00104\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u00105\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\u0002\u0010;J+\u0010<\u001a\u00020\u001f2\b\b\u0001\u0010=\u001a\u00020\u00102\u0012\u0010>\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000fH\u0004\u00a2\u0006\u0002\u0010?J\u0010\u0010<\u001a\u00020\u001f2\u0006\u0010@\u001a\u00020\u000fH\u0004J(\u0010<\u001a\u00020\u001f2\u0006\u0010@\u001a\u00020\u000f2\u0006\u0010A\u001a\u00020\u000f2\u000e\b\u0002\u0010B\u001a\b\u0012\u0004\u0012\u00020\u001f02H\u0004J+\u0010C\u001a\u00020\u001f2\b\b\u0001\u0010=\u001a\u00020\u00102\u0012\u0010>\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000fH\u0004\u00a2\u0006\u0002\u0010?J\u0010\u0010C\u001a\u00020\u001f2\u0006\u0010@\u001a\u00020\u000fH\u0004J(\u0010C\u001a\u00020\u001f2\u0006\u0010@\u001a\u00020\u000f2\u0006\u0010A\u001a\u00020\u000f2\u000e\b\u0002\u0010B\u001a\b\u0012\u0004\u0012\u00020\u001f02H\u0004J\u0012\u0010D\u001a\u00020\u001f2\n\b\u0002\u0010E\u001a\u0004\u0018\u00010\u000fJ\u0006\u0010F\u001a\u00020\u001fJ\u0010\u0010G\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR)\u0010\f\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0004\u0012\u00020\u00100\r0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\bR\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\bR\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\bR\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006J"}, d2={"Lcom/merseyside/archy/presentation/model/BaseViewModel;", "Landroidx/lifecycle/ViewModel;", "Lcom/merseyside/archy/presentation/interfaces/IStringHelper;", "()V", "alertDialogLiveEvent", "Landroidx/lifecycle/MutableLiveData;", "Lcom/merseyside/archy/presentation/model/BaseViewModel$AlertDialogModel;", "getAlertDialogLiveEvent", "()Landroidx/lifecycle/MutableLiveData;", "errorLiveEvent", "", "getErrorLiveEvent", "grantPermissionLiveEvent", "Lkotlin/Pair;", "", "", "", "getGrantPermissionLiveEvent", "isInProgress", "Landroidx/databinding/ObservableBoolean;", "()Landroidx/databinding/ObservableBoolean;", "isInProgressLiveData", "", "messageLiveEvent", "Lcom/merseyside/archy/presentation/model/BaseViewModel$TextMessage;", "getMessageLiveEvent", "progressText", "Landroidx/databinding/ObservableField;", "getProgressText", "()Landroidx/databinding/ObservableField;", "dispose", "", "handleError", "throwable", "hideProgress", "isPermissionsGranted", "context", "Landroid/content/Context;", "permissions", "(Landroid/content/Context;[Ljava/lang/String;)Z", "onBackPressed", "onCleared", "onError", "requestPermissions", "showAlertDialog", "titleRes", "messageRes", "positiveButtonTextRes", "negativeButtonTextRes", "onPositiveClick", "Lkotlin/Function0;", "onNegativeClick", "isSingleAction", "isCancelable", "(Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Ljava/lang/Boolean;Ljava/lang/Boolean;)V", "title", "message", "positiveButtonText", "negativeButtonText", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Ljava/lang/Boolean;Ljava/lang/Boolean;)V", "showErrorMsg", "id", "args", "(I[Ljava/lang/String;)V", "msg", "actionMsg", "onClick", "showMsg", "showProgress", "text", "stopAllWorks", "updateLanguage", "AlertDialogModel", "TextMessage", "archy_release"})
public abstract class BaseViewModel
extends ViewModel
implements IStringHelper {
    @NotNull
    private final ObservableBoolean isInProgress = new ObservableBoolean(false);
    @NotNull
    private final ObservableField<String> progressText = new ObservableField();
    @NotNull
    private final MutableLiveData<Throwable> errorLiveEvent = (MutableLiveData)new SingleLiveEvent();
    @NotNull
    private final MutableLiveData<TextMessage> messageLiveEvent = (MutableLiveData)new SingleLiveEvent();
    @NotNull
    private final MutableLiveData<Boolean> isInProgressLiveData = new MutableLiveData();
    @NotNull
    private final MutableLiveData<AlertDialogModel> alertDialogLiveEvent = (MutableLiveData)new SingleLiveEvent();
    @NotNull
    private final MutableLiveData<Pair<String[], Integer>> grantPermissionLiveEvent = (MutableLiveData)new SingleLiveEvent();

    protected BaseViewModel() {
    }

    @NotNull
    public final ObservableBoolean isInProgress() {
        return this.isInProgress;
    }

    @NotNull
    public final ObservableField<String> getProgressText() {
        return this.progressText;
    }

    @NotNull
    public final MutableLiveData<Throwable> getErrorLiveEvent() {
        return this.errorLiveEvent;
    }

    @NotNull
    public final MutableLiveData<TextMessage> getMessageLiveEvent() {
        return this.messageLiveEvent;
    }

    @NotNull
    public final MutableLiveData<Boolean> isInProgressLiveData() {
        return this.isInProgressLiveData;
    }

    @NotNull
    public final MutableLiveData<AlertDialogModel> getAlertDialogLiveEvent() {
        return this.alertDialogLiveEvent;
    }

    @NotNull
    public final MutableLiveData<Pair<String[], Integer>> getGrantPermissionLiveEvent() {
        return this.grantPermissionLiveEvent;
    }

    public void handleError(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        this.errorLiveEvent.setValue((Object)throwable);
    }

    protected final void showMsg(@StringRes int id, String ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.showMsg(this.getString(id, Arrays.copyOf(args, args.length)));
    }

    protected final void showErrorMsg(@StringRes int id, String ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.showErrorMsg(this.getString(id, Arrays.copyOf(args, args.length)));
    }

    protected final void showMsg(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Logger.INSTANCE.log((Object)this, (Object)msg);
        TextMessage textMessage = new TextMessage(false, msg, null, null, 12, null);
        this.messageLiveEvent.setValue((Object)textMessage);
    }

    protected final void showErrorMsg(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Logger.INSTANCE.logErr((Object)this, (Object)msg);
        TextMessage textMessage = new TextMessage(true, msg, null, null, 12, null);
        this.messageLiveEvent.setValue((Object)textMessage);
    }

    protected final void showMsg(@NotNull String msg, @NotNull String actionMsg, @NotNull Function0<Unit> onClick2) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)actionMsg, (String)"actionMsg");
        Intrinsics.checkNotNullParameter(onClick2, (String)"onClick");
        Logger.INSTANCE.log((Object)this, (Object)msg);
        TextMessage textMessage = new TextMessage(false, msg, actionMsg, onClick2);
        this.messageLiveEvent.setValue((Object)textMessage);
    }

    public static /* synthetic */ void showMsg$default(BaseViewModel baseViewModel, String string, String string2, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: showMsg");
        }
        if ((n & 4) != 0) {
            function0 = showMsg.1.INSTANCE;
        }
        baseViewModel.showMsg(string, string2, (Function0<Unit>)function0);
    }

    protected final void showErrorMsg(@NotNull String msg, @NotNull String actionMsg, @NotNull Function0<Unit> onClick2) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)actionMsg, (String)"actionMsg");
        Intrinsics.checkNotNullParameter(onClick2, (String)"onClick");
        Logger.INSTANCE.logErr((Object)this, (Object)msg);
        TextMessage textMessage = new TextMessage(true, msg, actionMsg, onClick2);
        this.messageLiveEvent.setValue((Object)textMessage);
    }

    public static /* synthetic */ void showErrorMsg$default(BaseViewModel baseViewModel, String string, String string2, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: showErrorMsg");
        }
        if ((n & 4) != 0) {
            function0 = showErrorMsg.1.INSTANCE;
        }
        baseViewModel.showErrorMsg(string, string2, (Function0<Unit>)function0);
    }

    public void onError(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
    }

    public final void showProgress(@Nullable String text) {
        String string = text;
        Logger.INSTANCE.log((Object)this, (Object)(string == null ? "Empty" : string));
        this.isInProgress.set(true);
        this.progressText.set((Object)text);
        this.isInProgressLiveData.setValue((Object)true);
    }

    public static /* synthetic */ void showProgress$default(BaseViewModel baseViewModel, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: showProgress");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        baseViewModel.showProgress(string);
    }

    public final void hideProgress() {
        if (Intrinsics.areEqual((Object)this.isInProgressLiveData.getValue(), (Object)true)) {
            this.isInProgress.set(false);
            ObservableExtKt.clear(this.progressText);
            this.isInProgressLiveData.setValue((Object)false);
        }
    }

    public final void showAlertDialog(@Nullable String title, @Nullable String message, @Nullable String positiveButtonText, @Nullable String negativeButtonText, @NotNull Function0<Unit> onPositiveClick2, @NotNull Function0<Unit> onNegativeClick2, @Nullable Boolean isSingleAction, @Nullable Boolean isCancelable) {
        Intrinsics.checkNotNullParameter(onPositiveClick2, (String)"onPositiveClick");
        Intrinsics.checkNotNullParameter(onNegativeClick2, (String)"onNegativeClick");
        this.alertDialogLiveEvent.setValue((Object)new AlertDialogModel(title, message, positiveButtonText, negativeButtonText, onPositiveClick2, onNegativeClick2, isSingleAction, isCancelable));
    }

    public static /* synthetic */ void showAlertDialog$default(BaseViewModel baseViewModel, String string, String string2, String string3, String string4, Function0 function0, Function0 function02, Boolean bl, Boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: showAlertDialog");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        if ((n & 8) != 0) {
            string4 = null;
        }
        if ((n & 0x10) != 0) {
            function0 = showAlertDialog.1.INSTANCE;
        }
        if ((n & 0x20) != 0) {
            function02 = showAlertDialog.2.INSTANCE;
        }
        if ((n & 0x40) != 0) {
            bl = null;
        }
        if ((n & 0x80) != 0) {
            bl2 = null;
        }
        baseViewModel.showAlertDialog(string, string2, string3, string4, (Function0<Unit>)function0, (Function0<Unit>)function02, bl, bl2);
    }

    public final void showAlertDialog(@StringRes @Nullable Integer titleRes, @StringRes @Nullable Integer messageRes, @StringRes @Nullable Integer positiveButtonTextRes, @StringRes @Nullable Integer negativeButtonTextRes, @NotNull Function0<Unit> onPositiveClick2, @NotNull Function0<Unit> onNegativeClick2, @Nullable Boolean isSingleAction, @Nullable Boolean isCancelable) {
        Intrinsics.checkNotNullParameter(onPositiveClick2, (String)"onPositiveClick");
        Intrinsics.checkNotNullParameter(onNegativeClick2, (String)"onNegativeClick");
        this.showAlertDialog(this.getString(titleRes, new String[0]), this.getString(messageRes, new String[0]), this.getString(positiveButtonTextRes, new String[0]), this.getString(negativeButtonTextRes, new String[0]), onPositiveClick2, onNegativeClick2, isSingleAction, isCancelable);
    }

    public static /* synthetic */ void showAlertDialog$default(BaseViewModel baseViewModel, Integer n, Integer n2, Integer n3, Integer n4, Function0 function0, Function0 function02, Boolean bl, Boolean bl2, int n5, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: showAlertDialog");
        }
        if ((n5 & 1) != 0) {
            n = null;
        }
        if ((n5 & 2) != 0) {
            n2 = null;
        }
        if ((n5 & 4) != 0) {
            n3 = null;
        }
        if ((n5 & 8) != 0) {
            n4 = null;
        }
        if ((n5 & 0x10) != 0) {
            function0 = showAlertDialog.3.INSTANCE;
        }
        if ((n5 & 0x20) != 0) {
            function02 = showAlertDialog.4.INSTANCE;
        }
        if ((n5 & 0x40) != 0) {
            bl = null;
        }
        if ((n5 & 0x80) != 0) {
            bl2 = null;
        }
        baseViewModel.showAlertDialog(n, n2, n3, n4, (Function0<Unit>)function0, (Function0<Unit>)function02, bl, bl2);
    }

    protected void dispose() {
    }

    public final void stopAllWorks() {
        this.dispose();
    }

    public final boolean isPermissionsGranted(@NotNull Context context, String ... permissions) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        return PermissionManager.INSTANCE.isPermissionsGranted(context, Arrays.copyOf(permissions, permissions.length));
    }

    public final void requestPermissions(@NotNull Pair<String[], Integer> permissions) {
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        this.grantPermissionLiveEvent.setValue(permissions);
    }

    public void updateLanguage(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
    }

    public boolean onBackPressed() {
        return true;
    }

    protected void onCleared() {
        super.onCleared();
        this.dispose();
    }

    @Override
    @NotNull
    public String getString(@StringRes int id, String ... args) {
        return IStringHelper.DefaultImpls.getString((IStringHelper)this, id, args);
    }

    @Override
    @Nullable
    public String getString(@StringRes @Nullable Integer id, String ... args) {
        return IStringHelper.DefaultImpls.getString((IStringHelper)this, id, args);
    }

    @Override
    @Nullable
    public String getString(@NotNull Context context, @StringRes @Nullable Integer id, String ... args) {
        return IStringHelper.DefaultImpls.getString((IStringHelper)this, context, id, args);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J9\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u00032\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0005H\u00d6\u0001R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u000fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lcom/merseyside/archy/presentation/model/BaseViewModel$TextMessage;", "", "isError", "", "msg", "", "actionMsg", "onClick", "Lkotlin/Function0;", "", "(ZLjava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "getActionMsg", "()Ljava/lang/String;", "setActionMsg", "(Ljava/lang/String;)V", "()Z", "getMsg", "setMsg", "getOnClick", "()Lkotlin/jvm/functions/Function0;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "archy_release"})
    public static final class TextMessage {
        private final boolean isError;
        @NotNull
        private String msg;
        @Nullable
        private String actionMsg;
        @NotNull
        private final Function0<Unit> onClick;

        public TextMessage(boolean isError, @NotNull String msg, @Nullable String actionMsg, @NotNull Function0<Unit> onClick2) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            Intrinsics.checkNotNullParameter(onClick2, (String)"onClick");
            this.isError = isError;
            this.msg = msg;
            this.actionMsg = actionMsg;
            this.onClick = onClick2;
        }

        public /* synthetic */ TextMessage(boolean bl, String string, String string2, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                string2 = null;
            }
            if ((n & 8) != 0) {
                function0 = 1.INSTANCE;
            }
            this(bl, string, string2, (Function0<Unit>)function0);
        }

        public final boolean isError() {
            return this.isError;
        }

        @NotNull
        public final String getMsg() {
            return this.msg;
        }

        public final void setMsg(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.msg = string;
        }

        @Nullable
        public final String getActionMsg() {
            return this.actionMsg;
        }

        public final void setActionMsg(@Nullable String string) {
            this.actionMsg = string;
        }

        @NotNull
        public final Function0<Unit> getOnClick() {
            return this.onClick;
        }

        public final boolean component1() {
            return this.isError;
        }

        @NotNull
        public final String component2() {
            return this.msg;
        }

        @Nullable
        public final String component3() {
            return this.actionMsg;
        }

        @NotNull
        public final Function0<Unit> component4() {
            return this.onClick;
        }

        @NotNull
        public final TextMessage copy(boolean isError, @NotNull String msg, @Nullable String actionMsg, @NotNull Function0<Unit> onClick2) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            Intrinsics.checkNotNullParameter(onClick2, (String)"onClick");
            return new TextMessage(isError, msg, actionMsg, onClick2);
        }

        public static /* synthetic */ TextMessage copy$default(TextMessage textMessage, boolean bl, String string, String string2, Function0 function0, int n, Object object) {
            if ((n & 1) != 0) {
                bl = textMessage.isError;
            }
            if ((n & 2) != 0) {
                string = textMessage.msg;
            }
            if ((n & 4) != 0) {
                string2 = textMessage.actionMsg;
            }
            if ((n & 8) != 0) {
                function0 = textMessage.onClick;
            }
            return textMessage.copy(bl, string, string2, function0);
        }

        @NotNull
        public String toString() {
            return "TextMessage(isError=" + this.isError + ", msg=" + this.msg + ", actionMsg=" + this.actionMsg + ", onClick=" + this.onClick + ')';
        }

        public int hashCode() {
            int n = this.isError ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            int result = n;
            result = result * 31 + this.msg.hashCode();
            result = result * 31 + (this.actionMsg == null ? 0 : this.actionMsg.hashCode());
            result = result * 31 + this.onClick.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TextMessage)) {
                return false;
            }
            TextMessage textMessage = (TextMessage)other;
            if (this.isError != textMessage.isError) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.msg, (Object)textMessage.msg)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.actionMsg, (Object)textMessage.actionMsg)) {
                return false;
            }
            return Intrinsics.areEqual(this.onClick, textMessage.onClick);
        }

        public TextMessage() {
            this(false, null, null, null, 15, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0019\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001Bm\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\u000eJ\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\fH\u00c6\u0003\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010 \u001a\u0004\u0018\u00010\fH\u00c6\u0003\u00a2\u0006\u0002\u0010\u000fJv\u0010!\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\fH\u00c6\u0001\u00a2\u0006\u0002\u0010\"J\u0013\u0010#\u001a\u00020\f2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001J\t\u0010'\u001a\u00020\u0003H\u00d6\u0001R\u0015\u0010\r\u001a\u0004\u0018\u00010\f\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\r\u0010\u000fR\u0015\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000b\u0010\u000fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012\u00a8\u0006("}, d2={"Lcom/merseyside/archy/presentation/model/BaseViewModel$AlertDialogModel;", "", "title", "", "message", "positiveButtonText", "negativeButtonText", "onPositiveClick", "Lkotlin/Function0;", "", "onNegativeClick", "isSingleAction", "", "isCancelable", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Ljava/lang/Boolean;Ljava/lang/Boolean;)V", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getMessage", "()Ljava/lang/String;", "getNegativeButtonText", "getOnNegativeClick", "()Lkotlin/jvm/functions/Function0;", "getOnPositiveClick", "getPositiveButtonText", "getTitle", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Ljava/lang/Boolean;Ljava/lang/Boolean;)Lcom/merseyside/archy/presentation/model/BaseViewModel$AlertDialogModel;", "equals", "other", "hashCode", "", "toString", "archy_release"})
    public static final class AlertDialogModel {
        @Nullable
        private final String title;
        @Nullable
        private final String message;
        @Nullable
        private final String positiveButtonText;
        @Nullable
        private final String negativeButtonText;
        @NotNull
        private final Function0<Unit> onPositiveClick;
        @NotNull
        private final Function0<Unit> onNegativeClick;
        @Nullable
        private final Boolean isSingleAction;
        @Nullable
        private final Boolean isCancelable;

        public AlertDialogModel(@Nullable String title, @Nullable String message, @Nullable String positiveButtonText, @Nullable String negativeButtonText, @NotNull Function0<Unit> onPositiveClick2, @NotNull Function0<Unit> onNegativeClick2, @Nullable Boolean isSingleAction, @Nullable Boolean isCancelable) {
            Intrinsics.checkNotNullParameter(onPositiveClick2, (String)"onPositiveClick");
            Intrinsics.checkNotNullParameter(onNegativeClick2, (String)"onNegativeClick");
            this.title = title;
            this.message = message;
            this.positiveButtonText = positiveButtonText;
            this.negativeButtonText = negativeButtonText;
            this.onPositiveClick = onPositiveClick2;
            this.onNegativeClick = onNegativeClick2;
            this.isSingleAction = isSingleAction;
            this.isCancelable = isCancelable;
        }

        public /* synthetic */ AlertDialogModel(String string, String string2, String string3, String string4, Function0 function0, Function0 function02, Boolean bl, Boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                string3 = null;
            }
            if ((n & 8) != 0) {
                string4 = null;
            }
            if ((n & 0x10) != 0) {
                function0 = 1.INSTANCE;
            }
            if ((n & 0x20) != 0) {
                function02 = 2.INSTANCE;
            }
            if ((n & 0x40) != 0) {
                bl = null;
            }
            if ((n & 0x80) != 0) {
                bl2 = null;
            }
            this(string, string2, string3, string4, (Function0<Unit>)function0, (Function0<Unit>)function02, bl, bl2);
        }

        @Nullable
        public final String getTitle() {
            return this.title;
        }

        @Nullable
        public final String getMessage() {
            return this.message;
        }

        @Nullable
        public final String getPositiveButtonText() {
            return this.positiveButtonText;
        }

        @Nullable
        public final String getNegativeButtonText() {
            return this.negativeButtonText;
        }

        @NotNull
        public final Function0<Unit> getOnPositiveClick() {
            return this.onPositiveClick;
        }

        @NotNull
        public final Function0<Unit> getOnNegativeClick() {
            return this.onNegativeClick;
        }

        @Nullable
        public final Boolean isSingleAction() {
            return this.isSingleAction;
        }

        @Nullable
        public final Boolean isCancelable() {
            return this.isCancelable;
        }

        @Nullable
        public final String component1() {
            return this.title;
        }

        @Nullable
        public final String component2() {
            return this.message;
        }

        @Nullable
        public final String component3() {
            return this.positiveButtonText;
        }

        @Nullable
        public final String component4() {
            return this.negativeButtonText;
        }

        @NotNull
        public final Function0<Unit> component5() {
            return this.onPositiveClick;
        }

        @NotNull
        public final Function0<Unit> component6() {
            return this.onNegativeClick;
        }

        @Nullable
        public final Boolean component7() {
            return this.isSingleAction;
        }

        @Nullable
        public final Boolean component8() {
            return this.isCancelable;
        }

        @NotNull
        public final AlertDialogModel copy(@Nullable String title, @Nullable String message, @Nullable String positiveButtonText, @Nullable String negativeButtonText, @NotNull Function0<Unit> onPositiveClick2, @NotNull Function0<Unit> onNegativeClick2, @Nullable Boolean isSingleAction, @Nullable Boolean isCancelable) {
            Intrinsics.checkNotNullParameter(onPositiveClick2, (String)"onPositiveClick");
            Intrinsics.checkNotNullParameter(onNegativeClick2, (String)"onNegativeClick");
            return new AlertDialogModel(title, message, positiveButtonText, negativeButtonText, onPositiveClick2, onNegativeClick2, isSingleAction, isCancelable);
        }

        public static /* synthetic */ AlertDialogModel copy$default(AlertDialogModel alertDialogModel, String string, String string2, String string3, String string4, Function0 function0, Function0 function02, Boolean bl, Boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                string = alertDialogModel.title;
            }
            if ((n & 2) != 0) {
                string2 = alertDialogModel.message;
            }
            if ((n & 4) != 0) {
                string3 = alertDialogModel.positiveButtonText;
            }
            if ((n & 8) != 0) {
                string4 = alertDialogModel.negativeButtonText;
            }
            if ((n & 0x10) != 0) {
                function0 = alertDialogModel.onPositiveClick;
            }
            if ((n & 0x20) != 0) {
                function02 = alertDialogModel.onNegativeClick;
            }
            if ((n & 0x40) != 0) {
                bl = alertDialogModel.isSingleAction;
            }
            if ((n & 0x80) != 0) {
                bl2 = alertDialogModel.isCancelable;
            }
            return alertDialogModel.copy(string, string2, string3, string4, function0, function02, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "AlertDialogModel(title=" + this.title + ", message=" + this.message + ", positiveButtonText=" + this.positiveButtonText + ", negativeButtonText=" + this.negativeButtonText + ", onPositiveClick=" + this.onPositiveClick + ", onNegativeClick=" + this.onNegativeClick + ", isSingleAction=" + this.isSingleAction + ", isCancelable=" + this.isCancelable + ')';
        }

        public int hashCode() {
            int result = this.title == null ? 0 : this.title.hashCode();
            result = result * 31 + (this.message == null ? 0 : this.message.hashCode());
            result = result * 31 + (this.positiveButtonText == null ? 0 : this.positiveButtonText.hashCode());
            result = result * 31 + (this.negativeButtonText == null ? 0 : this.negativeButtonText.hashCode());
            result = result * 31 + this.onPositiveClick.hashCode();
            result = result * 31 + this.onNegativeClick.hashCode();
            result = result * 31 + (this.isSingleAction == null ? 0 : ((Object)this.isSingleAction).hashCode());
            result = result * 31 + (this.isCancelable == null ? 0 : ((Object)this.isCancelable).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AlertDialogModel)) {
                return false;
            }
            AlertDialogModel alertDialogModel = (AlertDialogModel)other;
            if (!Intrinsics.areEqual((Object)this.title, (Object)alertDialogModel.title)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.message, (Object)alertDialogModel.message)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.positiveButtonText, (Object)alertDialogModel.positiveButtonText)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.negativeButtonText, (Object)alertDialogModel.negativeButtonText)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.onPositiveClick, alertDialogModel.onPositiveClick)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.onNegativeClick, alertDialogModel.onNegativeClick)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.isSingleAction, (Object)alertDialogModel.isSingleAction)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.isCancelable, (Object)alertDialogModel.isCancelable);
        }

        public AlertDialogModel() {
            this(null, null, null, null, null, null, null, null, 255, null);
        }
    }
}

