/*
 * Decompiled with CFR 0.152.
 */
package com.daasuu.bl;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.widget.FrameLayout;
import com.daasuu.bl.ArrowDirection;
import com.daasuu.bl.Bubble;
import com.daasuu.bl.R;

public class BubbleLayout
extends FrameLayout {
    public static float DEFAULT_STROKE_WIDTH = -1.0f;
    private ArrowDirection mArrowDirection;
    private Bubble mBubble;
    private float mArrowWidth;
    private float mCornersRadius;
    private float mArrowHeight;
    private float mArrowPosition;
    private int mBubbleColor;
    private float mStrokeWidth;
    private int mStrokeColor;

    public BubbleLayout(Context context) {
        this(context, null, 0);
    }

    public BubbleLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BubbleLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.BubbleLayout);
        this.mArrowWidth = a.getDimension(R.styleable.BubbleLayout_bl_arrowWidth, BubbleLayout.convertDpToPixel(8.0f, context));
        this.mArrowHeight = a.getDimension(R.styleable.BubbleLayout_bl_arrowHeight, BubbleLayout.convertDpToPixel(8.0f, context));
        this.mCornersRadius = a.getDimension(R.styleable.BubbleLayout_bl_cornersRadius, 0.0f);
        this.mArrowPosition = a.getDimension(R.styleable.BubbleLayout_bl_arrowPosition, BubbleLayout.convertDpToPixel(12.0f, context));
        this.mBubbleColor = a.getColor(R.styleable.BubbleLayout_bl_bubbleColor, -1);
        this.mStrokeWidth = a.getDimension(R.styleable.BubbleLayout_bl_strokeWidth, DEFAULT_STROKE_WIDTH);
        this.mStrokeColor = a.getColor(R.styleable.BubbleLayout_bl_strokeColor, -7829368);
        int location = a.getInt(R.styleable.BubbleLayout_bl_arrowDirection, ArrowDirection.LEFT.getValue());
        this.mArrowDirection = ArrowDirection.fromInt(location);
        a.recycle();
        this.initPadding();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.initDrawable(0, this.getWidth(), 0, this.getHeight());
    }

    protected void dispatchDraw(Canvas canvas) {
        if (this.mBubble != null) {
            this.mBubble.draw(canvas);
        }
        super.dispatchDraw(canvas);
    }

    private void initDrawable(int left, int right, int top, int bottom) {
        if (right < left || bottom < top) {
            return;
        }
        RectF rectF = new RectF((float)left, (float)top, (float)right, (float)bottom);
        switch (this.mArrowDirection) {
            case LEFT_CENTER: 
            case RIGHT_CENTER: {
                this.mArrowPosition = (float)((bottom - top) / 2) - this.mArrowHeight / 2.0f;
                break;
            }
            case TOP_CENTER: 
            case BOTTOM_CENTER: {
                this.mArrowPosition = (float)((right - left) / 2) - this.mArrowWidth / 2.0f;
            }
        }
        this.mBubble = new Bubble(rectF, this.mArrowWidth, this.mCornersRadius, this.mArrowHeight, this.mArrowPosition, this.mStrokeWidth, this.mStrokeColor, this.mBubbleColor, this.mArrowDirection);
    }

    private void initPadding() {
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        switch (this.mArrowDirection) {
            case LEFT_CENTER: 
            case LEFT: {
                paddingLeft = (int)((float)paddingLeft + this.mArrowWidth);
                break;
            }
            case RIGHT_CENTER: 
            case RIGHT: {
                paddingRight = (int)((float)paddingRight + this.mArrowWidth);
                break;
            }
            case TOP_CENTER: 
            case TOP: {
                paddingTop = (int)((float)paddingTop + this.mArrowHeight);
                break;
            }
            case BOTTOM_CENTER: 
            case BOTTOM: {
                paddingBottom = (int)((float)paddingBottom + this.mArrowHeight);
            }
        }
        if (this.mStrokeWidth > 0.0f) {
            paddingLeft = (int)((float)paddingLeft + this.mStrokeWidth);
            paddingRight = (int)((float)paddingRight + this.mStrokeWidth);
            paddingTop = (int)((float)paddingTop + this.mStrokeWidth);
            paddingBottom = (int)((float)paddingBottom + this.mStrokeWidth);
        }
        this.setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
    }

    private void resetPadding() {
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        switch (this.mArrowDirection) {
            case LEFT_CENTER: 
            case LEFT: {
                paddingLeft = (int)((float)paddingLeft - this.mArrowWidth);
                break;
            }
            case RIGHT_CENTER: 
            case RIGHT: {
                paddingRight = (int)((float)paddingRight - this.mArrowWidth);
                break;
            }
            case TOP_CENTER: 
            case TOP: {
                paddingTop = (int)((float)paddingTop - this.mArrowHeight);
                break;
            }
            case BOTTOM_CENTER: 
            case BOTTOM: {
                paddingBottom = (int)((float)paddingBottom - this.mArrowHeight);
            }
        }
        if (this.mStrokeWidth > 0.0f) {
            paddingLeft = (int)((float)paddingLeft - this.mStrokeWidth);
            paddingRight = (int)((float)paddingRight - this.mStrokeWidth);
            paddingTop = (int)((float)paddingTop - this.mStrokeWidth);
            paddingBottom = (int)((float)paddingBottom - this.mStrokeWidth);
        }
        this.setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
    }

    static float convertDpToPixel(float dp, Context context) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        return dp * (float)(metrics.densityDpi / 160);
    }

    public BubbleLayout setArrowDirection(ArrowDirection arrowDirection) {
        this.resetPadding();
        this.mArrowDirection = arrowDirection;
        this.initPadding();
        return this;
    }

    public BubbleLayout setArrowWidth(float arrowWidth) {
        this.resetPadding();
        this.mArrowWidth = arrowWidth;
        this.initPadding();
        return this;
    }

    public BubbleLayout setCornersRadius(float cornersRadius) {
        this.mCornersRadius = cornersRadius;
        this.requestLayout();
        return this;
    }

    public BubbleLayout setArrowHeight(float arrowHeight) {
        this.resetPadding();
        this.mArrowHeight = arrowHeight;
        this.initPadding();
        return this;
    }

    public BubbleLayout setArrowPosition(float arrowPosition) {
        this.resetPadding();
        this.mArrowPosition = arrowPosition;
        this.initPadding();
        return this;
    }

    public BubbleLayout setBubbleColor(int bubbleColor) {
        this.mBubbleColor = bubbleColor;
        this.requestLayout();
        return this;
    }

    public BubbleLayout setStrokeWidth(float strokeWidth) {
        this.resetPadding();
        this.mStrokeWidth = strokeWidth;
        this.initPadding();
        return this;
    }

    public BubbleLayout setStrokeColor(int strokeColor) {
        this.mStrokeColor = strokeColor;
        this.requestLayout();
        return this;
    }

    public ArrowDirection getArrowDirection() {
        return this.mArrowDirection;
    }

    public float getArrowWidth() {
        return this.mArrowWidth;
    }

    public float getCornersRadius() {
        return this.mCornersRadius;
    }

    public float getArrowHeight() {
        return this.mArrowHeight;
    }

    public float getArrowPosition() {
        return this.mArrowPosition;
    }

    public int getBubbleColor() {
        return this.mBubbleColor;
    }

    public float getStrokeWidth() {
        return this.mStrokeWidth;
    }

    public int getStrokeColor() {
        return this.mStrokeColor;
    }
}

