/*
 * Decompiled with CFR 0.152.
 */
package com.ctetin.expandabletextviewlibrary;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.PatternsCompat;
import android.support.v7.widget.AppCompatTextView;
import android.text.DynamicLayout;
import android.text.Layout;
import android.text.Selection;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.text.method.MovementMethod;
import android.text.method.Touch;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.ImageSpan;
import android.text.util.Linkify;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;
import com.ctetin.expandabletextviewlibrary.R;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExpandableTextView
extends AppCompatTextView {
    private static final int DEF_MAX_LINE = 4;
    public static final String TEXT_CONTRACT = "\u6536\u8d77";
    public static final String TEXT_EXPEND = "\u5c55\u5f00";
    public static final String Space = " ";
    public static final String TEXT_TARGET = "\u7f51\u9875\u94fe\u63a5";
    public static final String IMAGE_TARGET = "\u56fe";
    public static final String TARGET = "\u56fe\u7f51\u9875\u94fe\u63a5";
    public static final String regexp = "http?://([-\\w\\.]+)+(:\\d+)?(/([\\w/_\\.]*(\\?\\S+)?)?)?";
    public static final String regexp_mention = "@[\\w\\p{InCJKUnifiedIdeographs}-]{1,26}";
    private TextPaint mPaint;
    boolean linkHit;
    private Context mContext;
    private DynamicLayout mDynamicLayout;
    private int mLimitLines;
    private int currentLines;
    private int mWidth;
    private Drawable mLinkDrawable = null;
    private OnLinkClickListener linkClickListener;
    private boolean mNeedContract = true;
    private FormatData mFormatData;
    private boolean mNeedExpend = true;
    private boolean mNeedAnimation = true;
    private int mLineCount;
    private CharSequence mContent;
    private int mExpandTextColor;
    private int mLinkTextColor;
    private int mContractTextColor;
    private String mExpandString;
    private String mContractString;
    private String mEndExpandContent;
    private int mEndExpandTextColor;
    boolean dontConsumeNonUrlClicks = true;

    public ExpandableTextView(Context context) {
        this(context, null);
    }

    public ExpandableTextView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, -1);
    }

    public ExpandableTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
        this.setMovementMethod((MovementMethod)LocalLinkMovementMethod.getInstance());
        Linkify.addLinks((TextView)this, (int)1);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ExpandableTextView, defStyleAttr, 0);
            this.mLimitLines = a.getInt(R.styleable.ExpandableTextView_ep_max_line, 4);
            this.mNeedExpend = a.getBoolean(R.styleable.ExpandableTextView_ep_need_expand, true);
            this.mNeedContract = a.getBoolean(R.styleable.ExpandableTextView_ep_need_contract, false);
            this.mNeedAnimation = a.getBoolean(R.styleable.ExpandableTextView_ep_need_animation, true);
            this.mContractString = a.getString(R.styleable.ExpandableTextView_ep_contract_text);
            this.mExpandString = a.getString(R.styleable.ExpandableTextView_ep_expand_text);
            this.mExpandTextColor = a.getColor(R.styleable.ExpandableTextView_ep_expand_color, Color.parseColor((String)"#999999"));
            this.mEndExpandTextColor = a.getColor(R.styleable.ExpandableTextView_ep_expand_color, Color.parseColor((String)"#999999"));
            this.mContractTextColor = a.getColor(R.styleable.ExpandableTextView_ep_contract_color, Color.parseColor((String)"#999999"));
            this.mLinkTextColor = a.getColor(R.styleable.ExpandableTextView_ep_link_color, Color.parseColor((String)"#FF6200"));
            int resId = a.getResourceId(R.styleable.ExpandableTextView_ep_link_res, R.mipmap.link);
            this.mLinkDrawable = this.getResources().getDrawable(resId);
            this.currentLines = this.mLimitLines;
            a.recycle();
        } else {
            this.mLinkDrawable = context.getResources().getDrawable(R.mipmap.link);
        }
        this.mContext = context;
        this.mPaint = this.getPaint();
        this.mPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mLinkDrawable.setBounds(0, 0, 30, 30);
    }

    private SpannableStringBuilder setRealContent(CharSequence content) {
        this.mFormatData = this.formatData(content);
        this.mDynamicLayout = new DynamicLayout((CharSequence)this.mFormatData.formatedContent, this.mPaint, this.mWidth, Layout.Alignment.ALIGN_NORMAL, 1.2f, 0.0f, true);
        this.mLineCount = this.mDynamicLayout.getLineCount();
        if (!this.mNeedExpend || this.mLineCount <= this.mLimitLines) {
            return this.dealLink(this.mFormatData, false);
        }
        return this.dealLink(this.mFormatData, true);
    }

    public void setEndExpendContent(String endExpendContent) {
        this.mEndExpandContent = endExpendContent;
    }

    public void setContent(String content) {
        this.mContent = content;
        this.currentLines = this.mLimitLines;
        if (this.mWidth == 0) {
            this.mWidth = this.getWidth();
        }
        if (this.mWidth == 0) {
            this.post(() -> this.setContent(content));
        } else {
            this.setRealContent(content);
        }
    }

    private String getExpandEndContent() {
        if (TextUtils.isEmpty((CharSequence)this.mEndExpandContent)) {
            return String.format(Locale.getDefault(), "  %s", TEXT_CONTRACT);
        }
        return String.format(Locale.getDefault(), "  %s  %s", this.mEndExpandContent, TEXT_CONTRACT);
    }

    private String getHideEndContent() {
        if (TextUtils.isEmpty((CharSequence)this.mEndExpandContent)) {
            return String.format(Locale.getDefault(), "...  %s", TEXT_EXPEND);
        }
        return String.format(Locale.getDefault(), "...  %s  %s", this.mEndExpandContent, TEXT_EXPEND);
    }

    private SpannableStringBuilder dealLink(FormatData formatData, boolean ignoreMore) {
        SpannableStringBuilder ssb = new SpannableStringBuilder();
        if (ignoreMore) {
            if (this.currentLines < this.mLineCount) {
                int index = this.currentLines - 1;
                int endPosition = this.mDynamicLayout.getLineEnd(index);
                int startPosition = this.mDynamicLayout.getLineStart(index);
                float lineWidth = this.mDynamicLayout.getLineWidth(index);
                String endString = this.getHideEndContent();
                int fitPosition = this.getFitPosition(endPosition, startPosition, lineWidth, this.mPaint.measureText(endString), 0.0f);
                ssb.append((CharSequence)formatData.formatedContent.substring(0, fitPosition));
                ssb.append((CharSequence)endString);
                int expendLength = TextUtils.isEmpty((CharSequence)this.mEndExpandContent) ? 0 : 2 + this.mEndExpandContent.length();
                ssb.setSpan((Object)new ClickableSpan(){

                    public void onClick(View widget) {
                        ExpandableTextView.this.action();
                    }

                    public void updateDrawState(TextPaint ds) {
                        super.updateDrawState(ds);
                        ds.setColor(ExpandableTextView.this.mExpandTextColor);
                        ds.setUnderlineText(false);
                    }
                }, ssb.length() - TEXT_EXPEND.length() - expendLength, ssb.length(), 17);
            } else {
                ssb.append((CharSequence)formatData.formatedContent);
                if (this.mNeedContract) {
                    String endString = this.getExpandEndContent();
                    ssb.append((CharSequence)endString);
                    int expendLength = TextUtils.isEmpty((CharSequence)this.mEndExpandContent) ? 0 : 2 + this.mEndExpandContent.length();
                    ssb.setSpan((Object)new ClickableSpan(){

                        public void onClick(View widget) {
                            ExpandableTextView.this.action();
                        }

                        public void updateDrawState(TextPaint ds) {
                            super.updateDrawState(ds);
                            ds.setColor(ExpandableTextView.this.mContractTextColor);
                            ds.setUnderlineText(false);
                        }
                    }, ssb.length() - TEXT_CONTRACT.length() - expendLength, ssb.length(), 17);
                } else if (!TextUtils.isEmpty((CharSequence)this.mEndExpandContent)) {
                    ssb.append((CharSequence)this.mEndExpandContent);
                    ssb.setSpan((Object)new ForegroundColorSpan(this.mEndExpandTextColor), ssb.length() - this.mEndExpandContent.length(), ssb.length(), 17);
                }
            }
        } else {
            ssb.append((CharSequence)formatData.formatedContent);
            if (!TextUtils.isEmpty((CharSequence)this.mEndExpandContent)) {
                ssb.append((CharSequence)this.mEndExpandContent);
                ssb.setSpan((Object)new ForegroundColorSpan(this.mEndExpandTextColor), ssb.length() - this.mEndExpandContent.length(), ssb.length(), 17);
            }
        }
        List<FormatData.PositionData> positionDatas = formatData.getPositionDatas();
        for (FormatData.PositionData data : positionDatas) {
            if (ssb.length() < data.getEnd()) continue;
            if (data.getType().equals((Object)LinkType.LINK_TYPE)) {
                if (this.mNeedExpend && ignoreMore) {
                    int fitPosition = ssb.length() - this.getHideEndContent().length();
                    if (data.getStart() >= fitPosition) continue;
                    SelfImageSpan imageSpan = new SelfImageSpan(this.mLinkDrawable, 1);
                    ssb.setSpan((Object)imageSpan, data.getStart(), data.getStart() + 1, 18);
                    int endPosition = data.getEnd();
                    if (fitPosition > data.getStart() + 1 && fitPosition < data.getEnd()) {
                        endPosition = fitPosition;
                    }
                    if (data.getStart() + 1 >= fitPosition) continue;
                    this.addUrl(ssb, data, endPosition);
                    continue;
                }
                SelfImageSpan imageSpan = new SelfImageSpan(this.mLinkDrawable, 1);
                ssb.setSpan((Object)imageSpan, data.getStart(), data.getStart() + 1, 18);
                this.addUrl(ssb, data, data.getEnd());
                continue;
            }
            if (this.mNeedExpend && ignoreMore) {
                int fitPosition = ssb.length() - this.getHideEndContent().length();
                if (data.getStart() >= fitPosition) continue;
                int endPosition = data.getEnd();
                if (fitPosition < data.getEnd()) {
                    endPosition = fitPosition;
                }
                this.addMention(ssb, data, endPosition);
                continue;
            }
            this.addMention(ssb, data, data.getEnd());
        }
        this.setText((CharSequence)ssb);
        this.setHighlightColor(0);
        return ssb;
    }

    private void addMention(SpannableStringBuilder ssb, final FormatData.PositionData data, int endPosition) {
        ssb.setSpan((Object)new ClickableSpan(){

            public void onClick(View widget) {
                if (ExpandableTextView.this.linkClickListener != null) {
                    ExpandableTextView.this.linkClickListener.onLinkClickListener(LinkType.MENTION_TYPE, data.getUrl());
                }
            }

            public void updateDrawState(TextPaint ds) {
                ds.setColor(ExpandableTextView.this.mLinkTextColor);
                ds.setUnderlineText(false);
            }
        }, data.getStart(), endPosition, 17);
    }

    private void addUrl(SpannableStringBuilder ssb, final FormatData.PositionData data, int endPosition) {
        ssb.setSpan((Object)new ClickableSpan(){

            public void onClick(View widget) {
                if (ExpandableTextView.this.linkClickListener != null) {
                    ExpandableTextView.this.linkClickListener.onLinkClickListener(LinkType.LINK_TYPE, data.getUrl());
                }
            }

            public void updateDrawState(TextPaint ds) {
                ds.setColor(ExpandableTextView.this.mLinkTextColor);
                ds.setUnderlineText(false);
            }
        }, data.getStart() + 1, endPosition, 17);
    }

    private void action() {
        boolean isHide;
        boolean bl = isHide = this.currentLines < this.mLineCount;
        if (this.mNeedAnimation) {
            ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            valueAnimator.addUpdateListener(animation -> {
                Float value = (Float)animation.getAnimatedValue();
                if (isHide) {
                    this.currentLines = this.mLimitLines + (int)((float)(this.mLineCount - this.mLimitLines) * value.floatValue());
                } else if (this.mNeedContract) {
                    this.currentLines = this.mLimitLines + (int)((float)(this.mLineCount - this.mLimitLines) * (1.0f - value.floatValue()));
                }
                this.setText((CharSequence)this.setRealContent(this.mContent));
            });
            valueAnimator.setDuration(100L);
            valueAnimator.start();
        } else {
            if (isHide) {
                this.currentLines = this.mLimitLines + (this.mLineCount - this.mLimitLines);
            } else if (this.mNeedContract) {
                this.currentLines = this.mLimitLines;
            }
            this.setText((CharSequence)this.setRealContent(this.mContent));
        }
    }

    private int getFitPosition(int endPosition, int startPosition, float lineWidth, float endStringWith, float offset) {
        int position = (int)((lineWidth - (endStringWith + offset)) * (float)(endPosition - startPosition) / lineWidth);
        if (position < 0) {
            return endPosition;
        }
        float measureText = this.mPaint.measureText(this.mFormatData.formatedContent.substring(startPosition, startPosition + position));
        if (measureText <= lineWidth - endStringWith) {
            return startPosition + position;
        }
        return this.getFitPosition(endPosition, startPosition, lineWidth, endStringWith, offset + this.mPaint.measureText(Space));
    }

    private FormatData formatData(CharSequence content) {
        FormatData formatData = new FormatData();
        ArrayList<FormatData.PositionData> datas = new ArrayList<FormatData.PositionData>();
        Pattern pattern = PatternsCompat.AUTOLINK_WEB_URL;
        Matcher matcher = pattern.matcher(content);
        StringBuffer newResult = new StringBuffer();
        int start = 0;
        int end = 0;
        int temp = 0;
        while (matcher.find()) {
            start = matcher.start();
            end = matcher.end();
            newResult.append(content.toString().substring(temp, start));
            datas.add(new FormatData.PositionData(newResult.length() + 1, newResult.length() + 2 + TARGET.length(), matcher.group(), LinkType.LINK_TYPE));
            newResult.append(" \u56fe\u7f51\u9875\u94fe\u63a5 ");
            temp = end;
        }
        newResult.append(content.toString().substring(end, content.toString().length()));
        pattern = Pattern.compile(regexp_mention, 2);
        matcher = pattern.matcher(newResult.toString());
        ArrayList<FormatData.PositionData> datasMention = new ArrayList<FormatData.PositionData>();
        while (matcher.find()) {
            datasMention.add(new FormatData.PositionData(matcher.start(), matcher.end(), matcher.group(), LinkType.MENTION_TYPE));
        }
        formatData.setFormatedContent(newResult.toString());
        datas.addAll(0, datasMention);
        formatData.setPositionDatas(datas);
        return formatData;
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.linkHit = false;
        boolean res = super.onTouchEvent(event);
        if (this.dontConsumeNonUrlClicks) {
            return this.linkHit;
        }
        return res;
    }

    public OnLinkClickListener getLinkClickListener() {
        return this.linkClickListener;
    }

    public void setLinkClickListener(OnLinkClickListener linkClickListener) {
        this.linkClickListener = linkClickListener;
    }

    public static enum LinkType {
        LINK_TYPE,
        MENTION_TYPE;

    }

    public static interface OnLinkClickListener {
        public void onLinkClickListener(LinkType var1, String var2);
    }

    public static class LocalLinkMovementMethod
    extends LinkMovementMethod {
        static LocalLinkMovementMethod sInstance;

        public static LocalLinkMovementMethod getInstance() {
            if (sInstance == null) {
                sInstance = new LocalLinkMovementMethod();
            }
            return sInstance;
        }

        public boolean onTouchEvent(TextView widget, Spannable buffer, MotionEvent event) {
            int action = event.getAction();
            if (action == 1 || action == 0) {
                int line;
                int x = (int)event.getX();
                int y = (int)event.getY();
                x -= widget.getTotalPaddingLeft();
                y -= widget.getTotalPaddingTop();
                Layout layout = widget.getLayout();
                int off = layout.getOffsetForHorizontal(line = layout.getLineForVertical(y += widget.getScrollY()), (float)(x += widget.getScrollX()));
                ClickableSpan[] link = (ClickableSpan[])buffer.getSpans(off, off, ClickableSpan.class);
                if (link.length != 0) {
                    if (action == 1) {
                        link[0].onClick((View)widget);
                    } else if (action == 0) {
                        Selection.setSelection((Spannable)buffer, (int)buffer.getSpanStart((Object)link[0]), (int)buffer.getSpanEnd((Object)link[0]));
                    }
                    if (widget instanceof ExpandableTextView) {
                        ((ExpandableTextView)widget).linkHit = true;
                    }
                    return true;
                }
                Selection.removeSelection((Spannable)buffer);
                Touch.onTouchEvent((TextView)widget, (Spannable)buffer, (MotionEvent)event);
                return false;
            }
            return Touch.onTouchEvent((TextView)widget, (Spannable)buffer, (MotionEvent)event);
        }
    }

    class SelfImageSpan
    extends ImageSpan {
        private Drawable drawable;

        public SelfImageSpan(Drawable d, int verticalAlignment) {
            super(d, verticalAlignment);
            this.drawable = d;
        }

        public Drawable getDrawable() {
            return this.drawable;
        }

        public void draw(@NonNull Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, @NonNull Paint paint) {
            Drawable b = this.getDrawable();
            Paint.FontMetricsInt fm = paint.getFontMetricsInt();
            int transY = (y + fm.descent + y + fm.ascent) / 2 - b.getBounds().bottom / 2;
            canvas.save();
            canvas.translate(x, (float)transY);
            b.draw(canvas);
            canvas.restore();
        }
    }

    static class FormatData {
        private String formatedContent;
        private List<PositionData> positionDatas;

        FormatData() {
        }

        public String getFormatedContent() {
            return this.formatedContent;
        }

        public void setFormatedContent(String formatedContent) {
            this.formatedContent = formatedContent;
        }

        public List<PositionData> getPositionDatas() {
            return this.positionDatas;
        }

        public void setPositionDatas(List<PositionData> positionDatas) {
            this.positionDatas = positionDatas;
        }

        static class PositionData {
            private int start;
            private int end;
            private String url;
            private LinkType type;

            public LinkType getType() {
                return this.type;
            }

            public void setType(LinkType type) {
                this.type = type;
            }

            public String getUrl() {
                return this.url;
            }

            public void setUrl(String url) {
                this.url = url;
            }

            public PositionData(int start, int end, String url, LinkType type) {
                this.start = start;
                this.end = end;
                this.url = url;
                this.type = type;
            }

            public int getStart() {
                return this.start;
            }

            public void setStart(int start) {
                this.start = start;
            }

            public int getEnd() {
                return this.end;
            }

            public void setEnd(int end) {
                this.end = end;
            }
        }
    }
}

