/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.utils;

import android.graphics.Bitmap;
import android.util.Log;
import java.util.LinkedHashMap;
import java.util.Map;
import org.osmdroid.bonuspack.utils.BonusPackHelper;

public class WebImageCache {
    LinkedHashMap<String, Bitmap> mCacheMap;
    int mCapacity;

    public WebImageCache(int maxItems) {
        this.mCapacity = maxItems;
        this.mCacheMap = new LinkedHashMap<String, Bitmap>(maxItems + 1, 1.1f, true){
            private static final long serialVersionUID = -4831331496601290979L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Bitmap> eldest) {
                return this.size() > WebImageCache.this.mCapacity;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putInCache(String url, Bitmap image) {
        LinkedHashMap<String, Bitmap> linkedHashMap = this.mCacheMap;
        synchronized (linkedHashMap) {
            this.mCacheMap.put(url, image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap get(String url) {
        Bitmap image;
        LinkedHashMap<String, Bitmap> linkedHashMap = this.mCacheMap;
        synchronized (linkedHashMap) {
            image = this.mCacheMap.get(url);
        }
        if (image == null) {
            Log.d((String)"BONUSPACK", (String)("WebImageCache:load :" + url));
            image = BonusPackHelper.loadBitmap(url);
            if (image != null) {
                this.putInCache(url, image);
            }
        }
        return image;
    }
}

