/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.routing;

import java.util.ArrayList;
import java.util.Locale;
import org.osmdroid.bonuspack.routing.Road;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.overlay.Polyline;

public abstract class RoadManager {
    protected String mOptions = "";

    public abstract Road getRoad(ArrayList<GeoPoint> var1);

    public abstract Road[] getRoads(ArrayList<GeoPoint> var1);

    public void addRequestOption(String requestOption) {
        this.mOptions = this.mOptions + "&" + requestOption;
    }

    protected String geoPointAsString(GeoPoint p) {
        Locale l = null;
        return String.format(l, "%.10f,%.10f", p.getLatitude(), p.getLongitude());
    }

    protected String geoPointAsLonLatString(GeoPoint p) {
        Locale l = null;
        return String.format(l, "%.10f,%.10f", p.getLongitude(), p.getLatitude());
    }

    public static Polyline buildRoadOverlay(Road road, int color, float width) {
        Polyline roadOverlay = new Polyline();
        roadOverlay.setColor(color);
        roadOverlay.setWidth(width);
        if (road != null) {
            ArrayList<GeoPoint> polyline = road.mRouteHigh;
            roadOverlay.setPoints(polyline);
        }
        return roadOverlay;
    }

    public static Polyline buildRoadOverlay(Road road) {
        return RoadManager.buildRoadOverlay(road, -2147483393, 5.0f);
    }
}

