/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.routing;

import android.content.Context;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osmdroid.bonuspack.R;
import org.osmdroid.bonuspack.routing.Road;
import org.osmdroid.bonuspack.routing.RoadLeg;
import org.osmdroid.bonuspack.routing.RoadManager;
import org.osmdroid.bonuspack.routing.RoadNode;
import org.osmdroid.bonuspack.utils.BonusPackHelper;
import org.osmdroid.bonuspack.utils.PolylineEncoder;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.util.GeoPoint;

public class OSRMRoadManager
extends RoadManager {
    static final String DEFAULT_SERVICE = "https://routing.openstreetmap.de/";
    public static final String MEAN_BY_CAR = "routed-car/route/v1/driving/";
    public static final String MEAN_BY_BIKE = "routed-bike/route/v1/driving/";
    public static final String MEAN_BY_FOOT = "routed-foot/route/v1/driving/";
    private final Context mContext;
    protected String mServiceUrl;
    protected String mMeanUrl;
    protected String mUserAgent;
    static final HashMap<String, Integer> MANEUVERS = new HashMap();
    static final HashMap<Integer, Object> DIRECTIONS;

    public OSRMRoadManager(Context context, String userAgent) {
        this.mContext = context;
        this.mUserAgent = userAgent;
        this.mServiceUrl = DEFAULT_SERVICE;
        this.mMeanUrl = MEAN_BY_CAR;
    }

    public void setService(String serviceUrl) {
        this.mServiceUrl = serviceUrl;
    }

    public void setMean(String meanUrl) {
        this.mMeanUrl = meanUrl;
    }

    protected String getUrl(ArrayList<GeoPoint> waypoints, boolean getAlternate) {
        StringBuilder urlString = new StringBuilder(this.mServiceUrl + this.mMeanUrl);
        for (int i = 0; i < waypoints.size(); ++i) {
            GeoPoint p = waypoints.get(i);
            if (i > 0) {
                urlString.append(';');
            }
            urlString.append(this.geoPointAsLonLatString(p));
        }
        urlString.append("?alternatives=" + (getAlternate ? "true" : "false"));
        urlString.append("&overview=full&steps=true");
        urlString.append(this.mOptions);
        return urlString.toString();
    }

    protected Road[] defaultRoad(ArrayList<GeoPoint> waypoints) {
        Road[] roads = new Road[]{new Road(waypoints)};
        return roads;
    }

    protected Road[] getRoads(ArrayList<GeoPoint> waypoints, boolean getAlternate) {
        String url = this.getUrl(waypoints, getAlternate);
        Log.d((String)"BONUSPACK", (String)("OSRMRoadManager.getRoads:" + url));
        String jString = BonusPackHelper.requestStringFromUrl(url, this.mUserAgent);
        if (jString == null) {
            Log.e((String)"BONUSPACK", (String)"OSRMRoadManager::getRoad: request failed.");
            return this.defaultRoad(waypoints);
        }
        try {
            JSONObject jObject = new JSONObject(jString);
            String jCode = jObject.getString("code");
            if (!"Ok".equals(jCode)) {
                Log.e((String)"BONUSPACK", (String)("OSRMRoadManager::getRoad: error code=" + jCode));
                Road[] roads = this.defaultRoad(waypoints);
                if ("NoRoute".equals(jCode)) {
                    roads[0].mStatus = -1;
                }
                return roads;
            }
            JSONArray jRoutes = jObject.getJSONArray("routes");
            Road[] roads = new Road[jRoutes.length()];
            for (int i = 0; i < jRoutes.length(); ++i) {
                Road road;
                roads[i] = road = new Road();
                road.mStatus = 0;
                JSONObject jRoute = jRoutes.getJSONObject(i);
                String route_geometry = jRoute.getString("geometry");
                road.mRouteHigh = PolylineEncoder.decode(route_geometry, 10, false);
                road.mBoundingBox = BoundingBox.fromGeoPoints(road.mRouteHigh);
                road.mLength = jRoute.getDouble("distance") / 1000.0;
                road.mDuration = jRoute.getDouble("duration");
                JSONArray jLegs = jRoute.getJSONArray("legs");
                for (int l = 0; l < jLegs.length(); ++l) {
                    JSONObject jLeg = jLegs.getJSONObject(l);
                    RoadLeg leg = new RoadLeg();
                    road.mLegs.add(leg);
                    leg.mLength = jLeg.getDouble("distance");
                    leg.mDuration = jLeg.getDouble("duration");
                    JSONArray jSteps = jLeg.getJSONArray("steps");
                    RoadNode lastNode = null;
                    String lastRoadName = "";
                    for (int s = 0; s < jSteps.length(); ++s) {
                        JSONObject jStep = jSteps.getJSONObject(s);
                        RoadNode node = new RoadNode();
                        node.mLength = jStep.getDouble("distance") / 1000.0;
                        node.mDuration = jStep.getDouble("duration");
                        JSONObject jStepManeuver = jStep.getJSONObject("maneuver");
                        JSONArray jLocation = jStepManeuver.getJSONArray("location");
                        node.mLocation = new GeoPoint(jLocation.getDouble(1), jLocation.getDouble(0));
                        String direction = jStepManeuver.getString("type");
                        if (direction.equals("turn") || direction.equals("ramp") || direction.equals("merge")) {
                            String modifier = jStepManeuver.getString("modifier");
                            direction = direction + '-' + modifier;
                        } else if (direction.equals("roundabout")) {
                            int exit = jStepManeuver.getInt("exit");
                            direction = direction + '-' + exit;
                        } else if (direction.equals("rotary")) {
                            int exit = jStepManeuver.getInt("exit");
                            direction = "roundabout-" + exit;
                        }
                        node.mManeuverType = this.getManeuverCode(direction);
                        String roadName = jStep.optString("name", "");
                        node.mInstructions = this.buildInstructions(node.mManeuverType, roadName);
                        if (lastNode != null && node.mManeuverType == 2 && lastRoadName.equals(roadName)) {
                            lastNode.mDuration += node.mDuration;
                            lastNode.mLength += node.mLength;
                            continue;
                        }
                        road.mNodes.add(node);
                        lastNode = node;
                        lastRoadName = roadName;
                    }
                }
            }
            Log.d((String)"BONUSPACK", (String)"OSRMRoadManager.getRoads - finished");
            return roads;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return this.defaultRoad(waypoints);
        }
    }

    @Override
    public Road[] getRoads(ArrayList<GeoPoint> waypoints) {
        return this.getRoads(waypoints, true);
    }

    @Override
    public Road getRoad(ArrayList<GeoPoint> waypoints) {
        Road[] roads = this.getRoads(waypoints, false);
        return roads[0];
    }

    protected int getManeuverCode(String direction) {
        Integer code = MANEUVERS.get(direction);
        if (code != null) {
            return code;
        }
        return 0;
    }

    protected String buildInstructions(int maneuver, String roadName) {
        String instructions;
        Integer resDirection = (Integer)DIRECTIONS.get(maneuver);
        if (resDirection == null) {
            return null;
        }
        String direction = this.mContext.getString(resDirection.intValue());
        if (roadName.equals("")) {
            instructions = direction.replaceFirst("\\[[^\\]]*\\]", "");
        } else {
            direction = direction.replace('[', ' ');
            direction = direction.replace(']', ' ');
            instructions = String.format(direction, roadName);
        }
        return instructions;
    }

    static {
        MANEUVERS.put("new name", 2);
        MANEUVERS.put("turn-straight", 1);
        MANEUVERS.put("turn-slight right", 6);
        MANEUVERS.put("turn-right", 7);
        MANEUVERS.put("turn-sharp right", 8);
        MANEUVERS.put("turn-uturn", 12);
        MANEUVERS.put("turn-sharp left", 5);
        MANEUVERS.put("turn-left", 4);
        MANEUVERS.put("turn-slight left", 3);
        MANEUVERS.put("depart", 24);
        MANEUVERS.put("arrive", 24);
        MANEUVERS.put("roundabout-1", 27);
        MANEUVERS.put("roundabout-2", 28);
        MANEUVERS.put("roundabout-3", 29);
        MANEUVERS.put("roundabout-4", 30);
        MANEUVERS.put("roundabout-5", 31);
        MANEUVERS.put("roundabout-6", 32);
        MANEUVERS.put("roundabout-7", 33);
        MANEUVERS.put("roundabout-8", 34);
        MANEUVERS.put("merge-left", 20);
        MANEUVERS.put("merge-sharp left", 20);
        MANEUVERS.put("merge-slight left", 20);
        MANEUVERS.put("merge-right", 21);
        MANEUVERS.put("merge-sharp right", 21);
        MANEUVERS.put("merge-slight right", 21);
        MANEUVERS.put("merge-straight", 22);
        MANEUVERS.put("ramp-left", 17);
        MANEUVERS.put("ramp-sharp left", 17);
        MANEUVERS.put("ramp-slight left", 17);
        MANEUVERS.put("ramp-right", 18);
        MANEUVERS.put("ramp-sharp right", 18);
        MANEUVERS.put("ramp-slight right", 18);
        MANEUVERS.put("ramp-straight", 19);
        DIRECTIONS = new HashMap();
        DIRECTIONS.put(1, R.string.osmbonuspack_directions_1);
        DIRECTIONS.put(2, R.string.osmbonuspack_directions_2);
        DIRECTIONS.put(3, R.string.osmbonuspack_directions_3);
        DIRECTIONS.put(4, R.string.osmbonuspack_directions_4);
        DIRECTIONS.put(5, R.string.osmbonuspack_directions_5);
        DIRECTIONS.put(6, R.string.osmbonuspack_directions_6);
        DIRECTIONS.put(7, R.string.osmbonuspack_directions_7);
        DIRECTIONS.put(8, R.string.osmbonuspack_directions_8);
        DIRECTIONS.put(12, R.string.osmbonuspack_directions_12);
        DIRECTIONS.put(17, R.string.osmbonuspack_directions_17);
        DIRECTIONS.put(18, R.string.osmbonuspack_directions_18);
        DIRECTIONS.put(19, R.string.osmbonuspack_directions_19);
        DIRECTIONS.put(24, R.string.osmbonuspack_directions_24);
        DIRECTIONS.put(27, R.string.osmbonuspack_directions_27);
        DIRECTIONS.put(28, R.string.osmbonuspack_directions_28);
        DIRECTIONS.put(29, R.string.osmbonuspack_directions_29);
        DIRECTIONS.put(30, R.string.osmbonuspack_directions_30);
        DIRECTIONS.put(31, R.string.osmbonuspack_directions_31);
        DIRECTIONS.put(32, R.string.osmbonuspack_directions_32);
        DIRECTIONS.put(33, R.string.osmbonuspack_directions_33);
        DIRECTIONS.put(34, R.string.osmbonuspack_directions_34);
    }
}

