/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.location;

import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.osmdroid.bonuspack.location.POI;
import org.osmdroid.bonuspack.location.PicasaXMLHandler;
import org.osmdroid.bonuspack.utils.HttpConnection;
import org.osmdroid.util.BoundingBox;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Deprecated
public class PicasaPOIProvider {
    String mAccessToken;

    public PicasaPOIProvider(String accessToken) {
        this.mAccessToken = accessToken;
    }

    private String getUrlInside(BoundingBox boundingBox, int maxResults, String query) {
        StringBuilder url = new StringBuilder("http://picasaweb.google.com/data/feed/api/all?");
        url.append("bbox=" + boundingBox.getLonWest());
        url.append("," + boundingBox.getLatSouth());
        url.append("," + boundingBox.getLonEast());
        url.append("," + boundingBox.getLatNorth());
        url.append("&max-results=" + maxResults);
        url.append("&thumbsize=64c");
        url.append("&fields=openSearch:totalResults,entry(summary,media:group/media:thumbnail,media:group/media:title,gphoto:*,georss:where,link)");
        if (query != null) {
            url.append("&q=" + URLEncoder.encode(query));
        }
        if (this.mAccessToken != null) {
            url.append("&access_token=" + this.mAccessToken);
        }
        return url.toString();
    }

    public ArrayList<POI> getThem(String fullUrl) {
        Log.d((String)"BONUSPACK", (String)("PicasaPOIProvider:get:" + fullUrl));
        HttpConnection connection = new HttpConnection();
        connection.doGet(fullUrl);
        InputStream stream = connection.getStream();
        if (stream == null) {
            return null;
        }
        PicasaXMLHandler handler = new PicasaXMLHandler();
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.getXMLReader().setFeature("http://xml.org/sax/features/namespaces", false);
            parser.getXMLReader().setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            parser.parse(stream, (DefaultHandler)handler);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        connection.close();
        if (handler.mPOIs != null) {
            Log.d((String)"BONUSPACK", (String)("done:" + handler.mPOIs.size() + " got, on a total of:" + handler.mTotalResults));
        }
        return handler.mPOIs;
    }

    public ArrayList<POI> getPOIInside(BoundingBox boundingBox, int maxResults, String query) {
        String url = this.getUrlInside(boundingBox, maxResults, query);
        return this.getThem(url);
    }
}

