/*
 * Decompiled with CFR 0.152.
 */
package ng.max.slideview;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v7.widget.AppCompatSeekBar;
import android.util.AttributeSet;
import android.view.MotionEvent;
import ng.max.slideview.SlideView;

public class Slider
extends AppCompatSeekBar {
    private Drawable thumb;
    private SlideView.OnSlideCompleteListener listener;
    private SlideView slideView;

    public Slider(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setThumb(Drawable thumb) {
        this.thumb = thumb;
        super.setThumb(thumb);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 0) {
            if (!this.thumb.getBounds().contains((int)event.getX(), (int)event.getY())) return false;
            this.getParent().requestDisallowInterceptTouchEvent(true);
            super.onTouchEvent(event);
            return true;
        } else if (event.getAction() == 1) {
            if (this.getProgress() > 85 && this.listener != null) {
                this.listener.onSlideComplete(this.slideView);
            }
            this.getParent().requestDisallowInterceptTouchEvent(false);
            this.setProgress(0);
            return true;
        } else {
            super.onTouchEvent(event);
        }
        return true;
    }

    void setOnSlideCompleteListenerInternal(SlideView.OnSlideCompleteListener listener, SlideView slideView) {
        this.listener = listener;
        this.slideView = slideView;
    }

    public Drawable getThumb() {
        if (Build.VERSION.SDK_INT >= 16) {
            return super.getThumb();
        }
        return this.thumb;
    }
}

