/*
 * Decompiled with CFR 0.152.
 */
package ng.max.slideview;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.RequiresApi;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import ng.max.slideview.R;
import ng.max.slideview.Slider;
import ng.max.slideview.Util;

public class SlideView
extends RelativeLayout
implements SeekBar.OnSeekBarChangeListener {
    protected Slider slider;
    protected Drawable slideBackground;
    protected Drawable buttonBackground;
    protected Drawable buttonImage;
    protected Drawable buttonImageDisabled;
    protected TextView slideTextView;
    protected LayerDrawable buttonLayers;
    protected ColorStateList slideBackgroundColor;
    protected ColorStateList buttonBackgroundColor;
    protected boolean animateSlideText;

    public SlideView(Context context) {
        super(context);
        this.init(null, 0);
    }

    public SlideView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public SlideView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs, defStyleAttr);
    }

    @RequiresApi(api=21)
    public SlideView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs, defStyleAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(AttributeSet attrs, int defStyle) {
        SlideView.inflate((Context)this.getContext(), (int)R.layout.sv_slide_view, (ViewGroup)this);
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.sv_view_bg));
        } else {
            this.setBackgroundDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.sv_view_bg));
        }
        this.slideTextView = (TextView)this.findViewById(R.id.sv_text);
        this.slider = (Slider)this.findViewById(R.id.sv_slider);
        this.slider.setOnSeekBarChangeListener(this);
        this.slideBackground = this.getBackground();
        this.buttonLayers = (LayerDrawable)this.slider.getThumb();
        this.buttonBackground = this.buttonLayers.findDrawableByLayerId(R.id.buttonBackground);
        TypedArray a = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.SlideView, defStyle, defStyle);
        float slideTextSize = Util.spToPx(16, this.getContext());
        try {
            this.animateSlideText = a.getBoolean(R.styleable.SlideView_sv_animateSlideText, true);
            boolean reverseSlide = a.getBoolean(R.styleable.SlideView_sv_reverseSlide, false);
            int strokeColor = a.getColor(R.styleable.SlideView_sv_strokeColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.sv_stroke_color_default));
            String slideText = a.getString(R.styleable.SlideView_sv_slideText);
            ColorStateList sliderTextColor = a.getColorStateList(R.styleable.SlideView_sv_slideTextColor);
            slideTextSize = a.getDimension(R.styleable.SlideView_sv_slideTextSize, slideTextSize);
            this.slideTextView.setTextSize(0, slideTextSize);
            this.setText(slideText);
            this.setTextColor(sliderTextColor == null ? this.slideTextView.getTextColors() : sliderTextColor);
            int buttonImageId = a.getResourceId(R.styleable.SlideView_sv_buttonImage, R.drawable.sv_ic_chevron_double_right);
            this.setButtonImage(ContextCompat.getDrawable((Context)this.getContext(), (int)buttonImageId));
            this.setButtonImageDisabled(ContextCompat.getDrawable((Context)this.getContext(), (int)a.getResourceId(R.styleable.SlideView_sv_buttonImageDisabled, buttonImageId)));
            this.setButtonBackgroundColor(a.getColorStateList(R.styleable.SlideView_sv_buttonBackgroundColor));
            this.setSlideBackgroundColor(a.getColorStateList(R.styleable.SlideView_sv_slideBackgroundColor));
            if (a.hasValue(R.styleable.SlideView_sv_strokeColor)) {
                Util.setDrawableStroke(this.slideBackground, strokeColor);
            }
            if (reverseSlide) {
                this.slider.setRotation(180.0f);
                RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.slideTextView.getLayoutParams();
                params.addRule(11, 0);
                params.addRule(9);
                if (Build.VERSION.SDK_INT >= 17) {
                    params.addRule(21, 0);
                    params.addRule(20);
                }
                this.slideTextView.setLayoutParams((ViewGroup.LayoutParams)params);
            }
        }
        finally {
            a.recycle();
        }
    }

    public void setTextColor(@ColorInt int color2) {
        this.slideTextView.setTextColor(color2);
    }

    public void setTextColor(ColorStateList colors) {
        this.slideTextView.setTextColor(colors);
    }

    public void setText(CharSequence text) {
        this.slideTextView.setText(text);
    }

    public void setTextSize(int size) {
        this.slideTextView.setTextSize((float)size);
    }

    public TextView getTextView() {
        return this.slideTextView;
    }

    public void setButtonImage(Drawable image) {
        this.buttonImage = image;
        this.buttonLayers.setDrawableByLayerId(R.id.buttonImage, image);
    }

    public void setButtonImageDisabled(Drawable image) {
        this.buttonImageDisabled = image;
    }

    public void setButtonBackgroundColor(ColorStateList color2) {
        this.buttonBackgroundColor = color2;
        Util.setDrawableColor(this.buttonBackground, color2.getDefaultColor());
    }

    public void setSlideBackgroundColor(ColorStateList color2) {
        this.slideBackgroundColor = color2;
        Util.setDrawableColor(this.slideBackground, color2.getDefaultColor());
    }

    public Slider getSlider() {
        return this.slider;
    }

    public void setOnSlideCompleteListener(OnSlideCompleteListener listener) {
        this.slider.setOnSlideCompleteListenerInternal(listener, this);
    }

    public void setEnabled(boolean enabled) {
        int[] nArray;
        int[] nArray2;
        super.setEnabled(enabled);
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).setEnabled(enabled);
        }
        this.buttonLayers.setDrawableByLayerId(R.id.buttonImage, enabled ? this.buttonImage : (this.buttonImageDisabled == null ? this.buttonImage : this.buttonImageDisabled));
        if (enabled) {
            int[] nArray3 = new int[1];
            nArray2 = nArray3;
            nArray3[0] = 16842910;
        } else {
            int[] nArray4 = new int[1];
            nArray2 = nArray4;
            nArray4[0] = -16842910;
        }
        Util.setDrawableColor(this.buttonBackground, this.buttonBackgroundColor.getColorForState(nArray2, ContextCompat.getColor((Context)this.getContext(), (int)R.color.sv_button_color_default)));
        if (enabled) {
            int[] nArray5 = new int[1];
            nArray = nArray5;
            nArray5[0] = 16842910;
        } else {
            int[] nArray6 = new int[1];
            nArray = nArray6;
            nArray6[0] = -16842910;
        }
        Util.setDrawableColor(this.slideBackground, this.slideBackgroundColor.getColorForState(nArray, ContextCompat.getColor((Context)this.getContext(), (int)R.color.sv_button_color_default)));
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
        if (this.animateSlideText) {
            this.slideTextView.setAlpha(1.0f - (float)progress / 100.0f);
        }
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
    }

    public static interface OnSlideCompleteListener {
        public void onSlideComplete(SlideView var1);
    }
}

