/*
 * Decompiled with CFR 0.152.
 */
package com.yalantis.ucrop;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import com.bumptech.glide.request.RequestOptions;
import com.yalantis.ucrop.R;
import com.yalantis.ucrop.model.CutInfo;
import java.util.ArrayList;
import java.util.List;

public class PicturePhotoGalleryAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private Context context;
    private List<CutInfo> list = new ArrayList<CutInfo>();
    private LayoutInflater mInflater;

    public PicturePhotoGalleryAdapter(Context context, List<CutInfo> list) {
        this.mInflater = LayoutInflater.from((Context)context);
        this.context = context;
        this.list = list;
    }

    public void bindData(List<CutInfo> list) {
        this.list = list;
        this.notifyDataSetChanged();
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int position) {
        View view = this.mInflater.inflate(R.layout.ucrop_picture_gf_adapter_edit_list, parent, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        String path = "";
        CutInfo photoInfo = this.list.get(position);
        if (photoInfo != null) {
            path = photoInfo.getPath();
        }
        if (photoInfo.isCut()) {
            holder.iv_dot.setVisibility(0);
            holder.iv_dot.setImageResource(R.drawable.ucrop_oval_true);
        } else {
            holder.iv_dot.setVisibility(8);
        }
        RequestOptions options = new RequestOptions().placeholder(R.color.ucrop_color_grey).centerCrop().diskCacheStrategy(DiskCacheStrategy.ALL);
        Glide.with((Context)this.context).load(path).transition((TransitionOptions)DrawableTransitionOptions.withCrossFade()).apply(options).into(holder.mIvPhoto);
    }

    public int getItemCount() {
        return this.list.size();
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        ImageView mIvPhoto;
        ImageView iv_dot;

        public ViewHolder(View view) {
            super(view);
            this.mIvPhoto = (ImageView)view.findViewById(R.id.iv_photo);
            this.iv_dot = (ImageView)view.findViewById(R.id.iv_dot);
        }
    }
}

