/*
 * Decompiled with CFR 0.152.
 */
package android.print;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.ParcelFileDescriptor;
import android.print.PageRange;
import android.print.PdfConverter;
import android.print.PrintAttributes;
import android.print.PrintDocumentAdapter;
import android.print.PrintDocumentInfo;
import android.util.Log;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\n\b\u0000\u0018\u0000 #2\u00020\u0001:\u0001#B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\b2\b\u0010\u001c\u001a\u0004\u0018\u00010\n2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00102\b\u0010\u001e\u001a\u0004\u0018\u00010\u000eJ\b\u0010\u001f\u001a\u00020\u001aH\u0002J\b\u0010 \u001a\u00020\u001aH\u0016J\u0010\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u0001H\u0002R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00048BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006\u00a8\u0006$"}, d2={"Landroid/print/PdfConverter;", "Ljava/lang/Runnable;", "()V", "defaultPrintAttrs", "Landroid/print/PrintAttributes;", "getDefaultPrintAttrs", "()Landroid/print/PrintAttributes;", "mContext", "Landroid/content/Context;", "mHtmlString", "", "mIsCurrentlyConverting", "", "mOnComplete", "Landroid/print/PdfConverter$Companion$OnComplete;", "mPdfFile", "Ljava/io/File;", "mWebView", "Landroid/webkit/WebView;", "outputFileDescriptor", "Landroid/os/ParcelFileDescriptor;", "getOutputFileDescriptor", "()Landroid/os/ParcelFileDescriptor;", "pdfPrintAttrs", "getPdfPrintAttrs", "convert", "", "context", "htmlString", "file", "onComplete", "destroy", "run", "runOnUiThread", "runnable", "Companion", "html2pdf_release"})
public final class PdfConverter
implements Runnable {
    private Context mContext;
    private String mHtmlString;
    private File mPdfFile;
    private PrintAttributes pdfPrintAttrs;
    private boolean mIsCurrentlyConverting;
    private WebView mWebView;
    private Companion.OnComplete mOnComplete;
    private static final String TAG = "PdfConverter";
    private static PdfConverter sInstance;
    public static final Companion Companion;

    private final PrintAttributes getPdfPrintAttrs() {
        return this.pdfPrintAttrs != null ? this.pdfPrintAttrs : this.getDefaultPrintAttrs();
    }

    private final ParcelFileDescriptor getOutputFileDescriptor() {
        try {
            File file = this.mPdfFile;
            if (file == null) {
                Intrinsics.throwNpe();
            }
            file.createNewFile();
            return ParcelFileDescriptor.open((File)this.mPdfFile, (int)0x34000000);
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"Failed to open ParcelFileDescriptor", (Throwable)e);
            return null;
        }
    }

    private final PrintAttributes getDefaultPrintAttrs() {
        return Build.VERSION.SDK_INT < 19 ? null : new PrintAttributes.Builder().setMediaSize(PrintAttributes.MediaSize.ISO_A4).setResolution(new PrintAttributes.Resolution("RESOLUTION_ID", "RESOLUTION_ID", 600, 600)).setMinMargins(PrintAttributes.Margins.NO_MARGINS).build();
    }

    @Override
    public void run() {
        WebSettings settings;
        WebView webView = this.mWebView = new WebView(this.mContext);
        if (webView == null) {
            Intrinsics.throwNpe();
        }
        webView.setWebViewClient(new WebViewClient(this){
            final /* synthetic */ PdfConverter this$0;

            public void onPageFinished(@NotNull WebView view, @NotNull String url) {
                Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                if (Build.VERSION.SDK_INT < 19) {
                    throw (Throwable)new RuntimeException("call requires API level 19");
                }
                WebView webView = PdfConverter.access$getMWebView$p(this.this$0);
                if (webView == null) {
                    Intrinsics.throwNpe();
                }
                PrintDocumentAdapter documentAdapter = webView.createPrintDocumentAdapter();
                documentAdapter.onLayout(null, PdfConverter.access$getPdfPrintAttrs$p(this.this$0), null, new PrintDocumentAdapter.LayoutResultCallback(this, documentAdapter){
                    final /* synthetic */ run.1 this$0;
                    final /* synthetic */ PrintDocumentAdapter $documentAdapter;

                    public void onLayoutFinished(@Nullable PrintDocumentInfo info, boolean changed) {
                        super.onLayoutFinished(info, changed);
                        this.$documentAdapter.onWrite(new PageRange[]{PageRange.ALL_PAGES}, PdfConverter.access$getOutputFileDescriptor$p(this.this$0.this$0), null, new PrintDocumentAdapter.WriteResultCallback(this){
                            final /* synthetic */ run.onPageFinished.1 this$0;

                            public void onWriteFinished(@NotNull PageRange[] pages) {
                                Intrinsics.checkParameterIsNotNull((Object)pages, (String)"pages");
                                Companion.OnComplete onComplete = PdfConverter.access$getMOnComplete$p(this.this$0.this$0.this$0);
                                if (onComplete != null) {
                                    onComplete.onWriteComplete();
                                }
                                PdfConverter.access$destroy(this.this$0.this$0.this$0);
                            }

                            public void onWriteFailed(@Nullable CharSequence error) {
                                block0: {
                                    super.onWriteFailed(error);
                                    Companion.OnComplete onComplete = PdfConverter.access$getMOnComplete$p(this.this$0.this$0.this$0);
                                    if (onComplete == null) break block0;
                                    onComplete.onWriteFailed();
                                }
                            }
                            {
                                this.this$0 = $outer;
                            }
                        });
                    }
                    {
                        this.this$0 = $outer;
                        this.$documentAdapter = $captured_local_variable$1;
                    }
                }, null);
            }
            {
                this.this$0 = $outer;
            }
        });
        WebView webView2 = this.mWebView;
        if (webView2 == null) {
            Intrinsics.throwNpe();
        }
        WebSettings webSettings = settings = webView2.getSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)webSettings, (String)"settings");
        webSettings.setDefaultTextEncodingName("utf-8");
        WebView webView3 = this.mWebView;
        if (webView3 == null) {
            Intrinsics.throwNpe();
        }
        webView3.loadData(this.mHtmlString, "text/HTML; charset=utf-8", null);
    }

    public final void convert(@Nullable Context context, @Nullable String htmlString, @Nullable File file, @Nullable Companion.OnComplete onComplete) throws Exception {
        if (context == null) {
            throw (Throwable)new Exception("context can't be null");
        }
        if (htmlString == null) {
            throw (Throwable)new Exception("htmlString can't be null");
        }
        if (file == null) {
            throw (Throwable)new Exception("file can't be null");
        }
        if (this.mIsCurrentlyConverting) {
            return;
        }
        this.mContext = context;
        this.mHtmlString = htmlString;
        this.mPdfFile = file;
        this.mIsCurrentlyConverting = true;
        this.mOnComplete = onComplete;
        this.runOnUiThread(this);
    }

    private final void runOnUiThread(Runnable runnable) {
        Context context = this.mContext;
        if (context == null) {
            Intrinsics.throwNpe();
        }
        Handler handler = new Handler(context.getMainLooper());
        handler.post(runnable);
    }

    private final void destroy() {
        this.mContext = null;
        this.mHtmlString = null;
        this.mPdfFile = null;
        this.pdfPrintAttrs = null;
        this.mIsCurrentlyConverting = false;
        this.mWebView = null;
        this.mOnComplete = null;
    }

    private PdfConverter() {
    }

    static {
        Companion = new Companion(null);
    }

    public static final /* synthetic */ WebView access$getMWebView$p(PdfConverter $this) {
        return $this.mWebView;
    }

    public static final /* synthetic */ void access$setMWebView$p(PdfConverter $this, WebView webView) {
        $this.mWebView = webView;
    }

    public static final /* synthetic */ PrintAttributes access$getPdfPrintAttrs$p(PdfConverter $this) {
        return $this.getPdfPrintAttrs();
    }

    public static final /* synthetic */ void access$setPdfPrintAttrs$p(PdfConverter $this, PrintAttributes printAttributes) {
        $this.pdfPrintAttrs = printAttributes;
    }

    public static final /* synthetic */ ParcelFileDescriptor access$getOutputFileDescriptor$p(PdfConverter $this) {
        return $this.getOutputFileDescriptor();
    }

    public static final /* synthetic */ Companion.OnComplete access$getMOnComplete$p(PdfConverter $this) {
        return $this.mOnComplete;
    }

    public static final /* synthetic */ void access$setMOnComplete$p(PdfConverter $this, Companion.OnComplete onComplete) {
        $this.mOnComplete = onComplete;
    }

    public static final /* synthetic */ void access$destroy(PdfConverter $this) {
        $this.destroy();
    }

    public /* synthetic */ PdfConverter(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Landroid/print/PdfConverter$Companion;", "", "()V", "TAG", "", "instance", "Landroid/print/PdfConverter;", "getInstance", "()Landroid/print/PdfConverter;", "sInstance", "OnComplete", "html2pdf_release"})
    public static final class Companion {
        @NotNull
        public final synchronized PdfConverter getInstance() {
            if (sInstance == null) {
                sInstance = new PdfConverter(null);
            }
            PdfConverter pdfConverter = sInstance;
            if (pdfConverter == null) {
                Intrinsics.throwNpe();
            }
            return pdfConverter;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&\u00a8\u0006\u0005"}, d2={"Landroid/print/PdfConverter$Companion$OnComplete;", "", "onWriteComplete", "", "onWriteFailed", "html2pdf_release"})
        public static interface OnComplete {
            public void onWriteComplete();

            public void onWriteFailed();
        }
    }
}

