/*
 * Decompiled with CFR 0.152.
 */
package com.lottiefiles.dotlottie.core.loader;

import android.content.Context;
import androidx.compose.runtime.internal.StabilityInferred;
import com.lottiefiles.dotlottie.core.loader.AbstractLoader;
import com.lottiefiles.dotlottie.core.util.DotLottieContent;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0011\u0010\u0010\u001a\u00020\u000fH\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0012"}, d2={"Lcom/lottiefiles/dotlottie/core/loader/NetworkLoader;", "Lcom/lottiefiles/dotlottie/core/loader/AbstractLoader;", "context", "Landroid/content/Context;", "url", "", "(Landroid/content/Context;Ljava/lang/String;)V", "httpClient", "Lokhttp3/OkHttpClient;", "cacheBytes", "", "data", "", "cacheJson", "fromCache", "Lcom/lottiefiles/dotlottie/core/util/DotLottieContent;", "loadInternal", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dotlottie_release"})
@StabilityInferred(parameters=0)
public final class NetworkLoader
extends AbstractLoader {
    @NotNull
    private final String url;
    @NotNull
    private final OkHttpClient httpClient;
    public static final int $stable = 8;

    public NetworkLoader(@NotNull Context context, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        super(context);
        this.url = url;
        this.httpClient = new OkHttpClient();
    }

    private final void cacheJson(String data) {
        File cacheFile = new File(this.getContext().getCacheDir(), this.url.hashCode() + ".json");
        FilesKt.writeText$default((File)cacheFile, (String)data, null, (int)2, null);
    }

    private final void cacheBytes(byte[] data) {
        File cacheFile = new File(this.getContext().getCacheDir(), this.url.hashCode() + ".bytes");
        FilesKt.writeBytes((File)cacheFile, (byte[])data);
    }

    private final DotLottieContent fromCache() {
        DotLottieContent dotLottieContent;
        if (StringsKt.endsWith$default((String)this.url, (String)".json", (boolean)false, (int)2, null)) {
            File cacheFile = new File(this.getContext().getCacheDir(), this.url.hashCode() + ".json");
            String cached = cacheFile.exists() ? FilesKt.readText$default((File)cacheFile, null, (int)1, null) : null;
            dotLottieContent = cached != null ? new DotLottieContent.Json(cached) : null;
        } else {
            File cacheFile = new File(this.getContext().getCacheDir(), this.url.hashCode() + ".bytes");
            byte[] cached = cacheFile.exists() ? FilesKt.readBytes((File)cacheFile) : null;
            dotLottieContent = cached != null ? new DotLottieContent.Binary(cached) : null;
        }
        return dotLottieContent;
    }

    @Override
    @Nullable
    protected Object loadInternal(@NotNull Continuation<? super DotLottieContent> $completion) {
        DotLottieContent dotLottieContent;
        block11: {
            Object object;
            block13: {
                block12: {
                    Response response;
                    block10: {
                        String contentType;
                        boolean isLottie;
                        DotLottieContent cached = this.fromCache();
                        if (cached instanceof DotLottieContent.Json) {
                            return cached;
                        }
                        if (cached instanceof DotLottieContent.Binary) {
                            return cached;
                        }
                        Request request = new Request.Builder().url(this.url).build();
                        response = this.httpClient.newCall(request).execute();
                        if (!response.isSuccessful()) {
                            throw new IOException("[NetworkLoader]: Failed to download file: " + this.url);
                        }
                        String string = response.header("Content-Type", "");
                        if (string == null) {
                            string = "";
                        }
                        boolean bl = isLottie = StringsKt.contains$default((CharSequence)(contentType = string), (CharSequence)"application/json", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)contentType, (CharSequence)"text/plain", (boolean)false, (int)2, null);
                        if (!isLottie) break block10;
                        Object object2 = response.body();
                        if (object2 == null || (object2 = object2.string()) == null) {
                            throw new IOException("Response body is null: " + this.url);
                        }
                        Object text = object2;
                        this.cacheJson((String)text);
                        dotLottieContent = new DotLottieContent.Json((String)text);
                        break block11;
                    }
                    object = response.body();
                    if (object == null) break block12;
                    byte[] byArray = object.bytes();
                    object = byArray;
                    if (byArray != null) break block13;
                }
                throw new IOException("Response body is null: " + this.url);
            }
            Object bytes = object;
            this.cacheBytes((byte[])bytes);
            dotLottieContent = new DotLottieContent.Binary((byte[])bytes);
        }
        DotLottieContent content = dotLottieContent;
        return content;
    }
}

