/*
 * Decompiled with CFR 0.152.
 */
package com.lottiefiles.dotlottie.core.loader;

import android.content.Context;
import androidx.compose.runtime.internal.StabilityInferred;
import com.lottiefiles.dotlottie.core.loader.AbstractLoader;
import com.lottiefiles.dotlottie.core.util.DotLottieContent;
import com.lottiefiles.dotlottie.core.util.DotLottieUtilsKt;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0007\u001a\u00020\bH\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\n"}, d2={"Lcom/lottiefiles/dotlottie/core/loader/AssetLoader;", "Lcom/lottiefiles/dotlottie/core/loader/AbstractLoader;", "context", "Landroid/content/Context;", "assetPath", "", "(Landroid/content/Context;Ljava/lang/String;)V", "loadInternal", "Lcom/lottiefiles/dotlottie/core/util/DotLottieContent;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dotlottie_release"})
@StabilityInferred(parameters=0)
public final class AssetLoader
extends AbstractLoader {
    @NotNull
    private final String assetPath;
    public static final int $stable;

    public AssetLoader(@NotNull Context context, @NotNull String assetPath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)assetPath, (String)"assetPath");
        super(context);
        this.assetPath = assetPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected Object loadInternal(@NotNull Continuation<? super DotLottieContent> $completion) {
        Closeable closeable = this.getContext().getAssets().open(this.assetPath);
        Throwable throwable = null;
        try {
            DotLottieContent content;
            DotLottieContent dotLottieContent;
            InputStream inputStream = (InputStream)closeable;
            boolean bl = false;
            if (DotLottieUtilsKt.isJsonAsset(this.assetPath)) {
                Intrinsics.checkNotNull((Object)inputStream);
                InputStream inputStream2 = inputStream;
                Charset charset = Charsets.UTF_8;
                dotLottieContent = new DotLottieContent.Json(TextStreamsKt.readText((Reader)new InputStreamReader(inputStream2, charset)));
            } else {
                Intrinsics.checkNotNull((Object)inputStream);
                dotLottieContent = new DotLottieContent.Binary(ByteStreamsKt.readBytes((InputStream)inputStream));
            }
            DotLottieContent dotLottieContent2 = content = dotLottieContent;
            return dotLottieContent2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

