// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!

@file:Suppress("NAME_SHADOWING")

package com.dotlottie.dlplayer

// Common helper code.
//
// Ideally this would live in a separate .kt file where it can be unittested etc
// in isolation, and perhaps even published as a re-useable package.
//
// However, it's important that the details of how this helper code works (e.g. the
// way that different builtin types are passed across the FFI) exactly match what's
// expected by the Rust code on the other side of the interface. In practice right
// now that means coming from the exact some version of `uniffi` that was used to
// compile the Rust component. The easiest way to ensure this is to bundle the Kotlin
// helpers directly inline like we're doing here.

import com.sun.jna.Callback
import com.sun.jna.IntegerType
import com.sun.jna.Library
import com.sun.jna.Native
import com.sun.jna.Pointer
import com.sun.jna.Structure
import com.sun.jna.ptr.*
import java.nio.ByteBuffer
import java.nio.ByteOrder
import java.nio.CharBuffer
import java.nio.charset.CodingErrorAction
import java.util.concurrent.ConcurrentHashMap
import java.util.concurrent.atomic.AtomicBoolean
import java.util.concurrent.atomic.AtomicLong
import java.util.concurrent.locks.ReentrantLock
import kotlin.concurrent.withLock

// This is a helper for safely working with byte buffers returned from the Rust code.
// A rust-owned buffer is represented by its capacity, its current length, and a
// pointer to the underlying data.

@Structure.FieldOrder("capacity", "len", "data")
open class RustBuffer : Structure() {
    @JvmField var capacity: Int = 0

    @JvmField var len: Int = 0

    @JvmField var data: Pointer? = null

    class ByValue : RustBuffer(), Structure.ByValue

    class ByReference : RustBuffer(), Structure.ByReference

    companion object {
        internal fun alloc(size: Int = 0) =
            uniffiRustCall { status ->
                UniffiLib.INSTANCE.ffi_dotlottie_player_rustbuffer_alloc(size, status)
            }.also {
                if (it.data == null) {
                    throw RuntimeException("RustBuffer.alloc() returned null data pointer (size=$size)")
                }
            }

        internal fun create(
            capacity: Int,
            len: Int,
            data: Pointer?,
        ): RustBuffer.ByValue {
            var buf = RustBuffer.ByValue()
            buf.capacity = capacity
            buf.len = len
            buf.data = data
            return buf
        }

        internal fun free(buf: RustBuffer.ByValue) =
            uniffiRustCall { status ->
                UniffiLib.INSTANCE.ffi_dotlottie_player_rustbuffer_free(buf, status)
            }
    }

    @Suppress("TooGenericExceptionThrown")
    fun asByteBuffer() =
        this.data?.getByteBuffer(0, this.len.toLong())?.also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
}

/**
 * The equivalent of the `*mut RustBuffer` type.
 * Required for callbacks taking in an out pointer.
 *
 * Size is the sum of all values in the struct.
 */
class RustBufferByReference : ByReference(16) {
    /**
     * Set the pointed-to `RustBuffer` to the given value.
     */
    fun setValue(value: RustBuffer.ByValue) {
        // NOTE: The offsets are as they are in the C-like struct.
        val pointer = getPointer()
        pointer.setInt(0, value.capacity)
        pointer.setInt(4, value.len)
        pointer.setPointer(8, value.data)
    }

    /**
     * Get a `RustBuffer.ByValue` from this reference.
     */
    fun getValue(): RustBuffer.ByValue {
        val pointer = getPointer()
        val value = RustBuffer.ByValue()
        value.writeField("capacity", pointer.getInt(0))
        value.writeField("len", pointer.getInt(4))
        value.writeField("data", pointer.getPointer(8))

        return value
    }
}

// This is a helper for safely passing byte references into the rust code.
// It's not actually used at the moment, because there aren't many things that you
// can take a direct pointer to in the JVM, and if we're going to copy something
// then we might as well copy it into a `RustBuffer`. But it's here for API
// completeness.

@Structure.FieldOrder("len", "data")
open class ForeignBytes : Structure() {
    @JvmField var len: Int = 0

    @JvmField var data: Pointer? = null

    class ByValue : ForeignBytes(), Structure.ByValue
}

// The FfiConverter interface handles converter types to and from the FFI
//
// All implementing objects should be public to support external types.  When a
// type is external we need to import it's FfiConverter.
public interface FfiConverter<KotlinType, FfiType> {
    // Convert an FFI type to a Kotlin type
    fun lift(value: FfiType): KotlinType

    // Convert an Kotlin type to an FFI type
    fun lower(value: KotlinType): FfiType

    // Read a Kotlin type from a `ByteBuffer`
    fun read(buf: ByteBuffer): KotlinType

    // Calculate bytes to allocate when creating a `RustBuffer`
    //
    // This must return at least as many bytes as the write() function will
    // write. It can return more bytes than needed, for example when writing
    // Strings we can't know the exact bytes needed until we the UTF-8
    // encoding, so we pessimistically allocate the largest size possible (3
    // bytes per codepoint).  Allocating extra bytes is not really a big deal
    // because the `RustBuffer` is short-lived.
    fun allocationSize(value: KotlinType): Int

    // Write a Kotlin type to a `ByteBuffer`
    fun write(
        value: KotlinType,
        buf: ByteBuffer,
    )

    // Lower a value into a `RustBuffer`
    //
    // This method lowers a value into a `RustBuffer` rather than the normal
    // FfiType.  It's used by the callback interface code.  Callback interface
    // returns are always serialized into a `RustBuffer` regardless of their
    // normal FFI type.
    fun lowerIntoRustBuffer(value: KotlinType): RustBuffer.ByValue {
        val rbuf = RustBuffer.alloc(allocationSize(value))
        try {
            val bbuf =
                rbuf.data!!.getByteBuffer(0, rbuf.capacity.toLong()).also {
                    it.order(ByteOrder.BIG_ENDIAN)
                }
            write(value, bbuf)
            rbuf.writeField("len", bbuf.position())
            return rbuf
        } catch (e: Throwable) {
            RustBuffer.free(rbuf)
            throw e
        }
    }

    // Lift a value from a `RustBuffer`.
    //
    // This here mostly because of the symmetry with `lowerIntoRustBuffer()`.
    // It's currently only used by the `FfiConverterRustBuffer` class below.
    fun liftFromRustBuffer(rbuf: RustBuffer.ByValue): KotlinType {
        val byteBuf = rbuf.asByteBuffer()!!
        try {
            val item = read(byteBuf)
            if (byteBuf.hasRemaining()) {
                throw RuntimeException("junk remaining in buffer after lifting, something is very wrong!!")
            }
            return item
        } finally {
            RustBuffer.free(rbuf)
        }
    }
}

// FfiConverter that uses `RustBuffer` as the FfiType
public interface FfiConverterRustBuffer<KotlinType> : FfiConverter<KotlinType, RustBuffer.ByValue> {
    override fun lift(value: RustBuffer.ByValue) = liftFromRustBuffer(value)

    override fun lower(value: KotlinType) = lowerIntoRustBuffer(value)
}

// A handful of classes and functions to support the generated data structures.
// This would be a good candidate for isolating in its own ffi-support lib.
// Error runtime.
@Structure.FieldOrder("code", "error_buf")
internal open class UniffiRustCallStatus : Structure() {
    @JvmField var code: Byte = 0

    @JvmField var error_buf: RustBuffer.ByValue = RustBuffer.ByValue()

    class ByValue : UniffiRustCallStatus(), Structure.ByValue

    fun isSuccess(): Boolean {
        return code == 0.toByte()
    }

    fun isError(): Boolean {
        return code == 1.toByte()
    }

    fun isPanic(): Boolean {
        return code == 2.toByte()
    }
}

class InternalException(message: String) : Exception(message)

// Each top-level error class has a companion object that can lift the error from the call status's rust buffer
interface UniffiRustCallStatusErrorHandler<E> {
    fun lift(error_buf: RustBuffer.ByValue): E
}

// Helpers for calling Rust
// In practice we usually need to be synchronized to call this safely, so it doesn't
// synchronize itself

// Call a rust function that returns a Result<>.  Pass in the Error class companion that corresponds to the Err
private inline fun <U, E : Exception> uniffiRustCallWithError(
    errorHandler: UniffiRustCallStatusErrorHandler<E>,
    callback: (UniffiRustCallStatus) -> U,
): U {
    var status = UniffiRustCallStatus()
    val return_value = callback(status)
    uniffiCheckCallStatus(errorHandler, status)
    return return_value
}

// Check UniffiRustCallStatus and throw an error if the call wasn't successful
private fun <E : Exception> uniffiCheckCallStatus(
    errorHandler: UniffiRustCallStatusErrorHandler<E>,
    status: UniffiRustCallStatus,
) {
    if (status.isSuccess()) {
        return
    } else if (status.isError()) {
        throw errorHandler.lift(status.error_buf)
    } else if (status.isPanic()) {
        // when the rust code sees a panic, it tries to construct a rustbuffer
        // with the message.  but if that code panics, then it just sends back
        // an empty buffer.
        if (status.error_buf.len > 0) {
            throw InternalException(FfiConverterString.lift(status.error_buf))
        } else {
            throw InternalException("Rust panic")
        }
    } else {
        throw InternalException("Unknown rust call status: $status.code")
    }
}

// UniffiRustCallStatusErrorHandler implementation for times when we don't expect a CALL_ERROR
object UniffiNullRustCallStatusErrorHandler : UniffiRustCallStatusErrorHandler<InternalException> {
    override fun lift(error_buf: RustBuffer.ByValue): InternalException {
        RustBuffer.free(error_buf)
        return InternalException("Unexpected CALL_ERROR")
    }
}

// Call a rust function that returns a plain value
private inline fun <U> uniffiRustCall(callback: (UniffiRustCallStatus) -> U): U {
    return uniffiRustCallWithError(UniffiNullRustCallStatusErrorHandler, callback)
}

// IntegerType that matches Rust's `usize` / C's `size_t`
public class USize(value: Long = 0) : IntegerType(Native.SIZE_T_SIZE, value, true) {
    // This is needed to fill in the gaps of IntegerType's implementation of Number for Kotlin.
    override fun toByte() = toInt().toByte()

    // Needed until https://youtrack.jetbrains.com/issue/KT-47902 is fixed.
    @Deprecated("`toInt().toChar()` is deprecated")
    override fun toChar() = toInt().toChar()

    override fun toShort() = toInt().toShort()

    fun writeToBuffer(buf: ByteBuffer) {
        // Make sure we always write usize integers using native byte-order, since they may be
        // casted to pointer values
        buf.order(ByteOrder.nativeOrder())
        try {
            when (Native.SIZE_T_SIZE) {
                4 -> buf.putInt(toInt())
                8 -> buf.putLong(toLong())
                else -> throw RuntimeException("Invalid SIZE_T_SIZE: ${Native.SIZE_T_SIZE}")
            }
        } finally {
            buf.order(ByteOrder.BIG_ENDIAN)
        }
    }

    companion object {
        val size: Int
            get() = Native.SIZE_T_SIZE

        fun readFromBuffer(buf: ByteBuffer): USize {
            // Make sure we always read usize integers using native byte-order, since they may be
            // casted from pointer values
            buf.order(ByteOrder.nativeOrder())
            try {
                return when (Native.SIZE_T_SIZE) {
                    4 -> USize(buf.getInt().toLong())
                    8 -> USize(buf.getLong())
                    else -> throw RuntimeException("Invalid SIZE_T_SIZE: ${Native.SIZE_T_SIZE}")
                }
            } finally {
                buf.order(ByteOrder.BIG_ENDIAN)
            }
        }
    }
}

// Map handles to objects
//
// This is used when the Rust code expects an opaque pointer to represent some foreign object.
// Normally we would pass a pointer to the object, but JNA doesn't support getting a pointer from an
// object reference , nor does it support leaking a reference to Rust.
//
// Instead, this class maps USize values to objects so that we can pass a pointer-sized type to
// Rust when it needs an opaque pointer.
//
// TODO: refactor callbacks to use this class
internal class UniFfiHandleMap<T : Any> {
    private val map = ConcurrentHashMap<USize, T>()

    // Use AtomicInteger for our counter, since we may be on a 32-bit system.  4 billion possible
    // values seems like enough. If somehow we generate 4 billion handles, then this will wrap
    // around back to zero and we can assume the first handle generated will have been dropped by
    // then.
    private val counter = java.util.concurrent.atomic.AtomicInteger(0)

    val size: Int
        get() = map.size

    fun insert(obj: T): USize {
        val handle = USize(counter.getAndAdd(1).toLong())
        map.put(handle, obj)
        return handle
    }

    fun get(handle: USize): T? {
        return map.get(handle)
    }

    fun remove(handle: USize): T? {
        return map.remove(handle)
    }
}

// FFI type for Rust future continuations
internal interface UniFffiRustFutureContinuationCallbackType : com.sun.jna.Callback {
    fun callback(
        continuationHandle: USize,
        pollResult: Byte,
    )
}

// Contains loading, initialization code,
// and the FFI Function declarations in a com.sun.jna.Library.
@Synchronized
private fun findLibraryName(componentName: String): String {
    val libOverride = System.getProperty("uniffi.component.$componentName.libraryOverride")
    if (libOverride != null) {
        return libOverride
    }
    return "uniffi_dotlottie_player"
}

private inline fun <reified Lib : Library> loadIndirect(componentName: String): Lib {
    return Native.load<Lib>(findLibraryName(componentName), Lib::class.java)
}

// A JNA Library to expose the extern-C FFI definitions.
// This is an implementation detail which will be called internally by the public API.

internal interface UniffiLib : Library {
    companion object {
        internal val INSTANCE: UniffiLib by lazy {
            loadIndirect<UniffiLib>(componentName = "dotlottie_player")
                .also { lib: UniffiLib ->
                    uniffiCheckContractApiVersion(lib)
                    uniffiCheckApiChecksums(lib)
                    uniffiCallbackInterfaceObserver.register(lib)
                }
        }

        // The Cleaner for the whole library
        internal val CLEANER: UniffiCleaner by lazy {
            UniffiCleaner.create()
        }
    }

    fun uniffi_dotlottie_player_fn_clone_dotlottieplayer(
        `ptr`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Pointer

    fun uniffi_dotlottie_player_fn_free_dotlottieplayer(
        `ptr`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Unit

    fun uniffi_dotlottie_player_fn_constructor_dotlottieplayer_new(
        `config`: RustBuffer.ByValue,
        uniffi_out_err: UniffiRustCallStatus,
    ): Pointer

    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_buffer_len(
        `ptr`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Long

    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_buffer_ptr(
        `ptr`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Long

    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_clear(
        `ptr`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Unit

    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_config(
        `ptr`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue

    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_current_frame(
        `ptr`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Float

    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_duration(
        `ptr`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Float

    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_is_complete(
        `ptr`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Byte

    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_is_loaded(
        `ptr`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Byte

    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_is_paused(
        `ptr`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Byte

    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_is_playing(
        `ptr`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Byte

    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_is_stopped(
        `ptr`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Byte

    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_load_animation(
        `ptr`: Pointer,
        `animationId`: RustBuffer.ByValue,
        `width`: Int,
        `height`: Int,
        uniffi_out_err: UniffiRustCallStatus,
    ): Byte

    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_load_animation_data(
        `ptr`: Pointer,
        `animationData`: RustBuffer.ByValue,
        `width`: Int,
        `height`: Int,
        uniffi_out_err: UniffiRustCallStatus,
    ): Byte

    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_load_animation_path(
        `ptr`: Pointer,
        `animationPath`: RustBuffer.ByValue,
        `width`: Int,
        `height`: Int,
        uniffi_out_err: UniffiRustCallStatus,
    ): Byte

    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_load_dotlottie_data(
        `ptr`: Pointer,
        `fileData`: RustBuffer.ByValue,
        `width`: Int,
        `height`: Int,
        uniffi_out_err: UniffiRustCallStatus,
    ): Byte

    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_load_theme(
        `ptr`: Pointer,
        `themeId`: RustBuffer.ByValue,
        uniffi_out_err: UniffiRustCallStatus,
    ): Byte

    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_load_theme_data(
        `ptr`: Pointer,
        `themeData`: RustBuffer.ByValue,
        uniffi_out_err: UniffiRustCallStatus,
    ): Byte

    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_loop_count(
        `ptr`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Int

    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_manifest(
        `ptr`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue

    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_manifest_string(
        `ptr`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue

    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_markers(
        `ptr`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue

    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_pause(
        `ptr`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Byte

    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_play(
        `ptr`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Byte

    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_render(
        `ptr`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Byte

    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_request_frame(
        `ptr`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Float

    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_resize(
        `ptr`: Pointer,
        `width`: Int,
        `height`: Int,
        uniffi_out_err: UniffiRustCallStatus,
    ): Byte

    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_seek(
        `ptr`: Pointer,
        `no`: Float,
        uniffi_out_err: UniffiRustCallStatus,
    ): Byte

    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_set_config(
        `ptr`: Pointer,
        `config`: RustBuffer.ByValue,
        uniffi_out_err: UniffiRustCallStatus,
    ): Unit

    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_set_frame(
        `ptr`: Pointer,
        `no`: Float,
        uniffi_out_err: UniffiRustCallStatus,
    ): Byte

    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_stop(
        `ptr`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Byte

    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_subscribe(
        `ptr`: Pointer,
        `observer`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Unit

    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_total_frames(
        `ptr`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Float

    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_unsubscribe(
        `ptr`: Pointer,
        `observer`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Unit

    fun uniffi_dotlottie_player_fn_clone_observer(
        `ptr`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Pointer

    fun uniffi_dotlottie_player_fn_free_observer(
        `ptr`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Unit

    fun uniffi_dotlottie_player_fn_init_callback_observer(`handle`: ForeignCallback): Unit

    fun uniffi_dotlottie_player_fn_method_observer_on_complete(
        `ptr`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Unit

    fun uniffi_dotlottie_player_fn_method_observer_on_frame(
        `ptr`: Pointer,
        `frameNo`: Float,
        uniffi_out_err: UniffiRustCallStatus,
    ): Unit

    fun uniffi_dotlottie_player_fn_method_observer_on_load(
        `ptr`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Unit

    fun uniffi_dotlottie_player_fn_method_observer_on_load_error(
        `ptr`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Unit

    fun uniffi_dotlottie_player_fn_method_observer_on_loop(
        `ptr`: Pointer,
        `loopCount`: Int,
        uniffi_out_err: UniffiRustCallStatus,
    ): Unit

    fun uniffi_dotlottie_player_fn_method_observer_on_pause(
        `ptr`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Unit

    fun uniffi_dotlottie_player_fn_method_observer_on_play(
        `ptr`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Unit

    fun uniffi_dotlottie_player_fn_method_observer_on_render(
        `ptr`: Pointer,
        `frameNo`: Float,
        uniffi_out_err: UniffiRustCallStatus,
    ): Unit

    fun uniffi_dotlottie_player_fn_method_observer_on_stop(
        `ptr`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Unit

    fun uniffi_dotlottie_player_fn_func_create_default_layout(uniffi_out_err: UniffiRustCallStatus): RustBuffer.ByValue

    fun ffi_dotlottie_player_rustbuffer_alloc(
        `size`: Int,
        uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue

    fun ffi_dotlottie_player_rustbuffer_from_bytes(
        `bytes`: ForeignBytes.ByValue,
        uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue

    fun ffi_dotlottie_player_rustbuffer_free(
        `buf`: RustBuffer.ByValue,
        uniffi_out_err: UniffiRustCallStatus,
    ): Unit

    fun ffi_dotlottie_player_rustbuffer_reserve(
        `buf`: RustBuffer.ByValue,
        `additional`: Int,
        uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue

    fun ffi_dotlottie_player_rust_future_poll_u8(
        `handle`: Pointer,
        `callback`: UniFffiRustFutureContinuationCallbackType,
        `callbackData`: USize,
    ): Unit

    fun ffi_dotlottie_player_rust_future_cancel_u8(`handle`: Pointer): Unit

    fun ffi_dotlottie_player_rust_future_free_u8(`handle`: Pointer): Unit

    fun ffi_dotlottie_player_rust_future_complete_u8(
        `handle`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Byte

    fun ffi_dotlottie_player_rust_future_poll_i8(
        `handle`: Pointer,
        `callback`: UniFffiRustFutureContinuationCallbackType,
        `callbackData`: USize,
    ): Unit

    fun ffi_dotlottie_player_rust_future_cancel_i8(`handle`: Pointer): Unit

    fun ffi_dotlottie_player_rust_future_free_i8(`handle`: Pointer): Unit

    fun ffi_dotlottie_player_rust_future_complete_i8(
        `handle`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Byte

    fun ffi_dotlottie_player_rust_future_poll_u16(
        `handle`: Pointer,
        `callback`: UniFffiRustFutureContinuationCallbackType,
        `callbackData`: USize,
    ): Unit

    fun ffi_dotlottie_player_rust_future_cancel_u16(`handle`: Pointer): Unit

    fun ffi_dotlottie_player_rust_future_free_u16(`handle`: Pointer): Unit

    fun ffi_dotlottie_player_rust_future_complete_u16(
        `handle`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Short

    fun ffi_dotlottie_player_rust_future_poll_i16(
        `handle`: Pointer,
        `callback`: UniFffiRustFutureContinuationCallbackType,
        `callbackData`: USize,
    ): Unit

    fun ffi_dotlottie_player_rust_future_cancel_i16(`handle`: Pointer): Unit

    fun ffi_dotlottie_player_rust_future_free_i16(`handle`: Pointer): Unit

    fun ffi_dotlottie_player_rust_future_complete_i16(
        `handle`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Short

    fun ffi_dotlottie_player_rust_future_poll_u32(
        `handle`: Pointer,
        `callback`: UniFffiRustFutureContinuationCallbackType,
        `callbackData`: USize,
    ): Unit

    fun ffi_dotlottie_player_rust_future_cancel_u32(`handle`: Pointer): Unit

    fun ffi_dotlottie_player_rust_future_free_u32(`handle`: Pointer): Unit

    fun ffi_dotlottie_player_rust_future_complete_u32(
        `handle`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Int

    fun ffi_dotlottie_player_rust_future_poll_i32(
        `handle`: Pointer,
        `callback`: UniFffiRustFutureContinuationCallbackType,
        `callbackData`: USize,
    ): Unit

    fun ffi_dotlottie_player_rust_future_cancel_i32(`handle`: Pointer): Unit

    fun ffi_dotlottie_player_rust_future_free_i32(`handle`: Pointer): Unit

    fun ffi_dotlottie_player_rust_future_complete_i32(
        `handle`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Int

    fun ffi_dotlottie_player_rust_future_poll_u64(
        `handle`: Pointer,
        `callback`: UniFffiRustFutureContinuationCallbackType,
        `callbackData`: USize,
    ): Unit

    fun ffi_dotlottie_player_rust_future_cancel_u64(`handle`: Pointer): Unit

    fun ffi_dotlottie_player_rust_future_free_u64(`handle`: Pointer): Unit

    fun ffi_dotlottie_player_rust_future_complete_u64(
        `handle`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Long

    fun ffi_dotlottie_player_rust_future_poll_i64(
        `handle`: Pointer,
        `callback`: UniFffiRustFutureContinuationCallbackType,
        `callbackData`: USize,
    ): Unit

    fun ffi_dotlottie_player_rust_future_cancel_i64(`handle`: Pointer): Unit

    fun ffi_dotlottie_player_rust_future_free_i64(`handle`: Pointer): Unit

    fun ffi_dotlottie_player_rust_future_complete_i64(
        `handle`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Long

    fun ffi_dotlottie_player_rust_future_poll_f32(
        `handle`: Pointer,
        `callback`: UniFffiRustFutureContinuationCallbackType,
        `callbackData`: USize,
    ): Unit

    fun ffi_dotlottie_player_rust_future_cancel_f32(`handle`: Pointer): Unit

    fun ffi_dotlottie_player_rust_future_free_f32(`handle`: Pointer): Unit

    fun ffi_dotlottie_player_rust_future_complete_f32(
        `handle`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Float

    fun ffi_dotlottie_player_rust_future_poll_f64(
        `handle`: Pointer,
        `callback`: UniFffiRustFutureContinuationCallbackType,
        `callbackData`: USize,
    ): Unit

    fun ffi_dotlottie_player_rust_future_cancel_f64(`handle`: Pointer): Unit

    fun ffi_dotlottie_player_rust_future_free_f64(`handle`: Pointer): Unit

    fun ffi_dotlottie_player_rust_future_complete_f64(
        `handle`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Double

    fun ffi_dotlottie_player_rust_future_poll_pointer(
        `handle`: Pointer,
        `callback`: UniFffiRustFutureContinuationCallbackType,
        `callbackData`: USize,
    ): Unit

    fun ffi_dotlottie_player_rust_future_cancel_pointer(`handle`: Pointer): Unit

    fun ffi_dotlottie_player_rust_future_free_pointer(`handle`: Pointer): Unit

    fun ffi_dotlottie_player_rust_future_complete_pointer(
        `handle`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Pointer

    fun ffi_dotlottie_player_rust_future_poll_rust_buffer(
        `handle`: Pointer,
        `callback`: UniFffiRustFutureContinuationCallbackType,
        `callbackData`: USize,
    ): Unit

    fun ffi_dotlottie_player_rust_future_cancel_rust_buffer(`handle`: Pointer): Unit

    fun ffi_dotlottie_player_rust_future_free_rust_buffer(`handle`: Pointer): Unit

    fun ffi_dotlottie_player_rust_future_complete_rust_buffer(
        `handle`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue

    fun ffi_dotlottie_player_rust_future_poll_void(
        `handle`: Pointer,
        `callback`: UniFffiRustFutureContinuationCallbackType,
        `callbackData`: USize,
    ): Unit

    fun ffi_dotlottie_player_rust_future_cancel_void(`handle`: Pointer): Unit

    fun ffi_dotlottie_player_rust_future_free_void(`handle`: Pointer): Unit

    fun ffi_dotlottie_player_rust_future_complete_void(
        `handle`: Pointer,
        uniffi_out_err: UniffiRustCallStatus,
    ): Unit

    fun uniffi_dotlottie_player_checksum_func_create_default_layout(): Short

    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_buffer_len(): Short

    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_buffer_ptr(): Short

    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_clear(): Short

    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_config(): Short

    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_current_frame(): Short

    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_duration(): Short

    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_is_complete(): Short

    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_is_loaded(): Short

    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_is_paused(): Short

    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_is_playing(): Short

    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_is_stopped(): Short

    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_load_animation(): Short

    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_load_animation_data(): Short

    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_load_animation_path(): Short

    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_load_dotlottie_data(): Short

    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_load_theme(): Short

    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_load_theme_data(): Short

    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_loop_count(): Short

    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_manifest(): Short

    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_manifest_string(): Short

    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_markers(): Short

    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_pause(): Short

    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_play(): Short

    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_render(): Short

    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_request_frame(): Short

    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_resize(): Short

    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_seek(): Short

    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_set_config(): Short

    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_set_frame(): Short

    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_stop(): Short

    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_subscribe(): Short

    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_total_frames(): Short

    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_unsubscribe(): Short

    fun uniffi_dotlottie_player_checksum_method_observer_on_complete(): Short

    fun uniffi_dotlottie_player_checksum_method_observer_on_frame(): Short

    fun uniffi_dotlottie_player_checksum_method_observer_on_load(): Short

    fun uniffi_dotlottie_player_checksum_method_observer_on_load_error(): Short

    fun uniffi_dotlottie_player_checksum_method_observer_on_loop(): Short

    fun uniffi_dotlottie_player_checksum_method_observer_on_pause(): Short

    fun uniffi_dotlottie_player_checksum_method_observer_on_play(): Short

    fun uniffi_dotlottie_player_checksum_method_observer_on_render(): Short

    fun uniffi_dotlottie_player_checksum_method_observer_on_stop(): Short

    fun uniffi_dotlottie_player_checksum_constructor_dotlottieplayer_new(): Short

    fun ffi_dotlottie_player_uniffi_contract_version(): Int
}

private fun uniffiCheckContractApiVersion(lib: UniffiLib) {
    // Get the bindings contract version from our ComponentInterface
    val bindings_contract_version = 25
    // Get the scaffolding contract version by calling the into the dylib
    val scaffolding_contract_version = lib.ffi_dotlottie_player_uniffi_contract_version()
    if (bindings_contract_version != scaffolding_contract_version) {
        throw RuntimeException("UniFFI contract version mismatch: try cleaning and rebuilding your project")
    }
}

@Suppress("UNUSED_PARAMETER")
private fun uniffiCheckApiChecksums(lib: UniffiLib) {
    if (lib.uniffi_dotlottie_player_checksum_func_create_default_layout() != 41529.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_buffer_len() != 33793.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_buffer_ptr() != 30907.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_clear() != 26373.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_config() != 36040.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_current_frame() != 42425.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_duration() != 3831.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_is_complete() != 51890.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_is_loaded() != 20186.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_is_paused() != 56658.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_is_playing() != 45670.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_is_stopped() != 28412.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_load_animation() != 52252.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_load_animation_data() != 63827.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_load_animation_path() != 5718.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_load_dotlottie_data() != 3402.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_load_theme() != 58256.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_load_theme_data() != 49777.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_loop_count() != 14780.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_manifest() != 39779.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_manifest_string() != 60193.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_markers() != 29800.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_pause() != 16452.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_play() != 54931.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_render() != 34602.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_request_frame() != 39939.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_resize() != 16787.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_seek() != 60656.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_set_config() != 39472.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_set_frame() != 44086.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_stop() != 25240.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_subscribe() != 45859.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_total_frames() != 12091.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_unsubscribe() != 1373.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_observer_on_complete() != 24930.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_observer_on_frame() != 51247.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_observer_on_load() != 56735.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_observer_on_load_error() != 51239.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_observer_on_loop() != 7035.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_observer_on_pause() != 146.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_observer_on_play() != 59485.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_observer_on_render() != 55581.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_observer_on_stop() != 52331.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_constructor_dotlottieplayer_new() != 61364.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
}

// Async support

// Public interface members begin here.

// Interface implemented by anything that can contain an object reference.
//
// Such types expose a `destroy()` method that must be called to cleanly
// dispose of the contained objects. Failure to call this method may result
// in memory leaks.
//
// The easiest way to ensure this method is called is to use the `.use`
// helper method to execute a block and destroy the object at the end.
interface Disposable {
    fun destroy()

    companion object {
        fun destroy(vararg args: Any?) {
            args.filterIsInstance<Disposable>()
                .forEach(Disposable::destroy)
        }
    }
}

inline fun <T : Disposable?, R> T.use(block: (T) -> R) =
    try {
        block(this)
    } finally {
        try {
            // N.B. our implementation is on the nullable type `Disposable?`.
            this?.destroy()
        } catch (e: Throwable) {
            // swallow
        }
    }

public object FfiConverterByte : FfiConverter<Byte, Byte> {
    override fun lift(value: Byte): Byte {
        return value
    }

    override fun read(buf: ByteBuffer): Byte {
        return buf.get()
    }

    override fun lower(value: Byte): Byte {
        return value
    }

    override fun allocationSize(value: Byte) = 1

    override fun write(
        value: Byte,
        buf: ByteBuffer,
    ) {
        buf.put(value)
    }
}

public object FfiConverterUInt : FfiConverter<UInt, Int> {
    override fun lift(value: Int): UInt {
        return value.toUInt()
    }

    override fun read(buf: ByteBuffer): UInt {
        return lift(buf.getInt())
    }

    override fun lower(value: UInt): Int {
        return value.toInt()
    }

    override fun allocationSize(value: UInt) = 4

    override fun write(
        value: UInt,
        buf: ByteBuffer,
    ) {
        buf.putInt(value.toInt())
    }
}

public object FfiConverterULong : FfiConverter<ULong, Long> {
    override fun lift(value: Long): ULong {
        return value.toULong()
    }

    override fun read(buf: ByteBuffer): ULong {
        return lift(buf.getLong())
    }

    override fun lower(value: ULong): Long {
        return value.toLong()
    }

    override fun allocationSize(value: ULong) = 8

    override fun write(
        value: ULong,
        buf: ByteBuffer,
    ) {
        buf.putLong(value.toLong())
    }
}

public object FfiConverterFloat : FfiConverter<Float, Float> {
    override fun lift(value: Float): Float {
        return value
    }

    override fun read(buf: ByteBuffer): Float {
        return buf.getFloat()
    }

    override fun lower(value: Float): Float {
        return value
    }

    override fun allocationSize(value: Float) = 4

    override fun write(
        value: Float,
        buf: ByteBuffer,
    ) {
        buf.putFloat(value)
    }
}

public object FfiConverterBoolean : FfiConverter<Boolean, Byte> {
    override fun lift(value: Byte): Boolean {
        return value.toInt() != 0
    }

    override fun read(buf: ByteBuffer): Boolean {
        return lift(buf.get())
    }

    override fun lower(value: Boolean): Byte {
        return if (value) 1.toByte() else 0.toByte()
    }

    override fun allocationSize(value: Boolean) = 1

    override fun write(
        value: Boolean,
        buf: ByteBuffer,
    ) {
        buf.put(lower(value))
    }
}

public object FfiConverterString : FfiConverter<String, RustBuffer.ByValue> {
    // Note: we don't inherit from FfiConverterRustBuffer, because we use a
    // special encoding when lowering/lifting.  We can use `RustBuffer.len` to
    // store our length and avoid writing it out to the buffer.
    override fun lift(value: RustBuffer.ByValue): String {
        try {
            val byteArr = ByteArray(value.len)
            value.asByteBuffer()!!.get(byteArr)
            return byteArr.toString(Charsets.UTF_8)
        } finally {
            RustBuffer.free(value)
        }
    }

    override fun read(buf: ByteBuffer): String {
        val len = buf.getInt()
        val byteArr = ByteArray(len)
        buf.get(byteArr)
        return byteArr.toString(Charsets.UTF_8)
    }

    fun toUtf8(value: String): ByteBuffer {
        // Make sure we don't have invalid UTF-16, check for lone surrogates.
        return Charsets.UTF_8.newEncoder().run {
            onMalformedInput(CodingErrorAction.REPORT)
            encode(CharBuffer.wrap(value))
        }
    }

    override fun lower(value: String): RustBuffer.ByValue {
        val byteBuf = toUtf8(value)
        // Ideally we'd pass these bytes to `ffi_bytebuffer_from_bytes`, but doing so would require us
        // to copy them into a JNA `Memory`. So we might as well directly copy them into a `RustBuffer`.
        val rbuf = RustBuffer.alloc(byteBuf.limit())
        rbuf.asByteBuffer()!!.put(byteBuf)
        return rbuf
    }

    // We aren't sure exactly how many bytes our string will be once it's UTF-8
    // encoded.  Allocate 3 bytes per UTF-16 code unit which will always be
    // enough.
    override fun allocationSize(value: String): Int {
        val sizeForLength = 4
        val sizeForString = value.length * 3
        return sizeForLength + sizeForString
    }

    override fun write(
        value: String,
        buf: ByteBuffer,
    ) {
        val byteBuf = toUtf8(value)
        buf.putInt(byteBuf.limit())
        buf.put(byteBuf)
    }
}

public object FfiConverterByteArray : FfiConverterRustBuffer<ByteArray> {
    override fun read(buf: ByteBuffer): ByteArray {
        val len = buf.getInt()
        val byteArr = ByteArray(len)
        buf.get(byteArr)
        return byteArr
    }

    override fun allocationSize(value: ByteArray): Int {
        return 4 + value.size
    }

    override fun write(
        value: ByteArray,
        buf: ByteBuffer,
    ) {
        buf.putInt(value.size)
        buf.put(value)
    }
}

// The cleaner interface for Object finalization code to run.
// This is the entry point to any implementation that we're using.
//
// The cleaner registers objects and returns cleanables, so now we are
// defining a `UniffiCleaner` with a `UniffiClenaer.Cleanable` to abstract the
// different implmentations available at compile time.
interface UniffiCleaner {
    interface Cleanable {
        fun clean()
    }

    fun register(
        value: Any,
        cleanUpTask: Runnable,
    ): UniffiCleaner.Cleanable

    companion object
}

// The fallback Jna cleaner, which is available for both Android, and the JVM.
private class UniffiJnaCleaner : UniffiCleaner {
    private val cleaner = com.sun.jna.internal.Cleaner.getCleaner()

    override fun register(
        value: Any,
        cleanUpTask: Runnable,
    ): UniffiCleaner.Cleanable = UniffiJnaCleanable(cleaner.register(value, cleanUpTask))
}

private class UniffiJnaCleanable(
    private val cleanable: com.sun.jna.internal.Cleaner.Cleanable,
) : UniffiCleaner.Cleanable {
    override fun clean() = cleanable.clean()
}

// We decide at uniffi binding generation time whether we were
// using Android or not.
// There are further runtime checks to chose the correct implementation
// of the cleaner.
private fun UniffiCleaner.Companion.create(): UniffiCleaner =
    try {
        // For safety's sake: if the library hasn't been run in android_cleaner = true
        // mode, but is being run on Android, then we still need to think about
        // Android API versions.
        // So we check if java.lang.ref.Cleaner is there, and use that…
        java.lang.Class.forName("java.lang.ref.Cleaner")
        JavaLangRefCleaner()
    } catch (e: ClassNotFoundException) {
        // … otherwise, fallback to the JNA cleaner.
        UniffiJnaCleaner()
    }

private class JavaLangRefCleaner : UniffiCleaner {
    val cleaner = java.lang.ref.Cleaner.create()

    override fun register(
        value: Any,
        cleanUpTask: Runnable,
    ): UniffiCleaner.Cleanable = JavaLangRefCleanable(cleaner.register(value, cleanUpTask))
}

private class JavaLangRefCleanable(
    val cleanable: java.lang.ref.Cleaner.Cleanable,
) : UniffiCleaner.Cleanable {
    override fun clean() = cleanable.clean()
}

// The base class for all UniFFI Object types.
//
// This class provides core operations for working with the Rust `Arc<T>` pointer to
// the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// the Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each `FFIObject` instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an `FFIObject` is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an `FFIObject` instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each `FFIObject` an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//
abstract class FFIObject : Disposable, AutoCloseable {
    constructor(pointer: Pointer) {
        this.pointer = pointer
    }

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
    }

    protected val pointer: Pointer?
    protected abstract val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    open fun uniffiClonePointer(): Pointer {
        // Overridden by generated subclasses, the default method exists to allow users to manually
        // implement the interface
        throw RuntimeException("uniffiClonePointer not implemented")
    }

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (!this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }
}

/** Used to instantiate a [FFIObject] without an actual pointer, for fakes in tests, mostly. */
object NoPointer

public interface DotLottiePlayerInterface {
    fun `bufferLen`(): ULong

    fun `bufferPtr`(): ULong

    fun `clear`()

    fun `config`(): Config

    fun `currentFrame`(): Float

    fun `duration`(): Float

    fun `isComplete`(): Boolean

    fun `isLoaded`(): Boolean

    fun `isPaused`(): Boolean

    fun `isPlaying`(): Boolean

    fun `isStopped`(): Boolean

    fun `loadAnimation`(
        `animationId`: String,
        `width`: UInt,
        `height`: UInt,
    ): Boolean

    fun `loadAnimationData`(
        `animationData`: String,
        `width`: UInt,
        `height`: UInt,
    ): Boolean

    fun `loadAnimationPath`(
        `animationPath`: String,
        `width`: UInt,
        `height`: UInt,
    ): Boolean

    fun `loadDotlottieData`(
        `fileData`: ByteArray,
        `width`: UInt,
        `height`: UInt,
    ): Boolean

    fun `loadTheme`(`themeId`: String): Boolean

    fun `loadThemeData`(`themeData`: String): Boolean

    fun `loopCount`(): UInt

    fun `manifest`(): Manifest?

    fun `manifestString`(): String

    fun `markers`(): List<Marker>

    fun `pause`(): Boolean

    fun `play`(): Boolean

    fun `render`(): Boolean

    fun `requestFrame`(): Float

    fun `resize`(
        `width`: UInt,
        `height`: UInt,
    ): Boolean

    fun `seek`(`no`: Float): Boolean

    fun `setConfig`(`config`: Config)

    fun `setFrame`(`no`: Float): Boolean

    fun `stop`(): Boolean

    fun `subscribe`(`observer`: Observer)

    fun `totalFrames`(): Float

    fun `unsubscribe`(`observer`: Observer)

    companion object
}

open class DotLottiePlayer : FFIObject, DotLottiePlayerInterface {
    constructor(pointer: Pointer) : super(pointer)

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    constructor(noPointer: NoPointer) : super(noPointer)
    constructor(`config`: Config) :
        this(
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_constructor_dotlottieplayer_new(
                    FfiConverterTypeConfig.lower(`config`),
                    _status,
                )
            },
        )

    override val cleanable: UniffiCleaner.Cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_free_dotlottieplayer(ptr, status)
                }
            }
        }
    }

    override fun uniffiClonePointer(): Pointer {
        return uniffiRustCall { status ->
            UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_clone_dotlottieplayer(pointer!!, status)
        }
    }

    override fun `bufferLen`(): ULong =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_buffer_len(
                    it,
                    _status,
                )
            }
        }.let {
            FfiConverterULong.lift(it)
        }

    override fun `bufferPtr`(): ULong =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_buffer_ptr(
                    it,
                    _status,
                )
            }
        }.let {
            FfiConverterULong.lift(it)
        }

    override fun `clear`() =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_clear(
                    it,
                    _status,
                )
            }
        }

    override fun `config`(): Config =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_config(
                    it,
                    _status,
                )
            }
        }.let {
            FfiConverterTypeConfig.lift(it)
        }

    override fun `currentFrame`(): Float =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_current_frame(
                    it,
                    _status,
                )
            }
        }.let {
            FfiConverterFloat.lift(it)
        }

    override fun `duration`(): Float =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_duration(
                    it,
                    _status,
                )
            }
        }.let {
            FfiConverterFloat.lift(it)
        }

    override fun `isComplete`(): Boolean =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_is_complete(
                    it,
                    _status,
                )
            }
        }.let {
            FfiConverterBoolean.lift(it)
        }

    override fun `isLoaded`(): Boolean =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_is_loaded(
                    it,
                    _status,
                )
            }
        }.let {
            FfiConverterBoolean.lift(it)
        }

    override fun `isPaused`(): Boolean =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_is_paused(
                    it,
                    _status,
                )
            }
        }.let {
            FfiConverterBoolean.lift(it)
        }

    override fun `isPlaying`(): Boolean =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_is_playing(
                    it,
                    _status,
                )
            }
        }.let {
            FfiConverterBoolean.lift(it)
        }

    override fun `isStopped`(): Boolean =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_is_stopped(
                    it,
                    _status,
                )
            }
        }.let {
            FfiConverterBoolean.lift(it)
        }

    override fun `loadAnimation`(
        `animationId`: String,
        `width`: UInt,
        `height`: UInt,
    ): Boolean =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_load_animation(
                    it,
                    FfiConverterString.lower(`animationId`),
                    FfiConverterUInt.lower(`width`),
                    FfiConverterUInt.lower(`height`),
                    _status,
                )
            }
        }.let {
            FfiConverterBoolean.lift(it)
        }

    override fun `loadAnimationData`(
        `animationData`: String,
        `width`: UInt,
        `height`: UInt,
    ): Boolean =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_load_animation_data(
                    it,
                    FfiConverterString.lower(`animationData`),
                    FfiConverterUInt.lower(`width`),
                    FfiConverterUInt.lower(`height`),
                    _status,
                )
            }
        }.let {
            FfiConverterBoolean.lift(it)
        }

    override fun `loadAnimationPath`(
        `animationPath`: String,
        `width`: UInt,
        `height`: UInt,
    ): Boolean =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_load_animation_path(
                    it,
                    FfiConverterString.lower(`animationPath`),
                    FfiConverterUInt.lower(`width`),
                    FfiConverterUInt.lower(`height`),
                    _status,
                )
            }
        }.let {
            FfiConverterBoolean.lift(it)
        }

    override fun `loadDotlottieData`(
        `fileData`: ByteArray,
        `width`: UInt,
        `height`: UInt,
    ): Boolean =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_load_dotlottie_data(
                    it,
                    FfiConverterByteArray.lower(`fileData`),
                    FfiConverterUInt.lower(`width`),
                    FfiConverterUInt.lower(`height`),
                    _status,
                )
            }
        }.let {
            FfiConverterBoolean.lift(it)
        }

    override fun `loadTheme`(`themeId`: String): Boolean =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_load_theme(
                    it,
                    FfiConverterString.lower(`themeId`),
                    _status,
                )
            }
        }.let {
            FfiConverterBoolean.lift(it)
        }

    override fun `loadThemeData`(`themeData`: String): Boolean =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_load_theme_data(
                    it,
                    FfiConverterString.lower(`themeData`),
                    _status,
                )
            }
        }.let {
            FfiConverterBoolean.lift(it)
        }

    override fun `loopCount`(): UInt =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_loop_count(
                    it,
                    _status,
                )
            }
        }.let {
            FfiConverterUInt.lift(it)
        }

    override fun `manifest`(): Manifest? =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_manifest(
                    it,
                    _status,
                )
            }
        }.let {
            FfiConverterOptionalTypeManifest.lift(it)
        }

    override fun `manifestString`(): String =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_manifest_string(
                    it,
                    _status,
                )
            }
        }.let {
            FfiConverterString.lift(it)
        }

    override fun `markers`(): List<Marker> =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_markers(
                    it,
                    _status,
                )
            }
        }.let {
            FfiConverterSequenceTypeMarker.lift(it)
        }

    override fun `pause`(): Boolean =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_pause(
                    it,
                    _status,
                )
            }
        }.let {
            FfiConverterBoolean.lift(it)
        }

    override fun `play`(): Boolean =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_play(
                    it,
                    _status,
                )
            }
        }.let {
            FfiConverterBoolean.lift(it)
        }

    override fun `render`(): Boolean =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_render(
                    it,
                    _status,
                )
            }
        }.let {
            FfiConverterBoolean.lift(it)
        }

    override fun `requestFrame`(): Float =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_request_frame(
                    it,
                    _status,
                )
            }
        }.let {
            FfiConverterFloat.lift(it)
        }

    override fun `resize`(
        `width`: UInt,
        `height`: UInt,
    ): Boolean =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_resize(
                    it,
                    FfiConverterUInt.lower(`width`),
                    FfiConverterUInt.lower(`height`),
                    _status,
                )
            }
        }.let {
            FfiConverterBoolean.lift(it)
        }

    override fun `seek`(`no`: Float): Boolean =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_seek(
                    it,
                    FfiConverterFloat.lower(`no`),
                    _status,
                )
            }
        }.let {
            FfiConverterBoolean.lift(it)
        }

    override fun `setConfig`(`config`: Config) =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_set_config(
                    it,
                    FfiConverterTypeConfig.lower(`config`),
                    _status,
                )
            }
        }

    override fun `setFrame`(`no`: Float): Boolean =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_set_frame(
                    it,
                    FfiConverterFloat.lower(`no`),
                    _status,
                )
            }
        }.let {
            FfiConverterBoolean.lift(it)
        }

    override fun `stop`(): Boolean =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_stop(
                    it,
                    _status,
                )
            }
        }.let {
            FfiConverterBoolean.lift(it)
        }

    override fun `subscribe`(`observer`: Observer) =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_subscribe(
                    it,
                    FfiConverterTypeObserver.lower(`observer`),
                    _status,
                )
            }
        }

    override fun `totalFrames`(): Float =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_total_frames(
                    it,
                    _status,
                )
            }
        }.let {
            FfiConverterFloat.lift(it)
        }

    override fun `unsubscribe`(`observer`: Observer) =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_unsubscribe(
                    it,
                    FfiConverterTypeObserver.lower(`observer`),
                    _status,
                )
            }
        }

    companion object
}

public object FfiConverterTypeDotLottiePlayer : FfiConverter<DotLottiePlayer, Pointer> {
    override fun lower(value: DotLottiePlayer): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): DotLottiePlayer {
        return DotLottiePlayer(value)
    }

    override fun read(buf: ByteBuffer): DotLottiePlayer {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: DotLottiePlayer) = 8

    override fun write(
        value: DotLottiePlayer,
        buf: ByteBuffer,
    ) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}

public interface Observer {
    fun `onComplete`()

    fun `onFrame`(`frameNo`: Float)

    fun `onLoad`()

    fun `onLoadError`()

    fun `onLoop`(`loopCount`: UInt)

    fun `onPause`()

    fun `onPlay`()

    fun `onRender`(`frameNo`: Float)

    fun `onStop`()

    companion object
}

open class ObserverImpl : FFIObject, Observer {
    constructor(pointer: Pointer) : super(pointer)

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    constructor(noPointer: NoPointer) : super(noPointer)

    override val cleanable: UniffiCleaner.Cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_free_observer(ptr, status)
                }
            }
        }
    }

    override fun uniffiClonePointer(): Pointer {
        return uniffiRustCall { status ->
            UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_clone_observer(pointer!!, status)
        }
    }

    override fun `onComplete`() =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_observer_on_complete(
                    it,
                    _status,
                )
            }
        }

    override fun `onFrame`(`frameNo`: Float) =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_observer_on_frame(
                    it,
                    FfiConverterFloat.lower(`frameNo`),
                    _status,
                )
            }
        }

    override fun `onLoad`() =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_observer_on_load(
                    it,
                    _status,
                )
            }
        }

    override fun `onLoadError`() =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_observer_on_load_error(
                    it,
                    _status,
                )
            }
        }

    override fun `onLoop`(`loopCount`: UInt) =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_observer_on_loop(
                    it,
                    FfiConverterUInt.lower(`loopCount`),
                    _status,
                )
            }
        }

    override fun `onPause`() =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_observer_on_pause(
                    it,
                    _status,
                )
            }
        }

    override fun `onPlay`() =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_observer_on_play(
                    it,
                    _status,
                )
            }
        }

    override fun `onRender`(`frameNo`: Float) =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_observer_on_render(
                    it,
                    FfiConverterFloat.lower(`frameNo`),
                    _status,
                )
            }
        }

    override fun `onStop`() =
        callWithPointer {
            uniffiRustCall { _status ->
                UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_observer_on_stop(
                    it,
                    _status,
                )
            }
        }

    companion object
}

internal typealias UniffiHandle = Long

internal class ConcurrentHandleMap<T>(
    private val leftMap: MutableMap<UniffiHandle, T> = mutableMapOf(),
) {
    private val lock = java.util.concurrent.locks.ReentrantLock()
    private val currentHandle = AtomicLong(0L)
    private val stride = 1L

    fun insert(obj: T): UniffiHandle =
        lock.withLock {
            currentHandle.getAndAdd(stride)
                .also { handle ->
                    leftMap[handle] = obj
                }
        }

    fun get(handle: UniffiHandle) =
        lock.withLock {
            leftMap[handle] ?: throw InternalException("No callback in handlemap; this is a Uniffi bug")
        }

    fun delete(handle: UniffiHandle) {
        this.remove(handle)
    }

    fun remove(handle: UniffiHandle): T? =
        lock.withLock {
            leftMap.remove(handle)
        }
}

interface ForeignCallback : com.sun.jna.Callback {
    public fun invoke(
        handle: UniffiHandle,
        method: Int,
        argsData: Pointer,
        argsLen: Int,
        outBuf: RustBufferByReference,
    ): Int
}

// Magic number for the Rust proxy to call using the same mechanism as every other method,
// to free the callback once it's dropped by Rust.
internal const val IDX_CALLBACK_FREE = 0

// Callback return codes
internal const val UNIFFI_CALLBACK_SUCCESS = 0
internal const val UNIFFI_CALLBACK_ERROR = 1
internal const val UNIFFI_CALLBACK_UNEXPECTED_ERROR = 2

public abstract class FfiConverterCallbackInterface<CallbackInterface> : FfiConverter<CallbackInterface, UniffiHandle> {
    internal val handleMap = ConcurrentHandleMap<CallbackInterface>()

    internal fun drop(handle: UniffiHandle) {
        handleMap.remove(handle)
    }

    override fun lift(value: UniffiHandle): CallbackInterface {
        return handleMap.get(value)
    }

    override fun read(buf: ByteBuffer) = lift(buf.getLong())

    override fun lower(value: CallbackInterface) = handleMap.insert(value)

    override fun allocationSize(value: CallbackInterface) = 8

    override fun write(
        value: CallbackInterface,
        buf: ByteBuffer,
    ) {
        buf.putLong(lower(value))
    }
}

// Implement the foreign callback handler for Observer
internal class UniffiCallbackInterfaceObserver : ForeignCallback {
    @Suppress("TooGenericExceptionCaught")
    override fun invoke(
        handle: UniffiHandle,
        method: Int,
        argsData: Pointer,
        argsLen: Int,
        outBuf: RustBufferByReference,
    ): Int {
        val cb = FfiConverterTypeObserver.handleMap.get(handle)
        return when (method) {
            IDX_CALLBACK_FREE -> {
                FfiConverterTypeObserver.handleMap.remove(handle)

                // Successful return
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                UNIFFI_CALLBACK_SUCCESS
            }
            1 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeOnComplete`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            2 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeOnFrame`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            3 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeOnLoad`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            4 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeOnLoadError`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            5 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeOnLoop`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            6 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeOnPause`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            7 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeOnPlay`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            8 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeOnRender`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            9 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeOnStop`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }

            else -> {
                // An unexpected error happened.
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                try {
                    // Try to serialize the error into a string
                    outBuf.setValue(FfiConverterString.lower("Invalid Callback index"))
                } catch (e: Throwable) {
                    // If that fails, then it's time to give up and just return
                }
                UNIFFI_CALLBACK_UNEXPECTED_ERROR
            }
        }
    }

    @Suppress("UNUSED_PARAMETER")
    private fun `invokeOnComplete`(
        kotlinCallbackInterface: Observer,
        argsData: Pointer,
        argsLen: Int,
        outBuf: RustBufferByReference,
    ): Int {
        fun makeCall(): Int {
            kotlinCallbackInterface.`onComplete`()
            return UNIFFI_CALLBACK_SUCCESS
        }

        fun makeCallAndHandleError(): Int = makeCall()

        return makeCallAndHandleError()
    }

    @Suppress("UNUSED_PARAMETER")
    private fun `invokeOnFrame`(
        kotlinCallbackInterface: Observer,
        argsData: Pointer,
        argsLen: Int,
        outBuf: RustBufferByReference,
    ): Int {
        val argsBuf =
            argsData.getByteBuffer(0, argsLen.toLong()).also {
                it.order(ByteOrder.BIG_ENDIAN)
            }

        fun makeCall(): Int {
            kotlinCallbackInterface.`onFrame`(
                FfiConverterFloat.read(argsBuf),
            )
            return UNIFFI_CALLBACK_SUCCESS
        }

        fun makeCallAndHandleError(): Int = makeCall()

        return makeCallAndHandleError()
    }

    @Suppress("UNUSED_PARAMETER")
    private fun `invokeOnLoad`(
        kotlinCallbackInterface: Observer,
        argsData: Pointer,
        argsLen: Int,
        outBuf: RustBufferByReference,
    ): Int {
        fun makeCall(): Int {
            kotlinCallbackInterface.`onLoad`()
            return UNIFFI_CALLBACK_SUCCESS
        }

        fun makeCallAndHandleError(): Int = makeCall()

        return makeCallAndHandleError()
    }

    @Suppress("UNUSED_PARAMETER")
    private fun `invokeOnLoadError`(
        kotlinCallbackInterface: Observer,
        argsData: Pointer,
        argsLen: Int,
        outBuf: RustBufferByReference,
    ): Int {
        fun makeCall(): Int {
            kotlinCallbackInterface.`onLoadError`()
            return UNIFFI_CALLBACK_SUCCESS
        }

        fun makeCallAndHandleError(): Int = makeCall()

        return makeCallAndHandleError()
    }

    @Suppress("UNUSED_PARAMETER")
    private fun `invokeOnLoop`(
        kotlinCallbackInterface: Observer,
        argsData: Pointer,
        argsLen: Int,
        outBuf: RustBufferByReference,
    ): Int {
        val argsBuf =
            argsData.getByteBuffer(0, argsLen.toLong()).also {
                it.order(ByteOrder.BIG_ENDIAN)
            }

        fun makeCall(): Int {
            kotlinCallbackInterface.`onLoop`(
                FfiConverterUInt.read(argsBuf),
            )
            return UNIFFI_CALLBACK_SUCCESS
        }

        fun makeCallAndHandleError(): Int = makeCall()

        return makeCallAndHandleError()
    }

    @Suppress("UNUSED_PARAMETER")
    private fun `invokeOnPause`(
        kotlinCallbackInterface: Observer,
        argsData: Pointer,
        argsLen: Int,
        outBuf: RustBufferByReference,
    ): Int {
        fun makeCall(): Int {
            kotlinCallbackInterface.`onPause`()
            return UNIFFI_CALLBACK_SUCCESS
        }

        fun makeCallAndHandleError(): Int = makeCall()

        return makeCallAndHandleError()
    }

    @Suppress("UNUSED_PARAMETER")
    private fun `invokeOnPlay`(
        kotlinCallbackInterface: Observer,
        argsData: Pointer,
        argsLen: Int,
        outBuf: RustBufferByReference,
    ): Int {
        fun makeCall(): Int {
            kotlinCallbackInterface.`onPlay`()
            return UNIFFI_CALLBACK_SUCCESS
        }

        fun makeCallAndHandleError(): Int = makeCall()

        return makeCallAndHandleError()
    }

    @Suppress("UNUSED_PARAMETER")
    private fun `invokeOnRender`(
        kotlinCallbackInterface: Observer,
        argsData: Pointer,
        argsLen: Int,
        outBuf: RustBufferByReference,
    ): Int {
        val argsBuf =
            argsData.getByteBuffer(0, argsLen.toLong()).also {
                it.order(ByteOrder.BIG_ENDIAN)
            }

        fun makeCall(): Int {
            kotlinCallbackInterface.`onRender`(
                FfiConverterFloat.read(argsBuf),
            )
            return UNIFFI_CALLBACK_SUCCESS
        }

        fun makeCallAndHandleError(): Int = makeCall()

        return makeCallAndHandleError()
    }

    @Suppress("UNUSED_PARAMETER")
    private fun `invokeOnStop`(
        kotlinCallbackInterface: Observer,
        argsData: Pointer,
        argsLen: Int,
        outBuf: RustBufferByReference,
    ): Int {
        fun makeCall(): Int {
            kotlinCallbackInterface.`onStop`()
            return UNIFFI_CALLBACK_SUCCESS
        }

        fun makeCallAndHandleError(): Int = makeCall()

        return makeCallAndHandleError()
    }

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: UniffiLib) {
        lib.uniffi_dotlottie_player_fn_init_callback_observer(this)
    }
}

internal val uniffiCallbackInterfaceObserver = UniffiCallbackInterfaceObserver()

public object FfiConverterTypeObserver : FfiConverter<Observer, Pointer> {
    internal val handleMap = ConcurrentHandleMap<Observer>()

    override fun lower(value: Observer): Pointer {
        return Pointer(handleMap.insert(value))
    }

    override fun lift(value: Pointer): Observer {
        return ObserverImpl(value)
    }

    override fun read(buf: ByteBuffer): Observer {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Observer) = 8

    override fun write(
        value: Observer,
        buf: ByteBuffer,
    ) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}

data class Config(
    var `autoplay`: Boolean,
    var `loopAnimation`: Boolean,
    var `mode`: Mode,
    var `speed`: Float,
    var `useFrameInterpolation`: Boolean,
    var `segments`: List<Float>,
    var `backgroundColor`: UInt,
    var `layout`: Layout,
    var `marker`: String,
) {
    companion object
}

public object FfiConverterTypeConfig : FfiConverterRustBuffer<Config> {
    override fun read(buf: ByteBuffer): Config {
        return Config(
            FfiConverterBoolean.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterTypeMode.read(buf),
            FfiConverterFloat.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterSequenceFloat.read(buf),
            FfiConverterUInt.read(buf),
            FfiConverterTypeLayout.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: Config) =
        (
            FfiConverterBoolean.allocationSize(value.`autoplay`) +
                FfiConverterBoolean.allocationSize(value.`loopAnimation`) +
                FfiConverterTypeMode.allocationSize(value.`mode`) +
                FfiConverterFloat.allocationSize(value.`speed`) +
                FfiConverterBoolean.allocationSize(value.`useFrameInterpolation`) +
                FfiConverterSequenceFloat.allocationSize(value.`segments`) +
                FfiConverterUInt.allocationSize(value.`backgroundColor`) +
                FfiConverterTypeLayout.allocationSize(value.`layout`) +
                FfiConverterString.allocationSize(value.`marker`)
        )

    override fun write(
        value: Config,
        buf: ByteBuffer,
    ) {
        FfiConverterBoolean.write(value.`autoplay`, buf)
        FfiConverterBoolean.write(value.`loopAnimation`, buf)
        FfiConverterTypeMode.write(value.`mode`, buf)
        FfiConverterFloat.write(value.`speed`, buf)
        FfiConverterBoolean.write(value.`useFrameInterpolation`, buf)
        FfiConverterSequenceFloat.write(value.`segments`, buf)
        FfiConverterUInt.write(value.`backgroundColor`, buf)
        FfiConverterTypeLayout.write(value.`layout`, buf)
        FfiConverterString.write(value.`marker`, buf)
    }
}

data class Layout(
    var `fit`: Fit,
    var `align`: List<Float>,
) {
    companion object
}

public object FfiConverterTypeLayout : FfiConverterRustBuffer<Layout> {
    override fun read(buf: ByteBuffer): Layout {
        return Layout(
            FfiConverterTypeFit.read(buf),
            FfiConverterSequenceFloat.read(buf),
        )
    }

    override fun allocationSize(value: Layout) =
        (
            FfiConverterTypeFit.allocationSize(value.`fit`) +
                FfiConverterSequenceFloat.allocationSize(value.`align`)
        )

    override fun write(
        value: Layout,
        buf: ByteBuffer,
    ) {
        FfiConverterTypeFit.write(value.`fit`, buf)
        FfiConverterSequenceFloat.write(value.`align`, buf)
    }
}

data class Manifest(
    var `activeAnimationId`: String?,
    var `animations`: List<ManifestAnimation>,
    var `author`: String?,
    var `description`: String?,
    var `generator`: String?,
    var `keywords`: String?,
    var `revision`: UInt?,
    var `themes`: List<ManifestTheme>?,
    var `states`: List<String>?,
    var `version`: String?,
) {
    companion object
}

public object FfiConverterTypeManifest : FfiConverterRustBuffer<Manifest> {
    override fun read(buf: ByteBuffer): Manifest {
        return Manifest(
            FfiConverterOptionalString.read(buf),
            FfiConverterSequenceTypeManifestAnimation.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalUInt.read(buf),
            FfiConverterOptionalSequenceTypeManifestTheme.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: Manifest) =
        (
            FfiConverterOptionalString.allocationSize(value.`activeAnimationId`) +
                FfiConverterSequenceTypeManifestAnimation.allocationSize(value.`animations`) +
                FfiConverterOptionalString.allocationSize(value.`author`) +
                FfiConverterOptionalString.allocationSize(value.`description`) +
                FfiConverterOptionalString.allocationSize(value.`generator`) +
                FfiConverterOptionalString.allocationSize(value.`keywords`) +
                FfiConverterOptionalUInt.allocationSize(value.`revision`) +
                FfiConverterOptionalSequenceTypeManifestTheme.allocationSize(value.`themes`) +
                FfiConverterOptionalSequenceString.allocationSize(value.`states`) +
                FfiConverterOptionalString.allocationSize(value.`version`)
        )

    override fun write(
        value: Manifest,
        buf: ByteBuffer,
    ) {
        FfiConverterOptionalString.write(value.`activeAnimationId`, buf)
        FfiConverterSequenceTypeManifestAnimation.write(value.`animations`, buf)
        FfiConverterOptionalString.write(value.`author`, buf)
        FfiConverterOptionalString.write(value.`description`, buf)
        FfiConverterOptionalString.write(value.`generator`, buf)
        FfiConverterOptionalString.write(value.`keywords`, buf)
        FfiConverterOptionalUInt.write(value.`revision`, buf)
        FfiConverterOptionalSequenceTypeManifestTheme.write(value.`themes`, buf)
        FfiConverterOptionalSequenceString.write(value.`states`, buf)
        FfiConverterOptionalString.write(value.`version`, buf)
    }
}

data class ManifestAnimation(
    var `autoplay`: Boolean?,
    var `defaultTheme`: String?,
    var `direction`: Byte?,
    var `hover`: Boolean?,
    var `id`: String,
    var `intermission`: UInt?,
    var `loop`: Boolean?,
    var `loopCount`: UInt?,
    var `playMode`: String?,
    var `speed`: UInt?,
    var `themeColor`: String?,
) {
    companion object
}

public object FfiConverterTypeManifestAnimation : FfiConverterRustBuffer<ManifestAnimation> {
    override fun read(buf: ByteBuffer): ManifestAnimation {
        return ManifestAnimation(
            FfiConverterOptionalBoolean.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalByte.read(buf),
            FfiConverterOptionalBoolean.read(buf),
            FfiConverterString.read(buf),
            FfiConverterOptionalUInt.read(buf),
            FfiConverterOptionalBoolean.read(buf),
            FfiConverterOptionalUInt.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalUInt.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: ManifestAnimation) =
        (
            FfiConverterOptionalBoolean.allocationSize(value.`autoplay`) +
                FfiConverterOptionalString.allocationSize(value.`defaultTheme`) +
                FfiConverterOptionalByte.allocationSize(value.`direction`) +
                FfiConverterOptionalBoolean.allocationSize(value.`hover`) +
                FfiConverterString.allocationSize(value.`id`) +
                FfiConverterOptionalUInt.allocationSize(value.`intermission`) +
                FfiConverterOptionalBoolean.allocationSize(value.`loop`) +
                FfiConverterOptionalUInt.allocationSize(value.`loopCount`) +
                FfiConverterOptionalString.allocationSize(value.`playMode`) +
                FfiConverterOptionalUInt.allocationSize(value.`speed`) +
                FfiConverterOptionalString.allocationSize(value.`themeColor`)
        )

    override fun write(
        value: ManifestAnimation,
        buf: ByteBuffer,
    ) {
        FfiConverterOptionalBoolean.write(value.`autoplay`, buf)
        FfiConverterOptionalString.write(value.`defaultTheme`, buf)
        FfiConverterOptionalByte.write(value.`direction`, buf)
        FfiConverterOptionalBoolean.write(value.`hover`, buf)
        FfiConverterString.write(value.`id`, buf)
        FfiConverterOptionalUInt.write(value.`intermission`, buf)
        FfiConverterOptionalBoolean.write(value.`loop`, buf)
        FfiConverterOptionalUInt.write(value.`loopCount`, buf)
        FfiConverterOptionalString.write(value.`playMode`, buf)
        FfiConverterOptionalUInt.write(value.`speed`, buf)
        FfiConverterOptionalString.write(value.`themeColor`, buf)
    }
}

data class ManifestTheme(
    var `id`: String,
    var `animations`: List<String>,
) {
    companion object
}

public object FfiConverterTypeManifestTheme : FfiConverterRustBuffer<ManifestTheme> {
    override fun read(buf: ByteBuffer): ManifestTheme {
        return ManifestTheme(
            FfiConverterString.read(buf),
            FfiConverterSequenceString.read(buf),
        )
    }

    override fun allocationSize(value: ManifestTheme) =
        (
            FfiConverterString.allocationSize(value.`id`) +
                FfiConverterSequenceString.allocationSize(value.`animations`)
        )

    override fun write(
        value: ManifestTheme,
        buf: ByteBuffer,
    ) {
        FfiConverterString.write(value.`id`, buf)
        FfiConverterSequenceString.write(value.`animations`, buf)
    }
}

data class Marker(
    var `name`: String,
    var `time`: Float,
    var `duration`: Float,
) {
    companion object
}

public object FfiConverterTypeMarker : FfiConverterRustBuffer<Marker> {
    override fun read(buf: ByteBuffer): Marker {
        return Marker(
            FfiConverterString.read(buf),
            FfiConverterFloat.read(buf),
            FfiConverterFloat.read(buf),
        )
    }

    override fun allocationSize(value: Marker) =
        (
            FfiConverterString.allocationSize(value.`name`) +
                FfiConverterFloat.allocationSize(value.`time`) +
                FfiConverterFloat.allocationSize(value.`duration`)
        )

    override fun write(
        value: Marker,
        buf: ByteBuffer,
    ) {
        FfiConverterString.write(value.`name`, buf)
        FfiConverterFloat.write(value.`time`, buf)
        FfiConverterFloat.write(value.`duration`, buf)
    }
}

enum class Fit {
    CONTAIN,
    FILL,
    COVER,
    FIT_WIDTH,
    FIT_HEIGHT,
    NONE,
    ;

    companion object
}

public object FfiConverterTypeFit : FfiConverterRustBuffer<Fit> {
    override fun read(buf: ByteBuffer) =
        try {
            Fit.values()[buf.getInt() - 1]
        } catch (e: IndexOutOfBoundsException) {
            throw RuntimeException("invalid enum value, something is very wrong!!", e)
        }

    override fun allocationSize(value: Fit) = 4

    override fun write(
        value: Fit,
        buf: ByteBuffer,
    ) {
        buf.putInt(value.ordinal + 1)
    }
}

enum class Mode {
    FORWARD,
    REVERSE,
    BOUNCE,
    REVERSE_BOUNCE,
    ;

    companion object
}

public object FfiConverterTypeMode : FfiConverterRustBuffer<Mode> {
    override fun read(buf: ByteBuffer) =
        try {
            Mode.values()[buf.getInt() - 1]
        } catch (e: IndexOutOfBoundsException) {
            throw RuntimeException("invalid enum value, something is very wrong!!", e)
        }

    override fun allocationSize(value: Mode) = 4

    override fun write(
        value: Mode,
        buf: ByteBuffer,
    ) {
        buf.putInt(value.ordinal + 1)
    }
}

public object FfiConverterOptionalByte : FfiConverterRustBuffer<Byte?> {
    override fun read(buf: ByteBuffer): Byte? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterByte.read(buf)
    }

    override fun allocationSize(value: Byte?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterByte.allocationSize(value)
        }
    }

    override fun write(
        value: Byte?,
        buf: ByteBuffer,
    ) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterByte.write(value, buf)
        }
    }
}

public object FfiConverterOptionalUInt : FfiConverterRustBuffer<UInt?> {
    override fun read(buf: ByteBuffer): UInt? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterUInt.read(buf)
    }

    override fun allocationSize(value: UInt?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterUInt.allocationSize(value)
        }
    }

    override fun write(
        value: UInt?,
        buf: ByteBuffer,
    ) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterUInt.write(value, buf)
        }
    }
}

public object FfiConverterOptionalBoolean : FfiConverterRustBuffer<Boolean?> {
    override fun read(buf: ByteBuffer): Boolean? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterBoolean.read(buf)
    }

    override fun allocationSize(value: Boolean?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterBoolean.allocationSize(value)
        }
    }

    override fun write(
        value: Boolean?,
        buf: ByteBuffer,
    ) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterBoolean.write(value, buf)
        }
    }
}

public object FfiConverterOptionalString : FfiConverterRustBuffer<String?> {
    override fun read(buf: ByteBuffer): String? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterString.read(buf)
    }

    override fun allocationSize(value: String?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterString.allocationSize(value)
        }
    }

    override fun write(
        value: String?,
        buf: ByteBuffer,
    ) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterString.write(value, buf)
        }
    }
}

public object FfiConverterOptionalTypeManifest : FfiConverterRustBuffer<Manifest?> {
    override fun read(buf: ByteBuffer): Manifest? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeManifest.read(buf)
    }

    override fun allocationSize(value: Manifest?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeManifest.allocationSize(value)
        }
    }

    override fun write(
        value: Manifest?,
        buf: ByteBuffer,
    ) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeManifest.write(value, buf)
        }
    }
}

public object FfiConverterOptionalSequenceString : FfiConverterRustBuffer<List<String>?> {
    override fun read(buf: ByteBuffer): List<String>? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterSequenceString.read(buf)
    }

    override fun allocationSize(value: List<String>?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterSequenceString.allocationSize(value)
        }
    }

    override fun write(
        value: List<String>?,
        buf: ByteBuffer,
    ) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterSequenceString.write(value, buf)
        }
    }
}

public object FfiConverterOptionalSequenceTypeManifestTheme : FfiConverterRustBuffer<List<ManifestTheme>?> {
    override fun read(buf: ByteBuffer): List<ManifestTheme>? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterSequenceTypeManifestTheme.read(buf)
    }

    override fun allocationSize(value: List<ManifestTheme>?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterSequenceTypeManifestTheme.allocationSize(value)
        }
    }

    override fun write(
        value: List<ManifestTheme>?,
        buf: ByteBuffer,
    ) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterSequenceTypeManifestTheme.write(value, buf)
        }
    }
}

public object FfiConverterSequenceFloat : FfiConverterRustBuffer<List<Float>> {
    override fun read(buf: ByteBuffer): List<Float> {
        val len = buf.getInt()
        return List<Float>(len) {
            FfiConverterFloat.read(buf)
        }
    }

    override fun allocationSize(value: List<Float>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterFloat.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(
        value: List<Float>,
        buf: ByteBuffer,
    ) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterFloat.write(it, buf)
        }
    }
}

public object FfiConverterSequenceString : FfiConverterRustBuffer<List<String>> {
    override fun read(buf: ByteBuffer): List<String> {
        val len = buf.getInt()
        return List<String>(len) {
            FfiConverterString.read(buf)
        }
    }

    override fun allocationSize(value: List<String>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterString.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(
        value: List<String>,
        buf: ByteBuffer,
    ) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterString.write(it, buf)
        }
    }
}

public object FfiConverterSequenceTypeManifestAnimation : FfiConverterRustBuffer<List<ManifestAnimation>> {
    override fun read(buf: ByteBuffer): List<ManifestAnimation> {
        val len = buf.getInt()
        return List<ManifestAnimation>(len) {
            FfiConverterTypeManifestAnimation.read(buf)
        }
    }

    override fun allocationSize(value: List<ManifestAnimation>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypeManifestAnimation.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(
        value: List<ManifestAnimation>,
        buf: ByteBuffer,
    ) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypeManifestAnimation.write(it, buf)
        }
    }
}

public object FfiConverterSequenceTypeManifestTheme : FfiConverterRustBuffer<List<ManifestTheme>> {
    override fun read(buf: ByteBuffer): List<ManifestTheme> {
        val len = buf.getInt()
        return List<ManifestTheme>(len) {
            FfiConverterTypeManifestTheme.read(buf)
        }
    }

    override fun allocationSize(value: List<ManifestTheme>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypeManifestTheme.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(
        value: List<ManifestTheme>,
        buf: ByteBuffer,
    ) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypeManifestTheme.write(it, buf)
        }
    }
}

public object FfiConverterSequenceTypeMarker : FfiConverterRustBuffer<List<Marker>> {
    override fun read(buf: ByteBuffer): List<Marker> {
        val len = buf.getInt()
        return List<Marker>(len) {
            FfiConverterTypeMarker.read(buf)
        }
    }

    override fun allocationSize(value: List<Marker>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypeMarker.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(
        value: List<Marker>,
        buf: ByteBuffer,
    ) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypeMarker.write(it, buf)
        }
    }
}

fun `createDefaultLayout`(): Layout {
    return FfiConverterTypeLayout.lift(
        uniffiRustCall { _status ->
            UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_func_create_default_layout(_status)
        },
    )
}
