/*
 * Decompiled with CFR 0.152.
 */
package com.ruiwenliu.Horizontallibrary.adapter;

import android.content.Context;
import android.support.annotation.IntRange;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.ruiwenliu.Horizontallibrary.adapter.RecylcerViewHolder;
import com.ruiwenliu.Horizontallibrary.inter.OnItemClickListener;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseRecyclerviewAdapter<D, T extends RecylcerViewHolder>
extends RecyclerView.Adapter<T> {
    protected Context mContext;
    protected int mLayoutResId;
    protected List<D> mData;
    private int postion;
    private OnItemClickListener mOnItemClick;

    public BaseRecyclerviewAdapter(int layoutResId, List<D> data) {
        this.mLayoutResId = layoutResId;
        this.mData = data;
    }

    public BaseRecyclerviewAdapter(int layoutResId) {
        this.mLayoutResId = layoutResId;
    }

    public T onCreateViewHolder(ViewGroup parent, int viewType) {
        this.mContext = parent.getContext();
        View view = LayoutInflater.from((Context)this.mContext).inflate(this.mLayoutResId, parent, false);
        this.getItemView(view);
        RecylcerViewHolder viewHolder = new RecylcerViewHolder(view);
        this.bindViewClick(viewHolder);
        return (T)((Object)viewHolder);
    }

    public void onBindViewHolder(T holder, int position) {
        this.convert(holder, this.getItem(position), position);
    }

    public int getItemCount() {
        return this.mData.size();
    }

    public List<D> getData() {
        return this.mData == null ? new ArrayList() : this.mData;
    }

    public void setNewData(List<D> data) {
        this.mData = data == null ? new ArrayList() : data;
        this.notifyDataSetChanged();
    }

    protected abstract void convert(T var1, D var2, int var3);

    public D getItem(@IntRange(from=0L) int position) {
        return position >= 0 && position < this.mData.size() ? (D)this.mData.get(position) : null;
    }

    private void bindViewClick(final RecylcerViewHolder viewHolder) {
        if (viewHolder == null) {
            return;
        }
        View view = viewHolder.itemView;
        if (view == null) {
            return;
        }
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BaseRecyclerviewAdapter.this.setSelect(viewHolder.getLayoutPosition());
                if (BaseRecyclerviewAdapter.this.mOnItemClick != null) {
                    BaseRecyclerviewAdapter.this.mOnItemClick.onItemClick(BaseRecyclerviewAdapter.this, v, viewHolder.getLayoutPosition());
                }
            }
        });
    }

    public void setOnItemClickListener(OnItemClickListener onItemClick) {
        this.mOnItemClick = onItemClick;
    }

    public int getSelectPostion() {
        return this.postion;
    }

    public void setSelect(int postion) {
        this.postion = postion;
        this.notifyDataSetChanged();
    }

    public void getItemView(View view) {
    }
}

