/*
 * Decompiled with CFR 0.152.
 */
package de.linus.deepltranslator;

import com.google.common.net.UrlEscapers;
import com.machinepublishers.jbrowserdriver.JBrowserDriver;
import com.machinepublishers.jbrowserdriver.Settings;
import com.machinepublishers.jbrowserdriver.UserAgent;
import de.linus.deepltranslator.DeepLConfiguration;
import de.linus.deepltranslator.DeepLException;
import de.linus.deepltranslator.Language;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.WebElement;

class DeepLTranslatorBase {
    static final ExecutorService EXECUTOR = Executors.newCachedThreadPool();
    static final List<JBrowserDriver> GLOBAL_INSTANCES = new ArrayList<JBrowserDriver>();
    private final LinkedBlockingQueue<JBrowserDriver> INSTANCES = new LinkedBlockingQueue();
    private final DeepLConfiguration configuration;

    DeepLTranslatorBase() {
        this.configuration = new DeepLConfiguration.Builder().build();
    }

    DeepLTranslatorBase(DeepLConfiguration configuration) {
        this.configuration = configuration;
    }

    void isValid(String text, Language from, Language to) throws IllegalStateException {
        if (text == null || text.trim().isEmpty()) {
            throw new IllegalStateException("Text is null or empty");
        }
        if (from == null || to == null) {
            throw new IllegalStateException("Language is null");
        }
        if (text.length() > 5000) {
            throw new IllegalStateException("Text length is limited to 5000 characters");
        }
    }

    String getTranslation(String text, Language from, Language to) throws DeepLException {
        String result;
        JBrowserDriver driver = this.INSTANCES.poll();
        if (driver == null) {
            driver = new JBrowserDriver(Settings.builder().userAgent(UserAgent.CHROME).timezone(this.configuration.getTimezone()).screen(new Dimension(1920, 1080)).ajaxWait(100L).ajaxResourceTimeout(this.configuration.getTimeout().toMillis()).connectTimeout((int)this.configuration.getTimeout().toMillis()).cache(true).build());
            GLOBAL_INSTANCES.add(driver);
        }
        String url = "https://www.deepl.com/translator#" + from.getLanguageCode() + "/" + to.getLanguageCode() + "/" + UrlEscapers.urlFragmentEscaper().escape(text);
        long end = System.currentTimeMillis() + this.configuration.getTimeout().toMillis();
        driver.get(url);
        while ((result = this.readResult(driver)) == null || result.isEmpty()) {
            if (System.currentTimeMillis() > end) {
                throw new DeepLException("Timed out.");
            }
            driver.pageWait();
        }
        int statusCode = driver.getStatusCode();
        this.INSTANCES.offer(driver);
        if (statusCode != 200) {
            throw new DeepLException("Received status code " + statusCode + ".");
        }
        return result;
    }

    private String readResult(JBrowserDriver driver) {
        WebElement webElement = driver.findElementByClassName("lmt__translations_as_text__text_btn");
        if (webElement == null) {
            return null;
        }
        String text = webElement.getAttribute("textContent");
        if (text == null) {
            return null;
        }
        return text.trim().replaceAll("(?:\r?\n)+", " ").replaceAll("\\s{2,}", " ");
    }

    boolean repeat(int repeated) {
        return this.configuration.getRepetitions() == -1 || this.configuration.getRepetitions() > repeated;
    }

    public DeepLConfiguration getConfiguration() {
        return this.configuration;
    }
}

