/*
 * Decompiled with CFR 0.152.
 */
package de.linus.deepltranslator;

import com.machinepublishers.jbrowserdriver.JBrowserDriver;
import de.linus.deepltranslator.DeepLConfiguration;
import de.linus.deepltranslator.DeepLException;
import de.linus.deepltranslator.DeepLTranslatorBase;
import de.linus.deepltranslator.Language;
import de.linus.deepltranslator.TranslationConsumer;

public class DeepLTranslator
extends DeepLTranslatorBase {
    public DeepLTranslator() {
    }

    public DeepLTranslator(DeepLConfiguration configuration) {
        super(configuration);
    }

    public String translate(String text, Language from, Language to) throws Exception {
        this.isValid(text, from, to);
        return this.translate(text, from, to, -1);
    }

    private String translate(String text, Language from, Language to, int repeated) throws Exception {
        try {
            return this.getTranslation(text, from, to);
        }
        catch (DeepLException e) {
            if (this.repeat(++repeated)) {
                Thread.sleep(this.getConfiguration().getRepetitionsDelay().apply(repeated).toMillis());
                return this.translate(text, from, to, repeated);
            }
            throw e;
        }
    }

    public void translateAsync(String text, Language from, Language to, TranslationConsumer translationConsumer) throws IllegalStateException {
        this.isValid(text, from, to);
        EXECUTOR.submit(() -> {
            try {
                translationConsumer.passTranslation(this.translate(text, from, to));
            }
            catch (Exception e) {
                translationConsumer.passException(e);
            }
        });
    }

    public static void shutdown() {
        GLOBAL_INSTANCES.forEach(JBrowserDriver::quit);
        EXECUTOR.shutdownNow();
    }
}

