/*
 * Decompiled with CFR 0.152.
 */
package de.linus.deepltranslator;

import com.machinepublishers.jbrowserdriver.Timezone;
import java.time.Duration;
import java.util.function.Function;

public class DeepLConfiguration {
    private Duration timeout;
    private int repetitions;
    private Function<Integer, Duration> repetitionsDelay;
    private Timezone timezone;

    private DeepLConfiguration(Duration timeout, int repetitions, Function<Integer, Duration> repetitionsDelay, Timezone timezone) {
        this.timeout = timeout;
        this.repetitions = repetitions;
        this.repetitionsDelay = repetitionsDelay;
        this.timezone = timezone;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public int getRepetitions() {
        return this.repetitions;
    }

    public Function<Integer, Duration> getRepetitionsDelay() {
        return this.repetitionsDelay;
    }

    public Timezone getTimezone() {
        return this.timezone;
    }

    public static class Builder {
        private Duration timeout = Duration.ofSeconds(10L);
        private int repetitions = 3;
        private Function<Integer, Duration> repetitionsDelay = retryNumber -> Duration.ofMillis(3000 + 5000 * retryNumber);
        private Timezone timezone = Timezone.UTC;

        public Builder setTimeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder setRepetitions(int repetitions) {
            this.repetitions = repetitions;
            return this;
        }

        public Builder setRepetitionsDelay(Function<Integer, Duration> repetitionsDelay) {
            this.repetitionsDelay = repetitionsDelay;
            return this;
        }

        public Builder setTimezone(Timezone timezone) {
            this.timezone = timezone;
            return this;
        }

        public DeepLConfiguration build() {
            return new DeepLConfiguration(this.timeout, this.repetitions, this.repetitionsDelay, this.timezone);
        }
    }
}

