/*
 * Decompiled with CFR 0.152.
 */
package com.zhengsr.tablib.utils;

import android.content.Context;
import android.widget.Scroller;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.LinearSmoothScroller;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager.widget.ViewPager;
import androidx.viewpager2.widget.ViewPager2;
import java.lang.reflect.Field;

public class ViewPagerHelperUtils {
    public static final int LOOP_COUNT = 5000;
    public static final int LOOP_TAIL_MODE = 4097;
    public static final int LOOP_MODE = 4098;
    public static final int GLIDE_MODE = 4098;
    public static final int VIEWPAGER_DATA_URL = 8194;
    public static final int VIEWPAGER_DATA_RES = 8195;
    public static final int VIEWPAGER_DATA_VIEW = 8196;

    public static void initSwitchTime(Context context, ViewPager viewPager, int time) {
        try {
            Field field = ViewPager.class.getDeclaredField("mScroller");
            field.setAccessible(true);
            field.set(viewPager, (Object)new ViewPagerScroller(context, time));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void initSwitchTime(Context context, ViewPager2 viewPager2, int time) {
        try {
            RecyclerView recyclerView = (RecyclerView)viewPager2.getChildAt(0);
            recyclerView.setOverScrollMode(2);
            ProxyLayoutManger proxyLayoutManger = new ProxyLayoutManger(context, viewPager2.getOrientation(), time);
            recyclerView.setLayoutManager((RecyclerView.LayoutManager)proxyLayoutManger);
            Field LayoutMangerField = ViewPager2.class.getDeclaredField("mLayoutManager");
            LayoutMangerField.setAccessible(true);
            LayoutMangerField.set(viewPager2, (Object)proxyLayoutManger);
            Field pageTransformerAdapterField = ViewPager2.class.getDeclaredField("mPageTransformerAdapter");
            pageTransformerAdapterField.setAccessible(true);
            Object mPageTransformerAdapter = pageTransformerAdapterField.get(viewPager2);
            if (mPageTransformerAdapter != null) {
                Class<?> aClass = mPageTransformerAdapter.getClass();
                Field layoutManager = aClass.getDeclaredField("mLayoutManager");
                layoutManager.setAccessible(true);
                layoutManager.set(mPageTransformerAdapter, (Object)proxyLayoutManger);
            }
            Field scrollEventAdapterField = ViewPager2.class.getDeclaredField("mScrollEventAdapter");
            scrollEventAdapterField.setAccessible(true);
            Object mScrollEventAdapter = scrollEventAdapterField.get(viewPager2);
            if (mScrollEventAdapter != null) {
                Class<?> aClass = mScrollEventAdapter.getClass();
                Field layoutManager = aClass.getDeclaredField("mLayoutManager");
                layoutManager.setAccessible(true);
                layoutManager.set(mScrollEventAdapter, (Object)proxyLayoutManger);
            }
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static int getViewPageClickItem(ViewPager viewPager) {
        if (viewPager != null) {
            try {
                Class<?> zClass = viewPager.getClass();
                Field mCurItem = zClass.getDeclaredField("mCurItem");
                mCurItem.setAccessible(true);
                return mCurItem.getInt(viewPager);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    private static class ProxyLayoutManger
    extends LinearLayoutManager {
        int time;

        ProxyLayoutManger(Context context, int orientation, int time) {
            super(context, orientation, false);
            this.time = time;
        }

        public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State state, int position) {
            LinearSmoothScroller linearSmoothScroller = new LinearSmoothScroller(recyclerView.getContext()){

                protected int calculateTimeForDeceleration(int dx) {
                    return (int)((double)ProxyLayoutManger.this.time * 0.6644);
                }
            };
            linearSmoothScroller.setTargetPosition(position);
            this.startSmoothScroll((RecyclerView.SmoothScroller)linearSmoothScroller);
        }
    }

    static class ViewPagerScroller
    extends Scroller {
        int time;

        public ViewPagerScroller(Context context, int time) {
            super(context);
            this.time = time;
        }

        public void startScroll(int startX, int startY, int dx, int dy, int duration) {
            super.startScroll(startX, startY, dx, dy, this.time);
        }
    }
}

