/*
 * Decompiled with CFR 0.152.
 */
package com.zhengsr.tablib.view.flow;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.LinearLayout;
import android.widget.Scroller;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.viewpager.widget.ViewPager;
import androidx.viewpager2.widget.ViewPager2;
import com.zhengsr.tablib.R;
import com.zhengsr.tablib.bean.TabBean;
import com.zhengsr.tablib.callback.FlowListenerAdapter;
import com.zhengsr.tablib.utils.AttrsUtils;
import com.zhengsr.tablib.view.action.BaseAction;
import com.zhengsr.tablib.view.action.ColorAction;
import com.zhengsr.tablib.view.action.RectAction;
import com.zhengsr.tablib.view.action.ResAction;
import com.zhengsr.tablib.view.action.RoundAction;
import com.zhengsr.tablib.view.action.TriAction;
import com.zhengsr.tablib.view.adapter.TabFlowAdapter;
import com.zhengsr.tablib.view.flow.ScrollFlowLayout;

public class TabFlowLayout
extends ScrollFlowLayout {
    private static final String TAG = "TabFlowLayout";
    private TabFlowAdapter mAdapter;
    private BaseAction mAction;
    private boolean isFirst = true;
    private Scroller mScroller;
    private int mLastScrollPos = 0;
    private int mLastIndex = 0;
    private int mCurrentIndex = 0;
    private ViewPager mViewPager;
    private ViewPager2 mViewPager2;
    private int mTextId = -1;
    private int mSelectedColor = -1;
    private int mUnSelectedColor = -1;
    private TabBean mTabBean;
    private boolean isItemClick;

    public TabFlowLayout(Context context) {
        this(context, null);
    }

    public TabFlowLayout(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TabFlowLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setClickable(true);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.TabFlowLayout);
        this.mTabBean = AttrsUtils.getTabBean(ta);
        this.mScroller = new Scroller(this.getContext());
        this.setVisualCount(this.mTabBean.visualCount);
        this.setTabOrientation(this.mTabBean.tabOrientation);
        this.chooseTabTpye(this.mTabBean.tabType);
        this.setLayerType(1, null);
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                TabFlowLayout.this.reAdjustLayoutParams();
                if (TabFlowLayout.this.isFirst) {
                    TabFlowLayout.this.isFirst = false;
                    if (TabFlowLayout.this.mAction == null) {
                        return;
                    }
                    TabFlowLayout.this.mAction.config(TabFlowLayout.this);
                    TabFlowLayout.this.mAction.chooseIndex(TabFlowLayout.this.mLastIndex, TabFlowLayout.this.mCurrentIndex);
                    View view = TabFlowLayout.this.getChildAt(TabFlowLayout.this.mCurrentIndex);
                    if (view != null && TabFlowLayout.this.mViewPager == null) {
                        TabFlowLayout.this.updateScroll(view, false);
                    }
                }
                TabFlowLayout.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        });
    }

    private void reAdjustLayoutParams() {
        if (!this.isVertical() && this.getWidth() > this.mWidth) {
            ViewGroup parent = (ViewGroup)this.getParent();
            if (parent instanceof LinearLayout) {
                LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)this.getLayoutParams();
                params.gravity = 0x800003;
                this.setLayoutParams((ViewGroup.LayoutParams)params);
            } else if (parent instanceof ConstraintLayout) {
                boolean isWrapContent;
                ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams)this.getLayoutParams();
                boolean bl = isWrapContent = params.width == -2;
                if (isWrapContent && this.isCanMove()) {
                    params.width = 0;
                    this.setLayoutParams((ViewGroup.LayoutParams)params);
                }
            }
        }
    }

    private void chooseTabTpye(int tabStyle) {
        if (tabStyle != -1) {
            switch (tabStyle) {
                case 0: {
                    this.mAction = new RectAction();
                    break;
                }
                case 1: {
                    this.mAction = new TriAction();
                    break;
                }
                case 2: {
                    this.mAction = new RoundAction();
                    break;
                }
                case 4: {
                    this.mAction = new ResAction();
                    break;
                }
                case 3: {
                    this.mAction = new ColorAction();
                    break;
                }
            }
        }
        if (this.mAction != null) {
            this.mAction.setContext(this.getContext());
            this.mAction.configAttrs(this.mTabBean);
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        if (this.mAction != null) {
            this.mAction.draw(canvas);
        }
        super.dispatchDraw(canvas);
    }

    public void setAdapter(TabFlowAdapter adapter) {
        this.mAdapter = adapter;
        this.mAdapter.setListener(new FlowListener());
        this.notifyChanged();
    }

    public void setCusAction(BaseAction action) {
        this.mAction = action;
        this.mAction.configAttrs(this.mTabBean);
        if (this.mAction != null) {
            if (this.mViewPager != null && this.mAction.getViewPager() == null) {
                this.mAction.setViewPager(this.mViewPager);
            }
            if (this.mViewPager2 != null && this.mAction.getViewPager2() == null) {
                this.mAction.setViewPager(this.mViewPager2);
            }
            this.mAction.setTextId(this.mTextId).setSelectedColor(this.mSelectedColor).setUnSelectedColor(this.mUnSelectedColor);
        }
    }

    public TabFlowLayout setDefaultPosition(int position) {
        this.mCurrentIndex = position;
        return this;
    }

    public TabFlowLayout setViewPager(ViewPager viewPager) {
        if (viewPager == null) {
            return this;
        }
        this.mViewPager = viewPager;
        if (this.mAction != null) {
            this.mAction.setViewPager(viewPager);
        }
        return this;
    }

    public TabFlowLayout setViewPager(ViewPager2 viewpager2) {
        this.mViewPager2 = viewpager2;
        if (this.mAction != null) {
            this.mAction.setViewPager(viewpager2);
        }
        return this;
    }

    public TabFlowLayout setTextId(int textId) {
        this.mTextId = textId;
        if (this.mAction != null) {
            this.mAction.setTextId(textId);
        }
        return this;
    }

    public TabFlowLayout setSelectedColor(int selectedColor) {
        this.mSelectedColor = selectedColor;
        if (this.mAction != null) {
            this.mAction.setSelectedColor(selectedColor);
        }
        return this;
    }

    public TabFlowLayout setUnSelectedColor(int unSelectedColor) {
        this.mUnSelectedColor = unSelectedColor;
        if (this.mAction != null) {
            this.mAction.setUnSelectedColor(unSelectedColor);
        }
        return this;
    }

    private void notifyChanged() {
        this.removeAllViews();
        TabFlowAdapter adapter = this.mAdapter;
        int itemCount = adapter.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            View view = LayoutInflater.from((Context)this.getContext()).inflate(adapter.getLayoutId(), (ViewGroup)this, false);
            adapter.bindView(view, adapter.getDatas().get(i), i);
            this.configClick(view, i);
            this.addView(view);
        }
        if (this.mWidth == 0 && this.getWidth() == 0 || this.mVisualCount > 0) {
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (TabFlowLayout.this.getChildCount() > 0) {
                        TabFlowLayout.this.reAdjustLayoutParams();
                        if (TabFlowLayout.this.mAction != null) {
                            TabFlowLayout.this.mAction.config(TabFlowLayout.this);
                            if (TabFlowLayout.this.mViewPager != null) {
                                TabFlowLayout.this.mViewPager.setCurrentItem(TabFlowLayout.this.mCurrentIndex, false);
                            }
                            if (TabFlowLayout.this.mViewPager2 != null) {
                                TabFlowLayout.this.mViewPager2.setCurrentItem(TabFlowLayout.this.mCurrentIndex, false);
                            }
                            TabFlowLayout.this.mAction.chooseIndex(TabFlowLayout.this.mLastIndex, TabFlowLayout.this.mCurrentIndex);
                            TabFlowLayout.this.updateScroll(TabFlowLayout.this.getChildAt(TabFlowLayout.this.mCurrentIndex), false);
                        }
                    }
                }
            }, 5L);
        }
    }

    public void setItemClickByOutSet(int position) {
        this.isItemClick = false;
        if (position >= 0 && position < this.getChildCount()) {
            View view = this.getChildAt(position);
            this.chooseItem(position, view);
        }
    }

    private void configClick(final View view, final int i) {
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TabFlowLayout.this.isItemClick = true;
                TabFlowLayout.this.chooseItem(i, view);
            }
        });
        view.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (TabFlowLayout.this.mAdapter != null) {
                    return TabFlowLayout.this.mAdapter.onItemLongClick(view, i);
                }
                return false;
            }
        });
    }

    private void chooseItem(int position, View view) {
        this.mLastIndex = this.mCurrentIndex;
        this.mCurrentIndex = position;
        if ((this.mViewPager != null || this.mViewPager2 != null) && this.mAction != null) {
            this.mLastIndex = this.mAction.getCurrentIndex();
        }
        if (this.mAction != null) {
            this.mAction.onItemClick(this.mLastIndex, position);
        }
        if (this.mAdapter != null) {
            this.mAdapter.onItemClick(view, this.mAdapter.getDatas().get(position), position);
        }
        if (this.mViewPager == null && this.mViewPager2 == null) {
            this.updateScroll(view, true);
            this.invalidate();
        }
    }

    private void updateScroll(View view, boolean smoothScroll) {
        int scrollPos;
        if (this.isCanMove() && view != null && (scrollPos = this.isVertical() ? view.getTop() : view.getLeft()) != this.mLastScrollPos) {
            if (this.isVertical()) {
                if (scrollPos > this.mHeight / 2) {
                    if ((scrollPos -= this.mHeight / 2) < this.mBottomRound - this.mHeight) {
                        int offset = scrollPos - this.mLastScrollPos;
                        if (smoothScroll) {
                            this.mScroller.startScroll(0, this.getScrollY(), 0, offset);
                        } else {
                            this.scrollTo(0, offset);
                        }
                        this.mLastScrollPos = scrollPos;
                    } else {
                        int offset = this.mBottomRound - this.mHeight - this.getScrollY();
                        if (this.getScrollY() >= this.mBottomRound - this.mHeight) {
                            offset = 0;
                        }
                        if (smoothScroll) {
                            this.mScroller.startScroll(0, this.getScrollY(), 0, offset);
                        } else {
                            this.scrollTo(0, this.mBottomRound - this.mHeight);
                        }
                        this.mLastScrollPos = this.mBottomRound - this.mHeight - offset;
                    }
                } else {
                    int offset = -scrollPos;
                    if (smoothScroll) {
                        this.mScroller.startScroll(0, this.getScrollY(), 0, offset);
                    } else {
                        this.scrollTo(0, 0);
                    }
                    this.mLastScrollPos = 0;
                }
            } else if (scrollPos > this.mWidth / 2) {
                if ((scrollPos -= this.mWidth / 2) < this.mRightBound - this.mWidth) {
                    int offset = scrollPos - this.mLastScrollPos;
                    if (smoothScroll) {
                        this.mScroller.startScroll(this.getScrollX(), 0, offset, 0);
                    } else {
                        this.scrollTo(offset, 0);
                    }
                    this.mLastScrollPos = scrollPos;
                } else {
                    int offset = this.mRightBound - this.mWidth - this.getScrollX();
                    if (this.getScrollX() >= this.mRightBound - this.mWidth) {
                        offset = 0;
                    }
                    if (smoothScroll) {
                        this.mScroller.startScroll(this.getScrollX(), 0, offset, 0);
                    } else {
                        this.scrollTo(this.mRightBound - this.mWidth, 0);
                    }
                    this.mLastScrollPos = this.mRightBound - this.mWidth - offset;
                }
            } else {
                int offset = -scrollPos;
                if (smoothScroll) {
                    this.mScroller.startScroll(this.getScrollX(), 0, offset, 0);
                } else {
                    this.scrollTo(0, 0);
                }
                this.mLastScrollPos = 0;
            }
        }
    }

    @Override
    public void computeScroll() {
        super.computeScroll();
        if (this.mViewPager == null && this.mViewPager2 == null && this.mScroller.computeScrollOffset()) {
            int offset;
            if (this.isVertical()) {
                offset = this.mScroller.getCurrY();
                if (offset >= this.mBottomRound - this.mHeight) {
                    offset = this.mBottomRound - this.mHeight;
                }
            } else {
                offset = this.mScroller.getCurrX();
                if (offset >= this.mRightBound - this.mWidth) {
                    offset = this.mRightBound - this.mWidth;
                }
            }
            if (offset <= 0) {
                offset = 0;
            }
            if (this.isVertical()) {
                this.scrollTo(0, offset);
            } else {
                this.scrollTo(offset, 0);
            }
            this.postInvalidate();
        }
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            state = bundle.getParcelable("instancestatus");
            this.mCurrentIndex = bundle.getInt("index");
            this.mLastIndex = bundle.getInt("lastindex");
        }
        super.onRestoreInstanceState(state);
    }

    @Nullable
    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("instancestatus", super.onSaveInstanceState());
        if (this.mViewPager != null) {
            this.mCurrentIndex = this.mViewPager.getCurrentItem();
            this.mLastIndex = 0;
        } else if (this.mViewPager2 != null) {
            this.mCurrentIndex = this.mViewPager2.getCurrentItem();
            this.mLastIndex = 0;
        } else if (this.mAction != null) {
            this.mLastIndex = this.mAction.getLastIndex();
        }
        bundle.putInt("index", this.mCurrentIndex);
        bundle.putInt("lastindex", this.mLastIndex);
        return bundle;
    }

    public TabFlowLayout setTabBean(TabBean bean) {
        if (bean == null) {
            return this;
        }
        this.mTabBean = AttrsUtils.diffTabBean(this.mTabBean, bean);
        if (bean.tabType != -1) {
            this.chooseTabTpye(bean.tabType);
        }
        if (this.mAction != null && this.mTabBean != null) {
            this.mAction.configAttrs(this.mTabBean);
            if (this.mViewPager != null && this.mAction.getViewPager() == null) {
                this.mAction.setViewPager(this.mViewPager);
            }
            if (this.mViewPager2 != null && this.mAction.getViewPager2() == null) {
                this.mAction.setViewPager(this.mViewPager2);
            }
            this.mAction.setTextId(this.mTextId).setSelectedColor(this.mSelectedColor).setUnSelectedColor(this.mUnSelectedColor);
        }
        this.setTabOrientation(bean.tabOrientation);
        if (bean.visualCount != -1) {
            this.setVisualCount(bean.visualCount);
        }
        return this;
    }

    public TabFlowAdapter getAdapter() {
        return this.mAdapter;
    }

    public void setItemAnim(int position) {
        this.mLastIndex = this.mCurrentIndex;
        this.mCurrentIndex = position;
        if (this.mAction != null) {
            this.mAction.autoScaleView();
            this.mAction.doAnim(this.mLastIndex, this.mCurrentIndex, this.mTabBean.tabClickAnimTime);
        }
    }

    public boolean isItemClick() {
        return this.isItemClick;
    }

    public void setItemClickStatus(boolean isClick) {
        this.isItemClick = isClick;
    }

    @Override
    public boolean isTabAutoScroll() {
        return this.mTabBean.isAutoScroll;
    }

    @Override
    public boolean isLabelFlow() {
        return false;
    }

    class FlowListener
    extends FlowListenerAdapter {
        FlowListener() {
        }

        @Override
        public void notifyDataChanged() {
            super.notifyDataChanged();
            TabFlowLayout.this.notifyChanged();
        }

        @Override
        public void resetAllTextColor(int viewId, int color) {
            super.resetAllTextColor(viewId, color);
            int childCount = TabFlowLayout.this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View view = TabFlowLayout.this.getChildAt(i);
                TextView textView = (TextView)view.findViewById(viewId);
                if (textView == null) continue;
                textView.setTextColor(color);
            }
        }
    }
}

