/*
 * Decompiled with CFR 0.152.
 */
package com.zhengsr.tablib.view.flow;

import android.content.Context;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewParent;
import android.widget.Scroller;
import androidx.annotation.Nullable;
import com.zhengsr.tablib.view.flow.FlowLayout;

class ScrollFlowLayout
extends FlowLayout {
    private static final String TAG = "ScrollFlowLayout";
    private int mTouchSlop;
    private float mLastPos;
    private float mMovePos;
    protected int mRightBound;
    protected int mBottomRound;
    private boolean isCanMove;
    private int mScreenWidth;
    private int mScreenHeight;
    private VelocityTracker mVelocityTracker;
    private Scroller mScroller;
    private int mCurScrollPos;
    private int mMaximumVelocity;
    private int mMinimumVelocity;
    protected boolean isMove;
    protected int mWidth;
    protected int mHeight;

    public ScrollFlowLayout(Context context) {
        this(context, null);
    }

    public ScrollFlowLayout(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ScrollFlowLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.mScreenWidth = this.getResources().getDisplayMetrics().widthPixels;
        this.mScreenHeight = this.getResources().getDisplayMetrics().heightPixels;
        this.mScroller = new Scroller(context);
        this.mMaximumVelocity = ViewConfiguration.get((Context)context).getScaledMaximumFlingVelocity();
        this.mMinimumVelocity = ViewConfiguration.get((Context)context).getScaledMinimumFlingVelocity();
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        int count = this.getChildCount();
        if (count > 0) {
            View child = this.getChildAt(count - 1);
            this.mRightBound = child.getRight() + this.getPaddingRight();
            this.mBottomRound = child.getBottom() + this.getPaddingBottom();
        }
        if (this.isVerticalMove()) {
            if (this.mViewHeight < this.mScreenHeight) {
                this.isCanMove = this.mBottomRound > this.mViewHeight;
                this.mHeight = this.mViewHeight;
            } else {
                if (this.mBottomRound > this.mScreenHeight) {
                    this.isCanMove = true;
                }
                this.mHeight = this.mScreenHeight;
                this.mHeight = this.mHeight - this.getActionBarHeight(this.getContext()) - this.getStatusBarHeight();
            }
            if (!this.isLabelAutoScroll() || !this.isTabAutoScroll()) {
                this.isCanMove = false;
            }
        } else if (!this.isVertical()) {
            if (this.mVisualCount != -1) {
                this.isCanMove = this.getChildCount() > this.mVisualCount;
                this.mWidth = this.mViewWidth;
            } else if (this.mViewWidth < this.mScreenWidth) {
                this.isCanMove = this.mRightBound > this.mViewWidth;
                this.mWidth = this.mViewWidth;
            } else {
                if (this.mRightBound > this.mScreenWidth) {
                    this.isCanMove = true;
                }
                this.mWidth = this.mScreenWidth;
            }
            if (!this.isTabAutoScroll()) {
                this.isCanMove = false;
            }
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (!this.isCanMove) {
            return super.onInterceptTouchEvent(ev);
        }
        ViewParent parent = this.getParent();
        switch (ev.getAction()) {
            case 0: {
                this.mLastPos = this.isVertical() ? ev.getY() : ev.getX();
                this.mMovePos = this.isVertical() ? ev.getY() : ev.getX();
                if (this.mScroller != null && !this.mScroller.isFinished()) {
                    this.mScroller.abortAnimation();
                }
                if (this.mVelocityTracker != null) {
                    this.mVelocityTracker.recycle();
                    this.mVelocityTracker = null;
                }
                this.mVelocityTracker = VelocityTracker.obtain();
                this.mVelocityTracker.addMovement(ev);
                if (parent == null) break;
                parent.requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 2: {
                float offset = this.isVerticalMove() ? ev.getY() - this.mLastPos : ev.getX() - this.mLastPos;
                if (Math.abs(offset) >= (float)this.mTouchSlop) {
                    if (parent != null) {
                        parent.requestDisallowInterceptTouchEvent(true);
                    }
                    if (this.mVelocityTracker == null) {
                        this.mVelocityTracker = VelocityTracker.obtain();
                    }
                    this.mVelocityTracker.addMovement(ev);
                    return true;
                }
                if (this.isVerticalMove()) {
                    this.mLastPos = ev.getY();
                    break;
                }
                this.mLastPos = ev.getX();
                break;
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(event);
        ViewParent parent = this.getParent();
        switch (event.getAction()) {
            case 0: {
                break;
            }
            case 2: {
                int scrollPos;
                int offset = this.isVerticalMove() ? (int)(this.mMovePos - event.getY()) : (int)(this.mMovePos - event.getX());
                if (Math.abs(offset) > this.mTouchSlop && parent != null) {
                    parent.requestDisallowInterceptTouchEvent(true);
                }
                if ((scrollPos = this.isVerticalMove() ? this.getScrollY() : this.getScrollX()) + offset <= 0) {
                    this.scrollTo(0, 0);
                    return true;
                }
                if (this.isVerticalMove()) {
                    if (scrollPos + offset >= this.mBottomRound - this.mHeight) {
                        this.scrollTo(0, this.mBottomRound - this.mHeight);
                        return true;
                    }
                    this.scrollBy(0, offset);
                } else {
                    if (scrollPos + offset >= this.mRightBound - this.mWidth) {
                        this.scrollTo(this.mRightBound - this.mWidth, 0);
                        return true;
                    }
                    this.scrollBy(offset, 0);
                }
                this.isMove = true;
                if (this.isVerticalMove()) {
                    this.mMovePos = event.getY();
                    break;
                }
                this.mMovePos = event.getX();
                break;
            }
            case 1: 
            case 3: {
                this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                int velocityPos = this.isVerticalMove() ? (int)this.mVelocityTracker.getYVelocity() : (int)this.mVelocityTracker.getXVelocity();
                if (Math.abs(velocityPos) < this.mMinimumVelocity) break;
                if (this.isVerticalMove()) {
                    this.mCurScrollPos = this.getScrollY();
                    this.mScroller.fling(0, this.mCurScrollPos, 0, velocityPos, 0, 0, 0, this.getHeight());
                } else {
                    this.mCurScrollPos = this.getScrollX();
                    this.mScroller.fling(this.mCurScrollPos, 0, velocityPos, 0, 0, this.getWidth(), 0, 0);
                }
                if (this.mVelocityTracker == null) break;
                this.mVelocityTracker.clear();
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
                break;
            }
        }
        return super.onTouchEvent(event);
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.mScroller.computeScrollOffset()) {
            int offset = this.isVerticalMove() ? this.mCurScrollPos - this.mScroller.getCurrY() : this.mCurScrollPos - this.mScroller.getCurrX();
            if (this.isVerticalMove()) {
                if (this.getScrollY() + offset >= this.mBottomRound - this.mHeight) {
                    offset = this.mBottomRound - this.mHeight - this.getScrollY();
                }
                if (this.getScrollY() + offset <= 0) {
                    offset = -this.getScrollY();
                }
                this.scrollBy(0, offset);
            } else {
                if (this.getScrollX() + offset >= this.mRightBound - this.mWidth) {
                    offset = this.mRightBound - this.mWidth - this.getScrollX();
                }
                if (this.getScrollX() + offset <= 0) {
                    offset = -this.getScrollX();
                }
                this.scrollBy(offset, 0);
            }
            this.postInvalidate();
        }
    }

    public int getViewWidth() {
        return this.mWidth;
    }

    public boolean isCanMove() {
        return this.isCanMove;
    }

    public boolean isMove() {
        return this.isMove;
    }

    public void setMove(boolean move) {
        this.isMove = move;
    }

    private int getStatusBarHeight() {
        int result = 0;
        int resourceId = this.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = this.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    private int getActionBarHeight(Context context) {
        TypedValue tv = new TypedValue();
        if (context.getTheme().resolveAttribute(16843499, tv, true)) {
            return TypedValue.complexToDimensionPixelSize((int)tv.data, (DisplayMetrics)context.getResources().getDisplayMetrics());
        }
        return 0;
    }

    public boolean isLabelAutoScroll() {
        return true;
    }

    public boolean isTabAutoScroll() {
        return true;
    }
}

