/*
 * Decompiled with CFR 0.152.
 */
package com.zhengsr.tablib.view.flow;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.zhengsr.tablib.R;
import com.zhengsr.tablib.bean.LabelBean;
import com.zhengsr.tablib.callback.FlowListenerAdapter;
import com.zhengsr.tablib.view.adapter.LabelFlowAdapter;
import com.zhengsr.tablib.view.flow.ScrollFlowLayout;
import java.util.ArrayList;
import java.util.List;

public class LabelFlowLayout
extends ScrollFlowLayout {
    private static final String TAG = "LabelFlowLayout";
    private LabelFlowAdapter mAdapter;
    private int mMaxSelectCount;
    private int mLastPosition = -1;
    private boolean isHasMoreView;
    private boolean isHasHandUpView;
    private boolean isAutoScroll;
    private int mShowMoreColor;
    private int mShowMoreLayoutId;
    private int mHandUpLayoutId;
    private Paint mPaint;
    private View mMoreView;
    private Bitmap mBitmap;
    private RectF mBitRect;
    private int mShowMoreLines = -1;
    private View mHandUpView;

    public LabelFlowLayout(Context context) {
        this(context, null);
    }

    public LabelFlowLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LabelFlowLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.LabelFlowLayout);
        this.mMaxSelectCount = ta.getInteger(R.styleable.LabelFlowLayout_label_maxSelectCount, 1);
        this.isAutoScroll = ta.getBoolean(R.styleable.LabelFlowLayout_label_isAutoScroll, true);
        this.mShowMoreLines = ta.getInteger(R.styleable.LabelFlowLayout_label_showLine, -1);
        this.setLabelLines(this.mShowMoreLines);
        this.mShowMoreColor = ta.getColor(R.styleable.LabelFlowLayout_label_showMore_Color, -65536);
        this.mShowMoreLayoutId = ta.getResourceId(R.styleable.LabelFlowLayout_label_showMore_layoutId, -1);
        this.mHandUpLayoutId = ta.getResourceId(R.styleable.LabelFlowLayout_label_handUp_layoutId, -1);
        ta.recycle();
        if (this.mShowMoreLayoutId != -1) {
            this.mMoreView = LayoutInflater.from((Context)this.getContext()).inflate(this.mShowMoreLayoutId, (ViewGroup)this, false);
            this.isHasMoreView = true;
        }
        if (this.mHandUpLayoutId != -1) {
            this.mHandUpView = LayoutInflater.from((Context)this.getContext()).inflate(this.mHandUpLayoutId, (ViewGroup)this, false);
        }
        this.setClickable(true);
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mBitRect = new RectF();
        this.setWillNotDraw(false);
    }

    @Override
    public boolean isLabelAutoScroll() {
        return this.isAutoScroll;
    }

    public void setAdapter(LabelFlowAdapter adapter) {
        this.mAdapter = adapter;
        this.mAdapter.setListener(new LabelListener());
        this.notifyData();
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mMoreView == null || !this.isLabelMoreLine()) {
            return super.onInterceptTouchEvent(ev);
        }
        switch (ev.getAction()) {
            case 0: {
                float x = ev.getX();
                float y = ev.getY();
                if (!this.mBitRect.contains(x, y)) break;
                return true;
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        float y;
        float x;
        if (event.getAction() == 1 && this.mBitRect.contains(x = event.getX(), y = event.getY()) && this.mAdapter != null) {
            this.mBitmap = null;
            if (this.isHasMoreView && this.isLabelMoreLine()) {
                this.setLabelLines(-1);
                this.mAdapter.onShowMoreClick(this.mMoreView);
                if (this.mHandUpView != null) {
                    this.isHasHandUpView = true;
                    this.isHasMoreView = false;
                }
            } else if (this.isHasHandUpView) {
                this.setLabelLines(this.mShowMoreLines);
                this.mAdapter.onHandUpClick(this.mHandUpView);
                if (this.mMoreView != null) {
                    this.isHasHandUpView = false;
                    this.isHasMoreView = true;
                }
            }
            this.requestLayout();
        }
        return super.onTouchEvent(event);
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.isHasMoreView && this.mBitmap == null && this.mMoreView != null) {
            this.mMoreView.layout(0, 0, this.getWidth(), this.mMoreView.getMeasuredHeight());
            this.mMoreView.buildDrawingCache();
            this.mBitmap = this.mMoreView.getDrawingCache();
            LinearGradient shader = new LinearGradient(0.0f, 0.0f, 0.0f, (float)this.getHeight(), 0, this.mShowMoreColor, Shader.TileMode.CLAMP);
            this.mPaint.setShader((Shader)shader);
            this.mBitRect.set((float)l, (float)(this.getHeight() - this.mMoreView.getMeasuredHeight()), (float)r, (float)this.getHeight());
        } else if (this.isHasHandUpView && this.mBitmap == null) {
            this.mHandUpView.layout(0, 0, this.getWidth(), this.mHandUpView.getMeasuredHeight());
            this.mHandUpView.buildDrawingCache();
            this.mBitmap = this.mHandUpView.getDrawingCache();
            this.mBitRect.set((float)l, (float)(this.getHeight() - this.mMoreView.getMeasuredHeight()), (float)r, (float)this.getHeight());
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.isLabelMoreLine() && this.isHasMoreView && this.mBitmap != null) {
            canvas.drawPaint(this.mPaint);
            canvas.drawBitmap(this.mBitmap, this.mBitRect.left, this.mBitRect.top, null);
        } else if (this.isHasHandUpView && this.mBitmap != null) {
            canvas.drawBitmap(this.mBitmap, this.mBitRect.left, this.mBitRect.top, null);
        }
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.isHasMoreView) {
            this.measureChild(this.mMoreView, widthMeasureSpec, heightMeasureSpec);
            this.mViewHeight += this.mMoreView.getMeasuredHeight() / 2;
            this.setMeasuredDimension(this.mLineWidth, this.mViewHeight);
        }
        if (this.isHasHandUpView) {
            this.measureChild(this.mHandUpView, widthMeasureSpec, heightMeasureSpec);
            this.mViewHeight += this.mHandUpView.getMeasuredHeight();
            this.setMeasuredDimension(this.mLineWidth, this.mViewHeight);
        }
    }

    private void notifyData() {
        this.removeAllViews();
        int childCount = this.mAdapter.getItemCount();
        for (int i = 0; i < childCount; ++i) {
            View view = LayoutInflater.from((Context)this.getContext()).inflate(this.mAdapter.getLayoutId(), (ViewGroup)this, false);
            this.mAdapter.bindView(view, this.mAdapter.getDatas().get(i), i);
            this.addView(view);
            this.onItemViewConfig(this.mAdapter, view, i);
        }
    }

    private void onItemViewConfig(LabelFlowAdapter flowAdapter, View view, final int position) {
        final LabelFlowAdapter adapter = flowAdapter;
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                adapter.onItemClick(v, adapter.getDatas().get(position), position);
                if (LabelFlowLayout.this.mMaxSelectCount == 1) {
                    if (LabelFlowLayout.this.mLastPosition != position) {
                        View selectedView = LabelFlowLayout.this.getSelectedView();
                        if (selectedView != null) {
                            selectedView.setSelected(false);
                            adapter.onItemSelectState(selectedView, false);
                        }
                        adapter.onFocusChanged(selectedView, v);
                        if (v.isSelected()) {
                            v.setSelected(false);
                            adapter.onItemSelectState(v, false);
                        } else {
                            v.setSelected(true);
                            adapter.onItemSelectState(v, true);
                        }
                    }
                } else {
                    if (v.isSelected()) {
                        v.setSelected(false);
                        adapter.onItemSelectState(v, false);
                    } else {
                        v.setSelected(true);
                        adapter.onItemSelectState(v, true);
                    }
                    if (LabelFlowLayout.this.getSelectedCount() > LabelFlowLayout.this.mMaxSelectCount) {
                        v.setSelected(false);
                        adapter.onItemSelectState(v, false);
                        adapter.onReachMaxCount(LabelFlowLayout.this.getSelecteds(), LabelFlowLayout.this.mMaxSelectCount);
                        return;
                    }
                }
                LabelFlowLayout.this.mLastPosition = position;
            }
        });
        view.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                return adapter.onItemLongClick(view, position);
            }
        });
    }

    private int getSelectedCount() {
        int count = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            View view = this.getChildAt(i);
            if (!view.isSelected()) continue;
            ++count;
        }
        return count;
    }

    public View getSelectedView() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            View view = this.getChildAt(i);
            if (!view.isSelected()) continue;
            return view;
        }
        return null;
    }

    public List<Integer> getSelecteds() {
        ArrayList<Integer> indexs = new ArrayList<Integer>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            View view = this.getChildAt(i);
            if (!view.isSelected()) continue;
            indexs.add(i);
        }
        return indexs;
    }

    public void setSelects(Integer ... indexs) {
        if (indexs != null && indexs.length > 0) {
            block0: for (int i = 0; i < indexs.length; ++i) {
                for (int j = 0; j < this.getChildCount(); ++j) {
                    View view = this.getChildAt(j);
                    if (j == indexs[i]) {
                        view.setSelected(true);
                        this.mLastPosition = j;
                        if (this.mAdapter == null) continue block0;
                        this.mAdapter.onItemSelectState(view, true);
                        continue block0;
                    }
                    if (this.mAdapter == null) continue;
                    this.mAdapter.onItemSelectState(view, false);
                }
            }
        }
    }

    public void setMaxSelectCount(int nums) {
        if (this.mMaxSelectCount != nums) {
            this.mMaxSelectCount = nums;
        }
    }

    public void setAutoScroll(boolean autoScroll) {
        if (this.isAutoScroll != autoScroll) {
            this.isAutoScroll = autoScroll;
        }
    }

    public void setLabelBean(LabelBean bean) {
        if (this.isAutoScroll != bean.isAutoScroll) {
            this.isAutoScroll = bean.isAutoScroll;
        }
        if (this.mMaxSelectCount != bean.maxSelectCount) {
            this.mMaxSelectCount = bean.maxSelectCount;
        }
        if (this.mShowMoreLines != bean.showLines) {
            this.mShowMoreLines = bean.showLines;
            this.setLabelLines(this.mShowMoreLines);
        }
        if (bean.showMoreLayoutId != -1) {
            this.mShowMoreLayoutId = bean.showMoreLayoutId;
            this.mMoreView = LayoutInflater.from((Context)this.getContext()).inflate(this.mShowMoreLayoutId, (ViewGroup)this, false);
            this.isHasMoreView = true;
        }
        if (bean.showMoreColor != -2) {
            this.mShowMoreColor = bean.showMoreColor;
        }
        if (bean.handUpLayoutId != -1) {
            this.mHandUpLayoutId = bean.handUpLayoutId;
            this.mHandUpView = LayoutInflater.from((Context)this.getContext()).inflate(this.mHandUpLayoutId, (ViewGroup)this, false);
        }
    }

    class LabelListener
    extends FlowListenerAdapter {
        LabelListener() {
        }

        @Override
        public void notifyDataChanged() {
            super.notifyDataChanged();
            LabelFlowLayout.this.notifyData();
        }

        @Override
        public void resetAllStatus() {
            super.resetAllStatus();
            int childCount = LabelFlowLayout.this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View view = LabelFlowLayout.this.getChildAt(i);
                view.setSelected(false);
                LabelFlowLayout.this.mAdapter.onItemSelectState(view, false);
            }
        }
    }
}

