/*
 * Decompiled with CFR 0.152.
 */
package com.zhengsr.tablib.view.action;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.view.View;
import android.view.animation.LinearInterpolator;
import android.widget.TextView;
import com.zhengsr.tablib.bean.TabBean;
import com.zhengsr.tablib.bean.TabTypeEvaluator;
import com.zhengsr.tablib.bean.TabValue;
import com.zhengsr.tablib.view.TabColorTextView;
import com.zhengsr.tablib.view.action.BViewPager;
import com.zhengsr.tablib.view.adapter.TabFlowAdapter;
import com.zhengsr.tablib.view.flow.TabFlowLayout;

public abstract class BaseAction
extends BViewPager {
    private static final String TAG = "BaseAction";
    public Paint mPaint = new Paint();
    public RectF mTabRect;
    protected TabFlowLayout mParentView;
    protected int mViewWidth;
    protected int mRightBound;
    private ValueAnimator mAnimator;
    protected float mOffset;
    protected Context mContext;
    private int mTextViewId = -1;
    private int mUnSelectedColor = -1;
    private int mSelectedColor = -1;
    protected int mCurrentIndex;
    private int mLastIndex;
    private boolean isColorText = false;
    private boolean isTextView = false;
    private boolean isTabClick = false;
    protected TabBean mTabBean;
    private boolean isClickMore = false;

    public BaseAction() {
        this.mPaint.setAntiAlias(true);
        this.mTabRect = new RectF();
    }

    public void config(TabFlowLayout parentView) {
        this.mParentView = parentView;
        if (parentView.getChildCount() > 0 && this.mTabBean != null) {
            View child;
            this.mContext = this.mParentView.getContext();
            this.mViewWidth = this.mParentView.getViewWidth();
            int childCount = this.mParentView.getChildCount();
            if (childCount > 0) {
                child = this.mParentView.getChildAt(childCount - 1);
                this.mRightBound = child.getRight() + this.mParentView.getPaddingRight();
            }
            if ((child = this.mParentView.getChildAt(0)) != null) {
                this.mOffset = this.isVertical() ? (float)this.mTabBean.tabHeight * 1.0f / (float)child.getMeasuredHeight() : (float)this.mTabBean.tabWidth * 1.0f / (float)child.getMeasuredWidth();
                if (this.mTextViewId != -1) {
                    View textView = child.findViewById(this.mTextViewId);
                    if (textView instanceof TabColorTextView) {
                        this.isColorText = true;
                        TabColorTextView colorTextView = (TabColorTextView)textView;
                        colorTextView.setTextColor(colorTextView.getChangeColor());
                    }
                    if (textView instanceof TextView) {
                        this.isTextView = true;
                    }
                }
                if (this.mTabBean.autoScale && this.mTabBean.scaleFactor > 1.0f) {
                    child.setScaleX(this.mTabBean.scaleFactor);
                    child.setScaleY(this.mTabBean.scaleFactor);
                }
                this.mParentView.getAdapter().onItemSelectState(child, true);
            }
        }
    }

    public BaseAction setTextId(int textId) {
        this.mTextViewId = textId;
        return this;
    }

    public BaseAction setSelectedColor(int selectedColor) {
        this.mSelectedColor = selectedColor;
        return this;
    }

    public BaseAction setUnSelectedColor(int unSelectedColor) {
        this.mUnSelectedColor = unSelectedColor;
        return this;
    }

    public void onItemClick(int lastIndex, int curIndex) {
        this.isTabClick = true;
        this.mCurrentIndex = curIndex;
        this.mLastIndex = lastIndex;
        if (this.mViewPager == null) {
            this.autoScaleView();
            this.doAnim(lastIndex, curIndex, this.mTabBean.tabClickAnimTime);
        } else if (Math.abs(this.mCurrentIndex - this.mLastIndex) > 1) {
            this.clearColorText();
            this.isClickMore = true;
            this.autoScaleView();
            this.doAnim(lastIndex, curIndex, this.mTabBean.tabClickAnimTime);
        }
    }

    public void clearColorText() {
        if (this.isColorText && this.mParentView != null && Math.abs(this.mCurrentIndex - this.mLastIndex) > 0) {
            int childCount = this.mParentView.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View view = this.mParentView.getChildAt(i);
                TabColorTextView textview = (TabColorTextView)view.findViewById(this.mTextViewId);
                if (textview == null) continue;
                textview.setTextColor(textview.getDefaultColor());
            }
            View view = this.mParentView.getChildAt(this.mCurrentIndex);
            TabColorTextView colorTextView = (TabColorTextView)view.findViewById(this.mTextViewId);
            if (colorTextView != null) {
                colorTextView.setTextColor(colorTextView.getChangeColor());
            }
        }
    }

    @Override
    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (this.mParentView != null) {
            View curView = this.mParentView.getChildAt(position);
            float offset = (float)curView.getMeasuredWidth() * positionOffset;
            int scrollX = (int)((float)curView.getLeft() + offset);
            if (offset > 0.0f && positionOffset > 0.0f) {
                if (!this.isClickMore && position < this.mParentView.getChildCount() - 1) {
                    View transView = this.mParentView.getChildAt(position + 1);
                    if (this.mTabBean.autoScale && this.mTabBean.scaleFactor > 0.0f) {
                        float factor = this.mTabBean.scaleFactor % 1.0f;
                        float transScale = 1.0f + factor * positionOffset;
                        float curScale = 1.0f + factor * (1.0f - positionOffset);
                        transView.setScaleX(transScale);
                        transView.setScaleY(transScale);
                        curView.setScaleX(curScale);
                        curView.setScaleY(curScale);
                    }
                    float left = (float)curView.getLeft() + positionOffset * (float)(transView.getLeft() - curView.getLeft());
                    float right = (float)curView.getRight() + positionOffset * (float)(transView.getRight() - curView.getRight());
                    if (this.mTabBean.tabWidth != -1) {
                        int width = curView.getMeasuredWidth();
                        left = curView.getLeft() + (width - this.mTabBean.tabWidth) / 2;
                        right = (left += positionOffset * (float)(curView.getMeasuredWidth() + transView.getMeasuredWidth()) / 2.0f) + (float)this.mTabBean.tabWidth;
                    }
                    this.mTabRect.left = left;
                    this.mTabRect.right = right;
                    this.valueChange(new TabValue(this.mTabRect.left, this.mTabRect.right));
                    this.mParentView.postInvalidate();
                    if (this.mTextViewId != -1 && this.isColorText) {
                        View leftView = curView.findViewById(this.mTextViewId);
                        View rightView = transView.findViewById(this.mTextViewId);
                        TabColorTextView colorLeft = (TabColorTextView)leftView;
                        TabColorTextView colorRight = (TabColorTextView)rightView;
                        colorLeft.setprogress(1.0f - positionOffset, 2);
                        colorRight.setprogress(positionOffset, 1);
                    }
                }
                if (this.mParentView.isCanMove()) {
                    if (scrollX > this.mViewWidth / 2 - this.mParentView.getPaddingLeft()) {
                        if ((scrollX -= this.mViewWidth / 2 - this.mParentView.getPaddingLeft()) <= this.mRightBound - this.mViewWidth) {
                            this.mParentView.scrollTo(scrollX, 0);
                        } else {
                            int dx = this.mRightBound - this.mViewWidth;
                            this.mParentView.scrollTo(dx, 0);
                        }
                    } else {
                        this.mParentView.scrollTo(0, 0);
                    }
                }
            }
        }
    }

    @Override
    public void onPageSelected(int position) {
        this.mLastIndex = this.mCurrentIndex;
        this.mCurrentIndex = position;
        this.chooseSelectedPosition(position);
    }

    @Override
    public void onPageScrollStateChanged(int state) {
        if (state == 2 && !this.isTabClick && this.mViewPager != null) {
            this.mLastIndex = this.mCurrentIndex;
            this.mCurrentIndex = this.mViewPager.getCurrentItem();
            if (Math.abs(this.mCurrentIndex - this.mLastIndex) > 1) {
                this.isClickMore = true;
                this.clearColorText();
                this.doAnim(this.mLastIndex, this.mCurrentIndex, this.mTabBean.tabClickAnimTime);
                this.autoScaleView();
            }
        }
        if (state == 0) {
            this.isClickMore = false;
            this.isTabClick = false;
        }
    }

    public void autoScaleView() {
        if (this.mParentView != null && this.mTabBean.autoScale && this.mTabBean.scaleFactor > 1.0f) {
            View lastView = this.mParentView.getChildAt(this.mLastIndex);
            View curView = this.mParentView.getChildAt(this.mCurrentIndex);
            if (lastView != null && curView != null) {
                lastView.animate().scaleX(1.0f).scaleY(1.0f).setDuration((long)this.mTabBean.tabClickAnimTime).setInterpolator((TimeInterpolator)new LinearInterpolator()).start();
                curView.animate().scaleX(this.mTabBean.scaleFactor).scaleY(this.mTabBean.scaleFactor).setDuration((long)this.mTabBean.tabClickAnimTime).setInterpolator((TimeInterpolator)new LinearInterpolator()).start();
            }
        }
    }

    public void doAnim(int lastIndex, int curIndex, int animTime) {
        if (this.mCurrentIndex == this.mLastIndex) {
            return;
        }
        if (this.mAnimator != null) {
            this.mAnimator.cancel();
            this.mAnimator = null;
        }
        if (this.mParentView != null) {
            View curView = this.mParentView.getChildAt(curIndex);
            View lastView = this.mParentView.getChildAt(lastIndex);
            if (curView != null && lastView != null) {
                TabValue lastValue = this.getValue(lastView);
                TabValue curValue = this.getValue(curView);
                if (this.isVertical()) {
                    if (this.mTabBean.tabHeight != -1) {
                        lastValue.top = this.mTabRect.top;
                        lastValue.bottom = this.mTabRect.bottom;
                        int height = curView.getMeasuredHeight();
                        curValue.top = (height - this.mTabBean.tabHeight) / 2 + curView.getTop();
                        curValue.bottom = (float)this.mTabBean.tabHeight + curValue.top;
                    }
                } else if (this.mTabBean.tabWidth != -1) {
                    lastValue.left = this.mTabRect.left;
                    lastValue.right = this.mTabRect.right;
                    int width = curView.getMeasuredWidth();
                    if (this.mTabBean.tabType == 0) {
                        curValue.left = (1.0f - this.mOffset) * (float)width / 2.0f + (float)curView.getLeft();
                        curValue.right = (float)width * this.mOffset + curValue.left;
                    } else {
                        curValue.left = (width - this.mTabBean.tabWidth) / 2 + curView.getLeft();
                        curValue.right = (float)this.mTabBean.tabWidth + curValue.left;
                    }
                }
                this.mAnimator = ObjectAnimator.ofObject((TypeEvaluator)new TabTypeEvaluator(), (Object[])new Object[]{lastValue, curValue});
                this.mAnimator.setDuration((long)animTime);
                this.mAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
                this.mAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animation) {
                        TabValue value = (TabValue)animation.getAnimatedValue();
                        BaseAction.this.valueChange(value);
                        BaseAction.this.mParentView.postInvalidate();
                    }
                });
                this.mAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        TabFlowAdapter adapter;
                        super.onAnimationEnd(animation);
                        if (BaseAction.this.mParentView != null && BaseAction.this.mViewPager == null && (adapter = BaseAction.this.mParentView.getAdapter()) != null) {
                            int count = adapter.getItemCount();
                            for (int i = 0; i < count; ++i) {
                                View child = BaseAction.this.mParentView.getChildAt(i);
                                if (i == BaseAction.this.mCurrentIndex) {
                                    adapter.onItemSelectState(child, true);
                                    continue;
                                }
                                adapter.onItemSelectState(child, false);
                            }
                        }
                    }
                });
                this.mAnimator.start();
            } else if (this.mAnimator != null) {
                this.mAnimator.end();
                this.mAnimator = null;
            }
        }
    }

    public void chooseSelectedPosition(int position) {
        if (this.mTextViewId != -1 && this.mParentView != null && this.isTextView && !this.isColorText) {
            int childCount = this.mParentView.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View view = this.mParentView.getChildAt(i);
                TextView textView = (TextView)view.findViewById(this.mTextViewId);
                if (i == position) {
                    textView.setTextColor(this.mSelectedColor);
                    continue;
                }
                textView.setTextColor(this.mUnSelectedColor);
            }
        }
    }

    public void chooseIndex(int lastIndex, int curIndex) {
        View child;
        this.mCurrentIndex = curIndex;
        this.mLastIndex = lastIndex;
        if (this.mViewPager != null) {
            this.chooseSelectedPosition(curIndex);
        }
        this.clearColorText();
        this.clearScale();
        if (this.mParentView != null && (child = this.mParentView.getChildAt(this.mCurrentIndex)) != null) {
            this.doAnim(this.mLastIndex, this.mCurrentIndex, 0);
            this.mOffset = (float)this.mTabBean.tabWidth * 1.0f / (float)child.getMeasuredWidth();
            if (this.mTextViewId != -1) {
                View textView = child.findViewById(this.mTextViewId);
                if (textView instanceof TabColorTextView) {
                    this.isColorText = true;
                    TabColorTextView colorTextView = (TabColorTextView)textView;
                    colorTextView.setTextColor(colorTextView.getChangeColor());
                }
                if (textView instanceof TextView) {
                    this.isTextView = true;
                }
            }
            if (this.mTabBean.autoScale && this.mTabBean.scaleFactor > 1.0f) {
                child.setScaleX(this.mTabBean.scaleFactor);
                child.setScaleY(this.mTabBean.scaleFactor);
            }
        }
    }

    private void clearScale() {
        if (this.mParentView != null && this.mTabBean.autoScale && this.mTabBean.scaleFactor > 1.0f) {
            int childCount = this.mParentView.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View view = this.mParentView.getChildAt(i);
                view.setScaleY(1.0f);
                view.setScaleX(1.0f);
            }
        }
    }

    private TabValue getValue(View view) {
        TabValue value = new TabValue();
        value.left = view.getLeft() + this.mTabBean.tabMarginLeft;
        value.top = view.getTop() + this.mTabBean.tabMarginTop;
        value.right = view.getRight() - this.mTabBean.tabMarginRight;
        value.bottom = view.getBottom() - this.mTabBean.tabMarginBottom;
        return value;
    }

    protected void valueChange(TabValue value) {
        this.mTabRect.left = value.left;
        this.mTabRect.right = value.right;
    }

    public void configAttrs(TabBean bean) {
        this.mTabBean = bean;
        if (bean.tabColor != -2) {
            this.mPaint.setColor(bean.tabColor);
        }
    }

    public abstract void draw(Canvas var1);

    public int getCurrentIndex() {
        return this.mCurrentIndex;
    }

    public int getLastIndex() {
        return this.mLastIndex;
    }

    public boolean isVertical() {
        return this.mTabBean.tabOrientation == 1;
    }

    public boolean isLeftAction() {
        return this.mTabBean.actionOrientation != -1 && this.mTabBean.actionOrientation == 1;
    }

    public boolean isRightAction() {
        return this.mTabBean.actionOrientation != -1 && this.mTabBean.actionOrientation == 2;
    }

    public void setContext(Context context) {
        this.mContext = context;
    }
}

