/*
 * Decompiled with CFR 0.152.
 */
package com.zhengsr.tablib.view.flow;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;

class FlowLayout
extends ViewGroup {
    private static final String TAG = "FlowLayout";
    protected int mViewWidth;
    protected int mViewHeight;
    private int mTabOrientation;
    protected int mVisualCount = -1;
    protected List<Integer> mLineHeights = new ArrayList<Integer>();
    private List<List<View>> mAllViews = new ArrayList<List<View>>();
    private int mLabelLines = -1;
    private boolean isLabelMoreLine;
    protected int mLineWidth;

    public FlowLayout(Context context) {
        this(context, null);
    }

    public FlowLayout(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FlowLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.isLabelFlow()) {
            this.measureVertical(widthMeasureSpec, heightMeasureSpec);
        } else if (this.mTabOrientation == 2) {
            this.measureTabHorizontal(widthMeasureSpec, heightMeasureSpec);
        } else {
            this.measureTabVertical(widthMeasureSpec, heightMeasureSpec);
        }
    }

    public void setVisualCount(int visualCount) {
        this.mVisualCount = visualCount;
    }

    protected void setLabelLines(int lines) {
        this.mLabelLines = lines;
    }

    public void setTabOrientation(int orientation) {
        this.mTabOrientation = orientation;
    }

    public boolean isLabelFlow() {
        return true;
    }

    private void measureTabVertical(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int childCount = this.getChildCount();
        int width = 0;
        int height = 0;
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            int cw = child.getMeasuredWidth() + params.leftMargin + params.rightMargin;
            int ch = child.getMeasuredHeight() + params.topMargin + params.bottomMargin;
            height += ch;
            width = Math.max(width, cw);
        }
        width = 0x40000000 == widthMode ? widthSize : (width += this.getPaddingLeft() + this.getPaddingRight());
        height = 0x40000000 == heightMode ? heightSize : (height += this.getPaddingTop() + this.getPaddingBottom());
        this.mViewHeight = height;
        this.setMeasuredDimension(width, height);
    }

    private void measureTabHorizontal(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int childCount = this.getChildCount();
        int width = 0;
        int height = 0;
        int widthPixels = this.getResources().getDisplayMetrics().widthPixels;
        if (0x40000000 == widthMode) {
            widthPixels = widthSize;
        }
        for (int i = 0; i < childCount; ++i) {
            int cw;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            if (this.mVisualCount != -1) {
                params.width = cw = widthPixels / this.mVisualCount;
                child.setLayoutParams((ViewGroup.LayoutParams)params);
                width = widthPixels;
            } else {
                cw = child.getMeasuredWidth() + params.leftMargin + params.rightMargin;
                width += cw;
            }
            int ch = child.getMeasuredHeight() + params.topMargin + params.bottomMargin;
            height = Math.max(height, ch);
        }
        height = 0x40000000 == heightMode ? heightSize : height + this.getPaddingTop() + this.getPaddingBottom();
        width = 0x40000000 == widthMode ? widthSize : (width += this.getPaddingLeft() + this.getPaddingRight());
        this.mViewWidth = width;
        this.setMeasuredDimension(width, height);
    }

    private void measureVertical(int widthMeasureSpec, int heightMeasureSpec) {
        this.mAllViews.clear();
        this.mLineHeights.clear();
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int count = this.getChildCount();
        int lineWidth = 0;
        int lineHeight = 0;
        int height = 0;
        ArrayList<View> lineViews = new ArrayList<View>();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            int cWidth = child.getMeasuredWidth() + params.leftMargin + params.rightMargin;
            int cHeight = child.getMeasuredHeight() + params.topMargin + params.bottomMargin;
            if (lineWidth + cWidth > widthSize - (this.getPaddingLeft() + this.getPaddingRight())) {
                height += lineHeight;
                this.mLineHeights.add(lineHeight);
                this.mAllViews.add(lineViews);
                lineViews = new ArrayList();
                lineViews.add(child);
                lineWidth = cWidth;
                lineHeight = cHeight;
                if (this.mLabelLines != -1 && this.mLineHeights.size() >= this.mLabelLines) {
                    this.isLabelMoreLine = true;
                    break;
                }
                this.isLabelMoreLine = false;
            } else {
                lineHeight = Math.max(lineHeight, cHeight);
                this.mLineWidth = Math.max(this.mLineWidth, lineWidth += cWidth);
                lineViews.add(child);
            }
            if (i != count - 1) continue;
            height += lineHeight;
            this.mLineHeights.add(lineHeight);
            this.mAllViews.add(lineViews);
        }
        if (heightMode == 0x40000000) {
            height = heightSize;
        } else if (heightMode == Integer.MIN_VALUE) {
            height = Math.min(height, heightSize);
            height += this.getPaddingTop() + this.getPaddingBottom();
        } else {
            height += this.getPaddingTop() + this.getPaddingBottom();
        }
        this.mViewHeight = height;
        this.setMeasuredDimension(widthSize, height);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.isLabelFlow()) {
            int size = this.mAllViews.size();
            int left = this.getPaddingLeft();
            int top = this.getPaddingTop();
            for (int i = 0; i < size; ++i) {
                List<View> lineViews = this.mAllViews.get(i);
                int count = lineViews.size();
                for (int j = 0; j < count; ++j) {
                    View child = lineViews.get(j);
                    ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
                    int cWidth = child.getMeasuredWidth();
                    int cHeight = child.getMeasuredHeight();
                    int cl = left + params.leftMargin;
                    int ct = top + params.topMargin;
                    int cr = cl + cWidth;
                    int cb = ct + cHeight;
                    child.layout(cl, ct, cr, cb);
                    left += cWidth + params.leftMargin + params.rightMargin;
                }
                left = this.getPaddingLeft();
                top += this.mLineHeights.get(i).intValue();
            }
        } else {
            int count = this.getChildCount();
            int left = this.getPaddingLeft();
            int top = this.getPaddingTop();
            for (int i = 0; i < count; ++i) {
                View child = this.getChildAt(i);
                ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
                int cl = this.isVertical() ? (this.getWidth() - child.getMeasuredWidth()) / 2 : left + params.leftMargin;
                int ct = top + params.topMargin;
                int cr = cl + child.getMeasuredWidth();
                int cb = ct + child.getMeasuredHeight();
                child.layout(cl, ct, cr, cb);
                if (this.mTabOrientation == 2) {
                    left += child.getMeasuredWidth() + params.leftMargin + params.rightMargin;
                    continue;
                }
                top += child.getMeasuredHeight() + params.topMargin + params.bottomMargin;
            }
        }
    }

    public boolean isVertical() {
        return this.mTabOrientation == 1;
    }

    public boolean isVerticalMove() {
        return this.isVertical() || this.isLabelFlow();
    }

    public boolean isLabelMoreLine() {
        return this.isLabelMoreLine;
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.MarginLayoutParams(-2, -2);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new ViewGroup.MarginLayoutParams(p);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attrs);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof ViewGroup.MarginLayoutParams;
    }
}

