/*
 * Decompiled with CFR 0.152.
 */
package com.zhengsr.tablib.view.action;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.view.View;
import com.zhengsr.tablib.bean.TabValue;
import com.zhengsr.tablib.view.action.BaseAction;
import com.zhengsr.tablib.view.flow.TabFlowLayout;

public class RectAction
extends BaseAction {
    private static final String TAG = "RectAction";

    @Override
    public void config(TabFlowLayout parentView) {
        super.config(parentView);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        View child = parentView.getChildAt(this.mCurrentIndex);
        if (child != null && this.mTabRect.isEmpty()) {
            float l = 0.0f;
            float t = 0.0f;
            float r = 0.0f;
            float b = 0.0f;
            if (this.isLeftAction()) {
                l = child.getLeft() + this.mTabBean.tabMarginLeft;
                t = child.getTop() + this.mTabBean.tabMarginTop;
                r = l + (float)this.mTabBean.tabWidth;
                b = t + (float)child.getBottom() - (float)this.mTabBean.tabMarginBottom;
                if (this.mTabBean.tabHeight != -1) {
                    b = (t += (float)((child.getMeasuredHeight() - this.mTabBean.tabHeight) / 2)) + (float)this.mTabBean.tabHeight;
                }
            } else if (this.isRightAction()) {
                l = child.getRight() - this.mTabBean.tabMarginRight;
                t = child.getTop() - this.mTabBean.tabMarginTop;
                r = l - (float)this.mTabBean.tabWidth;
                b = t + (float)this.mTabBean.tabHeight;
                if (this.mTabBean.tabHeight != -1) {
                    b = (t += (float)((child.getMeasuredHeight() - this.mTabBean.tabHeight) / 2)) + (float)this.mTabBean.tabHeight;
                }
            } else {
                l = this.mTabBean.tabMarginLeft + child.getLeft();
                t = this.mTabBean.tabMarginTop + child.getBottom() - this.mTabBean.tabHeight - this.mTabBean.tabMarginBottom;
                r = child.getRight() - this.mTabBean.tabMarginRight;
                b = t + (float)this.mTabBean.tabHeight;
                if (this.mTabBean.tabWidth != -1) {
                    r = (float)this.mTabBean.tabWidth + (l += (float)((child.getMeasuredWidth() - this.mTabBean.tabWidth) / 2));
                }
            }
            this.mTabRect.set(l, t, r, b);
        }
        parentView.postInvalidate();
    }

    @Override
    protected void valueChange(TabValue value) {
        if (this.isVertical()) {
            this.mTabRect.top = value.top;
            this.mTabRect.bottom = value.bottom;
            if (this.isLeftAction()) {
                this.mTabRect.left = value.left;
                this.mTabRect.right = (float)this.mTabBean.tabWidth + this.mTabRect.left;
            } else {
                this.mTabRect.left = value.right;
                this.mTabRect.right = this.mTabRect.left - (float)this.mTabBean.tabWidth;
            }
        } else {
            super.valueChange(value);
        }
    }

    @Override
    public void draw(Canvas canvas) {
        canvas.drawRect(this.mTabRect, this.mPaint);
    }
}

