/*
 * Decompiled with CFR 0.152.
 */
package com.zhengsr.tablib.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import androidx.appcompat.widget.AppCompatTextView;
import com.zhengsr.tablib.R;

public class TabColorTextView
extends AppCompatTextView {
    private static final String TAG = "ColorTextView";
    public static final int DEC_LEFT = 1;
    public static final int DEC_RIGHT = 2;
    private Paint mPaint;
    private int mWidth;
    private int mHeight;
    private int mDefaultColor;
    private int mChangeColor;
    private int mDecection = 1;
    private boolean isUseUserColor = false;
    private float mProgress = 0.0f;

    public TabColorTextView(Context context) {
        this(context, null);
    }

    public TabColorTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
        this.setIncludeFontPadding(false);
    }

    public TabColorTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.TabColorTextView);
        this.mDefaultColor = ta.getColor(R.styleable.TabColorTextView_colortext_default_color, -7829368);
        this.mChangeColor = ta.getColor(R.styleable.TabColorTextView_colortext_change_color, -1);
        ta.recycle();
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setDither(true);
        this.mPaint.setTextSize(this.getTextSize());
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.mWidth = this.getMeasuredWidth();
        this.mHeight = this.getMeasuredHeight();
    }

    public void setCusTextColor(int defaultColor, int changeColor) {
        this.mDefaultColor = defaultColor;
        this.mChangeColor = changeColor;
        this.isUseUserColor = false;
        this.invalidate();
    }

    public void setprogress(float progress, int decection) {
        this.isUseUserColor = false;
        this.mDecection = decection;
        this.mProgress = progress;
        this.invalidate();
    }

    public void setTextColor(int color) {
        super.setTextColor(color);
        this.isUseUserColor = true;
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        if (this.isUseUserColor) {
            super.onDraw(canvas);
        } else if (this.mDecection == 2) {
            this.drawText(canvas, 0, this.mWidth, this.mDefaultColor);
            this.drawText(canvas, (int)((1.0f - this.mProgress) * (float)this.mWidth), this.mWidth, this.mChangeColor);
        } else {
            this.drawText(canvas, 0, this.mWidth, this.mDefaultColor);
            this.drawText(canvas, 0, (int)(this.mProgress * (float)this.mWidth), this.mChangeColor);
        }
    }

    private void drawText(Canvas canvas, int start, int end, int color) {
        this.mPaint.setColor(color);
        canvas.save();
        canvas.clipRect(start, 0, end, this.mHeight);
        String text = this.getText().toString();
        float textWidth = this.mPaint.measureText(text);
        float x = ((float)this.mWidth - textWidth) / 2.0f;
        Paint.FontMetrics metrics = this.mPaint.getFontMetrics();
        float dy = (metrics.descent + metrics.ascent) / 2.0f;
        float ty = (float)(this.mHeight / 2) - dy;
        canvas.drawText(text, x, ty, this.mPaint);
        canvas.restore();
    }

    public int getChangeColor() {
        return this.mChangeColor;
    }

    public int getDefaultColor() {
        return this.mDefaultColor;
    }
}

