/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.plugins;

import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.SimpleBookmark;
import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import com.lowagie.toolbox.arguments.FileArgument;
import com.lowagie.toolbox.arguments.filters.PdfFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class XML2Bookmarks
extends AbstractTool {
    public XML2Bookmarks() {
        this.arguments.add(new FileArgument((AbstractTool)this, "xmlfile", "the bookmarks in XML", false));
        this.arguments.add(new FileArgument(this, "pdffile", "the PDF to which you want to add bookmarks", false, new PdfFilter()));
        this.arguments.add(new FileArgument(this, "destfile", "the resulting PDF", true, new PdfFilter()));
    }

    @Override
    protected void createFrame() {
        this.internalFrame = new JInternalFrame("XML + PDF = PDF", true, true, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== XML2Bookmarks OPENED ===");
    }

    @Override
    public void execute() {
        try {
            if (this.getValue("xmlfile") == null) {
                throw new InstantiationException("You need to choose an xml file");
            }
            if (this.getValue("pdffile") == null) {
                throw new InstantiationException("You need to choose a source PDF file");
            }
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination PDF file");
            }
            FileInputStream bmReader = new FileInputStream((File)this.getValue("xmlfile"));
            List bookmarks = SimpleBookmark.importFromXML((InputStream)bmReader);
            bmReader.close();
            PdfReader reader = new PdfReader(((File)this.getValue("pdffile")).getAbsolutePath());
            reader.consolidateNamedDestinations();
            PdfStamper stamper = new PdfStamper(reader, (OutputStream)new FileOutputStream((File)this.getValue("destfile")));
            stamper.setOutlines(bookmarks);
            stamper.setViewerPreferences(reader.getSimpleViewerPreferences() | 0x80);
            stamper.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.internalFrame, e.getMessage(), e.getClass().getName(), 0);
            System.err.println(e.getMessage());
        }
    }

    @Override
    public void valueHasChanged(AbstractArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] args) {
        XML2Bookmarks tool = new XML2Bookmarks();
        if (args.length < 3) {
            System.err.println(tool.getUsage());
        }
        tool.setMainArguments(args);
        tool.execute();
    }

    @Override
    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }

    static {
        XML2Bookmarks.addVersion("$Id: XML2Bookmarks.java 3373 2008-05-12 16:21:24Z xlv $");
    }
}

