/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.arguments;

import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.JColorChooser;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ColorArgument
extends AbstractArgument {
    public ColorArgument() {
    }

    public ColorArgument(AbstractTool tool, String name, String description) {
        super(tool, name, description, null);
    }

    @Override
    public Object getArgument() throws InstantiationException {
        if (this.value == null) {
            return null;
        }
        try {
            return Color.decode(this.value.toString());
        }
        catch (Exception e) {
            throw new InstantiationException(e.getMessage());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Color initialColor = new Color(255, 255, 255);
        if (this.value != null) {
            initialColor = Color.decode(this.value.toString());
        }
        Color newColor = JColorChooser.showDialog(this.tool.getInternalFrame(), "Choose Color", initialColor);
        this.setValue("0x" + Integer.toHexString(newColor.getRed() << 16 | newColor.getGreen() << 8 | newColor.getBlue() << 0).toUpperCase());
    }
}

