/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.plugins;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfIndirectObject;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.PushbuttonField;
import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import com.lowagie.toolbox.arguments.FileArgument;
import com.lowagie.toolbox.arguments.StringArgument;
import com.lowagie.toolbox.arguments.filters.PdfFilter;
import com.lowagie.toolbox.arguments.filters.U3DFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Add3D
extends AbstractTool {
    FileArgument destfile = null;
    public static final String PDF_NAME_3D = "3D";
    public static final String PDF_NAME_3DD = "3DD";
    public static final String PDF_NAME_3DV = "3DV";
    public static final String PDF_NAME_3DVIEW = "3DView";
    public static final String PDF_NAME_C2W = "C2W";
    public static final String PDF_NAME_IN = "IN";
    public static final String PDF_NAME_MS = "MS";
    public static final String PDF_NAME_U3D = "U3D";
    public static final String PDF_NAME_XN = "XN";

    public Add3D() {
        this.menuoptions = 3;
        FileArgument inputfile = new FileArgument(this, "srcfile", "The file you want to add the u3d File", false, new PdfFilter());
        this.arguments.add(inputfile);
        FileArgument u3dinputfile = new FileArgument(this, "srcu3dfile", "The u3d file you want to add", false, new U3DFilter());
        this.arguments.add(u3dinputfile);
        StringArgument pagenumber = new StringArgument(this, "pagenumber", "The pagenumber where to add the u3d annotation");
        pagenumber.setValue("1");
        this.arguments.add(pagenumber);
        this.destfile = new FileArgument(this, "destfile", "The file that contains the u3d annotation after processing", true, new PdfFilter());
        this.arguments.add(this.destfile);
        inputfile.addPropertyChangeListener(this.destfile);
    }

    @Override
    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Add3D", true, true, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Add3D OPENED ===");
    }

    @Override
    public void execute() {
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            if (this.getValue("srcu3dfile") == null) {
                throw new InstantiationException("You need to choose a u3d file");
            }
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            int pagenumber = Integer.parseInt((String)this.getValue("pagenumber"));
            PdfReader reader = new PdfReader(((File)this.getValue("srcfile")).getAbsolutePath());
            String u3dFileName = ((File)this.getValue("srcu3dfile")).getAbsolutePath();
            PdfStamper stamp = new PdfStamper(reader, (OutputStream)new FileOutputStream((File)this.getValue("destfile")));
            PdfWriter wr = stamp.getWriter();
            PdfContentByte cb = stamp.getUnderContent(pagenumber);
            Rectangle rectori = reader.getCropBox(pagenumber);
            Rectangle rect = new Rectangle(new Rectangle(100.0f, rectori.getHeight() - 550.0f, rectori.getWidth() - 100.0f, rectori.getHeight() - 150.0f));
            PdfStream oni = new PdfStream(PdfEncodings.convertToBytes((String)"runtime.setCurrentTool(\"Rotate\");", null));
            oni.flateCompress();
            PdfStream stream = new PdfStream((InputStream)new FileInputStream(u3dFileName), wr);
            stream.put(new PdfName("OnInstantiate"), (PdfObject)wr.addToBody((PdfObject)oni).getIndirectReference());
            stream.put(PdfName.TYPE, (PdfObject)new PdfName(PDF_NAME_3D));
            stream.put(PdfName.SUBTYPE, (PdfObject)new PdfName(PDF_NAME_U3D));
            stream.flateCompress();
            PdfIndirectReference streamRef = wr.addToBody((PdfObject)stream).getIndirectReference();
            stream.writeLength();
            PdfDictionary dict = new PdfDictionary(new PdfName(PDF_NAME_3DVIEW));
            dict.put(new PdfName(PDF_NAME_XN), (PdfObject)new PdfString("Default"));
            dict.put(new PdfName(PDF_NAME_IN), (PdfObject)new PdfString("Unnamed"));
            dict.put(new PdfName(PDF_NAME_MS), (PdfObject)PdfName.M);
            dict.put(new PdfName(PDF_NAME_C2W), (PdfObject)new PdfArray(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f, 3.0f, -235.0f, 28.0f}));
            dict.put(PdfName.CO, (PdfObject)new PdfNumber(235));
            PdfIndirectObject objRef = wr.addToBody((PdfObject)dict);
            PdfAppearance ap = cb.createAppearance(rect.getRight() - rect.getLeft(), rect.getTop() - rect.getBottom());
            ap.setBoundingBox(rect);
            PdfAnnotation annot = new PdfAnnotation(wr, rect);
            annot.put(PdfName.CONTENTS, (PdfObject)new PdfString("3D Model"));
            annot.put(PdfName.SUBTYPE, (PdfObject)new PdfName(PDF_NAME_3D));
            annot.put(PdfName.TYPE, (PdfObject)PdfName.ANNOT);
            annot.put(new PdfName(PDF_NAME_3DD), (PdfObject)streamRef);
            annot.put(new PdfName(PDF_NAME_3DV), (PdfObject)objRef.getIndirectReference());
            annot.put(new PdfName("3DI"), (PdfObject)PdfBoolean.PDFFALSE);
            PdfDictionary adi = new PdfDictionary();
            adi.put(PdfName.A, (PdfObject)new PdfName("PO"));
            adi.put(new PdfName("DIS"), (PdfObject)PdfName.I);
            annot.put(new PdfName("3DA"), (PdfObject)adi);
            annot.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, (PdfTemplate)ap);
            annot.setPage();
            stamp.addAnnotation(annot, pagenumber);
            Add3D.AddButton(100.0f, 100.0f, "Rotate", "im = this.getAnnots3D(0)[0].context3D;\rim.runtime.setCurrentTool(\"Rotate\");", "rotate.png", wr);
            Add3D.AddButton(150.0f, 100.0f, "Pan", "im = this.getAnnots3D(0)[0].context3D;\rim.runtime.setCurrentTool(\"Pan\");", "translate.png", wr);
            Add3D.AddButton(200.0f, 100.0f, "Zoom", "im = this.getAnnots3D(0)[0].context3D;\rim.runtime.setCurrentTool(\"Zoom\");", "zoom.png", wr);
            stamp.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.internalFrame, e.getMessage(), e.getClass().getName(), 0);
            System.err.println(e.getMessage());
        }
    }

    public static void AddButton(float x, float y, String fname, String js, String image, PdfWriter wr) {
        try {
            Image img = Image.getInstance((String)image);
            PushbuttonField bt = new PushbuttonField(wr, new Rectangle(x, y, x + img.getPlainWidth(), y + img.getPlainHeight()), fname);
            bt.setLayout(2);
            bt.setImage(img);
            PdfFormField ff = bt.getField();
            PdfAction ac = PdfAction.javaScript((String)js, (PdfWriter)wr);
            ff.setAction(ac);
            wr.addAnnotation((PdfAnnotation)ff);
        }
        catch (DocumentException | IOException throwable) {
            // empty catch block
        }
    }

    @Override
    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }

    @Override
    public void valueHasChanged(AbstractArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
        if (this.destfile.getValue() == null && arg.getName().equalsIgnoreCase("srcfile")) {
            String filename = arg.getValue().toString();
            String filenameout = filename.substring(0, filename.indexOf(".", filename.length() - 4)) + "_out.pdf";
            this.destfile.setValue(filenameout);
        }
    }

    public static void main(String[] args) {
        Add3D add3d = new Add3D();
        if (args.length != 4) {
            System.err.println(add3d.getUsage());
        }
        add3d.setMainArguments(args);
        add3d.execute();
    }

    static {
        Add3D.addVersion("$Id: Add3D.java 3373 2008-05-12 16:21:24Z xlv $");
    }
}

