/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.visibility.hiders;

import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.utils.BukkitPlayerHidingUtil;
import de.myzelyam.supervanish.visibility.hiders.PlayerHider;
import de.myzelyam.supervanish.visibility.hiders.modules.PlayerInfoModule;
import java.util.Set;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PreventionHider
extends PlayerHider
implements Runnable {
    private int taskId;

    public PreventionHider(SuperVanish plugin) {
        super(plugin);
        this.taskId = plugin.getServer().getScheduler().runTaskTimer((Plugin)plugin, (Runnable)this, 1L, 1L).getTaskId();
        if (plugin.isUseProtocolLib() && plugin.getVersionUtil().isOneDotXOrHigher(8) && plugin.getSettings().getBoolean("InvisibilityFeatures.ModifyTablistPackets", true)) {
            PlayerInfoModule.register(plugin, this);
        }
    }

    @Override
    public boolean setHidden(Player player, Player viewer, boolean hide) {
        boolean wasHidden = this.isHidden(player, viewer);
        if (!wasHidden && hide && player != viewer) {
            BukkitPlayerHidingUtil.hidePlayer(player, viewer, this.plugin);
        }
        boolean stateChanged = super.setHidden(player, viewer, hide);
        if (wasHidden && !hide && player != viewer) {
            BukkitPlayerHidingUtil.showPlayer(player, viewer, this.plugin);
        }
        return stateChanged;
    }

    @Override
    public boolean supportsShowInTab() {
        return false;
    }

    @Override
    public String getName() {
        return "Prevention";
    }

    @Override
    public void run() {
        for (Player hidden : this.playerHiddenFromPlayersMap.keySet()) {
            if (BukkitPlayerHidingUtil.isNewPlayerHidingAPISupported(hidden)) {
                this.plugin.getServer().getScheduler().cancelTask(this.taskId);
                return;
            }
            for (Player viewer : (Set)this.playerHiddenFromPlayersMap.get(hidden)) {
                BukkitPlayerHidingUtil.hidePlayer(hidden, viewer, this.plugin);
            }
        }
    }
}

