/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.visibility.hiders;

import com.google.common.collect.ImmutableSet;
import de.myzelyam.supervanish.SuperVanish;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public abstract class PlayerHider
implements Listener {
    protected final SuperVanish plugin;
    protected final Map<Player, Set<Player>> playerHiddenFromPlayersMap = new ConcurrentHashMap<Player, Set<Player>>();

    public PlayerHider(SuperVanish plugin) {
        this.plugin = plugin;
        this.registerQuitListener();
    }

    public abstract String getName();

    public abstract boolean supportsShowInTab();

    public boolean getShowInTab() {
        return !this.plugin.getSettings().getBoolean("InvisibilityFeatures.HideInTablist") && this.supportsShowInTab();
    }

    public boolean isHidden(Player player, Player viewer) {
        return !player.getUniqueId().equals(viewer.getUniqueId()) && this.playerHiddenFromPlayersMap.containsKey(player) && this.playerHiddenFromPlayersMap.get(player).contains(viewer);
    }

    public boolean isHidden(UUID playerUUID, Player viewer) {
        if (playerUUID.equals(viewer.getUniqueId())) {
            return false;
        }
        for (Player p : this.playerHiddenFromPlayersMap.keySet()) {
            if (!p.getUniqueId().equals(playerUUID)) continue;
            return this.playerHiddenFromPlayersMap.get(p).contains(viewer);
        }
        return false;
    }

    public boolean isHidden(String playerName, Player viewer) {
        if (playerName.equalsIgnoreCase(viewer.getName())) {
            return false;
        }
        for (Player p : this.playerHiddenFromPlayersMap.keySet()) {
            if (!p.getName().equalsIgnoreCase(playerName)) continue;
            return this.playerHiddenFromPlayersMap.get(p).contains(viewer);
        }
        return false;
    }

    public boolean setHidden(Player player, Player viewer, boolean hidden) {
        if (!this.playerHiddenFromPlayersMap.containsKey(player)) {
            this.playerHiddenFromPlayersMap.put(player, new HashSet());
        }
        if (viewer == player) {
            return false;
        }
        Set<Player> hiddenFromPlayers = this.playerHiddenFromPlayersMap.get(player);
        if (hidden && !hiddenFromPlayers.contains(viewer)) {
            hiddenFromPlayers.add(viewer);
            return true;
        }
        if (!hidden && hiddenFromPlayers.contains(viewer)) {
            hiddenFromPlayers.remove(viewer);
            return true;
        }
        return false;
    }

    public Set<Player> getHiddenPlayerKeys() {
        return this.playerHiddenFromPlayersMap.keySet();
    }

    private void registerQuitListener() {
        this.plugin.getServer().getPluginManager().registerEvents(new Listener(){

            @EventHandler(priority=EventPriority.MONITOR)
            public void onQuit(final PlayerQuitEvent e) {
                PlayerHider.this.plugin.getServer().getScheduler().runTaskLater((Plugin)PlayerHider.this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        PlayerHider.this.playerHiddenFromPlayersMap.remove(e.getPlayer());
                        for (Player p : ImmutableSet.copyOf(PlayerHider.this.playerHiddenFromPlayersMap.keySet())) {
                            PlayerHider.this.playerHiddenFromPlayersMap.get(p).remove(e.getPlayer());
                        }
                    }
                }, 1L);
            }
        }, (Plugin)this.plugin);
    }
}

