/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.visibility;

import de.myzelyam.api.vanish.PlayerHideEvent;
import de.myzelyam.api.vanish.PlayerShowEvent;
import de.myzelyam.api.vanish.PostPlayerHideEvent;
import de.myzelyam.api.vanish.PostPlayerShowEvent;
import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.utils.Validation;
import de.myzelyam.supervanish.visibility.hiders.PlayerHider;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class VisibilityChanger {
    private final PlayerHider hider;
    private final SuperVanish plugin;
    private final FileConfiguration config;

    public VisibilityChanger(PlayerHider hider, SuperVanish plugin) {
        this.plugin = plugin;
        this.hider = hider;
        this.config = plugin.getSettings();
    }

    public void hidePlayer(Player player) {
        this.hidePlayer(player, null, false);
    }

    public void showPlayer(Player player) {
        this.showPlayer(player, null, false);
    }

    public void hidePlayer(Player player, String hiderName) {
        this.hidePlayer(player, hiderName, false);
    }

    public void showPlayer(Player player, String hiderName) {
        this.showPlayer(player, hiderName, false);
    }

    public void hidePlayer(Player player, String hiderName, boolean silent) {
        try {
            Validation.checkNotNull("player cannot be null", player);
            if (this.plugin.getVanishStateMgr().isVanished(player.getUniqueId())) {
                this.plugin.log(Level.WARNING, "Failed to hide " + player.getName() + " since that player is already invisible.");
                return;
            }
            PlayerHideEvent e = new PlayerHideEvent(player, silent);
            this.plugin.getServer().getPluginManager().callEvent((Event)e);
            if (e.isCancelled()) {
                return;
            }
            silent = e.isSilent();
            this.plugin.getVanishStateMgr().setVanishedState(player.getUniqueId(), player.getName(), true, hiderName);
            player.setMetadata("vanished", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                if (this.plugin.hasPermissionToSee(onlinePlayer, player)) continue;
                this.plugin.getVisibilityChanger().getHider().setHidden(player, onlinePlayer, true);
            }
            if (this.config.getBoolean("InvisibilityFeatures.Fly.Enable")) {
                player.setAllowFlight(true);
            }
            if (this.plugin.getActionBarMgr() != null && this.config.getBoolean("MessageOptions.DisplayActionBar")) {
                this.plugin.getActionBarMgr().addActionBar(player);
            }
            player.setSleepingIgnored(true);
            if (hiderName == null) {
                this.plugin.sendMessage((CommandSender)player, "OnVanish", player);
            } else {
                this.plugin.sendMessage((CommandSender)player, "OnVanishCausedByOtherPlayer", player, hiderName);
            }
            try {
                player.spigot().setCollidesWithEntities(false);
            }
            catch (NoClassDefFoundError | NoSuchMethodError linkageError) {
                // empty catch block
            }
            PostPlayerHideEvent e2 = new PostPlayerHideEvent(player, silent);
            this.plugin.getServer().getPluginManager().callEvent((Event)e2);
        }
        catch (Exception e) {
            this.plugin.logException(e);
        }
    }

    public void showPlayer(Player player, String showerName, boolean silent) {
        try {
            Validation.checkNotNull("player cannot be null", player);
            if (!this.plugin.getVanishStateMgr().isVanished(player.getUniqueId())) {
                this.plugin.log(Level.WARNING, "Failed to show " + player.getName() + " since that player is already visible.");
                return;
            }
            PlayerShowEvent e = new PlayerShowEvent(player, silent);
            this.plugin.getServer().getPluginManager().callEvent((Event)e);
            if (e.isCancelled()) {
                return;
            }
            silent = e.isSilent();
            player.removeMetadata("vanished", (Plugin)this.plugin);
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                if (this.plugin.hasPermissionToSee(onlinePlayer, player)) continue;
                this.plugin.getVisibilityChanger().getHider().setHidden(player, onlinePlayer, false);
            }
            if (this.plugin.getActionBarMgr() != null && this.config.getBoolean("MessageOptions.DisplayActionBar")) {
                this.plugin.getActionBarMgr().removeActionBar(player);
            }
            player.setSleepingIgnored(false);
            this.plugin.getVanishStateMgr().setVanishedState(player.getUniqueId(), player.getName(), false, showerName);
            if (showerName == null) {
                this.plugin.sendMessage((CommandSender)player, "OnReappear", player);
            } else {
                this.plugin.sendMessage((CommandSender)player, "OnReappearCausedByOtherPlayer", player, showerName);
            }
            try {
                player.spigot().setCollidesWithEntities(true);
            }
            catch (NoClassDefFoundError | NoSuchMethodError linkageError) {
                // empty catch block
            }
            if (this.config.getBoolean("InvisibilityFeatures.Fly.DisableOnReappear") && !player.hasPermission("sv.keepfly") && (player.getGameMode() == GameMode.SURVIVAL || player.getGameMode() == GameMode.ADVENTURE) && this.config.getBoolean("InvisibilityFeatures.Fly.Enable")) {
                player.setAllowFlight(false);
            }
            PostPlayerShowEvent e2 = new PostPlayerShowEvent(player, silent);
            this.plugin.getServer().getPluginManager().callEvent((Event)e2);
        }
        catch (Exception e) {
            this.plugin.logException(e);
        }
    }

    public PlayerHider getHider() {
        return this.hider;
    }
}

