/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.visibility;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedServerPing;
import de.myzelyam.supervanish.SuperVanish;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;

public class ServerListPacketListener
extends PacketAdapter {
    private final SuperVanish plugin;

    public ServerListPacketListener(SuperVanish plugin) {
        super((Plugin)plugin, ListenerPriority.NORMAL, new PacketType[]{PacketType.Status.Server.OUT_SERVER_INFO});
        this.plugin = plugin;
    }

    public static void register(SuperVanish plugin) {
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new ServerListPacketListener(plugin));
    }

    public static boolean isEnabled(SuperVanish plugin) {
        FileConfiguration config = plugin.getSettings();
        return config.getBoolean("ExternalInvisibility.ServerList.AdjustAmountOfOnlinePlayers") || config.getBoolean("ExternalInvisibility.ServerList.AdjustListOfLoggedInPlayers");
    }

    public void onPacketSending(PacketEvent e) {
        try {
            FileConfiguration settings = this.plugin.getSettings();
            if (!settings.getBoolean("ExternalInvisibility.ServerList.AdjustAmountOfOnlinePlayers") && !settings.getBoolean("ExternalInvisibility.ServerList.AdjustListOfLoggedInPlayers")) {
                return;
            }
            WrappedServerPing ping = (WrappedServerPing)e.getPacket().getServerPings().read(0);
            Collection<UUID> onlineVanishedPlayers = this.plugin.getVanishStateMgr().getOnlineVanishedPlayers();
            int vanishedPlayersCount = this.plugin.getVanishStateMgr().getOnlineVanishedPlayers().size();
            int playerCount = Bukkit.getOnlinePlayers().size();
            if (settings.getBoolean("ExternalInvisibility.ServerList.AdjustAmountOfOnlinePlayers")) {
                ping.setPlayersOnline(playerCount - vanishedPlayersCount);
            }
            if (settings.getBoolean("ExternalInvisibility.ServerList.AdjustListOfLoggedInPlayers")) {
                ArrayList wrappedGameProfiles = new ArrayList(ping.getPlayers());
                Iterator iterator = wrappedGameProfiles.iterator();
                while (iterator.hasNext()) {
                    if (!onlineVanishedPlayers.contains(((WrappedGameProfile)iterator.next()).getUUID())) continue;
                    iterator.remove();
                }
                ping.setPlayers(wrappedGameProfiles);
            }
        }
        catch (Exception er) {
            this.plugin.logException(er);
        }
    }
}

